#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform vec3 twisterPosition[4];
uniform vec4 twisterParams[4]; // amp1, scale1, amp2, scale2
uniform float time;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec3 ec_pos;
out vec2 uv;


void main()
{
	vec3 offset = twisterPosition[gl_InstanceID];
	vec4 params = twisterParams[gl_InstanceID];

	vec3 po = POSITION.yyy + offset;
	float radius = 1.0 + sin(po.y*params.x + time) * sin(po.y*params.y + 0.37 + time) * sin(po.y*params.z + 0.78 + time)*params.w;

	float angle = sin(po.x*0.2 + time)*sin(po.y + time)*sin(po.z*0.3 + time);
	float r2 = smoothstep(0.0, 0.5, POSITION.y*0.25);
	float s = sin(angle);
	float c = cos(angle);
	offset.x += (c + s)*r2;
	offset.z += (-s + c)*r2;

	vec3 p;
	p.x = POSITION.x * radius;
	p.y = POSITION.y;
	p.z = POSITION.z * radius;

	vec3 n = NORMAL;
	vec3 pos = offset + p;

	uv = TEXCOORD;
	normal = NormalMatrix * n;

	ec_pos = vec3(ModelViewMatrix * vec4(pos, 1.0));

	vec4 proj_pos = ModelViewProjectionMatrix * vec4(pos, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
