#version 330 core

uniform sampler2D piano;
uniform sampler2D normal_depth;
uniform vec2 viewport;
uniform float intensity;

in vec2 uv;
in vec3 wpos;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_read_include.frag>

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture(normal_depth, uv_pos).w;
	vec3 pos = calc_position(uv_pos, d);

	if ( pos.z > wpos.z ) discard;

	float alpha = 1.0;//clamp((wpos.z - pos.z)*10.0, 0.0, 1.0);

	frag_color = texture(piano, uv) * alpha * intensity;
}
