#version 410 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec3 ec_pos;
out vec2 uv;

#include <go1891/pinhead_transform_include.vert>

void main()
{
	vec4 pos;
	vec3 displace;
	PinHeadDisplace(POSITION, pos, displace);

	uv = TEXCOORD;
	normal = NormalMatrix * (NORMAL + displace*0.5);

	ec_pos = vec3(ModelViewMatrix * pos);

	vec4 proj_pos = ModelViewProjectionMatrix * pos;
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
