#version 330 core

uniform sampler2D particle;
uniform sampler2D noise;
uniform sampler2D normal_depth;
uniform vec2 viewport;

in float lit;
in vec3 wpos;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_read_include.frag>

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture(normal_depth, uv_pos).w;
	vec3 pos = calc_position(uv_pos, d);

	if ( pos.z > wpos.z ) discard;

	float alpha = clamp((wpos.z - pos.z)*5.0, 0.0, 1.0);

	float n_scale = (1.0 - lit) + 0.5;
	vec2 n_uv = uv_pos * vec2((1.0 / viewport.x) / 128.0, (1.0 / viewport.y) / 128.0)* n_scale;

	frag_color = texture(particle, gl_PointCoord.xy) * texture(noise, n_uv) * alpha * lit;
}
