#version 410 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform sampler2D cubeview;
uniform int cvWidth;
//uniform vec4 cvParams; // size, const, lin, quad

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec3 ec_pos;
out vec3 uv_shade;

void main()
{
	ivec2 cvCoord;
	cvCoord.y = gl_InstanceID / cvWidth;
	cvCoord.x = gl_InstanceID - cvCoord.y*cvWidth;

	vec4 instData = texelFetch(cubeview, cvCoord, 0);

	float size = instData.w * 0.5;
	vec4 pos = vec4(POSITION*size + instData.xyz, 1.0);

	uv_shade.xy = TEXCOORD;
	uv_shade.z = clamp(instData.w, 0.0, 1.0);
	normal = NormalMatrix * NORMAL;

	ec_pos = vec3(ModelViewMatrix * pos);

	vec4 proj_pos = ModelViewProjectionMatrix * pos;
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
