#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;

in vec2 pos_zw;
in vec3 normal;
in vec2 uv;

#include <deferred/gbuffer_write_include.frag>

void main()
{
	diffuse_specular.rgb = texture(diffuse, uv).rgb;
	diffuse_specular.a = texture(specular, uv).r;

	normal_depth.xyz = normalize(normal);
	normal_depth.w = pos_zw.x/pos_zw.y;
}
