#version 330 core

in vec3 gs_color[1];

out vec3 light_dir;
out vec3 color;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT(VTX) \
	light_dir = dir; \
	color = gs_color[0]; \
	gl_Position = VTX; \
	EmitVertex()

void main()
{
	if ( gs_color[0].r < 0.0 ) return;

	// it is assumed that the input vertex is formatted as vec4(x,y,z,intensity)
	vec3 dir = normalize(gl_in[0].gl_Position.xyz);

	EMIT(vec4(1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(1.0, -1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, -1.0, 1.0, 1.0));
	
	EndPrimitive();
}
