#define NUMSAMPLES 44100*8
#define SAMPLESIZE NUMSAMPLES*2
#define	PLAYFREQ   44100
#define NUMLOOPS   12


// Worst hack ever to get better compression
float			datawave[NUMSAMPLES*NUMLOOPS*2];

// Wraping to get some nice sounding distortion
float Wrap (float val, float limit)
{
	if (val > limit)	
	{	
		return Wrap (limit-val+limit, limit);
	}
	else if (val < -limit)	
	{	
		return Wrap (-limit-val-limit, limit);	
	}

	return val;
}

float lastrand = 0.f;

float frand() {
	float r = (rand() & 0xffff)/32768.f-1.f;

	lastrand = lastrand*0.1f + r*0.9f; 
	if (lastrand < -1) lastrand = -1;
	else if (lastrand > 1) lastrand = 1;
	return lastrand;
}

// Init Sound, and play
__inline void initPlayer (void)
{
	int i;
	
	float	*bombo  = (float*)malloc (44100*4), 
	*bombo2  = (float*)malloc (44100*4), 
	*bass1  = (float*)malloc (44100*4), 
	*bass2  = (float*)malloc (44100*4), 
	*crash  = (float*)malloc (44100*4), 
	*caja  = (float*)malloc (44100*4), 
	*sinte1 = (float*)malloc (88200*4), 
	*sinte2 = (float*)malloc (88200*4),
	bomboFreq=2.0f,  sinte1Freq=2.0f, sinte2Freq=2.0f;

	u32 sintePtr = 0;

	float freq = 20.f;
	float mfreq = 0.999f;
	float freq2 = 12;
	float mfreq2 = 0.999f;
	float freq3 = 20;
	float mfreq3 = 0.999f;

	// Drum alike sample
	for (i = 0; i < 44100; ++i)
	{
		float env = (1.0f-(i/22050.0f));
		float envbass = 0.5f-(i/44100.f);

		if (env < 0.0f) { env = 0.0f; }

		bombo[i] = sinf((i/44100.0f)*360.0f*freq)*env;
		bombo2[i] = sinf((i/44100.0f)*360.0f*freq2)*env;
		crash[i] = frand()*2*env;/*sinf((cos(i*i*i+sin(i))*i/44100.0f)*360.0f*freq3)*/ //sinf((rand() % 0xff)/127.f-127.f)*env*env;
		caja[i] = crash[i]*sinf((i/44100.0f)*360.0f*freq)*env;

		bass1[i] = sinf(2*65.41f*(2*PI*i/44100.0f))*envbass;
		bass2[i] = sinf(2*73.42f*(2*PI*i/44100.0f))*envbass;

		freq *= mfreq;
		freq2 *= mfreq2;
		freq3 *= mfreq3;
	}

	// Synth alike samples
	for (i = 0; i < 88200; ++i)
	{
		float env = sinf(i/88200.0f);

		if (env < 0.0f) { env = 0.0f; }

		sinte1[i] = Wrap (sinf((i/88200.0f)*360.0f*sinte1Freq)*env, 0.2f);
		sinte1Freq = fabsf(cosf(i/88200.0f)*sinf(i/40000.0f))+1.5f;

		sinte2[i] = Wrap (sinf((i/88200.0f)*360.0f*sinte2Freq)*env, 0.5f);
		sinte2Freq = fabsf(cosf(i/88200.0f))+1.5f;
	}

	for (i = 0; i < NUMSAMPLES*NUMLOOPS; ++i)
	{
		// Base sound
		float currSample = 0; //sinte1[sintePtr/3];

		int beat = (i / (44100/4)) % 16;
		int beatbass = (i / (44100/4)) % 16;

		if (sintePtr > 74000*3)	{	sintePtr = 35000*3;	}
		
		sintePtr ++;

		/*
		// Create the sound mixing in a rather ugly manner the 3 samples
		if (i > 44100*10 && i < 44100*30)
		{
			currSample = (currSample+sinte1[((int)(i*(1.0f + (i-44100*10)/(4400.0f)))+40000)%88200])/2.0f;
			currSample = (currSample+bombo[(i>>1)%22100])/2.0f;
		}
		else if (i > 44100*30 && i < 44100*68)
		{
			currSample = (currSample+bombo[(int)(i/(2.0f - (i-44100*30)/(44100.0f*30)))%22100])/2.0f;
			currSample = (currSample+sinte2[(int)(i*(1.0f + (i-44100*30)/(4400.0f)))%88200])/2.0f;
			currSample = (currSample+sinte2[((int)(i*(1.0f + (i-44100*30)/(4400.0f)))+40000)%88200])/2.0f;
		}
		// Noise for the end part mixed with the drum
		else if (i > 44100*68 && i < 44100*75)
		{
			currSample = (currSample+0.7f*bombo[(int)(i/(2.0f - (i-44100*30)/(44100.0f*30)))%22100])/2.0f;
			currSample = (currSample+((rand()%256)/(1024.0f-(i/4410.0f))))/2.0f;
		}
		// Some noise for the end part
		else if (i > 44100*75)
		{
			currSample = (currSample+((rand()%256)/(1024.0f-(i/6000.0f))))/2.0f;
		}*/

		//currSample *= 2.0f;

		// disparo: currSample = bombo[(i)%22100]/2.0f + crash[(i)%22100]/2.0f;
	
//		if (i < 44100*1 || i > 44100*2) {
		//currSample = bombo[(i>>1)%22100]/2.0f;
		if (i < 44100*7 || i > 44100*8) {
			currSample = bombo[(i)%22100]/2.0f;
		} else  {
			currSample = bombo2[(i<<2)%22100]/2.0f;
		}
		if (i > 44100*8 && ((beat%4 == 1) || (beat%4 == 3))) {
			currSample += crash[(i<<1)%22100]/8.0f;
		}
		if (i > 44100*8 && (beat%4 == 2)) {
			currSample += caja[(i)%22100]/4.0f;
		}

		/*
		if (beat%4 == 0) {
			currSample += bass1[i%22100]/2.0f;
		}
		if (beat%4 == 1) {
			currSample += bass2[i%22100]/2.0f;
		}*/
		


		if ( beatbass == 0 || beatbass==3 || beatbass==6 || beatbass==9 || beatbass==12 ) {
			currSample += bass1[i%22100]/1.0f;
		}
		if ( beatbass == 1 || beatbass==4 || beatbass== 7 || beatbass== 10 || beatbass== 14) {
			currSample += bass2[i%22100]/1.0f;
		}


	//	if (i < 44100*7 || i > 44100*8) {
	//		currSample = crash[(i)%22100]/2.0f;
	//	}




		// If the mix fucked up
		if (currSample > 1.0f) { currSample = 1.0f; }

		// Copy actual sample to data buffer
		datawave[i] = currSample;
	}

	// Some filtering to get better sounding wave
/*	for (int x = 0; x < 10; x++)
	for (int i = 1; i < NUMSAMPLES*NUMLOOPS; ++i)	
	{
		datawave[i] = (datawave[i-1] + datawave[i]) >> 1;
	}
*/
	return;
}