#!/bin/bash

set -e

function exec {
        echo
        echo $*
        $*
}

export PATH=":$PATH"

CFLAGS="-std=c99" # i use c66 here
CFLAGS="$CFLAGS -Oz -mdynamic-no-pic -fomit-frame-pointer" # basic size opt flags
CFLAGS="$CFLAGS -ffast-math -mfpmath=387 -fsingle-precision-constant" # smaller floating point code & data
CFLAGS="$CFLAGS -fno-optimize-register-move -mtune=i386 -floop-optimize2" # optimizes for compression
CXXFLAGS="$CFLAGS -fno-exceptions -fno-rtti" # not used here but are a must for c++

# Compile
exec gcc $CFLAGS -c main.c -o ngon4k.o

# Default linker
exec gcc ngon4k.o -framework Carbon -framework CoreAudio -framework OpenGL -o ngon4k.unpacked

# Muncho
exec muncho -R2 -s 1320 ngon4k.o --no-args -fCarbon -o ngon4k.muncho


LSIZE=`wc -c < ngon4k.unpacked`
MSIZE=`wc -c < ngon4k.muncho`

PERCENT=`bc<<EOF
scale = 2
$MSIZE * 100 / $LSIZE
EOF
`

cat <<EOF

Sizes:
      ld: $LSIZE
  muncho: $MSIZE ($PERCENT%)
EOF
