{
  Unit XMS.PAS by FAC
  Thanks to Boris Bertelsons for explanation on how to use XMS
  and for some of the code, but the guys that translated the book
  (PC Underground) to Spanish (PC al lmite) messed up the code really bad.
  Anyway, it's easier than I thought :)
}

unit XMS;

interface

var XMSExist : boolean;
    XMSVersion : word;
    XMMAddress : pointer;

type XMSHandle = word;
     XMSStruct = record
                       size : longint;
                       SrcHandle : word;
                       SrcOffset : pointer;
                       DstHandle : word;
                       DstOffset : pointer;
                 end;

var xmscs : XMSStruct;

procedure XMSSetup;
function XMSFree : longint;
function XMSAlloc(var handle : XMSHandle; size : longint) : byte;
function XMSDispose(handle : XMShandle) : byte;
function XMSCopy(const info : XMSStruct) : byte;

{ Additional Copy Functions }
function xms2xms(h1, h2 : XMSHandle; size : word) : byte;
function xms2base(h : XMSHandle; p : pointer; size : word) : byte;
function base2xms(p : pointer; h : XMSHandle; size : word) : byte;


implementation

{ Checa si hay un controlador XMS instalado, y si as es, checa la
  versin e inicializa las variables globales }
procedure XMSSetup; assembler;
asm
   mov ax, 4300h        { checar si est el controlador instalado }
   int 2Fh              { con la funcin 43h de la int 2Fh }
   cmp al, 80h          { si devuelve 80h, entonces est instalado }
   jne @NoControles     { si no, entonces no hay XMS }
   mov ax, 4310h        { Con la subfuncin 10 de la funcin 43 }
   int 2Fh              { de la int 2Fh }
   mov word ptr XMMAddress + 2, es { obtenemos la direccin del }
   mov word ptr XMMAddress + 0, bx { controlador en es:bx }
   xor ax, ax           { Usamos la funcin 0 del XMM }
   call dword ptr [XMMAddress] { para obtener la versin }
   cmp ax, 0200h        { y checamos que sea por lo menos la 2.00 }
   jb @NoControles      { Si es una versin menor, entonces no funciona }
   mov XMSVersion, ax   { y si no, pues ya estuvo }
   mov XMSExist, 1      { XMSExist := true }
   jmp @Adios

@NoControles: mov XMSExist, 0  { XMSExist := false }

@Adios:
end;


{ Devuelve la cantidad de XMS libre }
function XMSFree : longint;
var totalfree : longint;
begin
     asm
        mov ax, 0800h
        db $66; xor dx, dx
        call dword ptr [XMMAddress]
        db $66; shl dx, 10
        db $66; mov word ptr [totalfree], dx
     end;
     XMSFree := totalfree;
end;


function XMSAlloc(var handle : XMSHandle; size : longint) : byte;
var KBsize, h : word;
    error : byte;
begin
     KBsize := size div 1024 + 1;
     asm
        mov ax, 0900h
        mov dx, KBsize
        call dword ptr [XMMAddress]
        cmp ax, 1
        jne @Err
        mov h, dx
        mov error, 0
        jmp @Adios
     @Err: mov error, bl
     @Adios:
     end;
     handle := h;
     XMSAlloc := error;
end;

function XMSDispose(handle : XMSHandle) : byte;
var error : byte;
begin
     asm
        mov ax, 0A00h
        mov dx, handle
        call dword ptr [XMMAddress]
        cmp ax, 1
        jne @Err
        mov error, 0
        jmp @Adios
     @Err: mov error, bl
     @Adios:
     end;
     XMSDispose := error;
end;

function XMSCopy(const info : XMSStruct) : byte;
var error : byte;
begin
     asm
        mov si, offset info
        mov ax, 0B00h
        call dword ptr [XMMAddress]
        cmp ax, 1
        jne @Err
        mov error, 0
        jmp @Adios
     @Err: mov error, bl
     @Adios:
     end;
     XMSCopy := error;
end;


function xms2xms(h1, h2 : XMSHandle; size : word) : byte;
var error : byte;
begin
     xmscs.size := size;
     xmscs.SrcHandle := h1;
     xmscs.SrcOffset := nil;
     xmscs.DstHandle := h2;
     xmscs.DstOffset := nil;
     asm
        mov si, offset xmscs
        mov ax, 0B00h
        call dword ptr [XMMAddress]
        cmp ax, 1
        jne @Err
        mov error, 0
        jmp @Adios
     @Err: mov error, bl
     @Adios:
     end;
     xms2xms := error;
end;

function xms2base(h : XMSHandle; p : pointer; size : word) : byte;
var error : byte;
begin
     xmscs.size := size;
     xmscs.SrcHandle := h;
     xmscs.SrcOffset := nil;
     xmscs.DstHandle := 0;
     xmscs.DstOffset := p;
     asm
        mov si, offset xmscs
        mov ax, 0B00h
        call dword ptr [XMMAddress]
        cmp ax, 1
        jne @Err
        mov error, 0
        jmp @Adios
     @Err: mov error, bl
     @Adios:
     end;
     xms2base := error;
end;

function base2xms(p : pointer; h : XMSHandle; size : word) : byte;
var error : byte;
begin
     xmscs.size := size;
     xmscs.SrcHandle := 0;
     xmscs.SrcOffset := p;
     xmscs.DstHandle := h;
     xmscs.DstOffset := nil;
     asm
        mov si, offset xmscs
        mov ax, 0B00h
        call dword ptr [XMMAddress]
        cmp ax, 1
        jne @Err
        mov error, 0
        jmp @Adios
     @Err: mov error, bl
     @Adios:
     end;
     base2xms := error;
end;

begin
     XMSSetup;
end.