
// phongpal.cpp

#include <math.h>
#include "mode13.h"
#include "phongpal.h"

// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif


double Cos256[256], Cos256Pow10[256];

void CalcPhongTables() {
	double ang = 3.14159265 / 2.0;
	double angadd = (3.14159265 / 256.0) / 2.0;
	for (int a = 0; a < 256; a++) {
		Cos256[a] = cos(ang);
		Cos256Pow10[a] = pow(cos(ang), 10);
		ang -= angadd;
	}
}


void PhongPal( double ra, double rd, double rs,
			   double ga, double gd, double gs,
			   double ba, double bd, double bs,
			   unsigned int n, 
			   TPalette p, unsigned int start, unsigned int range) {

	double dif, spec;
	int r, g, b;
	if (range > 256) range = 256;
	double ang = 3.14159265 / 2.0;
	double angadd = (3.14159265 / range) / 2.0;
	for (int i = 0; i < range; i++) {
		dif = cos(ang) * rd;
		spec = pow(cos(ang), n) * rs;
		r = (ra + dif + spec) / 4.0;
		
		dif = cos(ang) * gd;
		spec = pow(cos(ang), n) * gs;
		g = (ga + dif + spec) / 4.0;
		
		dif = cos(ang) * bd;
		spec = pow(cos(ang), n) * bs;
		b = (ba + dif + spec) / 4.0;
		
		if (r > 63) r = 63;
		if (g > 63) g = 63;
		if (b > 63) b = 63;
		p[start + i][0] = r;
		p[start + i][1] = g;
		p[start + i][2] = b;
		
		ang -= angadd;
	}
}



void Fast256PhongPal( double ra, double rd, double rs,
					  double ga, double gd, double gs,
					  double ba, double bd, double bs, TPalette p) {
	int r, g, b;
	for (int i = 0; i < 256; i++) {
		r = dtoi(ra + rd * Cos256[i] + rs * Cos256Pow10[i]) >> 2;
		g = dtoi(ga + gd * Cos256[i] + gs * Cos256Pow10[i]) >> 2;
		b = dtoi(ba + bd * Cos256[i] + bs * Cos256Pow10[i]) >> 2;
		if (r > 63) r = 63;
		if (g > 63) g = 63;
		if (b > 63) b = 63;
		p[i][0] = r;
		p[i][1] = g;
		p[i][2] = b;
	}
}
