//      OTR.CPP

//      ---------------------------------------------------------
//      -                                                       -
//      -               O f f    T h e    R o o f               -
//      -       -----------------------------------------       -
//      -                   by:  Delabu Alama                   -
//      -                                                       -
//      -     Code: FAC        Music: FAC       GFX: Manolo     -
//      ---------------------------------------------------------


#include <stdlib.h>
#include <stdio.h>
#include "midasdll.h"
#include "vectors.h"
#include "phongpal.h"
#include "stuff.h"

#include "intro.h"
#include "title.h"
#include "credits.h"
#include "objects.h"
#include "greets.h"
#include "metabola.h"
#include "beckkkck.h"
#include "tunnel.h"
#include "flying.h"
#include "dlblogo.h"
#include "ending.h"


//      Global stuff

MIDASmodule module;
char *modulename = "roof.xm";


//      Initialization

void Init() {
        CalcTrigTables();
        CalcPhongTables();
        MIDASstartup();
	MIDASdetectSoundCard();
	MIDASconfig();
        printf("\nCalculating stuff...\n");
	MIDASinit();
	module = MIDASloadModule(modulename);

        INTRO_Setup();
        TITLE_Setup();
        OBJECTS_Setup();
        CREDITS_Setup();
        GREETS_Setup();
        METABOLA_Setup();
        BECKKKCK_Setup();
        TUNNEL_Setup();
        FLYING_Setup();
        DLBLOGO_Setup();

        SetMode13();
}


//      Deinitialization

void UnInit() {
	MIDASstopModule(playhandle);
	MIDASfreeModule(module);
	MIDASclose();
	SetTextMode();
        if (lastresult) printf("(place your favorite ending message here)\n\n");
        else printf("WHAT HAVE YOU DONE !?!?!?!?!\n\n");
        exit(EXIT_SUCCESS);        
}        


//      main sequence

void main() {
        lastresult = OK;
        Init();
        playhandle = MIDASplayModule(module, TRUE);
        GetMusicInfo();

        INTRO_Run();
//        MIDASsetPosition(playhandle, 4);
        if (lastresult) TITLE_Run();
//        MIDASsetPosition(playhandle, 6);
        if (lastresult) OBJECTS_RunFirst();
//        MIDASsetPosition(playhandle, 8);
        if (lastresult) CREDITS_Run();
//        MIDASsetPosition(playhandle, 12);
        if (lastresult) GREETS_Run();
//        MIDASsetPosition(playhandle, 14);
        if (lastresult) METABOLA_Run();
//        MIDASsetPosition(playhandle, 16);
        if (lastresult) BECKKKCK_Run();
//        MIDASsetPosition(playhandle, 18);
        if (lastresult) OBJECTS_RunSecond();
//        MIDASsetPosition(playhandle, 20);
        if (lastresult) TUNNEL_Run();
//        MIDASsetPosition(playhandle, 23);
        if (lastresult) FLYING_Run();
//        MIDASsetPosition(playhandle, 25);
        if (lastresult) DLBLOGO_Run();
//        MIDASsetPosition(playhandle, 27);
        if (lastresult) ENDING_Run();

        UnInit();
}

