
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include "bitmaps.h"
#include "blitter.h"
#include "globals.h"
#include "obj3d.h"
#include "triangle.h"
#include "cameras.h"
#include "phongpal.h"
#include "plasmafx.h"
#include "midas.h"
#include "part7.h"

#include "videodat.h"
#include "p18a.h"
#include "p18b.h"
#include "mono3.h"
#include "tex9.h"
#include "geo720.h"


#define FX7radius 12.0
#define FX7depth 2.0

byte p7_table1[256], p7_table2[256];

void FX7(TObject3D *srcobj, TObject3D *obj, TBitmap8bpp *source) {
	byte *src = source->datos + source->ancho + 1;
	int total = obj->NumVertex;
	for (int i = 0; i < total; i++) {
		obj->Vertex[i]->SetP(srcobj->Vertex[i]->x, srcobj->Vertex[i]->y, srcobj->Vertex[i]->z);
		*(obj->Vertex[i]) += srcobj->Vertex[i]->normal * 
                        (Sin256[*src++] * FX7depth);
	}
	total = obj->NumPolygons;
	for (i = 0; i < total; i++) obj->Poly[i]->CalcNormal();
}


void Part7_Setup() {
        GeneratePlasmaTable(p7_table1, 0, 0, 0);
        GeneratePlasmaTable(p7_table1, 1, 64, 2);
        GeneratePlasmaTable(p7_table1, 5, 16, 4);
        GeneratePlasmaTable(p7_table2, 0, 0, 0);
        GeneratePlasmaTable(p7_table2, 2, 64, 1);
        GeneratePlasmaTable(p7_table2, 6, 16, 2);
}


void luchador_Part7() {
        int NumFrames[5] = { 13, 15, 10, 13, 10 };
        int frame[5] = { 0, 0, 0, 0, 0 };
        TBitmap8bpp *video[5][15];

        video[0][0] = new TBitmap8bpp(80, 60, V1_01, V1_01_PAL);
        video[0][1] = new TBitmap8bpp(80, 60, V1_02, V1_02_PAL);
        video[0][2] = new TBitmap8bpp(80, 60, V1_03, V1_03_PAL);
        video[0][3] = new TBitmap8bpp(80, 60, V1_04, V1_04_PAL);
        video[0][4] = new TBitmap8bpp(80, 60, V1_05, V1_05_PAL);
        video[0][5] = new TBitmap8bpp(80, 60, V1_06, V1_06_PAL);
        video[0][6] = new TBitmap8bpp(80, 60, V1_07, V1_07_PAL);
        video[0][7] = new TBitmap8bpp(80, 60, V1_08, V1_08_PAL);
        video[0][8] = new TBitmap8bpp(80, 60, V1_09, V1_09_PAL);
        video[0][9] = new TBitmap8bpp(80, 60, V1_10, V1_10_PAL);
        video[0][10] = new TBitmap8bpp(80, 60, V1_11, V1_11_PAL);
        video[0][11] = new TBitmap8bpp(80, 60, V1_12, V1_12_PAL);
        video[0][12] = new TBitmap8bpp(80, 60, V1_13, V1_13_PAL);

        video[1][0] = new TBitmap8bpp(80, 60, V2_01, V2_01_PAL);
        video[1][1] = new TBitmap8bpp(80, 60, V2_02, V2_02_PAL);
        video[1][2] = new TBitmap8bpp(80, 60, V2_03, V2_03_PAL);
        video[1][3] = new TBitmap8bpp(80, 60, V2_04, V2_04_PAL);
        video[1][4] = new TBitmap8bpp(80, 60, V2_05, V2_05_PAL);
        video[1][5] = new TBitmap8bpp(80, 60, V2_06, V2_06_PAL);
        video[1][6] = new TBitmap8bpp(80, 60, V2_07, V2_07_PAL);
        video[1][7] = new TBitmap8bpp(80, 60, V2_08, V2_08_PAL);
        video[1][8] = new TBitmap8bpp(80, 60, V2_09, V2_09_PAL);
        video[1][9] = new TBitmap8bpp(80, 60, V2_10, V2_10_PAL);
        video[1][10] = new TBitmap8bpp(80, 60, V2_11, V2_11_PAL);
        video[1][11] = new TBitmap8bpp(80, 60, V2_12, V2_12_PAL);
        video[1][12] = new TBitmap8bpp(80, 60, V2_13, V2_13_PAL);
        video[1][13] = new TBitmap8bpp(80, 60, V2_14, V2_14_PAL);
        video[1][14] = new TBitmap8bpp(80, 60, V2_15, V2_15_PAL);

        video[2][0] = new TBitmap8bpp(80, 60, V4_01, V4_01_PAL);
        video[2][1] = new TBitmap8bpp(80, 60, V4_02, V4_02_PAL);
        video[2][2] = new TBitmap8bpp(80, 60, V4_03, V4_03_PAL);
        video[2][3] = new TBitmap8bpp(80, 60, V4_04, V4_04_PAL);
        video[2][4] = new TBitmap8bpp(80, 60, V4_05, V4_05_PAL);
        video[2][5] = new TBitmap8bpp(80, 60, V4_06, V4_06_PAL);
        video[2][6] = new TBitmap8bpp(80, 60, V4_07, V4_07_PAL);
        video[2][7] = new TBitmap8bpp(80, 60, V4_08, V4_08_PAL);
        video[2][8] = new TBitmap8bpp(80, 60, V4_09, V4_09_PAL);
        video[2][9] = new TBitmap8bpp(80, 60, V4_10, V4_10_PAL);

        video[3][0] = new TBitmap8bpp(80, 60, V5_01, V5_01_PAL);
        video[3][1] = new TBitmap8bpp(80, 60, V5_02, V5_02_PAL);
        video[3][2] = new TBitmap8bpp(80, 60, V5_03, V5_03_PAL);
        video[3][3] = new TBitmap8bpp(80, 60, V5_04, V5_04_PAL);
        video[3][4] = new TBitmap8bpp(80, 60, V5_05, V5_05_PAL);
        video[3][5] = new TBitmap8bpp(80, 60, V5_06, V5_06_PAL);
        video[3][6] = new TBitmap8bpp(80, 60, V5_07, V5_07_PAL);
        video[3][7] = new TBitmap8bpp(80, 60, V5_08, V5_08_PAL);
        video[3][8] = new TBitmap8bpp(80, 60, V5_09, V5_09_PAL);
        video[3][9] = new TBitmap8bpp(80, 60, V5_10, V5_10_PAL);
        video[3][10] = new TBitmap8bpp(80, 60, V5_11, V5_11_PAL);
        video[3][11] = new TBitmap8bpp(80, 60, V5_12, V5_12_PAL);
        video[3][12] = new TBitmap8bpp(80, 60, V5_13, V5_13_PAL);

        video[4][0] = new TBitmap8bpp(80, 60, V6_01, V6_01_PAL);
        video[4][1] = new TBitmap8bpp(80, 60, V6_02, V6_02_PAL);
        video[4][2] = new TBitmap8bpp(80, 60, V6_03, V6_03_PAL);
        video[4][3] = new TBitmap8bpp(80, 60, V6_04, V6_04_PAL);
        video[4][4] = new TBitmap8bpp(80, 60, V6_05, V6_05_PAL);
        video[4][5] = new TBitmap8bpp(80, 60, V6_06, V6_06_PAL);
        video[4][6] = new TBitmap8bpp(80, 60, V6_07, V6_07_PAL);
        video[4][7] = new TBitmap8bpp(80, 60, V6_08, V6_08_PAL);
        video[4][8] = new TBitmap8bpp(80, 60, V6_09, V6_09_PAL);
        video[4][9] = new TBitmap8bpp(80, 60, V6_10, V6_10_PAL);

        TBitmap8bpp *top = new TBitmap8bpp(P18A_ANCHO, P18A_ALTO, P18A, P18A_PAL);
        TBitmap8bpp *bottom = new TBitmap8bpp(P18B_ANCHO, P18B_ALTO, P18B, P18B_PAL);
        TBitmap8bpp *mona = new TBitmap8bpp(MONO3_ANCHO, MONO3_ALTO, MONO3, MONO3_PAL);
        TBitmap8bpp *texture = new TBitmap8bpp(TEX9_ANCHO, TEX9_ALTO, TEX9, TEX9_PAL);

	TBitmap8bpp *plasma;

	TObject3D *srcobj = new TObject3D();
        Read3DObject(GEO720, srcobj);
	srcobj->Centre();
        srcobj->FitSphere(FX7radius);
        srcobj->MapEnviroment();

	TObject3D *obj = new TObject3D();
        Read3DObject(GEO720, obj);
	obj->Centre();
        obj->FitSphere(FX7radius);
	obj->SetStyle(c_texturemapped);
	obj->SetTexture(texture);
	obj->MapEnviroment();

        if (srcobj->NumVertex & 1) plasma = new TBitmap8bpp(srcobj->NumVertex + 3, 4);
        else plasma = new TBitmap8bpp(srcobj->NumVertex + 2, 4);
	
        camera->location.SetP(-FX7radius, FX7radius * 0.5, -FX7radius * 1.0);
        camera->ax = camera->ay = camera->az = 0;

        int xpos, i;
        double a;

        m_timer = 0;
        while (m_position < 20) {
                vscr->Borra(RGB(0, 156, 173));

                a = m_timer / 200.0;

                GeneratePlasma(plasma, p7_table1, p7_table2, 128 + 127 * sin(a), 
			128 + 127 * cos(a * 0.5), 255 * cos(a) * cos(a),
			128 - 127 * sin(a * 0.5));

                FX7(srcobj, obj, plasma);
		obj->Draw(vscr);

                srcobj->Rotate(dtoi(6.0 * sin(a * 1.2)), dtoi(6.0 * cos(a * 1.5)), dtoi(6.0 * sin(a * 0.7)));

                for (i = 0; i < 5; i++) frame[i] = dtoi(m_timer / 12.0) % NumFrames[i];

                xpos = -((m_timer >> 1) % 80);
                i = ((m_timer >> 1) / 80) % 5;

                while (xpos < 320) {
                        video[i][frame[i]]->BlitTo(vscr, xpos, 110);
                        xpos += 80;
                        i = (i + 1) % 5;
                }

                top->TransBlitTo(vscr, 0, 0, 112);

                if ((m_timer > 200) && (m_timer < 732))
                        mona->TransBlitTo(vscr, m_timer - 412, 8, 255);

                bottom->TransBlitTo(vscr, 0, 190, 112);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
        }

        for (i = 0; i < 5; i++)
                for (int j = 0; j < NumFrames[i]; j++) delete video[i][j];

        delete top;
        delete bottom;
        delete mona;
        delete texture;
        free(plasma->datos); delete plasma;
        delete srcobj;
        delete obj;
}
