
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include "bitmaps.h"
#include "blitter.h"
#include "obj3d.h"
#include "triangle.h"
#include "cameras.h"
#include "primitiv.h"
#include "globals.h"
#include "midas.h"
#include "part10.h"

#include "p13.h"
#include "tex3.h"
#include "tex5.h"
#include "banner7.h"

#define P10_LETRAS_R 255
#define P10_LETRAS_G 255
#define P10_LETRAS_B 255
#define P10_LETRAS_ALPHA 0.7;

unsigned p10_ColorTable[256][64];

void Part10_Setup() {
        double r, dr, g, dg, b, db;
        for (int i = 0; i < 256; i++) {
                r = (P13_PAL[i] >> 16) & 0xFF;
                g = (P13_PAL[i] >> 8) & 0xFF;
                b = P13_PAL[i] & 0xFF;
                dr = (P10_LETRAS_R - r) / 64.0 * P10_LETRAS_ALPHA;
                dg = (P10_LETRAS_G - g) / 64.0 * P10_LETRAS_ALPHA;
                db = (P10_LETRAS_B - b) / 64.0 * P10_LETRAS_ALPHA;
                for (int j = 0; j < 64; j++) {
                        p10_ColorTable[i][j] = RGB(dtoi(r), dtoi(g), dtoi(b));
                        r += dr;
                        g += dg;
                        b += db;
                }
        }
}


void luchador_Part10() {
        TBitmap8bpp *fondo = new TBitmap8bpp(P13_ANCHO, P13_ALTO, P13, P13_PAL);
        TBitmap8bpp *texsan = new TBitmap8bpp(TEX3_ANCHO, TEX3_ALTO, TEX3, TEX3_PAL);
        TBitmap8bpp *texlet = new TBitmap8bpp(TEX5_ANCHO, TEX5_ALTO, TEX5, TEX5_PAL);
        TBitmap8bpp *banner = new TBitmap8bpp(BANNER7_ANCHO, BANNER7_ALTO, BANNER7, BANNER7_PAL);

        TObject3D *santo = new TObject3D();
        MakeQuadPatch(santo, 1, 1);
        santo->SetStyle(ca_texturemapped);
        santo->SetTexture(texsan);
        santo->origin.SetP(0, -0.9, 0);

        TObject3D *letra = new TObject3D();
        MakeQuadPatch(letra, 1, 1);
        letra->SetStyle(nc_texturemapped);
        letra->SetTexture(texlet);
        letra->origin.SetP(0, 0, 0);

        camera->location.SetP(0, 0, -1.0);
        camera->ax = camera->ay = camera->az = 0;

        ColorBlendMap = (unsigned *)p10_ColorTable;
        BlendSource = fondo;

        int lang;
        double sscale;
        m_timer = 0;
        
        while (m_position < 27) {
                fondo->BlitTo(vscr, 0, 0);

                sscale = 1.6 + 0.3 * sin(m_timer / 100.0);
                lang = (m_timer << 1) % NumDegrees;

                TransparentColor = 0;
                letra->Rotate(0, 0, lang);
                letra->Draw(vscr);
                letra->Rotate(0, 0, -lang);

                TransparentColor = 127;
                santo->Scale(sscale, sscale, 1.0);
                santo->Draw(vscr);
                santo->Scale(1.0 / sscale, 1.0 / sscale, 1.0);

                banner->TransBlitTo(vscr, 96, 185, 255);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
        }

        delete fondo;
        delete texsan;
        delete texlet;
        delete banner;
        delete santo;
        delete letra;
}
