//	obj3d.h

#ifndef _OBJ3D_
#define _OBJ3D_

#include "vectors.h"
#include "bitmaps.h"

#define MaxObjectVertex 1200
#define MaxPolyVertex   10
#define MaxObjectPoly   2000
#define MaxScenePoly    4000
#define MaxSceneObjects 20


#define ScreenCenterX 160
#define ScreenCenterY 120
#define PerspectiveX  128.0
#define PerspectiveY  128.0


class TPolygon {
	public:
			int NumVertex;
			unsigned int zorder;
			TVector normal;
			TVertex *(*Vertex);
			int style, cstart, crange;
			int *ctable;
			TBitmap8bpp *texture;
			
			TPolygon();
			~TPolygon();
			
			void AddVertex(TVertex *v);
			void CalcNormal();
			int Visible();
			void CalcZOrder();
};


class TObject3D {
	public:
			TVector origin;
			int NumVertex, NumPolygons;
			TVertex *(*Vertex);
			TPolygon *(*Poly);
			
			TObject3D();
			~TObject3D();
			
			void AddVertex(double nx, double ny, double nz);
			void AddVertexUV(double nx, double ny, double nz, double nu, double nv);
			void AddPolygon(TPolygon *poly);
			void CalcNormals();
			void MapEnviroment();
			void Traslate(double tx, double ty, double tz);
			void Rotate(int ax, int ay, int az);
            void FlatRotate(int ax, int ay, int az);
			void Scale(double sx, double sy, double sz);
			void TransformView();
			void Draw(TBitmap *where);
            void SphericalMap(double scale);
            void FlipFaces();
            void Centre();
            void FitSphere(double radius);
            void SetColor(int cstart, int crange, int *ctable);
            void SetStyle(int style);
            void SetTexture(TBitmap8bpp *texture);
};


// load a 3d object
void Load3DObject(char *filename, TObject3D *obj);
void Read3DObject(int *vkx, TObject3D *obj);


void InitializeEngine();


// radix sort
void radixsort(TPolygon **source, long N);


#endif
