//	circles.cpp

#include "globals.h"
#include "circles.h"

void ClipHLine(int x0, int x1, int y0, unsigned color, TBitmap *where) {
	if ((y0 < 0) || (y0 >= where->alto)) return;
	if ((x1 < 0) || (x0 >= where->ancho)) return;
	if (x0 < 0) x0 = 0;
	if (x1 >= where->ancho) x1 = where->ancho - 1;
	unsigned off = (unsigned)(where->datos + where->tablay[y0] + x0);
	_asm {
		mov ecx, [x1]
		mov edi, [off]
		sub ecx, [x0]
		mov eax, [color]
		inc ecx
		rep stosd
	}
}


void DrawCircle(int xc, int yc, int r, unsigned color, TBitmap *where) {
        if (r < 0) return;
	int x = 0;
	int y = r;
	int p = 3 - r * 2;
	while (x < y) {
		ClipHLine(xc - x, xc + x, yc - y, color, where);
		ClipHLine(xc - x, xc + x, yc + y, color, where);
		ClipHLine(xc - y, xc + y, yc - x, color, where);
		ClipHLine(xc - y, xc + y, yc + x, color, where);
		if (p < 0) p += 4 * x + 6;
		else {
			p += 4 * (x - y) + 10;
			y--;
		}
		x++;
	}
	if (x == y) {
		ClipHLine(xc - x, xc + x, yc - y, color, where);
		ClipHLine(xc - x, xc + x, yc + y, color, where);
		ClipHLine(xc - y, xc + y, yc - x, color, where);
		ClipHLine(xc - y, xc + y, yc + x, color, where);
	}
}


void DrawCircleFX(TBitmap8bpp *source, TBitmap *dest, unsigned color, int size) {
	double stepx = dest->ancho / (double)source->ancho;
	double stepy = dest->alto / (double)source->alto;
	double xc, yc = stepy * 0.5;
	double factor = size / 256.0;
	byte *src = source->datos;
	for (int j = 0; j < source->alto; j++) {
		int xc = stepx * 0.5;
		for (int i = 0; i < source->ancho; i++) {
                        DrawCircle(dtoi(xc), dtoi(yc), dtoi((*src++) * factor), color, dest);
			xc += stepx;
		}
		yc += stepy;
	}
}


void ClipHLine2(int x0, int x1, int y0, TBitmap *img, TBitmap *where, unsigned tcolor) {
	if ((y0 < 0) || (y0 >= where->alto)) return;
	if ((x1 < 0) || (x0 >= where->ancho)) return;
	if (x0 < 0) x0 = 0;
	if (x1 >= where->ancho) x1 = where->ancho - 1;
	unsigned off = (unsigned)(where->datos + where->tablay[y0] + x0);
	unsigned imgoff = (unsigned)(img->datos + img->tablay[y0] + x0);
	_asm {
		mov ecx, [x1]
		mov edi, [off]
		mov esi, [imgoff]
		sub ecx, [x0]
                mov edx, [tcolor]
		inc ecx
                ciclo:  lodsd
                        cmp eax, edx
                        je nope
                        mov [edi], eax
                nope:   add edi, 4
                        dec ecx
                        jnz ciclo
                        
	}
}


void DrawCircle2(int xc, int yc, int r, TBitmap *img, TBitmap *where, unsigned tcolor) {
	if (r <= 0) return;
	int x = 0;
	int y = r;
	int p = 3 - r * 2;
	while (x < y) {
                ClipHLine2(xc - x, xc + x, yc - y, img, where, tcolor);
                ClipHLine2(xc - x, xc + x, yc + y, img, where, tcolor);
                ClipHLine2(xc - y, xc + y, yc - x, img, where, tcolor);
                ClipHLine2(xc - y, xc + y, yc + x, img, where, tcolor);
		if (p < 0) p += 4 * x + 6;
		else {
			p += 4 * (x - y) + 10;
			y--;
		}
		x++;
	}
	if (x == y) {
                ClipHLine2(xc - x, xc + x, yc - y, img, where, tcolor);
                ClipHLine2(xc - x, xc + x, yc + y, img, where, tcolor);
                ClipHLine2(xc - y, xc + y, yc - x, img, where, tcolor);
                ClipHLine2(xc - y, xc + y, yc + x, img, where, tcolor);
	}
}


void DrawCircleFX2(TBitmap8bpp *source, TBitmap *dest, TBitmap *img, int size, unsigned tcolor) {
	double stepx = dest->ancho / (double)source->ancho;
	double stepy = dest->alto / (double)source->alto;
        double xc, yc = stepy * 0.5;
	double factor = size / 256.0;
	byte *src = source->datos;
	for (int j = 0; j < source->alto; j++) {
                int xc = stepx * 0.5;
		for (int i = 0; i < source->ancho; i++) {
                        DrawCircle2(xc, yc, (*src++) * factor, img, dest, tcolor);
			xc += stepx;
		}
		yc += stepy;
	}
}
