//      bitmaps.h       -- Definicin de la clase TBitmap para 32 bpp

#ifndef _BITMAPS_
#define _BITMAPS_

//      Definicin de tipos auxiliares
typedef unsigned char byte;
typedef unsigned short word;

typedef struct {
        byte ID;
        byte Version;
        byte Compression;
        byte BPP;
        short XMin;
        short YMin;
        short XMax;
        short YMax;
        short XRes;
        short YRes;
        byte Palette16[48];
        byte Reserved;
        byte ColorPlanes;
        short BytesPerLine;
        short GrayScale;
        byte NotUsed[58];
} PCXHeader;

unsigned RGB(byte r, byte g, byte b);


// Definicin de la clase TBitmap
class TBitmap {
      public: int ancho, alto;
              unsigned *datos;
              int *tablay;

      TBitmap(int w, int h);
      TBitmap(TBitmap *clon);
      TBitmap(char *f);
      ~TBitmap();

      void PutPixel(int x, int y, unsigned color);
      void PutPixel(int x, int y, byte red, byte green, byte blue);
      unsigned GetPixel(int x, int y);
      void Borra(unsigned color);
      void Borra(byte red, byte green, byte blue);
      void Copia(TBitmap *fuente);
      void Blit(TBitmap *fuente, int x0, int y0);
      void Blur();
      void LoadPCX(char *f);
      void LoadTGA(char *f);
};


class TBitmap8bpp {
      public: int ancho, alto;
              byte *datos;
              int *tablay;
              unsigned paleta[256];

      TBitmap8bpp(int w, int h);
      TBitmap8bpp(char *f);
      TBitmap8bpp(int w, int h, unsigned char *data, unsigned *palette);
      ~TBitmap8bpp();

      void PutPixel(int x, int y, byte color);
      byte GetPixel(int x, int y);
      void Borra(byte color);
      void BlitTo(TBitmap *dest, int x0, int y0);
      void TransBlitTo(TBitmap *dest, int x0, int y0, byte tcolor);
      void BlitTo8bpp(TBitmap8bpp *dest, int x0, int y0);
      void LoadPCX(char *f);
      void Blur();
};

#endif
