Unit TSS;
---==============================================================---
--  *** TMT SOUND SYSTEM 0.1beta *** [1/98]                       --
--              by CiMEDIA/CiMEDIA iNC (a.k.a. Cesar Vellido)     --
--   Features:                                                    --
--   ---------                                                    --
--    o Support for MOD 2/4/6/8/10/12/14/16 Channels              --
--    o Support for all SB family (SB 1.0 to SB AWE32)            --
--    o Still Mono output/no Sorround...                          --
--    o needs PMODEW extender.                                    --
---==============================================================---
{ $define MixDebug}
{$define AutoPoll}


Interface
uses devSB,devGUS;
{$R-}

type
  tArray=Array[0..1]of byte;
  pArray=^tArray;

  tChannel=Record
    ActPtr,ESPtr,BLPtr,ELPtr:pArray;
    Period,FPeriod:DWORD; --FP:24.8
    Vol,Smp:DWORD;
    Loop:Boolean;
  end;

  tSample=Record
    BSPtr,ESPtr,BLPtr,ELPtr:pArray;
    Loop:Boolean;
    Vol:DWORD;
    ft:LongInt;
    Name:String;
  end;

  tPattern=array[0..63,0..15] of Record
    Period:DWORD;
    Inst:WORD;
    Efx:WORD;
  end;
  tPatterns=array[0..1] of tPattern;

Const
  PitchTable:Array[0..6*12]of DWORD=
   (1712,1616,1524,1440,1356,1280,1208,1140,1076,1016,960, 912, --Oct0--
    856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453, --Oct1--
    428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226, --Oct2--
    214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113, --Oct3--
    107, 101, 95,  90,  85,  80,  75,  71,  67,  63,  60,   56, --Oct4--
    53,  50,  47,  45,  42,  40,  37,  35,  33,  31,  30,   28, --Oct5--
    26); --no se si la usaran los s3m o xm, solo la utiliza GetNoteName!!!!

  MODStatus:INTEGER=0;
   ------------------------------------------------
   --  MODSatus:                                 --
   --   0:Stand by                               --
   --   1:MOD loaded Ok                          --
   --   2:MOD playing                            --
   --  -1:error: MOD file not found              --
   --  -2:error: cannot open MOD file            --
   --  -3:error: unknown MOD type                --
   ------------------------------------------------
  PlayDevice:DWORD=0;
   None=0;
   SB=1;
   GUS=2;

  AutoPOLL:Boolean=False;
  MixFreq:DWORD=43478;
  Stereo:Boolean=False;
  SuperBass:Boolean=False;
  MixVol:DWORD=127;
  BPM:DWORD=125;
  Tic:LongInt=MaxNBufs;   --for GUS sync, this is very dirty (GUS has IRQs...)

  --User Timers--
  Timer50:DWORD=0;
  Timer70:DWORD=0;
  Timer350:DWORD=0;

  --Synchronization Table--
  SyncTable:array[0..63] of Integer=(0,...);
  PreSyncTable:array[0..63] of Integer=(0,...);

Var
  Speed,
  MaxChnl,
  MaxSmp,
  MaxPattern,
  ActPattern,
  MaxPos,
  ActPos,
  ReStart,
  ActLine:DWORD;
  Pos:array[0..255] of DWORD;
  Pattern:^tPatterns;

  VolTable:array[0..64,0..255] of Integer;
  PostTable:array[0..4096] of Byte;
  PeriodTable:array[0..2047] of WORD;
  FreqTable:array[0..2047] of WORD;

  Sample:array[0..255] of tSample;
  Channel:array[0..15] of tChannel;

Procedure LoadMOD(st:String);
Procedure FreeMOD;
Procedure IniTSS;
Procedure TSS_Play;
Procedure TSS_Stop;
Procedure TSS_Poll;
Procedure TSS_SetVolume(vol:LongInt);

Implementation
uses crt,dos,midebug,DPMILib;
     --------------------------------------------------
Function Trans(b:byte):byte;
assembler;
asm
  mov   al,[b]
  add   al,128
end;
     --------------------------------------------------
Procedure LoadMOD(st:String);
label
  LMExit1,LMExit2;
type
  tMODHead=
   Record
     Title:array[1..20]of char;
     Sample:array[1..31]of
      Record
        Name:array[1..22]of char;
        Size:WORD;
        finetune:byte;
        Volume:byte;
        RepS:WORD;
        RepL:WORD;
      end;
     MaxPosition:byte;
     ReStart:byte;
     Position:array[0..127]of byte;
     Magik:array[0..3]of char;
   end;

var
  i,j:LongInt;
  d:DWORD;
  f:file;
  MODHead:tMODHead;
  MODPat:array[0..1024] of
   record
     d1,d2,d3,d4:BYTE;
   end;
  Magik:string[4];
  Sr:SearchRec;
  
begin
  If MODStatus=1 then
   FreeMOD;
  If MODStatus=2 then
   Goto LMExit1;
  MODStatus:=0;
  --Open File--
--{$I-}
  Assign(f,st);
  --Find File--
  Findfirst(st,Anyfile,Sr);
  If DOSError<>0 then
   begin
     MODStatus:=-1; --> MOD file not found
     Goto LMExit1;
   end;
  Reset(f,1);
  If IOResult<>0 then
   begin
     MODStatus:=-2; --> Error opening file
     Goto LMExit1;
   end;
  --Read MOD Header--
  BlockRead(f,MODHead,SizeOf(tMODHead),i);

  --MOD Verify & MaxChnl--
  Move(MODHead.Magik,Magik[1],4);
  Magik[0]:=#4;
  MaxChnl:=0;
  If Magik='2CHN' then
   MaxChnl:=2;
  If (Magik='M.K.') or (Magik='FLT4') or (Magik='4CHN') then
   MaxChnl:=4;
  If Magik='6CHN' then
   MaxChnl:=6;
  If (Magik='8CHN') or (Magik='FLT8') then
   MaxChnl:=8;
  If Magik='10CH' then
   MaxChnl:=10;
  If Magik='12CH' then
   MaxChnl:=12;
  If Magik='14CH' then
   MaxChnl:=14;
  If Magik='16CH' then
   MaxChnl:=16;
  If MaxChnl=0 then
   begin
     MODStatus:=-3; --> Unknown MOD tipe
     Goto LMExit2;
   end;

  --Pos, MaxPattern, MaxPos & ReStart--
  MaxPos:=MODHead.MaxPosition;
  for i:=0 to 127 do
   Pos[i]:=MODHead.Position[i];
  MaxPattern:=0;
  for i:=0 to 127 do
  if Pos[i]>MaxPattern then
   MaxPattern:=Pos[i];
  ReStart:=MODHead.ReStart;
  if ReStart=127 then
   ReStart:=0;

  --Patterns--
  GetMem(Pattern,(MaxPattern+1)*SizeOf(tPattern));
  for ActPattern:=0 to MaxPattern do
   begin
     BlockRead(f,MODPat,64*MaxChnl*4,i);
     for ActLine:=0 to 63 do
      for i:=0 to MaxChnl-1 do
       with Pattern^[ActPattern,ActLine,i] do
        with MODPat[(ActLine*MaxChnl)+i] do
         begin
           Inst:=(d1 AND $F0)+(d3 SHR 4);
           Period:=((d1 AND $0F) shl 8)+d2;
           Efx:=((d3 AND $0F) shl 8)+d4;
         end;
   end;

  --Sample nfo--
  MaxSmp:=31;
  for i:=1 to MaxSmp do
   begin
     --Name--
     Move(MODHead.Sample[i].Name,Sample[i].Name,22);
     Sample[i].Name[0]:=#20;
     --Begin Sample--
     j:=Swap(MODHead.Sample[i].Size) shl 1;
     GetMem(Sample[i].BSPtr,j+16); --Debug!!+16
     --End Sample--
     Sample[i].ESPtr:=POINTER(DWORD(Sample[i].BSPtr)+j);
     --Sample data--
     if j>0 then
      BlockRead(f,Sample[i].BSPtr^,j);
     for j:=j-1 downto 0 do
      Sample[i].BSPtr^[j]:=Trans(Sample[i].BSPtr^[j]);
     --Finetune--
     Sample[i].ft:=MODHead.Sample[i].FineTune AND 15;
     if Sample[i].ft>7 then
      Sample[i].ft-:=16;
     --Volume--
     Sample[i].vol:=MODHead.Sample[i].Volume;
     if Sample[i].vol>64 then Sample[i].vol:=64;
     --Begin Loop--
     j:=Swap(MODHead.Sample[i].RepS) shl 1;
     Sample[i].BLPtr:=POINTER(DWORD(Sample[i].BSPtr)+j);;
     --End Loop--
     j:=Swap(MODHead.Sample[i].RepL) shl 1;
     Sample[i].ELPtr:=POINTER(DWORD(Sample[i].BLPtr)+j);
     --Loop?--
     Sample[i].Loop:=j>2;
   end;
   
  --Clear Chnl nfo--
  for i:=1 to MaxChnl do
   begin
     Channel[i].ActPtr:=Sample[0].BSPtr;
     Channel[i].ESPtr:=Sample[0].BSPtr;
     Channel[i].Loop:=False;
     Channel[i].Vol:=0;
   end;

 LMExit2:
  Close(f);

  Speed:=6;
  BPM:=125;
  DMA_BufSize:=(MixFreq*Speed*125) div (50*BPM);
  ActLine:=0;
  ActPos:=0;
  ActPattern:=Pos[ActPos];
  MODStatus:=+1; --MODLoaded
 LMExit1:
end;
     --------------------------------------------------
Procedure MakeVolTable;
var
  t1,t2:Integer;
begin
  for t1:=0 to 64 do
   for t2:=0 to 256 do
    VolTable[t1,t2]:=t1*(t2-128) div 64;
end;
     --------------------------------------------------
Procedure SetMixRate(freq:DWORD);
var
  t1:Integer;
begin
  If PlayDevice=SB then
   begin
     MixFreq:=SB_GetRealMixRate(Freq);
     SB_SetMixRate(MixFreq);
     DMA_BufSize:=(MixFreq*Speed*125) div (50*BPM);
   end;

  --Build Period Table  (used by SB)--
  PeriodTable[0]:=0;
  for t1:=1 to 2047 do
   PeriodTable[t1]:=(($36904000 div MixFreq) div t1); --FP:24.8

  --Build Freq Table  (used by GUS)--
  FreqTable[0]:=0;
  for t1:=1 to 2047 do
   FreqTable[t1]:=(8363*1712) div t1; --DWORD --This  is  NOT true!!!
end;
     --------------------------------------------------
Procedure MakePostTable;
var
  i,b:integer;
  d,delta:real;
begin
--if MixVol>127 then
-- MixVol:=127;
  b:=MaxChnl*128;
  delta:=255*MixVol/(2*b*127);
  d:=127-MixVol;
  FillChar(PostTable,SizeOf(PostTable),0);
  for i:=2048-b to 2048+b do
   begin
     if i>=(2048-b) then
      d:=d+delta;
     PostTable[i]:=Trunc(d);
   end;
  for i:=2047+b to 4096 do
   PostTable[i]:=255;
end;
     --------------------------------------------------
Procedure PlaySample(Inst,ofs,Chnl,MODPeriod:DWORD);
begin
  with Channel[Chnl] do
   begin
     Period:=PeriodTable[MODPeriod];
     FPeriod:=0;
     ActPtr:=POINTER(DWORD(Sample[Inst].BSPtr)+ofs);
     ESPtr:=Sample[Inst].ESPtr;
     BLPtr:=Sample[Inst].BLPtr;
     ELPtr:=Sample[Inst].ELPtr;
     Smp:=Inst;
     vol:=Sample[Inst].vol;
     Loop:=Sample[Inst].Loop;
     IF Loop then
      ESPtr:=Sample[Inst].ELPtr;
   end;
  case PlayDevice of
{   SB:SB_PlaySample(Inst,ofs,Chnl,PeriodTable[MODPeriod]);{<<-- does nothing!!}
   GUS:GUS_PlaySample(Inst,ofs,Chnl,FreqTable[MODPeriod]); --GUS_PS tiene que convertir Period en Freq.!!!!!!
  end;
end;
     --------------------------------------------------
Procedure SetChnlVolume(Chnl:DWORD;Vol:LongInt);
begin
  if vol>64 then vol:=64;
  If vol<0 then vol:=0;
  If Channel[Chnl].Vol>0 then
   Channel[Chnl].Vol:=(Vol*Sample[Channel[Chnl].Smp].vol) shr 6;
  if PlayDevice=GUS then
   GUS_SetChnlVol(Chnl,(Vol*Sample[Channel[Chnl].Smp].vol) shr 4);
end;
     --------------------------------------------------

Procedure TSS_Poll;
label
  Exit;
var
  i,_ofs:DWORD;
  BreakNext:Boolean;
begin
  If ((PlayDevice=SB) and (NBufsReady<MaxNBufs)) or
     ((PlayDevice=GUS) and (Tic+MaxNBufs>0)) then
   begin
    If (PlayDevice=SB) and (DMA_NewBufSize>0) then --if speed was changed..
     If (NBufsReady>0) then                  --..wait for sync..
      Goto Exit
     else                                          
      begin
        DMA_BufSize:=DMA_NewBufSize;         --..and then change the DMA_BufSize
        DMA_NewBufSize:=0;
        SB_Mix;                              --mix last line (still unmixed)
        If SB_AutoInit then
         DMA_ChangeBS:=True;
      end
    else;
    tic-:=1;
    --Decode current line--
    BreakNext:=False;
    For i:=0 to MaxChnl-1 do
     with Pattern^[ActPattern,ActLine,i] do
      begin
        If (Efx shr 8)=$9 then
         _ofs:=(Efx AND $FF) shl 8
        else
         _ofs:=0;
        If Period<>0 then
         PlaySample(Inst,_ofs,i,Period);
        case (Efx shr 8) of
          $0:;                                                  --No Efx...
          $8:PreSyncTable[Efx AND $3F]+:=1 shl NBufsReady;      --Sync mark
          $A:SetChnlVolume(i,Channel[i].vol-(Efx AND $F)+((Efx AND $F0)shr 4));--VolSlide
          $B:begin                                              --Jump
               BreakNext:=True;
               ActPos:=(Efx AND $FF)-1;
             end;
          $C:SetChnlVolume(i,(Efx AND $FF));                    --Set Volume
          $D:BreakNext:=True;                                   --Break Pattern
          $E:case (Efx AND $F0) of
              $A0:SetChnlVolume(i,Channel[i].vol+(Efx AND $F)); --FineVolSl Up
              $B0:SetChnlVolume(i,Channel[i].vol-(Efx AND $F)); --FineVolSl Down
              $C0:SetChnlVolume(i,0);                           --Cut Sample
             end;
          $F:begin                                              --Set Speed/BPM
               if ((Efx AND $FF)<=32) and (Speed<>Efx AND $FF) then
                 begin
                   Speed:=Efx AND $FF;
                   if Speed=0 then
                    Speed:=1;
                   DMA_NewBufSize:=(MixFreq*Speed*125) div (50*BPM);
                 end
                else
                 If ((Efx AND $FF)>32) and (BPM<>Efx AND $FF) then
                  begin
                    BPM:=Efx AND $FF;
                    DMA_NewBufSize:=(MixFreq*Speed*125) div (50*BPM);
                  end;
             end;
        end;
      end;
    --SB stuff--
    If (PlayDevice=SB) and (DMA_NewBufSize=0) then
     SB_Mix;
    --Sync stuff--
    for i:=0 to 63 do
     if PreSyncTable[i]>0 then
      begin
       If (PreSyncTable[i] and 1)=1 then
        SyncTable[i]+:=1;
       PreSyncTable[i]:=PreSyncTable[i] shr 1;
      end;
    --Find next line--
    ActLine+:=1;
    if (ActLine>63) or BreakNext then
     begin
      ActLine:=0;
      ActPos+:=1;
      If ActPos>=MaxPos then
       ActPos:=Restart;
      ActPattern:=Pos[ActPos];
     end;
   end;
  Exit:
end;
     --------------------------------------------------
const
  Timer50Frac:DWORD=0;
  Timer70Frac:DWORD=0;
  TicFrac:DWORD=0;

Procedure TSS_Int8;
Interrupt;
--This new Int8 will be called 350 times per second.
--Doesn't respect old Int8 (but Time is restored when finished)
assembler;
asm
  push eax
  push ebx
  mov  al,$20
  out  $20,al

  {$IfDef MixDebug}
  mov   MiDebug.Red,$39
  mov   MiDebug.Green,$39
  mov   MiDebug.Blue,$39
  call  MiDebug.Border
  {$EndIf}
  
  xor  eax,eax
  Inc  [Timer350]
  Inc  [Timer70frac]
  cmp  [Timer70frac],5
  jne  @No70tic
   Inc [Timer70]
   mov [Timer70Frac],eax
  @No70tic:
  Inc  [Timer50frac]
  cmp  [Timer50frac],7
  jne  @No50tic
   Inc [Timer50]
   mov [Timer50frac],eax
   Inc [TicFrac]
   mov ebx,[Speed]
   cmp [TicFrac],ebx
   jne @NoMODTic
    Inc [Tic]
    mov [TicFrac],eax
   @NoMODTic:
  @No50tic:
  cmp   [AutoPoll],true
  jne   @NoAutoPoll
   pushad
   call TSS_Poll
   popad
  @NoAutoPoll:

  {$IfDef MixDebug}
  mov   MiDebug.Red,0
  mov   MiDebug.Green,0
  mov   MiDebug.Blue,0
  call  MiDebug.Border
  {$EndIf}

  pop  ebx
  pop  eax
end;
     --------------------------------------------------
var
  OldInt8:FarPointer;
     -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
Procedure SetFreq(Freq:WORD);
var
  FreqK:DWORD;
begin
  If Freq=0 then
   FreqK:=0
  else
   FreqK:=$1234DE div Freq;
  Port[$43]:=$36;
  Port[$40]:=Lo(FreqK); --LSB
  Port[$40]:=Hi(FreqK); --MSB
end;
     -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
Procedure RestoreTime;
begin
  --Would be nice to restore the date/time if you use the AutoPoll mode ;)
end;
     -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
Procedure SetTSSInt8;
begin
  GetIntVec(8,OldInt8);
  SetIntVec(8,@TSS_Int8);
  SetFreq(350);
end;
     -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
Procedure RestoreOldInt8;
begin
  SetIntVec(8,OldInt8);
  SetFreq(0);
  RestoreTime;
end;
     --------------------------------------------------
Procedure IniTSS;
var
  i:DWORD;
begin
  PlayDevice:=None;
  if GUS_Detect(true) then
   begin
     PlayDevice:=GUS;
     GUS_Reset;
     DumpMODtoGUS;
   end
  else
   if SB_Detect(true) then
    begin
      PlayDevice:=SB;
       --pillo el doble para asegurarme que este dentro de un pagina!!!
      DMA_Buffer:=Pointer(DWORD(DOSMemoryAlloc(32000) shl 4));
      If DWORD(DMA_Buffer)=0 then
       begin
         WriteLn('DOS memory unavailable (8Kb needed).');
         --DMA_Buffer:=Pointer(Buf_32);!!!
         halt;
       end;

      {Comprovar que este dentro de los limites de un pagina fisica!!!!!!!}
      --Clean buffers
      asm
        mov   edi,[DMA_Buffer]
        mov   ecx,32000/4
        xor   eax,eax
        rep   stosd
      end;
      FillChar(MixBuffer,SizeOf(MixBuffer),0);
      MakeVolTable;
      MakePostTable;
    end
  else
   begin
     WriteLn('Error: GUS/SB not detected.'); --Sera Null_Device!!!!
     halt;
   end;
  for i:=0 to MaxChnl-1 do
   begin
     Channel[i].vol:=0;
     Channel[i].smp:=1;
   end;
end;
     --------------------------------------------------
Procedure TSS_Play;
begin
  SetMixRate(MixFreq);
  If PlayDevice=SB then
   begin
     SB_SpeakerOn;
     SB_IniMixer;
   end;
  {$Ifdef AutoPoll}
  SetTSSInt8;
  {$endif}
end;
     --------------------------------------------------
Procedure TSS_Stop;
begin
  If PlayDevice=SB then
   begin
     SB_KillMixer;
     SB_SpeakerOff;
   end
  else If PlayDevice=GUS then
   GUS_Reset;
  {$Ifdef AutoPoll}
  RestoreOldInt8;
  {$endif}
end;
     --------------------------------------------------
Procedure TSS_SetVolume(vol:LongInt);
begin
  If vol>200 then
   vol:=200;
  If vol<1 then
   vol:=1;
  MixVol:=vol;
  case PlayDevice of
   SB:MakePostTable;
   GUS:; --??? I think it can be done easier by hardware
  end;
end;
     --------------------------------------------------
Procedure FreeMOD;
var
  i:DWORD;
begin
  If MODStatus=2 then
   TSS_Stop;
  If MODStatus=1 then
   begin
     If PlayDevice=SB then
      for i:=1 to MaxSmp do
       FreeMem(Sample[i].BSPtr,DWORD(Sample[i].ESPtr)-DWORD(Sample[i].BSPtr)+16); --Debug!!+16
     FreeMem(Pattern,MaxPattern*SizeOf(tPattern));
   end;
end;
     --------------------------------------------------
end.
