
// phongpal.cpp

#include "mymath.h"
#include "phongpal.h"
#include "bitmaps.h"
#include "globals.h"

void PhongPal( double ra, double rd, double rs,
               double ga, double gd, double gs,
               double ba, double bd, double bs,
               unsigned int n, unsigned *p, unsigned range) {

        double r, g, b;
	if (range > 256) range = 256;
	double ang = 3.14159265 / 2.0;
	double angadd = (3.14159265 / range) / 2.0;
	for (int i = 0; i < range; i++) {
                r = ra + fcos(ang) * rd + fpow(fcos(ang), n) * rs;
                if (r > 1.0) r = 1.0;
		
                g = ga + fcos(ang) * gd + fpow(fcos(ang), n) * gs;
                if (g > 1.0) g = 1.0;
		
                b = ba + fcos(ang) * bd + fpow(fcos(ang), n) * bs;
                if (b > 1.0) b = 1.0;
		
                p[i] = RGB(dtoi(r * 255.0), dtoi(g * 255.0), dtoi(b * 255.0));
		
		ang -= angadd;
	}
}
