
#include <string.h>
#include <stdio.h>
#include "mode13.h"
#include "charset.h"


// TTextInfo

TTextInfo::TTextInfo(int nx, int ny, char *s, int nhs) {
	x = nx;
	y = ny;
	hs = nhs;
	strncpy(txt, s, 81);
	next = NULL;
}

TTextInfo::~TTextInfo() {
	if (next != NULL) delete next;
	next = NULL;
}


// TCharSet

TCharSet::TCharSet() {
//	SetupVirtual(&MapScr, &MapOff);
//	if ((fn != "") && (MapScr != NULL)) Load(fn);
	AllText = NULL;
}

TCharSet::~TCharSet() {
//	if (MapScr != NULL) ShutDownVirtual(&MapScr);
	if (AllText != NULL) delete AllText;
//	MapScr = NULL;
	AllText = NULL;
}
/*
void TCharSet::Load(char *fn) {
	FILE *file;
	int h, l;
	
	if ((file = fopen(fn, "rb")) == NULL) return;
	for (int i = 0; i < 256; i++) {
		l = fgetc(file);
		h = fgetc(file);
		Info.Chars[i].x = (h << 8) + l;
		l = fgetc(file);
		h = fgetc(file);
		Info.Chars[i].y = (h << 8) + l;
	}
	Info.SizeX = fgetc(file);
	Info.SizeY = fgetc(file);
	fgetc(file);
	for (i = 0; i < 12; i++) Info.charmap[i] = fgetc(file);
	Info.charmap[12] = '\0';
	fclose(file);
	LoadPCX(Info.charmap, MapOff, 320, 200, 0, 0, Palette);
}
*/
void TCharSet::PrintChar(int x, int y, char c, unsigned int where) {
	int sx = Info.SizeX - 1;
	int sy = Info.SizeY - 1;
	unsigned int scroff = where + y * 320 + x;
	unsigned int mapoff = MapOff + (Info.Chars[c].y + 1) * 320 + Info.Chars[c].x;
	_asm {
		mov edx, [sy]
		mov esi, [mapoff]
		mov edi, [scroff]
		yloop:  mov ecx, [sx]
		xloop:  mov al, [esi]
				or al, al
				jz noplot
				mov [edi], al
		noplot: inc edi
				inc esi
				dec ecx
				jnz xloop
				add edi, 320
				add esi, 320
				sub edi, [sx]
				sub esi, [sx]
				dec edx
				jnz yloop
	}
}


void TCharSet::PrintString(int y, char *s, int hs, unsigned int where) {
	if (y >= 199) return;
	int sy = Info.SizeY;
	if ((y + sy) >= 200) Info.SizeY = 200 - y;
	int l = strlen(s);
        int xx = (Info.SizeX + hs) * l;
	for (int i = 0; i < l; i++)
		switch (s[i]) {
                        case 'i': xx -= 12; break;
                        case 'l': xx -= 12; break;
                        case 't': xx -= 12; break;
                        case 'r': xx -= 6; break;
                        case 's': xx -= 4; break;
                        case 'm': xx += 10; break;
		}
        xx = 150 - (xx / 2);
	for (i = 0; i < l; i++) {
		switch (s[i]) {
			case 'i': xx -= 6; break;
			case 'l': xx -= 6; break;
			case 't': xx -= 6; break;
			case 'r': xx -= 3; break;
			case 's': xx -= 2; break;
			case 'm': xx += 5; break;
		}
		PrintChar(xx, y, s[i], where);
		xx += Info.SizeX;
		xx += hs;
		switch (s[i]) {
			case 'i': xx -= 6; break;
			case 'l': xx -= 6; break;
			case 't': xx -= 6; break;
			case 'r': xx -= 3; break;
			case 's': xx -= 2; break;
			case 'm': xx += 5; break;
		}
	}
	Info.SizeY = sy;
}



void TCharSet::PrintRight(int y, char *s, int hs, unsigned int where) {
	if (y >= 199) return;
	int sy = Info.SizeY;
	if ((y + sy) >= 200) Info.SizeY = 200 - y;
	int l = strlen(s);
        int xx = 310 - (Info.SizeX + hs) * l;
	for (int i = 0; i < l; i++)
		switch (s[i]) {
			case 'i': xx += 12; break;
			case 'l': xx += 12; break;
			case 't': xx += 12; break;
			case 'r': xx += 6; break;
			case 's': xx += 4; break;
			case 'm': xx -= 10; break;
		}
	for (i = 0; i < l; i++) {
		switch (s[i]) {
			case 'i': xx -= 6; break;
			case 'l': xx -= 6; break;
			case 't': xx -= 6; break;
			case 'r': xx -= 3; break;
			case 's': xx -= 2; break;
			case 'm': xx += 5; break;
		}
		PrintChar(xx, y, s[i], where);
		xx += Info.SizeX;
		xx += hs;
		switch (s[i]) {
			case 'i': xx -= 6; break;
			case 'l': xx -= 6; break;
			case 't': xx -= 6; break;
			case 'r': xx -= 3; break;
			case 's': xx -= 2; break;
			case 'm': xx += 5; break;
		}
	}
	Info.SizeY = sy;
}



void TCharSet::AddText(int x, int y, char *s, int hs) {
	TTextInfo *temp;
	temp = new TTextInfo(x, y, s, hs);
	if (temp != NULL) {
		temp->next = AllText;
		AllText = temp;
	}
}

void TCharSet::ClearText() {
	if (AllText != NULL) delete AllText;
	AllText = NULL;
}

void TCharSet::PrintAll(unsigned int where) {
	TTextInfo *temp;
	for (temp = AllText; temp != NULL; temp = temp->next)
                PrintString(temp->y, temp->txt, temp->hs, where);
}
