
//	BARBIE.CPP

#include <malloc.h>
#include <math.h>
#include <i86.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <string.h>
#include "midasdll.h"

//	code includes
#include "mode13.h"
#include "vectors.h"
#include "obj3d.h"
#include "triangle.h"
#include "cuadro.h"
#include "charset.h"
#include "rotozoom.h"

//	binary includes
#include "charset0.h"
#include "lbarbie.h"
#include "lbarbie2.h"
#include "ezname.h"
#include "barbie0.h"
#include "barbie1.h"
#include "barbie2.h"
#include "barbie3.h"
#include "bitch1.h"
#include "bitch2.h"
#include "bitch3.h"
#include "gray0.h"
#include "gray1.h"
#include "gray2.h"
#include "gray3.h"
#include "eazy0.h"
#include "eazy1.h"
#include "eazy2.h"
#include "shot.h"
#include "barney0.h"
#include "barney1.h"
#include "logo.h"
#include "head.h"
#include "fondo.h"
#include "ojo1.h"
#include "ojo2.h"
#include "ojo3.h"
#include "ojo4.h"
#include "caramelo.h"


#define pi 3.14159265

//	Global stuff
TCharSet *charset = new TCharSet();
TPalette pal;
MIDASmodule module;
MIDASmodulePlayHandle playhandle;
char *modulename = "barbeazy.xm";
unsigned position, pattern, row;

typedef unsigned short TTunnelMatrix[200][320];
TTunnelMatrix *Trans1, *Trans2, *Trans3;

PTVirtual vscr;
unsigned int voff;

int shootcount = 0;
int dohidden = 0;

//	Midas stuff
void GetMusicInfo() {
	static MIDASplayStatus status;
	MIDASgetPlayStatus(playhandle, &status);
	position = status.position;
	pattern = status.pattern;
	row = status.row;
}


//	various cool functions
void ClearPalette(TPalette pal) {
	unsigned int off = FP_OFF(pal);
	_asm {
		mov edi, [off]
		mov ecx, 192
		xor eax, eax
		rep stosd
	}
}

void FadePalette(TPalette pal, int first, int last) {
	for (int i = first; i <= last; i++) {
		if (pal[i][0]) pal[i][0]--;
		if (pal[i][1]) pal[i][1]--;
		if (pal[i][2]) pal[i][2]--;
	}
}

void FadePaletteTo(TPalette pal, TPalette dest, int first, int last) {
	for (int i = first; i <= last; i++) {
		if (pal[i][0] > dest[i][0]) pal[i][0]--;
		if (pal[i][0] < dest[i][0]) pal[i][0]++;
		if (pal[i][1] > dest[i][1]) pal[i][1]--;
		if (pal[i][1] < dest[i][1]) pal[i][1]++;
		if (pal[i][2] > dest[i][2]) pal[i][2]--;
		if (pal[i][2] < dest[i][2]) pal[i][2]++;
	}
}

void CopyPalette(TPalette src, TPalette dst, int first, int last) {
	for (int i = first; i <= last; i++) {
		dst[i][0] = src[i][0];
		dst[i][1] = src[i][1];
		dst[i][2] = src[i][2];
	}
}


//	Initialization
void Initialize() {
        int start = clock();      
	//	initialize sound system
	CalcTrigTables();
	MIDASstartup();
	MIDASdetectSoundCard();
	MIDASconfig();
	printf("\nEazy sez wait...\n");
//	MIDASgetDisplayRefreshRate();
	MIDASinit();
	module = MIDASloadModule(modulename);

	//	initialize character set
	charset->Info.SizeX = 32;
	charset->Info.SizeY = 32;
	for (char c = 'a'; c <= '~'; c++) {
		charset->Info.Chars[c].y = ((c - 'a') / 10) * 32;
		charset->Info.Chars[c].x = ((c - 'a') % 10) * 32;
	}
	for (c = ' '; c <= '='; c++) {
		charset->Info.Chars[c].y = ((c - ' ') / 10 + 3) * 32;
		charset->Info.Chars[c].x = ((c - ' ') % 10) * 32;
	}
	charset->MapOff = FP_OFF(CHARSET0);

	//	initialize transformation tables
        int mapx1, mapy1, mapx2, mapy2, mapx3, mapy3;
        double dist, dist2, ang;
	Trans1 = (TTunnelMatrix *)malloc(sizeof(TTunnelMatrix));
	Trans2 = (TTunnelMatrix *)malloc(sizeof(TTunnelMatrix));
        Trans3 = (TTunnelMatrix *)malloc(sizeof(TTunnelMatrix));
	for (int y = 0; y < 200; y++)
		for (int x = 0; x < 320; x++) {
			mapy1 = 20.0 * sin(2.0 * x * pi / 160.0);
			mapy1 = (int)(mapy1 + y * 256.0 / 200.0) & 0xFF;
			mapx1 = 20.0 * cos(2.0 * y * pi / 100.0);
			mapx1 = (int)(mapx1 + x * 256.0 / 320.0) & 0xFF;
			dist = sqrt((x - 160) * (x - 160) + (y - 100) * (y - 100));
                        dist2 = sqrt((x - 148) * (x - 148) + (y - 100) * (y - 100));
			if (x != 160) ang = atan2((y - 100), (x - 160)) + pi;
			else ang = pi / 2.0;
                        mapx3 = (int)(ang * 256.0 / pi) & 0xFF;
                        if (dist2 > 20) mapy3 = (int)(10000.0 / dist2) & 0xFF;
                                else { mapx3 = 0; mapy3 = 0; }
			dist = dist + 10 * cos(ang * 5.0);
			mapx2 = (int)(ang * 256.0 / pi) & 0xFF;
			if (dist > 10) mapy2 = (int)(10000.0 / dist) & 0xFF;
                                else { mapx2 = 0; mapy2 = 0; }
			(*Trans1)[y][x] = (mapy1 << 8) + mapx1;
			(*Trans2)[y][x] = (mapy2 << 8) + mapx2;
                        (*Trans3)[y][x] = (mapy3 << 8) + mapx3;
		}

	//	initialize
	SetupVirtual(&vscr, &voff);
	ClearScreen(0, voff);
	SetMode13();
        srand(clock() - start);
}


//	uninitialization
void FreeEverything() {
	MIDASstopModule(playhandle);
	MIDASfreeModule(module);
	MIDASclose();
	SetTextMode();
	ShutDownVirtual(&vscr);
	free(Trans1);
	free(Trans2);
        free(Trans3);
	delete charset;
        if (dohidden) {
                printf("You shot Barney %d times.\n", shootcount);
                printf("I hope you feel better now.\n\n");
        }
        else printf("Barney wants you to find the hidden part...\n\n");
}


//	intro
void Intro() {
        TObject3D *blogo;
        TObject3D *elogo;
	TPalette temp;
        blogo = new TObject3D();
        elogo = new TObject3D();
	GeneraCuadro(3, 100, blogo);
	GeneraCuadro(3, 100, elogo);
	blogo->SetCenter(-100, 100);
	elogo->SetCenter(420, 100);
        blogo->NotFlatFastRotate(720, 0, 0);
        elogo->NotFlatFastRotate(720, 0, 0);
        blogo->Scale(1.5, 1.5, 1.5);
        elogo->Scale(1.5, 1.5, 1.5);
	CopyPalette(LBARBIE_PAL, pal, 0, 191);
	CopyPalette(EZNAME_PAL, pal, 192, 223);
	for (int i = 0; i < 22; i++) {
		pal[i + 224][0] = i * 3;
		pal[i + 224][1] = i * 3;
                pal[i + 224][2] = i * 3;
	}
	pal[0][0] = 0; pal[0][1] = 0; pal[0][2] = 0;
	ClearPalette(temp);
	SetPalette(temp);
	GetMusicInfo();
        charset->PrintString(80, "delabu alama", -10, VGA);
	while (row < 16) {
		FadePaletteTo(temp, pal, 0, 255);
		VRetrace();
		SetPalette(temp);
		GetMusicInfo();
	}
	VRetrace();
        SetPalette(LBARBIE2_PAL);
        i = -50;
        TextureOffset = FP_OFF(LBARBIE2);
	while (row < 32) {
                ClearScreen(167, voff);
                blogo->SetCenter(i, 80);
                blogo->Draw(voff);
		VRetrace();
                CopyScreen(voff, VGA);
		if (i < 100) i++;
		GetMusicInfo();
	}
	ClearScreen(0, VGA);
	ClearPalette(temp);
	SetPalette(temp);
        charset->PrintString(80, "presents", -10, VGA);
	while (row < 48) {
		FadePaletteTo(temp, pal, 0, 255);
		VRetrace();
		SetPalette(temp);
		GetMusicInfo();
	}
	VRetrace();
        SetPal(0, 32, 0, 0);
        i = 370;
        TextureOffset = FP_OFF(EZNAME);
        while (position < 1) {
                ClearScreen(0, voff);
                elogo->SetCenter(i, 80);
                elogo->Draw(voff);
		VRetrace();
                CopyScreen(voff, VGA);
                if (i > 220) i--;
		GetMusicInfo();
	}
	ClearScreen(0, VGA);
	ClearPalette(temp);
	SetPalette(temp);
        charset->PrintString(80, "a new deadmo", -10, VGA);
        while (row < 32) {
		FadePaletteTo(temp, pal, 0, 255);
		VRetrace();
		SetPalette(temp);
		GetMusicInfo();
	}
        i = 0;
        while (i++ < 64) {
                FadePalette(temp, 0, 255);
                VRetrace();
                SetPalette(temp);
        }
        ClearScreen(0, VGA);
        SetPalette(pal);
        i = 0;
        while (i++ < 140) {
                ClearScreen(0, voff);
                blogo->SetCenter(i - 50, 80);
                elogo->SetCenter(370 - i, 80);
                TextureOffset = FP_OFF(LBARBIE);
                blogo->Draw(voff);
                TextureOffset = FP_OFF(EZNAME);
                elogo->Draw(voff);
                if (i < 120) charset->PrintString(200 - i, "meets", -10, voff);
		VRetrace();
                CopyScreen(voff, VGA);
        }
        GetMusicInfo();
        i = 0;
        while ((position == 2) && (row < 48)) {
                ClearScreen(0, voff);
                blogo->SetCenter(90 - i / 2, 80 - i / 2);
                blogo->Scale(0.99, 0.99, 0.99);
                blogo->Rotate(4, 4, 0);
                TextureOffset = FP_OFF(LBARBIE);
                blogo->Draw(voff);
                charset->PrintString(80, "meets", -10, voff);
                elogo->SetCenter(230 + i, 80 + i / 2);
                elogo->Scale(1.01, 1.01, 1.01);
                elogo->Rotate(0, -4, -4);
                TextureOffset = FP_OFF(EZNAME);
                elogo->Draw(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                i++;
                GetMusicInfo();
        }
        int j;
        while (position < 3) {
                ClearScreen(0, voff);
                blogo->SetCenter(90 - i / 2, 80 - i / 2);
                blogo->Scale(0.99, 0.99, 0.99);
                blogo->Rotate(4, 4, 0);
                TextureOffset = FP_OFF(LBARBIE);
                blogo->Draw(voff);
                charset->PrintString(80, "meets", -10, voff);
                elogo->SetCenter(230 + i, 80 + i / 2);
                elogo->Scale(1.01, 1.01, 1.01);
                elogo->Rotate(0, -4, -4);
                TextureOffset = FP_OFF(EZNAME);
                elogo->Draw(voff);
                for (j = 0; j < 256; j++) {
                        if (pal[j][0] < 63) pal[j][0]++;
                        if (pal[j][1] < 63) pal[j][1]++;
                        if (pal[j][2] < 63) pal[j][2]++;
                        if (pal[j][0] < 63) pal[j][0]++;
                        if (pal[j][1] < 63) pal[j][1]++;
                        if (pal[j][2] < 63) pal[j][2]++;
                }
                VRetrace();
                CopyScreen(voff, VGA);
                SetPalette(pal);
                i++;
                GetMusicInfo();
        }
        delete blogo;
        delete elogo;
}



void DrawTunnel(unsigned int table,
                unsigned int texture,
                int depth, int ang,
                unsigned int where);
#pragma aux DrawTunnel =				\
"shl edx, 8"							\
"add edx, eax"						  \
"mov ecx, 64000"						\
"gloop: movzx eax, word ptr [ebx]"	   \
"       add ax, dx"                                    \
"       add ebx, 2"                                    \
"       mov al, [esi + eax]"                  \
"       or al, al"                      \
"       jz nope"                       \
"       mov [edi], al"                                  \
"nope:  inc edi"                                              \
"       dec ecx"                                              \
"       jnz gloop"                                           \
parm [ebx] [esi] [edx] [eax] [edi]                            \
modify [ecx];


void Credits() {
        TRotoZoom *rotozoom = new TRotoZoom(FP_OFF(LBARBIE2), LBARBIE2_PAL);
        CopyPalette(BARBIE0_PAL, pal, 0, 111);
        CopyPalette(LBARBIE2_PAL, pal, 112, 223);
        for (int i = 0; i < 22; i++) {
                pal[i + 224][0] = i * 3;
                pal[i + 224][1] = i * 3;
                pal[i + 224][2] = i * 3;
        }
        ClearScreen(0, VGA);
        SetPalette(pal);
        i = 200;
        unsigned char t = 0;
        int a = 0;
        GetMusicInfo();
        while (row < 32) {
                rotozoom->Draw(voff, 200);
                rotozoom->Scale(1 - sint[a] * 0.01);
                rotozoom->Rotate(cost[(a < 1438) ? (a += 2) : (a = 0)] * 8);
                DrawTunnel(FP_OFF(Trans1), FP_OFF(BARBIE0), t, t++, voff);
                charset->PrintRight(i, "fac=code", -10, voff);
                VRetrace();
                CopyScreen(voff, VGA);
                if ((i > 160) && ((t & 1) == 0)) i--;
                GetMusicInfo();
        }
        i = 200;
        while (position < 4) {
                rotozoom->Scale(1 - sint[a] * 0.01);
                rotozoom->Rotate(cost[(a < 1438) ? (a += 2) : (a = 0)] * 8);
                DrawTunnel(FP_OFF(Trans2), FP_OFF(LBARBIE2), 255 - t, 255 - t, voff);
                DrawTunnel(FP_OFF(Trans1), FP_OFF(BARBIE1), t, t++, voff);
                charset->PrintRight(i, "fac=music", -10, voff);
                VRetrace();
                CopyScreen(voff, VGA);
                if ((i > 160) && ((t & 1) == 0)) i--;
                GetMusicInfo();
        }
        i = 200;
        while (row < 32) {
                rotozoom->Draw(voff, 200);
                rotozoom->Scale(1 - sint[a] * 0.01);
                rotozoom->Rotate(cost[(a < 1438) ? (a += 2) : (a = 0)] * 8);
                DrawTunnel(FP_OFF(Trans1), FP_OFF(BARBIE2), t, t++, voff);
                charset->PrintRight(i, "manolo=gfx", -10, voff);
                VRetrace();
                CopyScreen(voff, VGA);
                if ((i > 160) && ((t & 1) == 0)) i--;
                GetMusicInfo();
        }
        i = 200;
        while (position < 5) {
                rotozoom->Scale(1 - sint[a] * 0.01);
                rotozoom->Rotate(cost[(a < 1438) ? (a += 2) : (a = 0)] * 8);
                DrawTunnel(FP_OFF(Trans2), FP_OFF(LBARBIE2), 40, 128 - t, voff);
                DrawTunnel(FP_OFF(Trans1), FP_OFF(BARBIE3), t, t++, voff);
                charset->PrintRight(i, "barbie=bitch", -10, voff);
                VRetrace();
                CopyScreen(voff, VGA);
                if ((i > 160) && ((t & 1) == 0)) i--;
                GetMusicInfo();
        }
        delete rotozoom;
}


void BlitPic(unsigned int source, unsigned int where);
#pragma aux BlitPic =           \
"mov ecx, 13600"                \
"add edi, 4800"                 \
"rep movsd"                     \
parm [esi] [edi]                \
modify [ecx];


void Party() {
        ClearScreen(0, VGA);
        SetPalette(GRAY2_PAL);
        BlitPic(FP_OFF(GRAY2), VGA);
        while (row < 4) GetMusicInfo();

        ClearScreen(0, VGA);
        SetPalette(BITCH3_PAL);
        BlitPic(FP_OFF(BITCH3), VGA);
        while (row < 8) GetMusicInfo();

        ClearScreen(0, VGA);
        SetPalette(GRAY3_PAL);
        BlitPic(FP_OFF(GRAY3), VGA);
        while (row < 12) GetMusicInfo();

        ClearScreen(0, VGA);
        SetPalette(GRAY0_PAL);
        BlitPic(FP_OFF(GRAY0), VGA);
        while (position < 6) GetMusicInfo();
}


void DrawShot() {
        unsigned int y = 20 + 150 * rand() / RAND_MAX;
        unsigned int x = 100 + 30 * rand() / RAND_MAX;
        unsigned int dst = FP_OFF(BARBIE3) + (y << 8) + x;
        unsigned int src = FP_OFF(SHOT);
        _asm {
                mov edi, [dst]
                mov esi, [src]
                mov edx, 20
                loopy:  mov ecx, 20
                loopx:  mov al, [esi]
                        or al, al
                        jz nope
                        mov [edi], al
                nope:   inc edi
                        inc esi
                        dec ecx
                        jnz loopx
                        add edi, 236
                        dec edx
                        jnz loopy
        }
}


void Disco() {
        unsigned int Sequence[6] = { FP_OFF(BARBIE0), FP_OFF(BARBIE2),
                                     FP_OFF(BARBIE1), FP_OFF(BARBIE3),
                                     FP_OFF(BARBIE1), FP_OFF(BARBIE2) };
        TObject3D *barbie = new TObject3D();
        TObject3D *eazy = new TObject3D();
        GeneraCuadro(3, 100, barbie);
        GeneraCuadro(3, 100, eazy);
        barbie->Rotate(720, 0, 0);
        eazy->Rotate(720, 0, 0);
        barbie->Traslate(0, 100, 0);
        barbie->Scale(2, 2, 2);
        eazy->Scale(2, 2, 2);

        CopyPalette(BARBIE0_PAL, pal, 0, 111);
        CopyPalette(SHOT_PAL, pal, 112, 127);
        CopyPalette(EAZY0_PAL, pal, 128, 255);

        VRetrace();
        ClearScreen(0, VGA);
        SetPalette(pal);
        GetMusicInfo();
        int x = -40;
        int count = 0;
        int flag = 0;
        while (position < 7) {
                ClearScreen(0, voff);
                TextureOffset = Sequence[count % 6];
                barbie->SetCenter(x / 2, 200);
                barbie->Draw(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
                if ((row & 1) == flag) { count++; flag = -1; }
                if ((row & 1) == 1) flag = 0;
                if (x < 120) x++;
        }

        x = 360;
        while (row < 32) {
                ClearScreen(0, voff);
                TextureOffset = Sequence[count % 6];
                barbie->Draw(voff);
                TextureOffset = FP_OFF(EAZY0);
                eazy->SetCenter(x, 100);
                eazy->Draw(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
                if ((row & 1) == flag) { count++; flag = -1; }
                if ((row & 1) == 1) flag = 0;
                if (x > 220) x--;
        }

        while (row < 40) {
                ClearScreen(0, voff);
                TextureOffset = Sequence[count % 6];
                barbie->Draw(voff);
                TextureOffset = FP_OFF(EAZY1);
                eazy->Draw(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
                if ((row & 1) == flag) { count++; flag = -1; }
                if ((row & 1) == 1) flag = 0;
        }

        x = 0;
        flag = 0;
        while (position < 8) {
                ClearScreen(0, voff);
                TextureOffset = FP_OFF(BARBIE3);
                barbie->SetCenter(60 + x / 4, 200 - x / 4);
                barbie->Draw(voff);
                if ((row == 0x28) || (row == 0x2B) || (row == 0x2F) ||
                    (row == 0x35)) {
                        TextureOffset = FP_OFF(EAZY2);
                        if (!flag) { DrawShot(); flag = -1; }
                }
                else { TextureOffset = FP_OFF(EAZY1); flag = 0; }
                eazy->Draw(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                if (x < 90) { barbie->Rotate(0, 0, 4); x++; }
                GetMusicInfo();
        }

        while (row < 12) {
                ClearScreen(0, voff);
                TextureOffset = FP_OFF(BARBIE3);
                if (row < 1) barbie->XCenter += 2;
                if (row > 1) barbie->XCenter -= 2;
                barbie->Draw(voff);
                TextureOffset = FP_OFF(EAZY1);
                eazy->Draw(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }

        while (position < 9) {
                for (x = 0; x < 256; x++) {
                        if (pal[x][0] < 63) pal[x][0]++;
                        if (pal[x][1] < 63) pal[x][1]++;
                        if (pal[x][2] < 63) pal[x][2]++;
                        if (pal[x][0] < 63) pal[x][0]++;
                        if (pal[x][1] < 63) pal[x][1]++;
                        if (pal[x][2] < 63) pal[x][2]++;
                }
                VRetrace();
                SetPalette(pal);
                GetMusicInfo();
        }

        delete barbie;
        delete eazy;
}


void BlitTransPic(unsigned int source, unsigned int where);
#pragma aux BlitTransPic =      \
"mov ecx, 54400"                \
"add edi, 4800"                 \
"bloop: mov al, [esi]"          \
"       or al, al"              \
"       jz nope"                \
"       mov [edi], al"          \
"nope:  inc esi"                \
"       inc edi"                \
"       dec ecx"                \
"       jnz bloop"              \
parm [esi] [edi]                \
modify [ecx];


void DrawFullTunnel(unsigned int table,
                unsigned int texture,
                int depth, int ang,
                unsigned int where);
#pragma aux DrawFullTunnel =                                \
"shl edx, 8"							\
"add edx, eax"						  \
"mov ecx, 64000"						\
"gloop: movzx eax, word ptr [ebx]"	   \
"       add ax, dx"                                    \
"       add ebx, 2"                                    \
"       mov al, [esi + eax]"                  \
"       mov [edi], al"                                  \
"       inc edi"                                              \
"       dec ecx"                                              \
"       jnz gloop"                                           \
parm [ebx] [esi] [edx] [eax] [edi]                            \
modify [ecx];


void Bullshit() {
        CopyPalette(CARAMELO_PAL, pal, 0, 127);
        for (int i = 0; i < 22; i++) {
                pal[i + 224][0] = i * 3;
                pal[i + 224][1] = i * 2;
                pal[i + 224][2] = i;
        }
        ClearScreen(0, VGA);
        unsigned char t = 0;
        GetMusicInfo();

        CopyPalette(BITCH1_PAL, pal, 128, 223);
        VRetrace();
        SetPalette(pal);
        charset->ClearText();
        charset->AddText(0, 4, "", -10);
        while (row < 11) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(BITCH1), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 36, "", -10);
        while (row < 21) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(BITCH1), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 68, "shot outs", -10);
        while (row < 32) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(BITCH1), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 100, "go to", -10);
        while (row < 43) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(BITCH1), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 132, "", -10);
        while (row < 53) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(BITCH1), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 164, "", -10);
        while (row > 0) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(BITCH1), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }


        CopyPalette(OJO1_PAL, pal, 128, 223);
        VRetrace();
        SetPalette(pal);
        charset->ClearText();
        charset->AddText(0, 4, "tpolm", -10);
        while (row < 11) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(OJO1), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 36, "orange", -10);
        while (row < 21) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(OJO1), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 68, "pulse", -10);
        while (row < 32) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(OJO1), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 100, "fudge", -10);
        while (row < 43) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(OJO1), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 132, "tbl", -10);
        while (row < 53) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(OJO1), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 164, "bomb", -10);
        while (row > 0) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(OJO1), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }


        CopyPalette(OJO2_PAL, pal, 128, 223);
        VRetrace();
        SetPalette(pal);
        charset->ClearText();
        charset->AddText(0, 4, "lightspeed", -10);
        while (row < 11) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(OJO2), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 36, "cncd", -10);
        while (row < 21) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(OJO2), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 68, "melon", -10);
        while (row < 32) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(OJO2), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 100, "cubic", -10);
        while (row < 43) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(OJO2), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 132, "purple", -10);
        while (row < 53) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(OJO2), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 164, "halcyon", -10);
        while (row > 0) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(OJO2), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }


        CopyPalette(OJO3_PAL, pal, 128, 223);
        VRetrace();
        SetPalette(pal);
        charset->ClearText();
        charset->AddText(0, 4, "delabu", -10);
        while (row < 11) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(OJO3), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 36, "has never", -10);
        while (row < 21) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(OJO3), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 68, "harmed", -10);
        while (row < 32) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(OJO3), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 100, "any", -10);
        while (row < 43) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(OJO3), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 132, "barbie", -10);
        while (row < 53) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(OJO3), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 164, "dolls", -10);
        while (row > 0) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(OJO3), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }


        CopyPalette(OJO4_PAL, pal, 128, 223);
        VRetrace();
        SetPalette(pal);
        charset->ClearText();
        charset->AddText(0, 4, "what", -10);
        while (row < 11) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(OJO4), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 36, "you", -10);
        while (row < 21) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(OJO4), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 68, "think", -10);
        while (row < 32) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(OJO4), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 100, "about", -10);
        while (row < 43) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(OJO4), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 132, "us", -10);
        while (row < 53) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(OJO4), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 164, "is false", -10);
        while (row > 0) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(OJO4), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }


        CopyPalette(BITCH2_PAL, pal, 128, 223);
        VRetrace();
        SetPalette(pal);
        charset->ClearText();
        charset->AddText(0, 4, "say", -10);
        while (row < 11) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(BITCH2), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 36, "bye", -10);
        while (row < 21) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(BITCH2), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 68, "to", -10);
        while (row < 32) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(BITCH2), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 100, "the", -10);
        while (row < 43) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(BITCH2), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 132, "bad", -10);
        while (row < 53) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t+=2, voff);
                BlitTransPic(FP_OFF(BITCH2), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
        charset->AddText(0, 164, "guy", -10);
        while (row > 0) {
                DrawFullTunnel(FP_OFF(Trans3), FP_OFF(CARAMELO), 0, t-=2, voff);
                BlitTransPic(FP_OFF(BITCH2), voff);
                charset->PrintAll(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }
}



void Outro() {
        TObject3D *barney = new TObject3D();
        TObject3D *dlogo = new TObject3D();
        TObject3D *head = new TObject3D();
        GeneraCuadro(3, 100, barney);
        GeneraCuadro(3, 100, dlogo);
        GeneraCuadro(3, 100, head);
        barney->Rotate(720, 0, 0);
        barney->Traslate(-8, -100, 0);
        barney->SetCenter(80, 0);
        barney->Scale(1.5, 1.5, 1.5);
        dlogo->Rotate(720, 0, 0);
        dlogo->SetCenter(320, 0);
        dlogo->Scale(2.5, 2.5, 2.5);
        dlogo->Rotate(0, 0, 120);
        head->Rotate(720, 0, 0);
        head->Scale(0.5, 0.5, 0.5);
        ClearScreen(0, VGA);
        for (int x = 0; x < 256; x++)
                pal[x][0] = pal[x][1] = pal[x][2] = 63;
        SetPalette(pal);
        x = -100;
        int angb = 0, angh = 0;
        GetMusicInfo();
        while (row < 0x28) {
                CopyScreen(FP_OFF(FONDO), voff);
                if (row & 1) TextureOffset = FP_OFF(BARNEY1);
                        else TextureOffset = FP_OFF(BARNEY0);
                barney->Rotate(0, 0, 60 * sint[angb]);
                barney->Draw(voff);
                barney->Rotate(0, 0, -60 * sint[angb]);
                TextureOffset = FP_OFF(HEAD);
                head->SetCenter(x, 175 - abs(40 * sint[angh]));
                head->Rotate(0, 0, -10);
                head->Draw(voff);
                x += 2;
                if ((angh += 18) >= 1440) angh -= 1440;
                if ((angb += 15) >= 1440) angb -= 1440;
                TextureOffset = FP_OFF(LOGO);
                dlogo->Rotate(0, 0, -4);
                dlogo->Draw(voff);
                FadePaletteTo(pal, FONDO_PAL, 0, 255);
                VRetrace();
                CopyScreen(voff, VGA);
                SetPalette(pal);
                GetMusicInfo();
        }
        x = 0;
        while (x++ < 64) {
                CopyScreen(FP_OFF(FONDO), voff);
                if (row & 1) TextureOffset = FP_OFF(BARNEY1);
                        else TextureOffset = FP_OFF(BARNEY0);
                barney->Rotate(0, 0, 60 * sint[angb]);
                barney->Draw(voff);
                barney->Rotate(0, 0, -60 * sint[angb]);
                if ((angb += 15) >= 1440) angb -= 1440;
                TextureOffset = FP_OFF(LOGO);
                dlogo->Rotate(0, 0, -4);
                dlogo->Draw(voff);
                FadePalette(pal, 0, 255);
                VRetrace();
                CopyScreen(voff, VGA);
                SetPalette(pal);
                GetMusicInfo();
        }
        delete barney;
        delete dlogo;
        delete head;
}



void Blur(unsigned int where);
#pragma aux Blur = \
"add edi, 320"	\
"xor ebx, ebx"	\
"mov ecx, 63360"	\
"@loop:	movzx eax, byte ptr [edi-1]" \
"		mov bl, [edi+1]" \
"		add eax, ebx"	\
"		mov bl, [edi-320]" \
"		add eax, ebx"	\
"		mov bl, [edi+320]" \
"		add eax, ebx" \
"		shr eax, 2" \
"		mov [edi], al" \
"		inc edi" \
"		dec ecx" \
"		jnz @loop" \
parm [edi] \
modify [eax ebx ecx];


void DelabuLogo() {
        TObject3D *logo = new TObject3D();
        GeneraCuadro(3, 100, logo);
        logo->Rotate(720, 0, 0);
        logo->Scale(1.9, 1, 1);
        logo->Traslate(0, 0, -1000);
        logo->SetCenter(160, 100);
        ClearScreen(0, VGA);
        for (int z = 0; z < 256; z++) {
                pal[z][1] = pal[z][2] = z >> 2;
                pal[z][0] = 0;
        }
        SetPalette(pal);
        z = 0;
        while (z < 26) {
                TextureOffset = FP_OFF(GRAY1);
                ClearScreen(0, voff);
                logo->Draw(voff);
                Blur(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                if (z & 1) {
                        logo->Traslate(0, 0, 100);
                        logo->Rotate(0, 0, -120);
                }
                z++;
        }
        GetMusicInfo();
        z = row;
        while (row == z) GetMusicInfo();
        z = row;
        while (row == z) GetMusicInfo();
        z = row;
        while (row == z) GetMusicInfo();
        z = row;
        while (row == z) GetMusicInfo();
        z = 0;
        while (z < 30) {
                TextureOffset = FP_OFF(GRAY1);
                ClearScreen(0, voff);
                logo->Draw(voff);
                Blur(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                if (z & 1) {
                        logo->XCenter += 16;
                        logo->Traslate(0, 0, -50);
                        logo->Rotate(0, 0, -120);
                }
                z++;
        }
        z = row;
        while (row == z) GetMusicInfo();
        z = row;
        while (row == z) GetMusicInfo();
        z = row;
        while (row == z) GetMusicInfo();
        z = row;
        while (row == z) GetMusicInfo();
        
        delete logo;
}


void ShootBarney() {
        unsigned int y = 40 + 150 * rand() / RAND_MAX;
        unsigned int x = 85 + 80 * rand() / RAND_MAX;
        unsigned int dst1 = FP_OFF(BARNEY0) + (y << 8) + x;
        unsigned int dst2 = FP_OFF(BARNEY1) + (y << 8) + x;
        unsigned int src = FP_OFF(SHOT);
        shootcount++;
        _asm {
                mov edi, [dst1]
                mov ebx, [dst2]
                mov esi, [src]
                mov edx, 20
                loopy:  mov ecx, 20
                loopx:  mov al, [esi]
                        or al, al
                        jz nope
                        mov [edi], al
                        mov [ebx], al
                nope:   inc edi
                        inc ebx
                        inc esi
                        dec ecx
                        jnz loopx
                        add edi, 236
                        add ebx, 236
                        dec edx
                        jnz loopy
        }
}

void Hidden()   {
        TObject3D *barney = new TObject3D();
        TObject3D *eazy = new TObject3D();
        TPalette temp;
        GeneraCuadro(3, 100, barney);
        barney->Rotate(720, 0, 0);
        barney->Traslate(-8, -100, 0);
        barney->SetCenter(80, 0);
        barney->Scale(1.8, 1.8, 1.8);
        GeneraCuadro(3, 100, eazy);
        eazy->Rotate(720, 0, 0);
        eazy->Scale(2, 2, 2);
        CopyPalette(BARNEY0_PAL, pal, 0, 111);
        CopyPalette(EAZY0_PAL, pal, 128, 255);
        CopyPalette(SHOT_PAL, pal, 112, 127);

        ClearScreen(0, VGA);
        ClearPalette(temp);
        SetPalette(temp);
        charset->PrintString(64, "you have found", -10, VGA);
        charset->PrintString(96, "the hidden part", -10, VGA);
        for (int i = 0; i < 64; i++) {
                for (int j = 1; j < 22; j++) {
                        if (temp[j + 224][0] < (j * 3)) temp[j + 224][0]++;
                        if (temp[j + 224][1] < (j * 3)) temp[j + 224][1]++;
                        if (temp[j + 224][2] < (j * 3)) temp[j + 224][2]++;
                }
                VRetrace();
                SetPalette(temp);
        }
        GetMusicInfo();
        int flag = row + 4;
        if (flag > 63) flag -= 64;
        while (row != flag) GetMusicInfo();
        for (i = 0; i < 64; i++) {
                for (int j = 1; j < 22; j++) {
                        if (temp[j + 224][0] > 0) temp[j + 224][0]--;
                        if (temp[j + 224][1] > 0) temp[j + 224][1]--;
                        if (temp[j + 224][2] > 0) temp[j + 224][2]--;
                }
                VRetrace();
                SetPalette(temp);
        }

        MIDASsetPosition(playhandle, 9);
        ClearScreen(0, VGA);
        SetPalette(pal);

        int angb = 720;
        int x = 370;
        GetMusicInfo();
        while (row < 54) {
                ClearScreen(0, voff);
                if (row & 2) TextureOffset = FP_OFF(BARNEY1);
                        else TextureOffset = FP_OFF(BARNEY0);
                barney->Rotate(0, 0, 60 * sint[angb]);
                barney->Draw(voff);
                barney->Rotate(0, 0, -60 * sint[angb]);
                if ((angb += 15) >= 1440) angb -= 1440;
                TextureOffset = FP_OFF(EAZY0);
                eazy->SetCenter(x, 100);
                eazy->Draw(voff);
                if (x > 220) x--;
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }

        ClearScreen(0, VGA);
        ClearPalette(temp);
        SetPalette(temp);
        charset->PrintString(4, "press space", -10, VGA);
        charset->PrintString(36, "to shoot him", -10, VGA);
        charset->PrintString(100, "press esc", -10, VGA);
        charset->PrintString(132, "when you agree", -10, VGA);
        charset->PrintString(164, "delabu rulez", -10, VGA);
        for (i = 0; i < 64; i++) {
                for (int j = 1; j < 22; j++) {
                        if (temp[j + 224][0] < (j * 3)) temp[j + 224][0]++;
                        if (temp[j + 224][1] < (j * 3)) temp[j + 224][1]++;
                        if (temp[j + 224][2] < (j * 3)) temp[j + 224][2]++;
                }
                VRetrace();
                SetPalette(temp);
        }
        GetMusicInfo();
        flag = row + 32;
        if (flag > 63) flag -= 64;
        while (row != flag) GetMusicInfo();
        for (i = 0; i < 64; i++) {
                for (int j = 1; j < 22; j++) {
                        if (temp[j + 224][0] > 0) temp[j + 224][0]--;
                        if (temp[j + 224][1] > 0) temp[j + 224][1]--;
                        if (temp[j + 224][2] > 0) temp[j + 224][2]--;
                }
                VRetrace();
                SetPalette(temp);
        }

        VRetrace();
        ClearScreen(0, VGA);
        SetPalette(pal);
        char k = 'x';
        int shot = -1;
        while (k != 27) {
                if (kbhit()) 
                        if ((k = getch()) == 32) { ShootBarney(); shot = row; }
                ClearScreen(0, voff);
                if (row & 2) TextureOffset = FP_OFF(BARNEY1);
                        else TextureOffset = FP_OFF(BARNEY0);
                barney->Rotate(0, 0, 60 * sint[angb]);
                barney->Draw(voff);
                barney->Rotate(0, 0, -60 * sint[angb]);
                if ((angb += 15) >= 1440) angb -= 1440;
                if (row == shot) TextureOffset = FP_OFF(EAZY2);
                else { TextureOffset = FP_OFF(EAZY1); shot = -1; }
                eazy->Draw(voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
        }

        ClearScreen(0, VGA);
        ClearPalette(temp);
        SetPalette(temp);
        charset->PrintString(36, "barney", -10, VGA);
        charset->PrintString(68, "is", -10, VGA);
        charset->PrintString(100, "evil", -10, VGA);
        for (i = 0; i < 64; i++) {
                for (int j = 1; j < 22; j++) {
                        if (temp[j + 224][0] < (j * 3)) temp[j + 224][0]++;
                        if (temp[j + 224][1] < (j * 3)) temp[j + 224][1]++;
                        if (temp[j + 224][2] < (j * 3)) temp[j + 224][2]++;
                }
                VRetrace();
                SetPalette(temp);
        }
        GetMusicInfo();
        flag = row + 10;
        if (flag > 63) flag -= 64;
        while (row != flag) GetMusicInfo();
        for (i = 0; i < 64; i++) {
                for (int j = 1; j < 22; j++) {
                        if (temp[j + 224][0] > 0) temp[j + 224][0]--;
                        if (temp[j + 224][1] > 0) temp[j + 224][1]--;
                        if (temp[j + 224][2] > 0) temp[j + 224][2]--;
                }
                VRetrace();
                SetPalette(temp);
        }

        delete barney;
        delete eazy;
}



//	main
void main(int argc, char *argv[]) {
        if (argc >= 3)
                if ((!strcmp(argv[1], "hanging")) &&
                    (!strcmp(argv[2], "barney"))) dohidden = 1;
	Initialize();
	playhandle = MIDASplayModule(module, TRUE);
        Intro();
//        MIDASsetPosition(playhandle, 3);
        Credits();
//        MIDASsetPosition(playhandle, 5);
        Party();
//        MIDASsetPosition(playhandle, 6);
        Disco();
//        MIDASsetPosition(playhandle, 9);
        Bullshit();
        MIDASsetPosition(playhandle, 10); // dont comment this one
        Outro();
        if (dohidden) Hidden();
        DelabuLogo();
	FreeEverything();
}
