
#include "obj3d.h"
#include "vectors.h"
#include "lightsrc.h"
#include "triangle.h"
#include "hires256.h"
#include "polygons.h"

// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif


int X_MIN[480], X_MAX[480], C_MIN[480], C_MAX[480];
double U_MIN[480], U_MAX[480], V_MIN[480], V_MAX[480];


// wireframe

void ClipDDALine(int x1, int y1, int x2, int y2, int color, unsigned int where) {
	//	line clipping
	double m = (double)(y2 - y1) / (double)(x2 - x1);
	double im = 1 / m;
	if (x1 <= x2) {
                if ((x1 > 639) || (x2 < 0)) return;
		if (x1 < 0) { y1 += dtoi(-x1 * m); x1 = 0; }
                if (x2 > 639) { y2 -= dtoi((x2 - 639) * m); x2 = 639; }
	}
	else {
                if ((x1 < 0) || (x2 > 639)) return;
		if (x2 < 0) { y2 += dtoi(-x2 * m); x2 = 0; }
                if (x1 > 639) { y1 -= dtoi((x1 - 639) * m); x1 = 639; }
	}
	if (y1 <= y2) {
                if ((y1 > 479) || (y2 < 0)) return;
		if (y1 < 0) { x1 += dtoi(-y1 * im); y1 = 0; }
                if (y2 > 479) { x2 -= dtoi((y2 - 479) * im); y2 = 479; }
	}
	else {
                if ((y1 < 0) || (y2 > 479)) return;
		if (y2 < 0) { x2 += dtoi(-y2 * im); y2 = 0; }
                if (y1 > 479) { x1 -= dtoi((y1 - 479) * im); y1 = 479; }
	}
	
	int width = x2 - x1;
	int height = y2 - y1;
	if (width < 0) width = -width;
	if (height < 0) height = - height;
	if (width > height) {
		if (height == 0) height = 1;
		if (x1 > x2) {
			int temp = x1; x1 = x2; x2 = temp;
			temp = y1; y1 = y2; y2 = temp;
		}
		int dy = (height << 16) / width;
                int yinc = (y1 > y2) ? (-640) : (640);
                unsigned int off = where + (y1 << 9) + (y1 << 7) + x1;
		_asm {
			mov edi, [off]
			mov esi, [yinc]
                        mov eax, [color]
			mov edx, [dy]
			xor ebx, ebx
			mov ecx, [width]
			lloop:  mov [edi], al
                                inc edi
                                add bx, dx
                                jnc cont
                                add edi, esi
			cont:   dec ecx
                                jnz lloop
		}
		return;
	}
	if (width < height) {
		if (width == 0) width = 1;
		if (y1 > y2) {
			int temp = y1; y1 = y2; y2 = temp;
			temp = x1; x1 = x2; x2 = temp;
		}
		int ddx = (width << 16) / height;
		int xinc = (x1 > x2) ? (-1) : (1);
                unsigned int off = where + (y1 << 9) + (y1 << 7) + x1;
		_asm {
			mov edi, [off]
			mov esi, [xinc]
                        mov eax, [color]
			mov edx, [ddx]
			xor ebx, ebx
			mov ecx, [height]
			lloop:  mov [edi], al
                                add edi, 640
                                add bx, dx
                                jnc cont
                                add edi, esi
			cont:   dec ecx
                                jnz lloop
		}
		return;
	}
	if (width == 0) width = 1;
	int dx = (x1 > x2) ? (-1) : (1);
        int dy = (y1 > y2) ? (-640 + dx) : (640 + dx);
        unsigned int off = where + (y1 << 9) + (y1 << 7) + x1;
	_asm {
		mov edi, [off]
                mov eax, [color]
		mov ebx, [dy]
		mov ecx, [width]
		lloop:  mov [edi], al
                        add edi, ebx
                        dec ecx
                        jnz lloop
	}
}


void ClipAddDDALine(int x1, int y1, int x2, int y2, int color, unsigned int where) {
	//	line clipping
	double m = (double)(y2 - y1) / (double)(x2 - x1);
	double im = 1 / m;
	if (x1 <= x2) {
                if ((x1 > 639) || (x2 < 0)) return;
		if (x1 < 0) { y1 += dtoi(-x1 * m); x1 = 0; }
                if (x2 > 639) { y2 -= dtoi((x2 - 639) * m); x2 = 639; }
	}
	else {
                if ((x1 < 0) || (x2 > 639)) return;
		if (x2 < 0) { y2 += dtoi(-x2 * m); x2 = 0; }
                if (x1 > 639) { y1 -= dtoi((x1 - 639) * m); x1 = 639; }
	}
	if (y1 <= y2) {
                if ((y1 > 479) || (y2 < 0)) return;
		if (y1 < 0) { x1 += dtoi(-y1 * im); y1 = 0; }
                if (y2 > 479) { x2 -= dtoi((y2 - 479) * im); y2 = 479; }
	}
	else {
                if ((y1 < 0) || (y2 > 479)) return;
		if (y2 < 0) { x2 += dtoi(-y2 * im); y2 = 0; }
                if (y1 > 479) { x1 -= dtoi((y1 - 479) * im); y1 = 479; }
	}
	
	int width = x2 - x1;
	int height = y2 - y1;
	if (width < 0) width = -width;
	if (height < 0) height = - height;
	if (width > height) {
		if (height == 0) height = 1;
		if (x1 > x2) {
			int temp = x1; x1 = x2; x2 = temp;
			temp = y1; y1 = y2; y2 = temp;
		}
		int dy = (height << 16) / width;
                int yinc = (y1 > y2) ? (-640) : (640);
                unsigned int off = where + (y1 << 9) + (y1 << 7) + x1;
		_asm {
			mov edi, [off]
			mov esi, [yinc]
                        mov eax, [color]
			mov edx, [dy]
			xor ebx, ebx
			mov ecx, [width]
                        lloop:  add byte ptr [edi], al
                                jnc nomax
                                mov al, 0FFh
                                mov [edi], al
                        nomax:  inc edi
                                add bx, dx
                                jnc cont
                                add edi, esi
			cont:   dec ecx
                                jnz lloop
		}
		return;
	}
	if (width < height) {
		if (width == 0) width = 1;
		if (y1 > y2) {
			int temp = y1; y1 = y2; y2 = temp;
			temp = x1; x1 = x2; x2 = temp;
		}
		int ddx = (width << 16) / height;
		int xinc = (x1 > x2) ? (-1) : (1);
                unsigned int off = where + (y1 << 9) + (y1 << 7) + x1;
		_asm {
			mov edi, [off]
			mov esi, [xinc]
                        mov eax, [color]
			mov edx, [ddx]
			xor ebx, ebx
			mov ecx, [height]
                        lloop:  add byte ptr [edi], al
                                jnc nomax
                                mov al, 0FFh
                                mov [edi], al
                        nomax:  add edi, 640
                                add bx, dx
                                jnc cont
                                add edi, esi
			cont:   dec ecx
                                jnz lloop
		}
		return;
	}
	if (width == 0) width = 1;
	int dx = (x1 > x2) ? (-1) : (1);
        int dy = (y1 > y2) ? (-640 + dx) : (640 + dx);
        unsigned int off = where + (y1 << 9) + (y1 << 7) + x1;
	_asm {
		mov edi, [off]
                mov eax, [color]
		mov ebx, [dy]
		mov ecx, [width]
                lloop:  add byte ptr [edi], al
                        jnc nomax
                        mov al, 0FFh
                        mov [edi], al
                nomax:  add edi, ebx
                        dec ecx
                        jnz lloop
	}
}


void WirePolygon(TPolygon *p, unsigned int where) {
        int x = p->Vertex[p->NumVertex - 1]->x2d;
        int y = p->Vertex[p->NumVertex - 1]->y2d;
        for (int i = 0; i < p->NumVertex; i++) {
                ClipDDALine(x, y, p->Vertex[i]->x2d, p->Vertex[i]->y2d, p->cstart, where);
                x = p->Vertex[i]->x2d;
                y = p->Vertex[i]->y2d;
        }
}

void AddWirePolygon(TPolygon *p, unsigned int where) {
        int x = p->Vertex[p->NumVertex - 1]->x2d;
        int y = p->Vertex[p->NumVertex - 1]->y2d;
        for (int i = 0; i < p->NumVertex; i++) {
                ClipAddDDALine(x, y, p->Vertex[i]->x2d, p->Vertex[i]->y2d, p->cstart, where);
                x = p->Vertex[i]->x2d;
                y = p->Vertex[i]->y2d;
        }
}



// flat
void FlatScanSide(TVertex *v1, TVertex *v2) {
        int y1 = v1->y2d;
        int y2 = v2->y2d;
        int altura = y2 - y1;
        if (altura == 0) return;
        if ((y2 <= 0) || (y1 >= 480)) return;
        int dxdy = (((v2->x2d - v1->x2d) << 16) + 32768) / altura;
        int x = v1->x2d << 16;
        if (y1 < 0) { x -= y1 * dxdy; y1 = 0; }
        if (y2 > 479) y2 = 479;
        for (int y = y1; y <= y2; y++) {
                if (x < X_MIN[y]) X_MIN[y] = x;
                if (x > X_MAX[y]) X_MAX[y] = x;
                x += dxdy;
        }
}


void FlatPolygon(TPolygon *p, unsigned int where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        for (int i = 0; i < p->NumVertex; i++) {
                if (p->Vertex[i]->y2d < ymin) ymin = p->Vertex[i]->y2d;
                if (p->Vertex[i]->y2d > ymax) ymax = p->Vertex[i]->y2d;
                if (p->Vertex[i]->x2d < xmin) xmin = p->Vertex[i]->x2d;
                if (p->Vertex[i]->x2d > xmax) xmax = p->Vertex[i]->x2d;
        }
        if (ymax == ymin) return;
        if ((ymin > 479) || (ymax < 0)) return;
        if ((xmin > 639) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 480
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 480
                rep stosd
        }

        TVertex *v0 = p->Vertex[p->NumVertex - 1];
        for (i = 0; i < p->NumVertex; i++) {
                if (v0->y2d < p->Vertex[i]->y2d) FlatScanSide(v0, p->Vertex[i]);
                else FlatScanSide(p->Vertex[i], v0);
                v0 = p->Vertex[i];
        }

        if (ymin < 0) ymin = 0;
        if (ymax > 479) ymax = 479;
        unsigned int off = ymin * 640 + where;
        for (i = ymin; i <= ymax; i++) {
                xmin = X_MIN[i];
                xmax = X_MAX[i];
                if (xmin < 0) xmin = 0;
                if (xmax > 41877504) xmax = 41877504;
                if (xmin <= xmax) {
                        int c = p->cstart + dtoi((DotProduct(p->normal, Light) + 1.0) * p->crange);
                        _asm {
                                mov eax, [c]
                                mov ecx, [xmax]
                                mov ah, al
                                mov edi, [xmin]
                                mov edx, eax
                                shr ecx, 16
                                shl eax, 16
                                shr edi, 16
                                inc ecx
                                mov ax, dx
                                sub ecx, edi
                                add edi, [off]
                                shr ecx, 1
                                jnc jp1
                                stosb
                                jp1:    shr ecx, 1
                                        jnc jp2
                                        stosw
                                jp2:    rep stosd
                        }
                }
                off += 640;
        }
}


void AddFlatPolygon(TPolygon *p, unsigned int where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        for (int i = 0; i < p->NumVertex; i++) {
                if (p->Vertex[i]->y2d < ymin) ymin = p->Vertex[i]->y2d;
                if (p->Vertex[i]->y2d > ymax) ymax = p->Vertex[i]->y2d;
                if (p->Vertex[i]->x2d < xmin) xmin = p->Vertex[i]->x2d;
                if (p->Vertex[i]->x2d > xmax) xmax = p->Vertex[i]->x2d;
        }
        if (ymax == ymin) return;
        if ((ymin > 479) || (ymax < 0)) return;
        if ((xmin > 639) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 480
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 480
                rep stosd
        }

        TVertex *v0 = p->Vertex[p->NumVertex - 1];
        for (i = 0; i < p->NumVertex; i++) {
                if (v0->y2d < p->Vertex[i]->y2d) FlatScanSide(v0, p->Vertex[i]);
                else FlatScanSide(p->Vertex[i], v0);
                v0 = p->Vertex[i];
        }

        if (ymin < 0) ymin = 0;
        if (ymax > 479) ymax = 479;
        unsigned int off = ymin * 640 + where;
        for (i = ymin; i <= ymax; i++) {
                xmin = X_MIN[i];
                xmax = X_MAX[i];
                if (xmin < 0) xmin = 0;
                if (xmax > 41877504) xmax = 41877504;
                if (xmin <= xmax) {
                        int c = p->cstart + dtoi((DotProduct(p->normal, Light) + 1.0) * p->crange);
                        _asm {
                                mov eax, [c]
                                mov ecx, [xmax]
                                mov ah, al
                                mov edi, [xmin]
                                mov edx, eax
                                shr ecx, 16
                                shl eax, 16
                                shr edi, 16
                                inc ecx
                                mov ax, dx
                                sub ecx, edi
                                add edi, [off]
                                mov ebx, 255

                                lp:     add [edi], al
                                        jnc nomax
                                        mov [edi], bl
                                nomax:  inc edi
                                        dec ecx
                                        jnz lp
                        }
                }
                off += 640;
        }
}


// gouraud
void GouraudScanSide(TVertex *v1, TVertex *v2) {
        int y1 = v1->y2d;
        int y2 = v2->y2d;
        int altura = y2 - y1;
        if (altura == 0) return;
        if ((y2 <= 0) || (y1 >= 480)) return;
        int dxdy = (((v2->x2d - v1->x2d) << 16) + 32768) / altura;
        int x = v1->x2d << 16;
        int dcdy = ((v2->c - v1->c) << 8) / altura;
        int c = v1->c << 8;
        if (y1 < 0) { x -= y1 * dxdy; c -= y1 * dcdy; y1 = 0; }
        if (y2 > 479) y2 = 479;
        for (int y = y1; y <= y2; y++) {
                if (x < X_MIN[y]) { X_MIN[y] = x; C_MIN[y] = c; }
                if (x > X_MAX[y]) { X_MAX[y] = x; C_MAX[y] = c; }
                x += dxdy;
                c += dcdy;
        }
}


void GouraudPolygon(TPolygon *p, unsigned int where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        for (int i = 0; i < p->NumVertex; i++) {
                if (p->Vertex[i]->y2d < ymin) ymin = p->Vertex[i]->y2d;
                if (p->Vertex[i]->y2d > ymax) ymax = p->Vertex[i]->y2d;
                if (p->Vertex[i]->x2d < xmin) xmin = p->Vertex[i]->x2d;
                if (p->Vertex[i]->x2d > xmax) xmax = p->Vertex[i]->x2d;
        }
        if (ymax == ymin) return;
        if ((ymin > 479) || (ymax < 0)) return;
        if ((xmin > 639) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 480
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 480
                rep stosd
        }

        TVertex *v0 = p->Vertex[p->NumVertex - 1];
        for (i = 0; i < p->NumVertex; i++) {
                if (v0->y2d < p->Vertex[i]->y2d) GouraudScanSide(v0, p->Vertex[i]);
                else GouraudScanSide(p->Vertex[i], v0);
                v0 = p->Vertex[i];
        }

        if (ymin < 0) ymin = 0;
        if (ymax > 479) ymax = 479;
        unsigned int off = ymin * 640 + where;
        int deltax, x, dcdx, c;
        for (i = ymin; i <= ymax; i++) {
                deltax = ((X_MAX[i] - X_MIN[i]) >> 16) + 1;
                x = X_MIN[i] >> 16;
                dcdx = (C_MAX[i] - C_MIN[i]) / deltax;
                c = C_MIN[i];
                if (x < 0) { c -= x * dcdx; deltax += x; x = 0; }
                if (X_MAX[i] > 41877504) deltax = 640 - x;
                if (deltax > 0)
                _asm {
                        mov edi, [off]
                        mov ecx, [deltax]
                        add edi, [x]
                        mov eax, [c]
                        mov ebx, [dcdx]
                        ciclo:  mov [edi], ah
                                inc edi
                                add eax, ebx
                                dec ecx
                                jnz ciclo
                }
                off += 640;
        }
}


void AddGouraudPolygon(TPolygon *p, unsigned int where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        for (int i = 0; i < p->NumVertex; i++) {
                if (p->Vertex[i]->y2d < ymin) ymin = p->Vertex[i]->y2d;
                if (p->Vertex[i]->y2d > ymax) ymax = p->Vertex[i]->y2d;
                if (p->Vertex[i]->x2d < xmin) xmin = p->Vertex[i]->x2d;
                if (p->Vertex[i]->x2d > xmax) xmax = p->Vertex[i]->x2d;
        }
        if (ymax == ymin) return;
        if ((ymin > 479) || (ymax < 0)) return;
        if ((xmin > 639) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 480
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 480
                rep stosd
        }

        TVertex *v0 = p->Vertex[p->NumVertex - 1];
        for (i = 0; i < p->NumVertex; i++) {
                if (v0->y2d < p->Vertex[i]->y2d) GouraudScanSide(v0, p->Vertex[i]);
                else GouraudScanSide(p->Vertex[i], v0);
                v0 = p->Vertex[i];
        }

        if (ymin < 0) ymin = 0;
        if (ymax > 479) ymax = 479;
        unsigned int off = ymin * 640 + where;
        int deltax, x, dcdx, c;
        for (i = ymin; i <= ymax; i++) {
                deltax = ((X_MAX[i] - X_MIN[i]) >> 16) + 1;
                x = X_MIN[i] >> 16;
                dcdx = (C_MAX[i] - C_MIN[i]) / deltax;
                c = C_MIN[i];
                if (x < 0) { c -= x * dcdx; deltax += x; x = 0; }
                if (X_MAX[i] > 41877504) deltax = 640 - x;
                if (deltax > 0)
                _asm {
                        mov edi, [off]
                        mov ecx, [deltax]
                        add edi, [x]
                        mov eax, [c]
                        mov ebx, [dcdx]
                        mov edx, 255
                        ciclo:  add [edi], ah
                                jnc nomax
                                mov [edi], dl
                        nomax:  inc edi
                                add eax, ebx
                                dec ecx
                                jnz ciclo
                }
                off += 640;
        }
}


// texture
void TextureScanSide(TVertex *v1, TVertex *v2) {
        int y1 = v1->y2d;
        int y2 = v2->y2d;
        int altura = y2 - y1;
        if (altura == 0) return;
        if ((y2 <= 0) || (y1 >= 480)) return;
        int dxdy = (((v2->x2d - v1->x2d) << 16) + 32768) / altura;
        int x = v1->x2d << 16;
        double dudy = (v2->u - v1->u) / (double)altura;
        double u = v1->u;
        double dvdy = (v2->v - v1->v) / (double)altura;
        double v = v1->v;
        if (y1 < 0) { x -= y1 * dxdy; u -= y1 * dudy; v -= y1 * dvdy; y1 = 0; }
        if (y2 > 479) y2 = 479;
        for (int y = y1; y <= y2; y++) {
                if (x < X_MIN[y]) { X_MIN[y] = x; U_MIN[y] = u; V_MIN[y] = v; }
                if (x > X_MAX[y]) { X_MAX[y] = x; U_MAX[y] = u; V_MAX[y] = v; }
                x += dxdy;
                u += dudy;
                v += dvdy;
        }
}


void TexturePolygon(TPolygon *p, unsigned int where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        for (int i = 0; i < p->NumVertex; i++) {
                if (p->Vertex[i]->y2d < ymin) ymin = p->Vertex[i]->y2d;
                if (p->Vertex[i]->y2d > ymax) ymax = p->Vertex[i]->y2d;
                if (p->Vertex[i]->x2d < xmin) xmin = p->Vertex[i]->x2d;
                if (p->Vertex[i]->x2d > xmax) xmax = p->Vertex[i]->x2d;
        }
        if (ymax == ymin) return;
        if ((ymin > 479) || (ymax < 0)) return;
        if ((xmin > 639) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 480
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 480
                rep stosd
        }

        TVertex *v0 = p->Vertex[p->NumVertex - 1];
        for (i = 0; i < p->NumVertex; i++) {
                if (v0->y2d < p->Vertex[i]->y2d) TextureScanSide(v0, p->Vertex[i]);
                else TextureScanSide(p->Vertex[i], v0);
                v0 = p->Vertex[i];
        }

        if (ymin < 0) ymin = 0;
        if (ymax > 479) ymax = 479;
        unsigned int off = ymin * 640 + where;
        int deltax, x, dudx, dvdx, u, v;
        unsigned int texture = p->texture;
        for (i = ymin; i <= ymax; i++) {
                deltax = ((X_MAX[i] - X_MIN[i]) >> 16) + 1;
                x = X_MIN[i] >> 16;
                dudx = dtoi((U_MAX[i] - U_MIN[i]) * 65536.0) / deltax;
                dvdx = dtoi((V_MAX[i] - V_MIN[i]) * 65536.0) / deltax;
                u = dtoi(U_MIN[i] * 65536.0);
                v = dtoi(V_MIN[i] * 65536.0);
                if (x < 0) { u -= x * dudx; v -= x * dvdx; deltax += x; x = 0; }
                if (X_MAX[i] > 41877504) deltax = 640 - x;
                if (deltax > 0)
                _asm {
                        mov edi, [off]
                        mov ecx, [deltax]
                        mov esi, [v]
                        mov edx, [u]
                        add edi, [x]
                        lp:     movzx ebx, si
                                add esi, [dvdx]
                                mov bl, dh
                                add edx, [dudx]
                                add ebx, [texture]
                                mov al, [ebx]
                                mov [edi], al
                                inc edi
                                dec ecx
                                jnz lp
                }
                off += 640;
        }
}


void AddTexturePolygon(TPolygon *p, unsigned int where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        for (int i = 0; i < p->NumVertex; i++) {
                if (p->Vertex[i]->y2d < ymin) ymin = p->Vertex[i]->y2d;
                if (p->Vertex[i]->y2d > ymax) ymax = p->Vertex[i]->y2d;
                if (p->Vertex[i]->x2d < xmin) xmin = p->Vertex[i]->x2d;
                if (p->Vertex[i]->x2d > xmax) xmax = p->Vertex[i]->x2d;
        }
        if (ymax == ymin) return;
        if ((ymin > 479) || (ymax < 0)) return;
        if ((xmin > 639) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 480
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 480
                rep stosd
        }

        TVertex *v0 = p->Vertex[p->NumVertex - 1];
        for (i = 0; i < p->NumVertex; i++) {
                if (v0->y2d < p->Vertex[i]->y2d) TextureScanSide(v0, p->Vertex[i]);
                else TextureScanSide(p->Vertex[i], v0);
                v0 = p->Vertex[i];
        }

        if (ymin < 0) ymin = 0;
        if (ymax > 479) ymax = 479;
        unsigned int off = ymin * 640 + where;
        int deltax, x, dudx, dvdx, u, v;
        unsigned int texture = p->texture;
        for (i = ymin; i <= ymax; i++) {
                deltax = ((X_MAX[i] - X_MIN[i]) >> 16) + 1;
                x = X_MIN[i] >> 16;
                dudx = dtoi((U_MAX[i] - U_MIN[i]) * 65536.0) / deltax;
                dvdx = dtoi((V_MAX[i] - V_MIN[i]) * 65536.0) / deltax;
                u = dtoi(U_MIN[i] * 65536.0);
                v = dtoi(V_MIN[i] * 65536.0);
                if (x < 0) { u -= x * dudx; v -= x * dvdx; deltax += x; x = 0; }
                if (X_MAX[i] > 41877504) deltax = 640 - x;
                if (deltax > 0)
                _asm {
                        mov edi, [off]
                        mov ecx, [deltax]
                        mov esi, [v]
                        mov edx, [u]
                        add edi, [x]
                        lp:     movzx ebx, si
                                add esi, [dvdx]
                                mov bl, dh
                                add edx, [dudx]
                                add ebx, [texture]
                                mov al, [ebx]
                                add [edi], al
                                jnc nomax
                                mov byte ptr [edi], 255
                        nomax:  inc edi
                                dec ecx
                                jnz lp
                }
                off += 640;
        }
}



// general
void DrawPolygon(TPolygon *p, unsigned int where) {
        switch (p->style) {
                case nc_wireframe: WirePolygon(p, where); break;
                case c_wireframe: WirePolygon(p, where); break;
                case ca_wireframe: AddWirePolygon(p, where); break;
                case nc_flatshaded: FlatPolygon(p, where); break;
                case c_flatshaded: FlatPolygon(p, where); break;
                case ca_flatshaded: AddFlatPolygon(p, where); break;
                case nc_gouraudshaded: GouraudPolygon(p, where); break;
                case c_gouraudshaded: GouraudPolygon(p, where); break;
                case ca_gouraudshaded: AddGouraudPolygon(p, where); break;
                case nc_texturemapped: TexturePolygon(p, where); break;
                case c_texturemapped: TexturePolygon(p, where); break;
                case ca_texturemapped: AddTexturePolygon(p, where); break;
        }
}

