#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include "hires256.h"
#include "stuff.h"
#include "phongpal.h"
#include "obj3d.h"
#include "triangle.h"
#include "polygons.h"
#include "vectors.h"
#include "scenes.h"
#include "cameras.h"
#include "intro.h"

// picture files
#include "intro1.h"
#include "intro2.h"
#include "intro3.h"
#include "antalla8.h"
#include "m8.h"
#include "m11.h"
#include "m13.h"
#include "m14.h"
#include "m15.h"
#include "m16.h"
#include "m18.h"
#include "m19.h"

// 3d files
#include "globe.h"


// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif

double Intro_Table1[128], Intro_Table2[128];
short Intro_Table3[32768];
unsigned short wobbleindex = 0;
TObject3D *Intro_obj[3];
unsigned int Logo[8] = {(unsigned int)M8, (unsigned int)M11,
                        (unsigned int)M13, (unsigned int)M14,
                        (unsigned int)M15, (unsigned int)M16,
                        (unsigned int)M18, (unsigned int)M19 };


void LateralBlur(unsigned int where);
#pragma aux LateralBlur =      \
"add edi, 320"  \
"mov ecx, 305920"       \
"xor ebx, ebx"  \
"bloop: movzx eax, byte ptr [edi+1]"      \
"       mov bl, [edi-1]"        \
"       add eax, ebx"   \
"       shr eax, 1"     \
"       mov [edi], al"  \
"       inc edi"        \
"       dec ecx"        \
"       jnz bloop"      \
parm [edi]      \
modify [eax ebx ecx];

void Blur(unsigned int where);
#pragma aux Blur =      \
"add edi, 320"  \
"mov ecx, 305920"       \
"xor ebx, ebx"  \
"bloop: movzx eax, byte ptr [edi+1]"      \
"       mov bl, [edi-1]"        \
"       add eax, ebx"   \
"       mov bl, [edi+640]"      \
"       add eax, ebx"   \
"       mov bl, [edi-640]"      \
"       add eax, ebx"   \
"       shr eax, 2"     \
"       mov [edi], al"  \
"       inc edi"        \
"       dec ecx"        \
"       jnz bloop"      \
parm [edi]      \
modify [eax ebx ecx];


void WobbleScreen(unsigned int table, unsigned int source, unsigned int dest);
#pragma aux WobbleScreen =      \
"   mov eax, 40"                \
"   imul eax, 640"              \
"   add esi, eax"               \
"   add edi, eax"               \
"   mov ebx, 400"               \
"   xor eax, eax"               \
"lpy:  mov ecx, 640"            \
"lpx:  movzx eax, cx"           \
"       shl ax, 1"              \
"       add ax, word ptr [wobbleindex]" \
"       movsx eax, word ptr [edx + eax]" \
"       mov al, [esi + eax]"    \
"       inc esi"                \
"       mov [edi], al"          \
"       inc edi"                \
"       dec ecx"                \
"       jnz lpx"                \
"       add word ptr [wobbleindex], 4" \
"       dec ebx"                \
"       jnz lpy"                \
parm [edx] [esi] [edi]          \
modify [eax ebx ecx];


void DrawLogo(unsigned int source, unsigned int dest);
#pragma aux DrawLogo =  \
"       add edi, 224000"        \
"       mov edx, 100"   \
"       yloop:  mov ecx, 160"   \
"       xloop:  mov al, [esi]"  \
"               inc esi"        \
"               or al, al"      \
"               jz nope"        \
"               mov [edi], al"  \
"       nope:   inc edi"        \
"               dec ecx"        \
"               jnz xloop"      \
"               add edi, 480"   \
"               dec edx"        \
"               jnz yloop"      \
parm [esi] [edi]        \
modify [eax ecx edx];


void Intro_Setup() {
        TPolygon *p;

        for (int i = 0; i < 307200; i++) ANTALLA8[i] /= 4;
        for (i = 0; i < 64000; i++) {
                INTRO1[i] = INTRO1[i] / 2;
                INTRO2[i] = INTRO2[i] / 2;
                if (INTRO3[i]) INTRO3[i] = 128 + INTRO3[i] / 4;
        }
        for (i = 0; i < 16000; i++) {
                if (M8[i]) M8[i] = 128 + M8[i] / 2;
                if (M11[i]) M11[i] = 128 + M11[i] / 2;
                if (M13[i]) M13[i] = 128 + M13[i] / 2;
                if (M14[i]) M14[i] = 128 + M14[i] / 2;
                if (M15[i]) M15[i] = 128 + M15[i] / 2;
                if (M16[i]) M16[i] = 128 + M16[i] / 2;
                if (M18[i]) M18[i] = 128 + M18[i] / 2;
                if (M19[i]) M19[i] = 128 + M19[i] / 2;
        }
	double ang = 3.14159265 / 2.0;
        double angadd = (3.14159265 / 128.0) / 2.0;
        for (i = 0; i < 128; i++) {
                Intro_Table1[i] = cos(ang);
                Intro_Table2[i] = pow(cos(ang), 20);
		ang -= angadd;
	}

        int v;
        for (i = 0; i < 2; i++) {
                Intro_obj[i] = new TObject3D();
                for (int j = 0; j < 6; j++) {
                        v = Intro_obj[i]->NumVertex;
                        Intro_obj[i]->AddVertex(1.0,  0, 0);
                        Intro_obj[i]->AddVertex(-0.5, 0,  0.866025403);
                        Intro_obj[i]->AddVertex(-0.5, 0, -0.866025403);
                        p = new TPolygon();
                        for (int k = 0; k < 3; k++) {
                                Intro_obj[i]->Vertex[v + k]->Traslate(2.0, 0, 0);
                                Intro_obj[i]->Vertex[v + k]->Rotate(0, j * NumDegrees / 6, 0);
                                p->AddVertex(Intro_obj[i]->Vertex[v + k]);
                        }
                        p->normal.SetP(0, 0, 0);
                        p->cstart = 64;
                        p->crange = 0;
                        p->style = ca_flatshaded;
                        Intro_obj[i]->AddPolygon(p);
                }
                p = new TPolygon();
                v = Intro_obj[i]->NumVertex;
                for (j = 0; j < 6; j++) {
                        Intro_obj[i]->AddVertex(cos(j * Pi / 3.0), 0,
                                                sin(j * Pi / 3.0));
                        p->AddVertex(Intro_obj[i]->Vertex[v + j]);
                }
                p->normal.SetP(0, 0, 0);
                p->cstart = 64;
                p->crange = 0;
                p->style = ca_flatshaded;
                Intro_obj[i]->AddPolygon(p);
        }
        Intro_obj[0]->origin.SetP(0, 0.8, 0);
        Intro_obj[1]->origin.SetP(0, -0.8, 0);

        Intro_obj[2] = new TObject3D();
        Read3DObject(GLOBE_VKX, Intro_obj[2]);
        Intro_obj[2]->Centre();
        Intro_obj[2]->SetColor(63, 31);
        Intro_obj[2]->SetStyle(c_wireframe);
        Intro_obj[2]->FitSphere(4);
        Intro_obj[2]->origin.SetP(0, 0, -4);

/*        for (i = 0; i < Intro_obj[2]->NumVertex; i++) {
                ang = 2.0 * Pi * i / (double)Intro_obj[2]->NumVertex;
                Intro_obj[2]->Vertex[i]->Scale( 1.0 + cos(ang) * 0.3,
                                                1.0 + sin(ang) * 0.3,
                                                1.0 - cos(ang * 2.0) * 0.3);
        }
*/
        Intro_obj[2]->FlipFaces();
        Intro_obj[2]->CalcNormals();

        int xx, yy;
        for (i = 0; i < 32768; i++) {
                ang = 8.0 * Pi * i / 32768.0;
                xx = dtoi(15.0 * (sin(10.0 * ang) + sin(8.0 * ang)) + 10.0 * (sin(ang * 4.0) * cos(ang * 8.0)));
                yy = dtoi(20.0 * (cos(ang * 8.0) * sin(ang * 4.0) + cos(ang * 12.0)) + 10.0 * cos(ang * 8.0));
                Intro_Table3[i] = yy * 640 + xx;
        }
}


void Intro_Free() {
        delete Intro_obj[0];
        delete Intro_obj[1];
        delete Intro_obj[2];
}

void FastPhongPal( double rd, double rs, double gd, double gs,
                   double bd, double bs, TPalette p) {
        double r, g, b;
        for (int i = 0; i < 128; i++) {
                r = rd * Intro_Table1[i] + rs * Intro_Table2[i];
                g = gd * Intro_Table1[i] + gs * Intro_Table2[i];
                b = bd * Intro_Table1[i] + bs * Intro_Table2[i];
                if (r > 1.0) r = 1.0;
                if (g > 1.0) g = 1.0;
                if (b > 1.0) b = 1.0;
                p[128 + i][0] = dtoi(r * 63.0);
                p[128 + i][1] = dtoi(g * 63.0);
                p[128 + i][2] = dtoi(b * 63.0);
	}
}


void Intro() {
        unsigned int voff, voff2, image = (unsigned int)INTRO1;
        PTVirtual vs, vs2;
        TPalette pal, pal2;
        unsigned short index = 0;

        HSetupVirtual(&vs, &voff);
        HSetupVirtual(&vs2, &voff2);
        for (int i = 0; i < 128; i++) SetPal(i, i >> 1, i >> 1, i >> 1);
        for (i = 0; i < 128; i++) SetPal(i + 128, i >> 1, i >> 1, i >> 1);
        GetPalette(pal);
        GetPalette(pal2);

        HClearScreen(0, voff);
        HClearScreen(0, voff2);
        _asm {
                mov esi, [image]
                mov edi, [voff]
                mov edx, 200
                add edi, 76960
                yloop:  mov ecx, 80
                        rep movsd
                        add edi, 320
                        dec edx
                        jnz yloop
        }
//        HCopyScreen(voff, SCREEN_OFF);

        while (row < 40) {
                wobbleindex = index;
                WobbleScreen((unsigned int)Intro_Table3, voff, voff2);
                for (i = 0; i < 8; i++) {
                        HDDALine(60 + rand() % 20, 60 + rand() % 20, 560 + rand() % 20, 60 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                        HDDALine(60 + rand() % 20, 400 + rand() % 20, 560 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                        HDDALine(60 + rand() % 20, 60 + rand() % 20, 60 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                        HDDALine(560 + rand() % 20, 60 + rand() % 20, 560 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                }
                HCopyAndClear(voff2, SCREEN_OFF);
                index -= 8;
                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        while (position < 1) {
                LateralBlur(voff);
                wobbleindex = index;
                WobbleScreen((unsigned int)Intro_Table3, voff, voff2);
                index -= 8;
                SetPalette(pal);
                for (i = 0; i < 8; i++) {
                        HDDALine(60 + rand() % 20, 60 + rand() % 20, 560 + rand() % 20, 60 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                        HDDALine(60 + rand() % 20, 400 + rand() % 20, 560 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                        HDDALine(60 + rand() % 20, 60 + rand() % 20, 60 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                        HDDALine(560 + rand() % 20, 60 + rand() % 20, 560 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                }
                HCopyAndClear(voff2, SCREEN_OFF);
                FadePalette(pal, 0, 127);
                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        HClearScreen(0, voff);
        HClearScreen(0, voff2);
        HDDALine(60 + rand() % 20, 60 + rand() % 20, 560 + rand() % 20, 60 + rand() % 20, 128 + (rand() & 0x3F), voff2);
        HDDALine(60 + rand() % 20, 400 + rand() % 20, 560 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
        HDDALine(60 + rand() % 20, 60 + rand() % 20, 60 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
        HDDALine(560 + rand() % 20, 60 + rand() % 20, 560 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
        HCopyScreen(voff2, SCREEN_OFF);
        image = (unsigned int)INTRO2;
        index = 0;
        _asm {
                mov esi, [image]
                mov edi, [voff]
                mov edx, 200
                add edi, 76960
                yloop:  mov ecx, 80
                        rep movsd
                        add edi, 320
                        dec edx
                        jnz yloop
        }        
        SetPalette(pal2);
        HCopyScreen(voff, SCREEN_OFF);

        while (row < 40) {
                wobbleindex = index;
                WobbleScreen((unsigned int)Intro_Table3, voff, voff2);
                for (i = 0; i < 8; i++) {
                        HDDALine(60 + rand() % 20, 60 + rand() % 20, 560 + rand() % 20, 60 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                        HDDALine(60 + rand() % 20, 400 + rand() % 20, 560 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                        HDDALine(60 + rand() % 20, 60 + rand() % 20, 60 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                        HDDALine(560 + rand() % 20, 60 + rand() % 20, 560 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                }
                HCopyAndClear(voff2, SCREEN_OFF);
                index -= 8;
                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        while (position < 2) {
                LateralBlur(voff);
                wobbleindex = index;
                WobbleScreen((unsigned int)Intro_Table3, voff, voff2);
                index -= 8;
                SetPalette(pal2);
                for (i = 0; i < 8; i++) {
                        HDDALine(60 + rand() % 20, 60 + rand() % 20, 560 + rand() % 20, 60 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                        HDDALine(60 + rand() % 20, 400 + rand() % 20, 560 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                        HDDALine(60 + rand() % 20, 60 + rand() % 20, 60 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                        HDDALine(560 + rand() % 20, 60 + rand() % 20, 560 + rand() % 20, 400 + rand() % 20, 128 + (rand() & 0x3F), voff2);
                }
                HCopyAndClear(voff2, SCREEN_OFF);
                FadePalette(pal2, 0, 127);
                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        
        for (i = 0; i < 64; i++) pal[i][0] = pal[i][1] = pal[i][2] = i;
        PhongPal(0.1, 0.8, 0.6, 0.0, 0.3, 0.7, 0.0, 0.0, 0.4, 10, pal, 64, 64);

        HClearScreen(0, SCREEN_OFF);
        HCopyScreen((unsigned int)ANTALLA8, voff2);
        HClearScreen(0, voff);
        double dist, a = 1.0, t = 0.0;
        int y;
        unsigned int logo = (unsigned int)INTRO3;
        camera->location.SetP(0, 0, -4);

        while (position < 4) {
                wobbleindex = index;
                WobbleScreen((unsigned int)Intro_Table3, voff2, voff);
                index -= 2;

                if (!(row & 7)) a = 1.0;
                FastPhongPal(0.0, a * 0.6, a * 0.7, a, 0.2, a * 0.8, pal);
                if (a > 0.6) a -= 0.01;

                dist = 6.0 - ((position - 2) * 64 + row) / 25.0;
                Intro_obj[0]->origin.SetP(0, dist, 0);
                Intro_obj[1]->origin.SetP(0, -dist, 0);
                Intro_obj[0]->Draw(voff);
                Intro_obj[1]->Draw(voff);

                y = 188 + (rand() & 3);
                _asm {
                        mov edi, [y]
                        mov esi, [logo]
                        imul edi, 640
                        mov ecx, 64000
                        add edi, [voff]
                        cloop: mov al, [esi]
                               inc esi 
                               add [edi], al
                               inc edi
                               dec ecx
                               jnz cloop
                }

                DrawLogo(Logo[(row >> 2) & 7], voff);

                SetPalette(pal);
                HCopyAndClear(voff, SCREEN_OFF);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
                Intro_obj[0]->FlatRotate(0, 6, 0);
                Intro_obj[1]->FlatRotate(0, 6, 0);
        }

        SetLightPosition(1, 1, 2);
        PhongPal(0.0, 0.1, 0.7, 0.1, 0.3, 0.9, 0.3, 0.8, 1.0, 20, pal, 0, 64);
        PhongPal(0.4, 0.9, 0.7, 0.1, 0.4, 0.8, 0.1, 0.1, 0.5, 10, pal, 64, 64);
        FastPhongPal(0.0, 0.6, 0.6, 1.0, 0.2, 0.8, pal);
        SetPalette(pal);
        HClearScreen(0, voff);
        int n;

        while (position < 6) {
                Intro_obj[2]->Draw(voff);
//                LateralBlur(voff);
                srand(row & 0xFC);
                for (i = 0; i < 40; i++) {
                        n = rand() % Intro_obj[2]->NumPolygons;
                        if (Intro_obj[2]->Poly[n]->Visible()) {
                                Intro_obj[2]->Poly[n]->cstart = 0;
                                Intro_obj[2]->Poly[n]->style = c_flatshaded;
                                DrawPolygon(Intro_obj[2]->Poly[n], voff);
                                Intro_obj[2]->Poly[n]->cstart = 63;
                                Intro_obj[2]->Poly[n]->style = c_wireframe;
                        }
                }
                Blur(voff);
                HHLine(0, 639, 0, 0, voff);
                HHLine(0, 639, 479, 0, voff);

                y = 188 + (rand() & 3);
                _asm {
                        mov edi, [y]
                        mov esi, [logo]
                        imul edi, 640
                        mov ecx, 64000
                        add edi, [voff]
                        cloop: mov al, [esi]
                               inc esi 
                               add [edi], al
                               inc edi
                               dec ecx
                               jnz cloop
                }

                dist = 0.88 + ((position - 4) * 64 + row) / 25.0;

                Intro_obj[0]->origin.SetP(0, dist, 0);
                Intro_obj[1]->origin.SetP(0, -dist, 0);
                Intro_obj[0]->Draw(voff);
                Intro_obj[1]->Draw(voff);

                DrawLogo(Logo[(row >> 2) & 7], voff);

                HCopyAndClear(voff, SCREEN_OFF);

                Intro_obj[2]->FlatRotate(dtoi(6.0 * sin(t)), dtoi(6.0 * cos(t)), dtoi(6.0 * sin(t / 2.0)));

                Intro_obj[0]->FlatRotate(0, 8, 0);
                Intro_obj[1]->FlatRotate(0, 8, 0);

                Light.Rotate(0, 0, -16);
                t += 0.01;

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        HShutDownVirtual(&vs);
}

