
#include <stdlib.h>
#include <malloc.h>
#include <math.h>
#include <conio.h>
#include "hires256.h"
#include "stuff.h"
#include "phongpal.h"
#include "obj3d.h"
#include "triangle.h"
#include "polygons.h"
#include "vectors.h"
#include "scenes.h"
#include "cameras.h"
#include "primitiv.h"
#include "deforms.h"

// pic files
#include "env2.h"
//#include "texcolor.h"
#include "texbn.h"
#include "antalla1.h"
#include "bottom.h"
#include "antalla4.h"
#include "texheart.h"
#include "antalla3.h"
#include "tex11.h"
#include "greets1.h"
#include "greets2.h"
#include "greets3.h"
#include "greets4.h"

// 3d files
#include "patamata.h"
#include "defcyl.h"
#include "pinata.h"


// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif


#define DeformDelay 1.0

TObject3D *Deforms_obj[5];
double Deform_Table1[1000], Deform_Table2[1000], Deform_Table3[160], Deform_Table4[160];
char Deform_Table5[65536];
int Deform_Table6[256];
double Deform_Table7[1000];


void Deforms_Setup() {
        Deforms_obj[1] = new TObject3D();
        Read3DObject(PATAMATA_VKX, Deforms_obj[1]);
        Deforms_obj[1]->Centre();
        Deforms_obj[1]->FitSphere(100.0);
        Deforms_obj[1]->SetStyle(c_texturemapped);
        Deforms_obj[1]->SetTexture((unsigned int)ENV2);
        Deforms_obj[1]->Rotate(0, 720, 0);

        double m;
        for (int i = 0; i < Deforms_obj[1]->NumVertex; i++) {
                m = Deforms_obj[1]->Vertex[i]->Magnitude();
                Deform_Table1[i] = DeformDelay * m / 100.0;
        }

        for (i = 0; i < 65536; i++) TEXBN[i] = 32 + TEXBN[i] / 4;
        for (i = 0; i < 307200; i++) ANTALLA1[i] = 96 + ANTALLA1[i] / 4;

        Deforms_obj[2] = new TObject3D();
        Read3DObject(DEFCYL_VKX, Deforms_obj[2]);
        Deforms_obj[2]->Rotate(360, 720, 0);
        Deforms_obj[2]->Centre();
        Deforms_obj[2]->FitSphere(100.0);
        Deforms_obj[2]->SetStyle(ca_texturemapped);
        Deforms_obj[2]->SetTexture((unsigned int)TEXBN);
        Deforms_obj[2]->SphericalMap(1.0);
        Deforms_obj[2]->MapEnviroment();

        for (i = 0; i < Deforms_obj[2]->NumVertex; i++) {
                m = 100.0 - Deforms_obj[2]->Vertex[i]->y;
                Deform_Table2[i] = DeformDelay * m / 200.0;
        }

	double ang = 3.14159265 / 2.0;
        double angadd = (3.14159265 / 160.0) / 2.0;
        for (i = 0; i < 160; i++) {
                Deform_Table3[i] = cos(ang);
                Deform_Table4[i] = pow(cos(ang), 10);
		ang -= angadd;
	}

        for (i = 0; i < 65536; i++) Deform_Table5[i] = 120 + (rand() & 7);
        for (i = 0; i < 256; i++) Deform_Table6[i] = rand() % 20;

        for (i = 0; i < 65536; i++) TEXHEART[i] += 128;
        Deforms_obj[3] = new TObject3D();
        Read3DObject(PINATA_VKX, Deforms_obj[3]);
        Deforms_obj[3]->Centre();
        Deforms_obj[3]->FitSphere(100.0);
        Deforms_obj[3]->SetStyle(c_texturemapped);
        Deforms_obj[3]->SetTexture((unsigned int)TEXHEART);
        Deforms_obj[3]->Rotate(0, 720, 0);
        Deforms_obj[3]->SetColor(128, 63);

        for (i = 0; i < Deforms_obj[3]->NumVertex; i++) {
                m = Deforms_obj[3]->Vertex[i]->Magnitude();
                Deform_Table7[i] = DeformDelay * m / 100.0;
        }

        for (i = 0; i < 65536; i++) TEX11[i] += 128;
        for (i = 0; i < 64000; i++) {
                if (GREETS1[i]) GREETS1[i] = 64 + GREETS1[i] / 4;
                if (GREETS2[i]) GREETS2[i] = 64 + GREETS2[i] / 4;
                if (GREETS3[i]) GREETS3[i] = 64 + GREETS3[i] / 4;
                if (GREETS4[i]) GREETS4[i] = 64 + GREETS4[i] / 4;
        }
        Deforms_obj[4] = new TObject3D();
        Read3DObject(DEFCYL_VKX, Deforms_obj[4]);
        Deforms_obj[4]->Rotate(360, 720, 0);
        Deforms_obj[4]->Centre();
        Deforms_obj[4]->FitSphere(100.0);
        Deforms_obj[4]->SetStyle(c_texturemapped);
        Deforms_obj[4]->SetTexture((unsigned int)TEX11);
        Deforms_obj[4]->SphericalMap(1.0);
        Deforms_obj[4]->MapEnviroment();
        Deforms_obj[4]->Rotate(-40, 0, 0);
}


void Deforms_Free() {
        delete Deforms_obj[1];
        delete Deforms_obj[2];
        delete Deforms_obj[3];
        delete Deforms_obj[4];
}


void DrawBottom(unsigned int source, unsigned int dest);
#pragma aux DrawBottom =        \
"       add edi, 222720"        \
"       mov ecx, 84480"         \
"       lp:     mov al, [esi]"  \
"               inc esi"        \
"               or al, al"      \
"               jz nope"        \
"               mov [edi], al"  \
"       nope:   inc edi"        \
"               dec ecx"        \
"               jnz lp"         \
parm [esi] [edi]        \
modify [eax ecx];

void DrawInterference(unsigned int where) {
        unsigned char TableIndex = rand() & 0xFF;
        unsigned short RandomIndex;
        unsigned int off = (unsigned int)Deform_Table5;
        int y = Deform_Table6[TableIndex++];
        where += 640 * y;
        while (y < 480) {
                RandomIndex = rand() & 0xFC00;
                _asm {
                        movzx esi, word ptr [RandomIndex]
                        mov edi, [where]
                        add esi, [off]
                        mov ecx, 160
                        rep movsd
                }
                y += Deform_Table6[TableIndex];
                where += 640 * Deform_Table6[TableIndex++];
        }
}


void Deform1() {
        TVirtual *vs = new TVirtual;
        TPalette pal;
        double ang, a = 0.0;
        double *d;
        int i;

        HClearScreen(0, SCREEN_OFF);
        HClearScreen(0, (unsigned int)vs);

        camera->location.SetP(0, 0, -120);

        CopyPalette(BOTTOM_PAL, pal, 0, 63);
        pal[64][0] = pal[64][1] = pal[64][2] = 0;               
        CopyPalette(ENV2_PAL, pal, 128, 255);
        for (i = 0; i < 8; i++) {
                ang = sin(i * Pi / 32.0);
                pal[i + 120][0] = 6 + (ang * (64 - 6) / 2.0);
                pal[i + 120][1] = 20 + (ang * (64 - 20) / 2.0);
                pal[i + 120][2] = 39 + (ang * (64 - 39) / 2.0);
        }
        SetPalette(pal);

        GetMusicInfo();

        while (position < 14) {
                DrawInterference((unsigned int)vs);

                Deforms_obj[1]->MapEnviroment();
                Deforms_obj[1]->Draw((unsigned int)vs);

                DrawBottom((unsigned int)BOTTOM, (unsigned int)vs);

                a = (((position) * 64) + row) * 0.04;
                d = Deform_Table1;
                for (i = 0; i < Deforms_obj[1]->NumVertex; i++) {
                        ang = a - (*d++);
                        Deforms_obj[1]->Vertex[i]->VRotate( dtoi(10.0 * sin(ang / 2.0)),
                                                        dtoi(10.0 * sin(ang)),
                                                        dtoi(12.0 * cos(ang * 2.0)));
                }
                for (i = 0; i < Deforms_obj[1]->NumPolygons; i++)
                        Deforms_obj[1]->Poly[i]->CalcNormal();

                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        delete vs;
}


void ScaleScreen(unsigned int source, unsigned int dest);
#pragma aux ScaleScreen =       \
"       mov edx, 240"   \
"       ylp:    mov ecx, 320"   \
"       xlp:    mov al, [esi]"  \
"               inc esi"        \
"               sub al, 96"     \
"               inc esi"        \
"               shr al, 1"      \
"               mov [edi], al"  \
"               inc edi"        \
"               dec ecx"        \
"               jnz xlp"        \
"               add esi, 640"   \
"               dec edx"        \
"               jnz ylp"        \
parm [esi] [edi]        \
modify [eax ecx edx];

void DrawScaledScreen(unsigned int source, unsigned int dest, int x, int y);
#pragma aux DrawScaledScreen =  \
"       imul ebx, 640"  \
"       add edi, eax"   \
"       mov edx, 240"   \
"       add edi, ebx"   \
"       ylp:    mov ecx, 80"    \
"               rep movsd"      \
"               add edi, 320"   \
"               dec edx"        \
"               jnz ylp"        \
parm [esi] [edi] [eax] [ebx]    \
modify [ecx edx];


void DFastPhongPal( double rd, double rs, double gd, double gs,
                    double bd, double bs, TPalette p) {
        double r, g, b;
        for (int i = 0; i < 160; i++) {
                r = rd * Deform_Table3[i] + rs * Deform_Table4[i];
                g = gd * Deform_Table3[i] + gs * Deform_Table4[i];
                b = 0.1 + bd * Deform_Table3[i] + bs * Deform_Table4[i];
                if (r > 1.0) r = 1.0;
                if (g > 1.0) g = 1.0;
                if (b > 1.0) b = 1.0;
                p[96 + i][0] = dtoi(r * 63.0);
                p[96 + i][1] = dtoi(g * 63.0);
                p[96 + i][2] = dtoi(b * 63.0);
	}
}


void Deform2() {
        TVirtual *vs = new TVirtual;
        char *scaled = (char *)malloc(320 * 240);
        TPalette pal;
        double ang, a = 0.0;
        double *d;
        int i;

        HClearScreen(0, SCREEN_OFF);
        HCopyScreen((unsigned int)ANTALLA1, (unsigned int)vs);
        PhongPal(0.0, 0.1, 0.9, 0.0, 0.3, 0.9, 0.1, 1.0, 1.0, 10, pal, 96, 160);
        PhongPal(0.1, 0.9, 0.8, 0.0, 0.3, 0.7, 0.0, 0.0, 0.7, 4, pal, 0, 80);
        SetPalette(pal);

        camera->location.SetP(-40, 0, -100);

        double p = 1.8;
        GetMusicInfo();
        while (position < 10) {
                if (row & 8) p = 1.8;
                DFastPhongPal(0.1, p * 0.9, p * 0.3, p * 0.9, 1.0, p * 1.0, pal);
                if (p > 0.8) p -= 0.12;

                Deforms_obj[2]->Draw((unsigned int)vs);

                a = ((position - 6) * 64 + row) * 0.04;

                camera->az = dtoi(40.0 * sin(a / 2.0));

                d = Deform_Table2;
                for (i = 0; i < Deforms_obj[2]->NumVertex; i++) {
                        ang = a - (3.0 - 2.0 * cos(a * 2.0)) * (*d++);
                        Deforms_obj[2]->Vertex[i]->VRotate(0, dtoi(10.0 * sin(ang)), 0);
                }
                for (i = 0; i < Deforms_obj[2]->NumPolygons; i++)
                        Deforms_obj[2]->Poly[i]->CalcNormal();

                ScaleScreen((unsigned int)vs, (unsigned int)scaled);
                DrawScaledScreen((unsigned int)scaled, (unsigned int)vs, 40, 40);

                for (i = 0; i < 4; i++) {
                        HDDALine(30 + rand() % 10, 30 + rand() % 10, 360 + rand() % 10, 30 + rand() % 10, 255, (unsigned int)vs);
                        HDDALine(30 + rand() % 10, 280 + rand() % 10, 360 + rand() % 10, 280 + rand() % 10, 255, (unsigned int)vs);
                        HDDALine(30 + rand() % 10, 30 + rand() % 10, 30 + rand() % 10, 280 + rand() % 10, 255, (unsigned int)vs);
                        HDDALine(360 + rand() % 10, 30 + rand() % 10, 360 + rand() % 10, 280 + rand() % 10, 255, (unsigned int)vs);
                }

                SetPalette(pal);
                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA1);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        delete vs;
        free(scaled);
}


void Deform3() {
        TVirtual *vs = new TVirtual;
        TPalette pal;
        double ang, a = 0.0;
        double *d;
        int i;

        HClearScreen(0, SCREEN_OFF);
        HCopyScreen((unsigned int)ANTALLA4, (unsigned int)vs);

        camera->location.SetP(0, 0, -120);

        CopyPalette(ANTALLA4_PAL, pal, 0, 127);
        for (i = 0; i < 128; i++) {
                pal[128 + i][0] = TEXHEART_PAL[i][0];
                pal[128 + i][1] = TEXHEART_PAL[i][1];
                pal[128 + i][2] = TEXHEART_PAL[i][2];
        }
        SetPalette(pal);

        GetMusicInfo();

        while ((position == 32) || (row < 8)) {
                Deforms_obj[3]->MapEnviroment();
                Deforms_obj[3]->Draw((unsigned int)vs);

                a = (((position) * 64) + row) * 0.04;
                d = Deform_Table7;
                for (i = 0; i < Deforms_obj[3]->NumVertex; i++) {
                        ang = a - (*d++);
                        Deforms_obj[3]->Vertex[i]->VRotate( dtoi(10.0 * sin(ang / 2.0)),
                                                        dtoi(10.0 * sin(ang)),
                                                        dtoi(12.0 * cos(ang * 2.0)));
                }
                for (i = 0; i < Deforms_obj[3]->NumPolygons; i++)
                        Deforms_obj[3]->Poly[i]->CalcNormal();

                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA4);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        Deforms_obj[3]->SetStyle(c_gouraudshaded);
        SetLightPosition(1, 1, -1);

        while (row < 32) {
                camera->location.SetP(0, 5 - (rand() % 10), -120 + (rand() % 10));
                Deforms_obj[3]->MapEnviroment();
                Deforms_obj[3]->Draw((unsigned int)vs);

                a = (((position) * 64) + row) * 0.04;
                d = Deform_Table7;
                for (i = 0; i < Deforms_obj[3]->NumVertex; i++) {
                        ang = a - (*d++);
                        Deforms_obj[3]->Vertex[i]->VRotate( dtoi(10.0 * sin(ang / 2.0)),
                                                        dtoi(10.0 * sin(ang)),
                                                        dtoi(12.0 * cos(ang * 2.0)));
                }
                for (i = 0; i < Deforms_obj[3]->NumPolygons; i++)
                        Deforms_obj[3]->Poly[i]->CalcNormal();

                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA4);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        camera->location.SetP(0, 0, -120);
        Deforms_obj[3]->SetStyle(c_texturemapped);

        while ((position == 33) || (row < 40)) {
                Deforms_obj[3]->MapEnviroment();
                Deforms_obj[3]->Draw((unsigned int)vs);

                a = (((position) * 64) + row) * 0.04;
                d = Deform_Table7;
                for (i = 0; i < Deforms_obj[3]->NumVertex; i++) {
                        ang = a - (*d++);
                        Deforms_obj[3]->Vertex[i]->VRotate( dtoi(10.0 * sin(ang / 2.0)),
                                                        dtoi(10.0 * sin(ang)),
                                                        dtoi(12.0 * cos(ang * 2.0)));
                }
                for (i = 0; i < Deforms_obj[3]->NumPolygons; i++)
                        Deforms_obj[3]->Poly[i]->CalcNormal();

                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA4);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        Deforms_obj[3]->SetStyle(c_gouraudshaded);

        while (position < 35) {
                camera->location.SetP(0, 5 - (rand() % 10), -120 + (rand() % 10));
                Deforms_obj[3]->MapEnviroment();
                Deforms_obj[3]->Draw((unsigned int)vs);

                a = (((position) * 64) + row) * 0.04;
                d = Deform_Table7;
                for (i = 0; i < Deforms_obj[3]->NumVertex; i++) {
                        ang = a - (*d++);
                        Deforms_obj[3]->Vertex[i]->VRotate( dtoi(10.0 * sin(ang / 2.0)),
                                                        dtoi(10.0 * sin(ang)),
                                                        dtoi(12.0 * cos(ang * 2.0)));
                }
                for (i = 0; i < Deforms_obj[3]->NumPolygons; i++)
                        Deforms_obj[3]->Poly[i]->CalcNormal();

                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA4);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        camera->location.SetP(0, 0, -120);
        Deforms_obj[3]->SetStyle(c_texturemapped);

        while (position < 36) {
                Deforms_obj[3]->MapEnviroment();
                Deforms_obj[3]->Draw((unsigned int)vs);

                a = (((position) * 64) + row) * 0.04;
                d = Deform_Table7;
                for (i = 0; i < Deforms_obj[3]->NumVertex; i++) {
                        ang = a - (*d++);
                        Deforms_obj[3]->Vertex[i]->VRotate( dtoi(10.0 * sin(ang / 2.0)),
                                                        dtoi(10.0 * sin(ang)),
                                                        dtoi(12.0 * cos(ang * 2.0)));
                }
                for (i = 0; i < Deforms_obj[3]->NumPolygons; i++)
                        Deforms_obj[3]->Poly[i]->CalcNormal();

                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA4);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        delete vs;
}


void DrawGreets(unsigned int source, unsigned int dest);
#pragma aux DrawGreets =        \
"       mov edx, 320"   \
"       add edi, 51580" \
"       ylp:    mov ecx, 200"   \
"       xlp:    mov al, [esi]"  \
"               inc esi"        \
"               or al, al"      \
"               jz nope"        \
"               mov [edi], al"  \
"       nope:   inc edi"        \
"               dec ecx"        \
"               jnz xlp"        \
"               add edi, 440"   \
"               dec edx"        \
"               jnz ylp"        \
parm [esi] [edi]        \
modify [eax ecx edx];


void Deform4() {
        TVirtual *vs = new TVirtual;
        TPalette pal;
        double ang, a = 0.0;
        double *d;
        int i;

        HClearScreen(0, SCREEN_OFF);
        HCopyScreen((unsigned int)ANTALLA3, (unsigned int)vs);
        PhongPal(0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1, pal, 64, 64);
        CopyPalette(ANTALLA3_PAL, pal, 0, 63);
        for (i = 0; i < 128; i++) {
                pal[128 + i][0] = TEX11_PAL[i][0];
                pal[128 + i][1] = TEX11_PAL[i][1];
                pal[128 + i][2] = TEX11_PAL[i][2];
        }
        SetPalette(pal);

        camera->location.SetP(40, 0, -100);

        GetMusicInfo();
        while (position < 37) {

                Deforms_obj[4]->Draw((unsigned int)vs);

                DrawGreets((unsigned int)GREETS1, (unsigned int)vs);

                a = ((position - 36) * 64 + row) * 0.04;
                camera->az = dtoi(60.0 * sin(a));

                d = Deform_Table2;
                for (i = 0; i < Deforms_obj[4]->NumVertex; i++) {
                        ang = a - (3.0 - 2.0 * cos(a * 2.0)) * (*d++);
                        Deforms_obj[4]->Vertex[i]->VRotate(0, dtoi(10.0 * sin(ang)), 0);
                }
                for (i = 0; i < Deforms_obj[4]->NumPolygons; i++)
                        Deforms_obj[4]->Poly[i]->CalcNormal();

                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA3);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        while (position < 38) {

                Deforms_obj[4]->Draw((unsigned int)vs);

                DrawGreets((unsigned int)GREETS2, (unsigned int)vs);

                a = ((position - 36) * 64 + row) * 0.04;
                camera->az = dtoi(60.0 * sin(a));

                d = Deform_Table2;
                for (i = 0; i < Deforms_obj[4]->NumVertex; i++) {
                        ang = a - (3.0 - 2.0 * cos(a * 2.0)) * (*d++);
                        Deforms_obj[4]->Vertex[i]->VRotate(0, dtoi(10.0 * sin(ang)), 0);
                }
                for (i = 0; i < Deforms_obj[4]->NumPolygons; i++)
                        Deforms_obj[4]->Poly[i]->CalcNormal();

                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA3);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        while (position < 39) {
                if (row >= 40) camera->location.SetP(40, 5 - (rand() % 10), -120 + (rand() % 10));
                Deforms_obj[4]->Draw((unsigned int)vs);

                DrawGreets((unsigned int)GREETS3, (unsigned int)vs);

                a = ((position - 36) * 64 + row) * 0.04;
                camera->az = dtoi(60.0 * sin(a));

                d = Deform_Table2;
                for (i = 0; i < Deforms_obj[4]->NumVertex; i++) {
                        ang = a - (3.0 - 2.0 * cos(a * 2.0)) * (*d++);
                        Deforms_obj[4]->Vertex[i]->VRotate(0, dtoi(10.0 * sin(ang)), 0);
                }
                for (i = 0; i < Deforms_obj[4]->NumPolygons; i++)
                        Deforms_obj[4]->Poly[i]->CalcNormal();

                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA3);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        camera->location.SetP(40, 0, -100);
        while (position < 40) {

                Deforms_obj[4]->Draw((unsigned int)vs);

                DrawGreets((unsigned int)GREETS4, (unsigned int)vs);

                a = ((position - 36) * 64 + row) * 0.04;
                camera->az = dtoi(60.0 * sin(a));

                d = Deform_Table2;
                for (i = 0; i < Deforms_obj[4]->NumVertex; i++) {
                        ang = a - (3.0 - 2.0 * cos(a * 2.0)) * (*d++);
                        Deforms_obj[4]->Vertex[i]->VRotate(0, dtoi(10.0 * sin(ang)), 0);
                }
                for (i = 0; i < Deforms_obj[4]->NumPolygons; i++)
                        Deforms_obj[4]->Poly[i]->CalcNormal();

                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA3);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        delete vs;
}
