        device zxspectrum128
main=#8000;#6400

TMKPLAYER=1

SCROLLSTEP=4;3
CHECKSPACES=1

pt3_frq=0;1;all freq tables(3.4x)
pt3_smpfix=1;vol,T,E/N cumulations in SMPs
pt3_patchaddr=0;1;0 ;physical addresses in module
;pt3_oddtempo=0;3 ;3,2,3,2...

pt3_port3=1;tone port.
pt3_vib6=1;vibrate

pt3_msx=0
pt3_ts2=1;2nd TS player; 47  0  ..

       if ATM
VIDEOMODE=0xa8;EGA+turbo
       endif

pgfont=4
pgblack=6
pgengine=0
       if ATM
pgwasmusic=3 ; ATM   pgmusic
pgmusic=8
pgwaspanorama0=1 ; ATM   pgpanorama0
pgwaspanorama1=7 ; ATM   pgpanorama1
pgpanorama0=9
pgpanorama1=10
pgfont0=11
pgfont1=12
pgbg=13
pgpics=14 ; 
       else
pgmusic=3
pgpanorama=pgmusic
       endif

       macro GOENTRY
        ;push de
        ;ret
        ex de,hl
        jp (hl)
       endm
       

	org 0x6000
begin
        ei ;    ,          
        halt
        ;di

        xor a
	out (0xfe),a            ;Border  
	ld hl,#5800;+64
	ld de,#5801;+64
	ld bc,767;-256-64
	ld (hl),0               ;  
	ldir

	;ld hl,wasmakers
	;ld de,makers
	;ld bc,szmakers
	;ldir

        xor a
	ld (0x5d10),a ;for TR-DOS
	ld (iy+1),0xcc ;"128K basic off"

        ld hl,tsin
mksin0
        ld a,(hl)
        sra a
        sra a
        sra a
        sub (hl) ;-7/8
        sra a
        ;sra a
        add a,157+64;/2
        ld (hl),a
        inc l
        jr nz,mksin0
      
       if ATM
        call killvtrdos
       
        ld hl,tfiles
        ld a,0x7f-pgpics
        call loader
       endif

        if ATM
        ld bc,0xbd77 ;   
        ;ld bc,0xfd77 ; 
        ld a,0xab;VIDEOMODE;0xab ;bit2..0 = videomode
        call outdos
        ;ld a,0x7f-1
        ;call setpg0000
        endif

       if ATM
        ld a,pgwasmusic
        call setpg;_music
       else
        call setpg_music
       endif
        call 0xc000
        call compile
	ei
	;halt

        if ATM
;copy music pg from pgmusic to pg8
        ld bc,0xbff7
        ld a,0x7f-pgmusic
        out (c),a
        ld hl,0xc000
        ld de,0x8000
        ld bc,0x4000
        ldir
        endif

       if ATM
        ld a,pgbg
        call setpg_lomem
        call clpg
        ld a,3
        call setpg_lomem
        call clpg
        ld a,7
        call setpg_lomem
        call clpg
        ld bc,0xbff7
        ld a,0x7f-pgfont
        out (c),a
        ld a,pgfont0
        call setpg_lomem
        ld de,font0__0-0x4000
        call mkprchar
        ld a,pgfont1
        call setpg_lomem
        ld de,font1__0-0x4000
        call mkprchar
;show pic
       if 0
        ld bc,0xbff7
        ld a,0x7f-3
        out (c),a
        ld hl,0xc000
        ld de,0x8000
        ld bc,0x4000
        ldir
        ld bc,0xbff7
        ld a,0x7f-7
        out (c),a
        ld a,pgpics+1
        call setpg_lomem
        ld hl,0xc000
        ld de,0x8000
        ld bc,0x4000
        ldir
       endif
       endif

        if ATM
        ld bc,0xbff7
        ld a,0x7f-2 ; 
        out (c),a
        endif

        halt

        if ATM
        ;ld a,0x20 ;ATM3 palette
        ;out (0xbf),a
        ld bc,0xbd77 ;   
        ld a,VIDEOMODE;0xab ;bit2..0 = videomode
        call outdos

        ;ld hl,pal+31
        ;call setpal
        endif

        ld a,0x18
        ld bc,0x7ffd
        out (c),a

       ld a,IMVEC/256
       ld i,a
	im 2
	;ld a,(timer)
	;ld (oldtimer),a

	ld sp,STACK

	jp maingo

clpg
        ld hl,0xc000
        ld de,0xc001
        ld bc,0x3fff
        ld (hl),l ;0
        ldir
        ret

       if ATM
killvtrdos
        call 0x3d46 ; 0x5cef
        or a ;  0, vtrdos 
        call z,0x3c9e ;vtrdos off
        ret
       
loader
loader0
       push af
       ld bc,0xfff7
       push hl
       call outdos ;set page
       pop hl
        ld de,0x5cdd
        ld bc,9
        ldir
       push hl
        ld c,0x0a ;find
        call 0x3d13
        ld a,c
        ld c,0x08 ;load descr
        call 0x3d13
        xor a
        ld (23801),a
        ld hl,0xc000
        ld de,(0x5ce8)
        ld a,3
        ld c,0x0e
        call 0x3d13
       pop hl
       pop af
        dec a
        inc (hl)
        dec (hl)
        jr nz,loader0
        inc hl
        ret

tfiles
        db "0ny1_16 C"
        db "1ny1_16 C"
        db "0ny2_16 C"
        db "1ny2_16 C"
        db "0ny3_16 C"
        db "1ny3_16 C"
        db "0ny4_16 C"
        db "1ny4_16 C"
        db "0ny5_16 C"
        db "1ny5_16 C"
        db "0ny6_16 C"
        db "1ny6_16 C"
        db "0ny7_16 C"
        db "1ny7_16 C"
        db "0ny8_16 C"
        db "1ny8_16 C"
        db 0
       endif

       if ATM
setpg_lomem
        ;ld (curpg),a
        xor 0x7f
        ld bc,0xfff7
        out (c),a
        ret
       endif

       if ATM
mkprchar
        ;ld a,(hl)
        ;[and ...]
        ;or ...
        ;ld (hl),a ; ld (hl),...
        ;add hl,bc
        ;...
        ;pop hl  
        ;...
        ;ret
        ;ld de,0x8000;+(32*('a'-32))
        ld hl,0xc200
        ld ix,0xc020
        ld b,0xf2-32
mkprchars0
        ld (ix),l
        inc hx
        ld (ix),h
        dec hx
        push bc
        call mkprchar_char
        pop bc
        inc lx
        djnz mkprchars0
        ld a,(0xc020)
        ld (0xc00d),a
        ld (0xc00a),a
        ld a,(0xc120)
        ld (0xc10d),a
        ld (0xc10a),a
        ;jr $
        ret
mkprchar_char
;de=gfx
;hl=proc
        ld (hl),0xeb ;"ex de,hl"
        inc hl
;   , ..   
       ;push hl
       ld a,e
       add a,24
       ld e,a
        call mkprchar_column
        ld (hl),0xe1 ;"pop hl"
        inc hl
       ld a,e
       add a,16-24-8
       ld e,a
        call mkprchar_column
        ld (hl),0xe1 ;"pop hl"
        inc hl
       ld a,e
       add a,8-16-8
       ld e,a
        call mkprchar_column
        ld (hl),0xe1 ;"pop hl"
        inc hl
       ld a,e
       add a,0-8-8
       ld e,a
        call mkprchar_column
        ld (hl),0xc9
        inc hl
       ld a,e
       add a,32-8
       ld e,a
       jr nc,$+3
       inc d
        
      if 0
       ld b,h
       ld c,l
       pop hl
;,      128b   (96  )
       ld a,l
       add a,96;128
       ld l,a
       jr nc,$+3
       inc h
        or a
        sbc hl,bc
        jr c,$ ;>128b  
        add hl,bc
      endif
        ret
mkprchar_column
        ld (mkprchar_lasthl),hl
        ld b,8
mkprchar_column0
        ld a,(de)
        cp 0xff
        jr z,mkprchar_skip
;  and (    15)
        ld c,0
        and 0x47 ;left pixel
        cp 0x47
        jr nz,$+3
         ld c,a
        ld a,(de)
        and 0xb8 ;right pixel
        cp 0xb8
        jr nz,$+4
         or c
         ld c,a
        ld a,c
        or a
        jr nz,mkprchar_masked
;=0
        ld a,(de)
        or a
        jr z,mkprchar_unmasked_0
        ld (hl),0x36 ;"ld (hl),n"
        inc hl
        ld (hl),a
        inc hl
mkprchar_byteok
        ld (mkprchar_lasthl),hl
mkprchar_skip
        ld (hl),0x09 ;"add hl,bc"
        inc hl
        inc e
        djnz mkprchar_column0
mkprchar_lasthl=$+1
        ld hl,0
        ret
mkprchar_unmasked_0
        ld (hl),0x70 ;"ld (hl),b" ;b=0
        inc hl
        jr mkprchar_byteok
mkprchar_masked
        ld (hl),0x7e ;"ld a,(hl)"
        inc hl
        ld (hl),0xe6 ;"and n"
        inc hl
        ld (hl),c
        inc hl
;  or (     15)
        ld a,(de)
        xor c
        jr z,mkprchar_skipor
        ld (hl),0xf6 ;"or n"
        inc hl
        ld (hl),a
        inc hl
mkprchar_skipor
        ld (hl),0x77 ;"ld (hl),a"
        inc hl
        jr mkprchar_byteok
       endif

;=====================================

	ds main-$

        align 256
tsin
	INCBIN "sindiv2"

        align 256
IMVEC=$+#ff
IMER=(($/#100)+1)*#101
	ds #101,#ff&IMER
timer
	dw 0
;drawsp
        ds 32;64
STACK
        ds 32;16;10
IMERSP
curpg
        db 0x10

setpg_font
        ld a,pgfont
        jr setpg
;setpg_tmap
;        ld a,pgblack
;        jr setpg
setpg_engine
        ld a,pgengine
        jr setpg
setpg_music
        ld a,pgmusic
        jr setpg

setpg
       if ATM
        ld (curpg),a
        xor 0x7f
        ld bc,0xfff7
        out (c),a
        ret
curscrnum
        db 0x10
       else
curscrnum=$+1
        or 0x18;0x10 for doublebuf
        ld (curpg),a
        ld bc,0x7ffd
        out (c),a
        ret
       endif

	;if IMVEC!=#3bff
        display "skip before ON_INT=",IMER-$
        ds IMER-$
ON_INT
        ei
        ret
       if 0
;     de
	 ex de,hl
	ex (sp),hl ;hl="de" ,   
	ld (IMERjp),hl
	pop hl ; hl="de"
	 ex de,hl
	ld (IMERwassp),sp
	ld sp,IMERSP
	push af,bc,hl
        call imer_main
	;push de
	;push ix,iy
	;ld a,(curpg)
	;push af
	;ld a,pgmuz
	;call OUTA
	;;call muz+5
	;pop af
	;call OUTA
	;pop iy,ix
	;pop de
	pop hl,bc,af
IMERwassp=$+1
	ld sp,0
	ei
IMERjp=$+1
	jp 0

        include "imer_main.asm"
       endif

        if ATM
copycurpal
        ld a,(curpgpic);pgpics
       ;rrca
       ;rlca
       ;ret c ; ,    
       ;ld hl,blackpal
       ;jr c,copycurpal_hl
        call setpg;_lomem
        ld hl,0xc000+8000
;copycurpal_hl
        ld de,pal
        ld bc,16;32
;copypal0
        ldir
        ;dec hl
        ;ldi
        ;jp pe,copypal0
        xor a
        ld (setpal),a
        ret
setpal
        ret ;/nop
        ld a,0xc9 ;"ret"
        ld (setpal),a
        ;ld c,0xff
        ;ld a,7
_=7
        dup 8
        ld a,_
        OUT (0xF6),A
        ld a,(hl)
        ;dec hl
        ;ld b,(hl) ;DDp palette low bits
        OUT (0xFF),A
        dec hl
        ;dec a
_=_-1
        edup
        ;ld a,7
_=7
        dup 7
        ld a,_
        OUT (0xFE),A
        ld a,(hl)
        ;dec hl
        ;ld b,(hl) ;DDp palette low bits
        OUT (0xFF),A
        dec hl
        ;dec a
_=_-1
        edup
        xor a
        OUT (0xFE),A ;0
        ld a,(hl)
        ;dec hl
        ;ld b,(hl) ;DDp palette low bits
        OUT (0xFF),A
        ret
        ;include "_tmp/pal.ast"
pal
;DDp palette: %grbG11RB(low),%grbG11RB(high), inverted
        ds 16,0xff
        ;dw 0xffff,0xfefe,0xfdfd,0xfcfc,0xefef,0xeeee,0xeded,0xecec
        ;dw 0xffff,0xdede,0xbdbd,0x9c9c,0x6f6f,0x4e4e,0x2d2d,0x0c0c
blackpal
        ds 16,0xff

        endif

       if 0
prcharxy
        sub 32
        ld l,a
        ld h,0
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,hl
        ld de,0xc000
        add hl,de
        ld de,0x0000
        ex de,hl
        call prcharxycolumn
        set 6,h
        call prcharxycolumn
        res 6,h
        set 5,h
        call prcharxycolumn
        set 6,h
        ;call prcharxycolumn
prcharxycolumn
        push hl
        ld bc,40
        dup 8
        ld a,(de)
        inc e
        ld (hl),a
        add hl,bc
        edup
        pop hl
        ret
       endif


rnd
;keep bc!
;Patrik Rak
rndseed1=$+1
        ld  hl,0xA280   ; xz -> yw
rndseed2=$+1
        ld  de,0xC0DE   ; yw -> zt
        ld  (rndseed1),de  ; x = y, z = w
        ld  a,e         ; w = w ^ ( w << 3 )
        add a,a
        add a,a
        add a,a
        xor e
        ld  e,a
        ld  a,h         ; t = x ^ (x << 1)
        add a,a
        xor h
        ld  d,a
        rra             ; t = t ^ (t >> 1) ^ w
        xor d
        xor e
        ld  h,l         ; y = z
        ld  l,a         ; w = t
        ld  (rndseed2),hl
        ret

prstar
;bc=yx
        ;jr $
        ld a,(curpgpic)
        rra
        jr c,prstarfail ;   ,   
        ld hl,(columnphase)
        ld c,(hl)
        inc c
        jr nz,prstarfail ;   
prstar_xy=$+1
        ld bc,(32+64)*256+4
        ld (unprstar_xy),bc
prstar_phase=$+1
        ld l,0 ;phase
        ld a,l
        inc a
        ld (prstar_phase),a
        cp 16
        call z,prstar_newstar ;    
        ld a,l
        srl a
        add a,0xc0
        ld l,a ;char
        ld h,0xc0
        ld e,(hl)
        inc h
        ld d,(hl)
         ld l,b
         ld a,c ;la=yx
        jp prcharxyfast
prstarfail
        xor a
        ld (unprstar_xy+1),a ;y=0: don't draw
prstar_newstar
       push hl
        call rnd
        and 127
        add a,64
        ld (prstar_xy+1),a ;y
        call rnd
        and 127
        add a,+(160-128)/2 +4
        and 0xfc
        ld (prstar_xy),a ;x
        xor a
        ld (prstar_phase),a
       pop hl
        ret
        
unprstar
unprstar_xy=$+1
        ld bc,0;(0+64)*256+4
        ld a,b
        or a
        ret z
         ld l,b
         ld a,c ;la=yx
        ld h,tytoscr/256
        or a
;CY=0
        rra
        rra;srl a
        add a,(hl)
        inc h
        ld e,a
        adc a,(hl)
        sub e ;HSB
        ld d,a
;de=scr
        push de
        ld a,d
        or 0xc0
        ld h,a
        ld l,e
        ld a,(curpgpic)
        call unprstar_half
        pop de
        set 6,d
        ld h,d
        set 7,h
        ld l,e
        ld a,(curpgpic)
        inc a
unprstar_half
        call setpg
        ld bc,40
       dup 4
        ld a,(hl)
        ld (de),a
        set 5,h
        set 5,d
        ld a,(hl)
        ld (de),a
        add hl,bc
        ex de,hl
        add hl,bc
        ld a,(de)
        ld (hl),a
        res 5,h
        res 5,d
        ld a,(de)
        ld (hl),a
        add hl,bc
        ex de,hl
        add hl,bc
       edup
        org $-3
        ret

        align 256
tytoscr
        dup 256;200
        db ((($-64)&0xff)*40-1)&0xff
        edup
        align 256
        dup 256;200
        db ((($-64)&0xff)*40-1)/256 ;+ 0x80
        edup

	macro NEXTCOLUMN
	bit 6,h
	set 6,h
	jr z,$+2+4+2+2+1
	ld a,h
	xor 0x60
	ld h,a
	and 0x20
	jr nz,$+3
	inc hl
	endm

        macro COUNTSCRADDR
;a=x2/4
        add a,(hl)
        inc h
         ld b,a
         adc a,(hl)
         sub b ;HSB
       ld l,b ;LSB
        endm

	macro NEXTCOLUMNS0
        ld h,a ;.00
	push hl
	set 6,h ;.10
	push hl
	xor 0x20
	ld h,a ;.01
	push hl
	set 6,h ;.11
	endm
	macro NEXTCOLUMNS1
        ld c,a
        xor 0x40
        ld h,a ;.10
	push hl
	xor 0x60
	ld h,a ;.01
	push hl
	set 6,h ;.11
	push hl
	ld h,c ;.00
	inc hl
	endm
	macro NEXTCOLUMNS1_last1
        ld bc,beginfree
	push bc
	push bc
	push bc
        ld h,a ;.00
	inc hl
	endm
	macro NEXTCOLUMNS1_first3
        xor 0x40
        ld h,a ;.10
	push hl
	xor 0x60
	ld h,a ;.01
	push hl
	set 6,h ;.11
	push hl
        ld hl,beginfree
	endm
	macro NEXTCOLUMNS2
        ld h,a
        set 5,h ;.01
	push hl
	set 6,h ;.11
	push hl
	ld h,a ;.00
	inc hl
	push hl
	set 6,h ;.10
	endm
	macro NEXTCOLUMNS2_last2
        ld bc,beginfree
	push bc
	push bc
	ld h,a ;.00
	inc hl
	push hl
	set 6,h ;.10
	endm
	macro NEXTCOLUMNS2_first2
        ld h,a
        set 5,h ;.01
	push hl
	set 6,h ;.11
	push hl
        ld hl,beginfree
	push hl
	endm
	macro NEXTCOLUMNS3
        ld c,a
        xor 0x60
        ld h,a ;.11
	push hl
	ld h,c ;.00
	inc hl
	push hl
	set 6,h ;.10
	push hl
         ld a,h ; , ..  inc hl
	 xor 0x60
	 ld h,a ;.01
	endm
	macro NEXTCOLUMNS3_last3
        ld bc,beginfree
	push bc
        ld h,a ;.00
	inc hl
	push hl
	set 6,h ;.10
	push hl
         ld a,h ; , ..  inc hl
	 xor 0x60
	 ld h,a ;.01
	endm
	macro NEXTCOLUMNS3_first1
        xor 0x60
        ld h,a ;.11
	push hl
        ld hl,beginfree
	push hl
	push hl
	endm

getsinphase_xphase
textphase=$+1
        ld hl,text
sinphase=$+1
        ld de,tsin
        ld a,l
        add a,a
        add a,l
        add a,a
        add a,e
        ld e,a
sin2phase=$+1
        ld b,0
        ld a,b
        add a,l
        add a,l
        add a,l
        ld ly,a
        ld hy,d
xphase=$+2
        ld lx,1 ;x>0
;lx=x
;de=tsin+
;iy=tsin2+
        ret

        macro UNTEXTCOLUMN
        dup 7
        ld a,(de)
        ld (hl),a
        add hl,bc
        inc d
        edup
        ld a,(de)
        ld (hl),a
        endm

        macro UNTEXTPROC_INNER
        UNTEXTCOLUMN
        dec e
        pop hl
        ld d,hx ;y
        UNTEXTCOLUMN
        dec e
        pop hl
        ld d,hx ;y
        UNTEXTCOLUMN
        dec e
        pop hl
        ld d,hx ;y
        UNTEXTCOLUMN
        endm

untextproc
        ex de,hl
        ld e,lx ;x
        ld d,hx ;y
        UNTEXTPROC_INNER
        ret
        
        macro UNTEXTPROC
        ld bc,40
        ld e,lx ;x
        ld d,hx ;y
        UNTEXTPROC_INNER
        jp untextloop
        endm

prtextxy
        call getsinphase_xphase
     if CHECKSPACES
     ld a,(hl)
     cp 32
     jp z,prtextxy0skip
       push hl
        ld l,a;(hl) ;char
     else
       push hl
        ld l,(hl) ;char
     endif
       push de
        ld a,(de)
        add a,(iy)
         rra
        ld h,0xc0
        ld e,(hl)
        inc h
        ld d,(hl)
         ld l,a
         ld a,lx;c ;la=yx
        call prcharxyfast_leftcropper
       pop de
       pop hl
prtextxy_skip
        inc hl
         dec ly;b
        ld a,e
        add a,SCROLLSTEP*2;6
        ld e,a
        ld a,lx;c
        add a,SCROLLSTEP;3
        ld lx,a;c,a
;lx=x
;de=tsin+
prtextxy0
     if CHECKSPACES
     ld a,(hl)
     cp 32
     jp z,prtextxy0skip
       push hl
        ld l,a;(hl) ;char
     else
       push hl
        ld l,(hl) ;char
     endif
       push de
        ld a,(de)
        add a,(iy)
         rra
        ld h,0xc0
        ld e,(hl)
        inc h
        ld d,(hl)
         ld l,a
         ld a,lx;c ;la=yx
        call prcharxyfast
       pop de
       pop hl
prtextxy0skip
        inc hl
         dec ly;b
        ld a,e
        add a,SCROLLSTEP*2;6
        ld e,a
        ld a,lx;c
        add a,SCROLLSTEP;3
        ld lx,a;c,a
        cp 160+4 -3
        jp c,prtextxy0

     if CHECKSPACES
     ld a,(hl)
     cp 32
     ret z
        ld l,a;(hl) ;char
     else
        ld l,(hl) ;char
     endif
        ld a,(de)
        add a,(iy)
         rra
        ld h,0xc0
        ld e,(hl)
        inc h
        ld d,(hl)
         ld l,a
         ld a,lx;c ;la=yx
        jp prcharxyfast_rightcropper

untextxy
        call getsinphase_xphase
     if CHECKSPACES
     ld a,(hl)
     cp 32
     jp z,untextxy_skip
     push hl
     endif
       push de
        ld a,(de)
        add a,(iy)
         rra
         ld l,a;b,a
         ;or 0xc0
         ld hx,a
         ld a,lx;ld lx,c ;la=yx
        ld de,untextproc
        call prcharxyfast_leftcropper
       pop de
     if CHECKSPACES
     pop hl
untextxy_skip
     inc hl
     endif
         dec ly;b
        ld a,e
        add a,SCROLLSTEP*2;6
        ld e,a
        ld a,lx;c
        add a,SCROLLSTEP;3
        ld lx,a;c,a
;lx=x
;de=tsin+
untextxy0
     if CHECKSPACES
     ld a,(hl)
     cp 32
     jp z,untextxy0skip
     push hl    
     endif
       push de
        ld a,(de)
        add a,(iy)
         rra
         ld l,a;b,a
         ;or 0xc0
         ld hx,a
         ld a,lx;ld lx,c ;la=yx
        ;ld de,untextproc
        ;call prcharxyfast
;prcharxyfast_untext
;la=yx
;de=gfxproc
        ld h,tytoscr/256
        or a
;CY=0
       rra
       jr c,prcharxy_untext_nextcolumns13
       rra;srl a
       jr c,prcharxy_untext_nextcolumns2
prcharxy_untext_nextcolumns0
        COUNTSCRADDR
	NEXTCOLUMNS0
        jp untextloop;UNTEXTPROC
prcharxy_untext_nextcolumns2
        COUNTSCRADDR
	NEXTCOLUMNS2
        jp untextloop;UNTEXTPROC
prcharxy_untext_nextcolumns13
       srl a
       jr c,prcharxy_untext_nextcolumns3
prcharxy_untext_nextcolumns1
        COUNTSCRADDR
	NEXTCOLUMNS1
        jp untextloop;UNTEXTPROC
prcharxy_untext_nextcolumns3
        COUNTSCRADDR
	NEXTCOLUMNS3
        ;UNTEXTPROC
untextloop
        ld bc,40
        ld e,lx ;x
        ld d,hx ;y
        UNTEXTPROC_INNER
       pop de
     if CHECKSPACES
     pop hl
untextxy0skip
     inc hl
     endif
         dec ly;b
        ld a,e
        add a,SCROLLSTEP*2;6
        ld e,a
        ld a,lx;c
        add a,SCROLLSTEP;3
        ld lx,a;c,a
        cp 160+4 -3
        jp c,untextxy0

     ld a,(hl)
     cp 32
     ret z;jp z,untextxy0skip
        ld a,(de)
        add a,(iy)
         rra
         ld l,a;b,a
         ;or 0xc0
         ld hx,a
         ld a,lx;ld lx,c ;la=yx
        ld de,untextproc
        jp prcharxyfast_rightcropper

prcharxyfast
;la=yx
;de=gfxproc
        ld h,tytoscr/256
        or a
;CY=0
       rra
       jr c,prcharxy_nextcolumns13
       rra;srl a
       jr c,prcharxy_nextcolumns2
prcharxy_nextcolumns0
        COUNTSCRADDR
	NEXTCOLUMNS0
        ld bc,40
        GOENTRY
prcharxy_nextcolumns2
        COUNTSCRADDR
	NEXTCOLUMNS2
        ld bc,40
        GOENTRY
prcharxy_nextcolumns13
       srl a
       jr c,prcharxy_nextcolumns3
prcharxy_nextcolumns1
        COUNTSCRADDR
	NEXTCOLUMNS1
        ld bc,40
        GOENTRY
prcharxy_nextcolumns3
        COUNTSCRADDR
	NEXTCOLUMNS3
        ld bc,40
        GOENTRY

prcharxyfast_rightcropper
;la=yx
;de=gfxproc
        ld h,tytoscr/256
        or a
;prcharxy_cropright
;column 157..160 (x=161..164)
;CY=0
       rra
       jr c,prcharxy_cropright_nextcolumns13
       rra;srl a
       ;jr c,prcharxy_cropright_nextcolumns2
        ret nc ;160:    ( )
;prcharxy_cropright_nextcolumns2
        COUNTSCRADDR
	NEXTCOLUMNS2_first2
        ld bc,40
        GOENTRY
prcharxy_cropright_nextcolumns13
       srl a
       jr c,prcharxy_cropright_nextcolumns3
prcharxy_cropright_nextcolumns1
        COUNTSCRADDR
	NEXTCOLUMNS1_first3
        ld bc,40
        GOENTRY
prcharxy_cropright_nextcolumns3 ;159:    
        COUNTSCRADDR
	NEXTCOLUMNS3_first1
        ld bc,40
        GOENTRY

prcharxyfast_leftcropper
;la=yx
;de=gfxproc
        ld h,tytoscr/256
        or a
;CY=0
       rra
       jr c,prcharxy_less4_nextcolumns13
       rra;srl a
       ;jr c,prcharxy_less4_nextcolumns2
        ret nc ;-4:   
;prcharxy_less4_nextcolumns2
        COUNTSCRADDR
	NEXTCOLUMNS2_last2
        ld bc,40
        GOENTRY
prcharxy_less4_nextcolumns13
       srl a
       jr c,prcharxy_less4_nextcolumns3
prcharxy_less4_nextcolumns1 ;-3:    
        COUNTSCRADDR
	NEXTCOLUMNS1_last1
        ld bc,40
        GOENTRY
prcharxy_less4_nextcolumns3
        COUNTSCRADDR
	NEXTCOLUMNS3_last3
        ld bc,40
        GOENTRY


drawframe_show
;swapscreen
        ld hl,curpgscr
        ld a,(hl)
        xor 2
        ld (hl),a
        ld hl,curscrnum
        ld a,(hl)
        xor 8
        ld (hl),a
       if ATM
        ld bc,0x7ffd
        out (c),a
       endif
        ld a,pgengine
        call setpg
       if ATM
        ret;jp clearscreen
       else
        ret
       endif

maingo
       if ATM
        call setpgsscr
        call copycurpal
        halt
        ;call setpal
        ;call copyscr
       endif
mainloop
        halt
       if ATM
        ld hl,pal+15;31
        call setpal
       endif
        ;ld a,2
        ;out (0xfe),a
       if ATM
        call unprstar
        ld a,pgfont0
        call setpg
        call prstar

        ld a,pgbg
        call setpg       
        call untextxy
       endif
        ;ld a,3
        ;out (0xfe),a
        
       if ATM
        call copycurcolumn ;4800
       endif

        call scroll
        
       if ATM
curpgfont=$+1
        ld a,pgfont1
        call setpg
       endif
        call prtextxy
        ;xor a
        ;out (0xfe),a

        call setpg_music
        di
        ld bc,0xfffd
        ld a,0xfe
        out (c),a ;chip0
       if TMKPLAYER
        call 0xc003
       else
        call 0xc005
       endif
        ld bc,0xfffd
        out (c),b ;chip1
        call PLAY
        ei
      
        ;call drawframe_show

       if 0
waithalt
	ld a,(timer)
oldtimer=$+1
	ld e,0
	sub e
         cp 1;RENDERSPEEDLIMIT
	jp c,waithalt;mainloop
        add a,e
	ld (oldtimer),a
       sub e ;a=  
       endif

	jp mainloop

        macro COLUMNS x,n
_=x
        dup n
        db _
_=_+7
        edup
        endm

        align 256
tcolumns
       if 1
        dup 160
        db $&0xff
        edup
       else 
        COLUMNS 0,1
        COLUMNS 1,2
        COLUMNS 2,3
        COLUMNS 3,4
        COLUMNS 4,5
        COLUMNS 5,6
        COLUMNS 6,7
        COLUMNS 7,8
        COLUMNS 15,8
        COLUMNS 23,8
        COLUMNS 31,8
        COLUMNS 39,8
        COLUMNS 47,8
        COLUMNS 55,8
        COLUMNS 63,8
        COLUMNS 71,8
        COLUMNS 79,8
        COLUMNS 87,8
        COLUMNS 95,8
        COLUMNS 103,8 ;max 103+7*7=152
        COLUMNS 111,7 ;[max 111+7*7=160]
        COLUMNS 119,6
        COLUMNS 127,5
        COLUMNS 135,4
        COLUMNS 143,3
        COLUMNS 151,2
        COLUMNS 159,1
       endif 
        ds 0xff&(-$),0xff

       if ATM
curpgpic
        db pgpics
       
copyscr
        ld c,0
        ld b,160
copyscr0
        push bc
        halt
        call copyscrcolumn
        pop bc
        inc c
        djnz copyscr0
        ret
copycurcolumn
columnphase=$+1
        ld hl,tcolumns
        ld c,(hl)
        inc l
        ld (columnphase),hl
        jr nz,copycurcolumn_nonextpic
        ;call prstarfail
        xor a
        ld (unprstar_xy+1),a ;y=0: don't draw
        ld hl,curpgpic
        ld a,(hl)
        inc a ;add a,2
        cp pgpics+16
        jr nz,$+4
        ld a,pgpics
        ld (hl),a
       rrca
       ;rlca
       ;ret c ; ,    
        call nc,copycurpal
copycurcolumn_nonextpic
        ld a,c
        inc a
        ret z
copyscrcolumn
;c=x
       push bc
        ld d,0x00
        ld a,(curpgpic)
       rrca
       rlca
       jr nc,copyscrcolumn_noblack
; ,    
        ld a,pgblack
        srl c
        jr nc,copyscrcolumn_noblackq
         ld d,0x40
        jp copyscrcolumn_noblackq
copyscrcolumn_noblack
        srl c
        jr nc,$+5
         inc a
         ld d,0x40
copyscrcolumn_noblackq
        push bc
        call setpg
        pop bc
        ld h,0xc0
        srl c
        jr nc,$+6
         set 5,h
         set 5,d
        ld l,c
        ld e,c
        ld bc,40
_y=0        
       dup 199       
        ld a,(hl)
        ld (de),a
        add hl,bc
_min=_y*40
_max=_y*40+39
       if (((_min+40)&0xff00) != (_min&0xff00)) || (((_max+40)&0xff00) != (_max&0xff00))
        ex de,hl
        add hl,bc
        ex de,hl
       else
        ld e,l
       endif
_y=_y+1
       edup
        ld a,(hl)
        ld (de),a

        ld a,pgbg
        call setpg
       
        ld hl,-40*(72-1)
        add hl,de
       pop de ;e=x
        ;ld a,e
        ;add a,4
        ;ld e,a
        inc e
        ld d,0xc0
        ld bc,40
       dup 63
        ld a,(hl)
        ld (de),a
        add hl,bc
        inc d
       edup
        ld a,(hl)
        ld (de),a
        ret
       endif


scroll        
        ld hl,sinphase
        dec (hl)
        dec (hl)
        dec (hl)
        dec (hl)
        
        ld hl,sin2phase
        inc (hl)
        
       if ATM 
       ld hl,curpgfont
       ld a,(hl)
       xor pgfont0^pgfont1
       ld (hl),a
       cp pgfont1
       jr nz,scrollq
       endif
        
        ld hl,xphase
        ld a,(hl)
        dec a
        ld (hl),a
        jr nz,scrollq
        ld (hl),3
        
        ld hl,(textphase)
        inc hl
        ld (textphase),hl
        ld bc,55
        add hl,bc
        ld a,(hl)
        or a
        jr nz,scrollq
        ld hl,text
        ld (textphase),hl
scrollq        
        ret

       if ATM
outdos
        ld hl,10835
        push hl
        jp 0x3d2f
       endif

       if ATM
setpgsscr
        ld a,(curpgscr)
        ;ld (curpg0000),a
        ld bc,0x3ff7
        out (c),a
        xor 4
        ld b,0x7f;bc,0x7ff7
        out (c),a
        ret

clearscreen
       ld hl,(0xfffe)
       push hl
        call setpgsscr
        ;ld hl,0
        ;ld de,1
        ;ld bc,0x6000+7999
        ;ld (hl),0
        ;ldir
       ld (clearscreensp),sp
       ld sp,0x8000
        xor a
        ld d,a
        ld e,a
clearscreen0
        dup 64
        push de
        edup
        dec a
        jp nz,clearscreen0
clearscreensp=$+1
        ld sp,0
       pop hl ;ld hl,0x101*((scrbase+(40*200))/256)
       ld (0xfffe),hl ;   ty
        ret
       endif
       if ATM
curpgscr
        db 0x7f-3;3 for doublebuf
       else
curpgscr ;?
        db 0x15;0x7f-3;1
       endif

text
        ;db "Happy New Year 2023! 12345678901234567890 1234567890123 - ",0
        incbin "text.txt"
        db 0   

beginfree
;********************************************************************
endall

        page 3
        org 0xc000
hicode3_begin
       if TMKPLAYER
        incbin "_tmp/MODULE2.C"
        ds 0xe400-$
compile
PLAY=$+3
        incbin "_tmp/MODULE1.C"
       else
        ;include "ptsplay.asm"
        incbin "_tmp/player2.bin"
        align 256
        include "PLAYFAS5.asm"
        include "PLAYFAS5_init.asm"
        ds 0xe000-$
MDLADDR
        incbin "ny2023.pt3"
       endif
hicode3_end
        display "hicode3_begin=",hicode3_begin
        display "hicode3_end=",hicode3_end

        page 4
        org 0xc000
hicode_begin
        include "_tmp/nyfnt.ast"
hicode_end

        page 6
        org 0xc000
hicode2_begin
        ds 0x4000
hicode2_end

        page 0
	savebin "_tmp/code.c",begin,endall-begin
        page 3
	savebin "_tmp/hicode3.c",hicode_begin,hicode3_end-hicode3_begin
        page 4
	savebin "_tmp/hicode.c",hicode_begin,hicode_end-hicode_begin
        page 6
        ;display hicode2_end-hicode2_begin
	savebin "_tmp/hicode2.c",hicode2_begin,hicode2_end-hicode2_begin
        ;page 1
	;savebin "_tmp/hicode4.c",0xc000,0x4000
        ;page 7
	;savebin "_tmp/hicode5.c",0xc000,0x4000

	LABELSLIST "../us/user.l";,1
