org 24300

loader:
       ld b, 7         ; RAM 7, ROM 3 (+3DOS)
       call setrambank
deact_ramdisk:
       ld hl, $0000
       ld de, $0000
       call DOS_EST_1346
       JP NC, 0        ; reset if failed

       ld hl, binary_str ; "game.bin"
       ld bc, $0001    	; File handle 0, exclusive read
       ld de, $0002	; Open, place pointer after header
       call DOS_OPEN	; open file
       jp nc, 0        	; reset if open failed (change into something better!!!)

	ld hl, 32768	; read to 32768
	ld de, 6912	; read 6912 bytes
	ld bc, $0000	; b=file descriptor 0, c=RAM0
       call DOS_READ	; read bytes
       jp nc, 0       	; reset if read failed (change into something better!!!)       

; copy loading screen to actual screen
	ld hl, 32768
	ld de, 16384
	ld bc, 6912
	ldir
      
       ld c, $fe
       ld a, 7
       out (c), a
                              
       ld hl, 49152
       ld de, 9453
       ld bc, $0001	; RAM1.BIN, 16373 bytes
       call DOS_READ	; read bytes
       jp nc, 0       	; reset if read failed (change into something better!!!)       

       ld c, $fe
       ld a, 6
       out (c), a

       ld hl, 49152
       ld de, 7603
       ld bc, $0000	; RAM0.BIN, 7603 bytes
       call DOS_READ	; read bytes
       jp nc, 0       	; reset if read failed (change into something better!!!)       

       ld c, $fe
       ld a, 5
       out (c), a

       ld hl, 49152
       ld de, 15399
       ld bc, $0003	; RAM3.BIN, 15399 bytes
       call DOS_READ	; read bytes
       jp nc, 0       	; reset if read failed (change into something better!!!)       

       ld c, $fe
       ld a, 4
       out (c), a

       ld hl, 49152
       ld de, 16181
       ld bc, $0004	; RAM4.bin, 16181 bytes
       call DOS_READ	; read bytes
       jp nc, 0       	; reset if read failed (change into something better!!!)       

       ld c, $fe
       ld a, 3
       out (c), a

       ld hl, 49152
       ld de, 15841
       ld bc, $0006	; RAM6.bin, 15841 bytes
       call DOS_READ	; read bytes
       jp nc, 0       	; reset if read failed (change into something better!!!)       

       ld c, $fe
       ld a, 2
       out (c), a

       ld hl, 24576
       ld de, 248
       ld bc, $0000	; uncrunch.bin, 248 bytes
       call DOS_READ	; read bytes
       jp nc, 0       	; reset if read failed (change into something better!!!)       

       ld c, $fe
       ld a, 1
       out (c), a

       ld hl, 24850
       ld de, 20619
       ld bc, $0000	; cannon_bubble.bin, 20619 bytes
       call DOS_READ	; read bytes
       jp nc, 0       	; reset if read failed (change into something better!!!)       

       ld c, $fe
       ld a, 0
       out (c), a

       ld hl, 45858
       ld de, 2736
       ld bc, $0000	; sprites.bin, 2736 bytes
       call DOS_READ	; read bytes
       jp nc, 0       	; reset if read failed (change into something better!!!)       

       ld b, 0
       call DOS_CLOSE	; close file
       jp nc, 0        	; reset if close failed (change into something better!!!)       

       call DOS_MOTOR_OFF	; disconnect drive motor


set_ram_paging:
	ld b, $10		; RAM 0, ROM 2 (48k BASIC)
	call setrambank
jump_to_start:
	jp RANDOMIZE_ADDR
	ret	

binary_str	db "GAME.BIN",$ff


; INPUT: B: page to set 

setrambank:
       di
       ld A, ($5B5C)
       and $E8
       or b
       ld BC, $7FFD
       ld ($5b5c), a   ; save in the BASIC variable
       out (c), a
       ei
       ret

DOS_EST_1346 	equ $13F
DOS_OPEN 	equ $106
DOS_READ 	equ $112
DOS_CLOSE	equ $109
DOS_MOTOR_OFF	equ $19c
RANDOMIZE_ADDR 	equ 24850
