#include <strings.h> 
#include <stdio.h>
#include <stdlib.h>
#include <spritepack.h> 

extern struct sp_Rect *sp_ClipStruct; 
#asm 
LIB SPCClipStruct 
._sp_ClipStruct         defw SPCClipStruct 
#endasm 
extern uchar *sp_NullSprPtr;
#asm
LIB SPNullSprPtr
._sp_NullSprPtr         defw SPNullSprPtr
#endasm 

#pragma output STACKPTR=49152

#include "sprites.h"
#include "tables.h"



struct ball
{
  struct sp_SS *sprite;	
  int posx,posy;	// Position in x and y; 1 bit sign; 8 bits _real_ position, 7 bits decimal part
  uchar player;		// To which player it belongs
  uchar ball_type;
  int dx,dy;
};

struct arrow
{
  struct sp_SS *sprite;	
  uint angle;    	
  uchar frame;
};

struct player		// extend this structure to include all arrays out there, FIXME!!!
{
  struct sp_SS *sprite;
  uchar frame_sprite;	
  uint time_to_go;	// time to launch the next ball
  uchar destroy_anim_pos; 
};

char arrow_offsets[8]={0,96,0,0,0,-96,0,0};
int player_offsets[8]={144,0,144,0,144,0,-432,0};
uchar cursor_moved; // See if the player's cursor changed


#define BALL_OFFSETX_1_P1_2PLAYERS 	8
#define BALL_OFFSETX_2_P1_2PLAYERS 	16
#define BALL_OFFSETX_1_P1_1PLAYER 	72
#define BALL_OFFSETX_2_P1_1PLAYER 	80
#define BALL_OFFSET_Y 			8
#define INITPOS_PLAYER1_1_1PLAYER	124
#define INITPOS_PLAYER1_2_1PLAYER 	160
#define INITPOS_PLAYER1_1_2PLAYERS	56
#define INITPOS_PLAYER1_2_2PLAYERS 	160
#define WAIT_TIME			250 	// If we do not do anything in 5 seconds, the ball will be auto-launched

uchar BALL_OFFSET_X_PLAYER1[2]={8,  16};
uchar BALL_OFFSET_X_PLAYER2[2]={136,144};
uchar INITPOS_PLAYER1[2]={56,160};
uchar INITPOS_PLAYER2[2]={184,160};
uchar NEXTBALL_POSX[2] = {15,19};  // Where to place the next ball icon
uchar PLAYER_SPRPOS[2] = {3,26};
#define NEXTBALL_POSY 23



// Each player's grid is defined as:
// Row 0: B1 B2 B3 B4 B5 B6 B7      <BLANK>
// Row 1: B1 B2 B3 B4 B5 B6 <BLANK> <BLANK>
// We are wasting some bytes, but it will be worth in the end

uchar grid_player1[80];

struct ball *current_ball[2];
uchar next_ball[2]; // Next ball for each player (just the ball type)
struct arrow Arrows;
struct player Players;

// Used by the SetNullSpr function

uchar counter_till_nullspr;
uchar new_color;

uchar ball_colors[7]={ TRANSPARENT, 
			PAPER_BLACK | INK_MAGENTA ,
			PAPER_BLACK | INK_RED ,
			PAPER_BLACK | INK_GREEN ,
			PAPER_BLACK | INK_CYAN ,
			PAPER_BLACK | INK_YELLOW ,
			PAPER_BLACK | INK_WHITE 
		      };

struct sp_Rect cliprect;  // 1 for each player

// Joystick/key reading functions
void *joyfunc; 
struct sp_UDK keys;

// Player states
#define PL_WAITING 	0
#define PL_BALL_MOVING	1
#define PL_LINES	2
#define PL_FIND_HANGING 3
#define PL_FALLING 	4
#define PL_DESTROY_ANIM 5

uchar state_player;
uchar num_players;
uchar playing;
uchar editing;
uchar player1_level;  // Current level for 1 player games
uchar player1_valid_balltypes; // Available ball types for 1 player matches
uchar edit_color;     // Color for editing

// Some variables we prefer to have global instead of local (speed and code size)
char modifier;  

#define PLAYER1SCR 52838

/* Create memory allocator for sprite routines */

void *my_malloc(uint bytes)
{
   	return sp_BlockAlloc(0);
}

void *u_malloc = my_malloc;
void *u_free = sp_FreeBlock; 


#define COMPRESSED_SCREEN_START (uint *)(25000)
#define UNCOMPRESSED_START (uint *)(25002)
#define UNCRUNCH_START 25004

void UncompressToScreen(uint source)
{
	*COMPRESSED_SCREEN_START=source;
	*UNCOMPRESSED_START=16384;	
#asm
	di
	call UNCRUNCH_START
	ei
#endasm		
}


void printGameArea(void)
{
  UncompressToScreen(PLAYER1SCR);
  sp_ClearRect(&(cliprect), INK_WHITE | PAPER_BLACK, ' ', sp_CR_ALL);
  sp_Invalidate(&(cliprect), sp_ClipStruct);  

}

uchar print_x;
uchar print_y;
char *print_string;


void PrintString(uchar x, uchar y, char *string)
{
	print_x=x;
	print_y=y;
	print_string=string;
#asm
	LD A, (_print_y)
	LD B, A
	LD A, (_print_x)
	LD C,A
	LD HL, (_print_string)
	CALL 52000
#endasm		
}


void SetNullSpr(struct sp_CS *cs)
{   
   cs->colour = new_color;
   if (counter_till_nullspr == 0) 
   {
   	cs->graphic = sp_NullSprPtr;   	
   }
   else 
   {
   	cs->colour = new_color;
   	counter_till_nullspr--;   
   }	
   return;
} 

uchar value;
uchar NextBall(void)
{
	value=(rand()%6)+1;
	if(num_players==2) return value;
	else
	{
	 while (((1<<value) & player1_valid_balltypes)==0)	
	 {
		value=(rand()%6)+1; // Get new random value
	 }	 
	}
	return value;		
}

void LaunchBall(struct ball *b)
{	    
   	counter_till_nullspr = 6;   	   	
   	new_color = ball_colors[b->ball_type];   	   	
   	sp_IterateSprChar(b->sprite, SetNullSpr);  

   	b->dx=(int)(costable[Arrows.angle >> 1]);			// TEST!!!
   	b->dy=-(int)(costable[(Arrows.angle >> 1)+18]);   	    
}



// Ball surrounding (x,y) = (x-1, y) , (x+1, y), (x-1+(y&1), y-1), (x+(y&1), y-1), (x-1+(y&1), y+1), (x+(y&1), y+1)
char init_diffx[6] = {-1,1,-1,0,-1,0};
char diffy[6]=  {0,0,-1,-1,1,1};

int BallLineLength(int gridx, int gridy, uchar *grid)
{
  int maxlength = 1;
  uchar *tmp;
  uchar i;
  char diffx[6];      
 
  // If we are at the border of the game area, return 0 (no more balls)
  if ( (gridx < 0) || (gridy <0) || (gridx > 7) || (gridy > 8))
	return 0;  
 
  modifier = gridy&1;	
  for(i=2;i<6;i++) 
    diffx[i] = init_diffx[i]+modifier;
  diffx[0]=-1;
  diffx[1]=1;
  
  // We have to search all 6 directions  
  tmp=&(grid[gridx|gridy<<3]);
  
  for(i=0;i<6;i++)
  {
  	if (*tmp == *(tmp+diffx[i]+(diffy[i]<<3)))
  	{  
  	  *tmp  |= 0x80;  // Mark the ball to avoid loops!
	  maxlength += BallLineLength(gridx+diffx[i],gridy+diffy[i],grid);
      	  *tmp  &= 0x7f;  // Unmark the ball
  	}
  	  	  	
  	if(maxlength > 2) return maxlength; // There is no need to continue, we already have a good line!
  }  	
  return maxlength;	
}

void MarkLines(int gridx, int gridy, uchar *grid)
{
  uchar i;
  char diffx[6];
  
  // If we are at the border of the game area, return 0 (no more balls)
  if ( (gridx < 0) || (gridy <0) || (gridx > 7) || (gridy > 8))
	return; 
	
  modifier = gridy&1;
  for(i=2;i<6;i++) 
    diffx[i] = init_diffx[i]+modifier;
  diffx[0]=-1;
  diffx[1]=1;
  
  // We have to search all 6 directions  
  
  grid[gridx | (gridy<<3)]  |= 0x80;  // Mark the ball: this ball will be deleted, and we avoid loops
  for(i=0;i<6;i++)
  {
  	if ((grid[gridx | (gridy<<3)]&0x7f) == grid[(gridx+diffx[i]) | ((gridy+diffy[i])<<3)])
  	{    	  
      	  MarkLines(gridx+diffx[i],gridy+diffy[i],grid);
  	}	
  }  	  	
}

void FindHangingBalls(int gridx, int gridy, uchar *grid)
{
  uchar i;
  char diffx[6];
  
  // If we are at the border of the game area, return (no more balls)
  if ( (gridx < 0) || (gridy <0) || (gridx > 7) || (gridy > 8))
	return;   
  modifier = gridy&1;
  
  for(i=2;i<6;i++) 
    diffx[i] = init_diffx[i]+modifier;
  diffx[0]=-1;
  diffx[1]=1;
  
  // We have to search all 6 directions  
  
  grid[gridx | (gridy<<3)]  |= 0x80;  // Mark the ball: this ball is in a safe position (must not fall)
  for(i=0;i<6;i++)
  {
  	modifier = grid[(gridx+diffx[i]) | ((gridy+diffy[i])<<3)];
  	
  	if (modifier && (!(modifier &0x80))) // This ball is also safe: go there and search again
  	{    	  
      	  FindHangingBalls(gridx+diffx[i],gridy+diffy[i],grid);
  	}	
  }  	  	
}


// Returns 0: no lines found
// Returns 1: lines found

uchar FindLines(uint gridx, uint gridy, uchar *grid)
{
 if (BallLineLength(gridx,gridy,grid) > 2)
 {
  	MarkLines(gridx,gridy,grid);  	
  	return 1;
 }  	 
 return 0;
}

// Posible values for draw_animation:
// 0: draw blank tile (erase)
// 1: draw solid ball
// 2,3,4,5: draw destroy animations


void DrawTileBall(uchar player, uchar pos, uchar draw_animation, uchar color)
{
	uchar posx,posy;
	
	modifier = cliprect.col_coord;

	 
	posx = (pos & 0x7) << 1;
 	posy = (pos >> 3);
 	modifier += posy & 1;
 	posy <<= 1;
	
	if(draw_animation == 0) // erase
	{
		sp_PrintAtInv(posy + 1, posx + modifier, TRANSPARENT, ' ');
		sp_PrintAtInv(posy + 1, posx + 1 + modifier, TRANSPARENT, ' ');
		sp_PrintAtInv(posy + 2, posx + modifier, TRANSPARENT, ' ');
		sp_PrintAtInv(posy + 2, posx + 1 + modifier, TRANSPARENT, ' ');			
	}
	else if(draw_animation == 1) //draw
	{
		sp_PrintAtInv(posy + 1, posx + modifier, color, 150);
		sp_PrintAtInv(posy + 1, posx + 1 + modifier, color, 151);
		sp_PrintAtInv(posy + 2, posx + modifier, color, 152);
		sp_PrintAtInv(posy + 2, posx + 1 + modifier, color, 153);
	}
	else // animation
	{
		sp_PrintAtInv(posy + 1, posx + modifier, color,     214 + ((draw_animation - 2) << 2));
		sp_PrintAtInv(posy + 1, posx + 1 + modifier, color, 215 + ((draw_animation - 2) << 2));
		sp_PrintAtInv(posy + 2, posx + modifier, color,     216 + ((draw_animation - 2) << 2));
		sp_PrintAtInv(posy + 2, posx + 1 + modifier, color, 217 + ((draw_animation - 2) << 2));				
	}
	
}

uchar x,y;
uchar i_cannon,j_cannon;

void DrawTileCannon(uchar player, uchar frame)
{	
	uchar frameinit= (frame*12)+155;
	
	if(player == 0)
	{
		x= (INITPOS_PLAYER1[0] >> 3)-1;
		y= (INITPOS_PLAYER1[1] >> 3)-1;
	}
	else
	{
		x= (INITPOS_PLAYER2[0] >> 3)-1;
		y= (INITPOS_PLAYER2[1] >> 3)-1;		
	}
	for(j_cannon=0;j_cannon<3;j_cannon++)
	 for(i_cannon=0;i_cannon<4;i_cannon++)
	 {
	   sp_PrintAtInv(y+j_cannon,x+i_cannon,PAPER_BLACK | INK_BLUE , frameinit++);	   
	 }				
}

uchar k;
void CleanupGrid(uchar player, uchar *grid)
{
 

 for(k=0;k<80;k++)
 {
 	if(grid[k] & 0x80)
 	{
 		grid[k]=0;
 		DrawTileBall(player, k, 0, 0); 	
 	}	
 }	
}


void StoreBall(uint gridx, uint gridy, uchar ball_type,uchar player)
{	
	uchar posx,posy,modif;
	struct ball *b;
	uchar *grid;
	
	if(gridy > 8)  // Game over for this player
	{
		playing=0;
		return;	
	}
	
	posx = gridx<<1;
	posy = gridy<<1;
	modif = gridy & 1;
	
	grid=grid_player1;

	
	grid[gridx | (gridy<<3)]=ball_type;
	DrawTileBall(player,gridx | (gridy<<3),1,ball_colors[ball_type]);
	if (FindLines(gridx,gridy,grid))
		state_player = PL_LINES;
	else 
		state_player = PL_WAITING;	


	// Send the ball back to the launch position
	b=current_ball[player];
	if(player == 0)
	{
	     b->posx = INITPOS_PLAYER1[0]; b->posx <<= 7; 
   	     b->posy = INITPOS_PLAYER1[1]; b->posy <<= 7; 
   	}
   	else
   	{
	     b->posx = INITPOS_PLAYER2[0]; b->posx <<= 7; 
   	     b->posy = INITPOS_PLAYER2[1]; b->posy <<= 7;    		   	     
   	}
    	sp_MoveSprAbs(b->sprite,&(cliprect),0, 
    		b->posy >> 10,  
    		b->posx >> 10, 
    		(b->posx >> 7) & 0x7, 
    		(b->posy >> 7) & 0x7);   
    		
    	// Assign the new ball type 
    	b->ball_type = next_ball[player];
   	new_color = ball_colors[b->ball_type];
    	counter_till_nullspr = 6;   	   	
   	sp_IterateSprChar(Arrows.sprite, SetNullSpr);   
	// Recalc the next ball type
    	next_ball[player] = NextBall();    	
 	sp_PrintAtInv(NEXTBALL_POSY, NEXTBALL_POSX[player], ball_colors[next_ball[player]], 154); 					
   	
   	Players.time_to_go = WAIT_TIME;
}

// La frmula para situar la bola es:
//
//     -> si row es par: 8 + x*16
// x = |
//     -> si row es impar: 16 + x*16
//
//     El offset_x (8 y 16) variar para el player 2
//
// y = 8 + y*16
 
 
// gridx2 es gridx para el caracter de la derecha de la bola (por si se sale a la bola de al lado)

void GetGridPos(struct ball *b, uint *gridx, uint *gridx2, uint *gridy)
{
	uchar *BALL_OFFSET_X;
	
	BALL_OFFSET_X=BALL_OFFSET_X_PLAYER1;
 	*gridy =((b->posy >> 7) - BALL_OFFSET_Y) >> 4 ;
	if((b->posx >> 7) < BALL_OFFSET_X[(*gridy)&1])
		*gridx=0;
	else
		*gridx  =((b->posx >> 7) - BALL_OFFSET_X[(*gridy)&1]) >> 4 ;		
	
	*gridx2 =(((b->posx+1024) >> 7) - BALL_OFFSET_X[(*gridy)&1]) >> 4 ;
}

#define BALL_SPEED 4



uchar l;
void CalcNewPosition(struct ball *b)
{
	int newval;
	uchar *grid_player;
	uint min_x, max_x;
	uint gridx, gridy, gridx2; // could use min_x, max_x to reduce memory usage?	
	
	grid_player = grid_player1;
	min_x = BALL_OFFSET_X_PLAYER1[0];
	
	min_x <<= 7;
	max_x = min_x + 12416; // 13440 == 105 << 7, size in X of the game area
	
	for(l=0;l<BALL_SPEED;l++)
	{		
		newval = b->posx + b-> dx;	
		if(newval < min_x)		// Left collision
		{
			//newval += min_x - newval;
			newval = min_x;
			b->dx = -b->dx;
		}
		else if(newval  > max_x)		// Right collision
		{
			//newval -= newval - max_x ;
			newval = max_x;
			b->dx = -b->dx;		
		}	
		else b->posx = newval;		
	
		newval = b->posy + b-> dy;
		b->posy = newval;	
		if (newval < 1152 ) // 9 << 7, top limit
		{
			// Calc the ball's final position in the grid		
			GetGridPos(b, &gridx, &gridx2,&gridy);	
			StoreBall(gridx,gridy,b->ball_type,b->player);
			return;
		}
	
		// Try to find collisions with existing balls
		GetGridPos(b, &gridx, &gridx2, &gridy);
		if ((grid_player[gridx | (gridy<<3)]) || (grid_player[gridx2 | (gridy<<3)]))
		{    		    		
			b->posx -= b->dx;
			b->posy -= b->dy;
	
			GetGridPos(b, &gridx, &gridx2,&gridy);	
			StoreBall(gridx,gridy,b->ball_type,b->player);
			return;
		}	
	}
}

#asm
defw 0                        /* two free bytes before start of a hook */
#endasm
void timerISR(void)
{/*
  if(playing)
  {
  	if(state_player == PL_WAITING)
  	{
  		Players.time_to_go--;
  		if(Players.time_to_go == 0) 
  		{
  			LaunchBall(current_ball[0]);
			state_player = PL_BALL_MOVING;	
	  	}
	}
 }*/
}


uchar m;
char *level_string="Level   \xff";
char *level_numbers="1 2 3 4 5 6 7 8 9 101112131415161718192021222324252627282930";

void SetOnePlayerGrid(uchar level)
{
  sp_ClearRect(&(cliprect), INK_WHITE | PAPER_BLACK, ' ', sp_CR_ALL);
  sp_Invalidate(&(cliprect), sp_ClipStruct);  
  
   memcpy(grid_player1,(uchar*)(49152+80*level),80);

	player1_valid_balltypes=0;
	
	for(m=0;m<80;m++)
	{
	 if(grid_player1[m]) 
	 {
	 	DrawTileBall(0,m,1,ball_colors[grid_player1[m]]);		
	 	player1_valid_balltypes |= 1 << grid_player1[m];  // Set the corresponding bit
 	 }
 	}
 	if(player1_valid_balltypes==0) player1_valid_balltypes = 126; 	
	sp_UpdateNow(); 	
	
	//Print level number
	level_string[6]=level_numbers[player1_level<<1];
	level_string[7]=level_numbers[(player1_level<<1)+1];

	PrintString(1,24,level_string);
	//playing=0;
	//sp_WaitForKey();
	sp_Invalidate(&(cliprect), sp_ClipStruct);
	sp_UpdateNow();	
	//playing=1;
}

char *help1="L- Load\xff";
char *help2="S- Save\xff";
char *help3="B- Prev.\xff";
char *help4="N- Next\xff";
char *help5="P- Play\xff";
char *help6="E- Edit\xff";
char *help7="C- Color\xff";
char *help8="  Use\xff";
char *help9="Sinclair\xff";
char *help10="joystick\xff";

void DrawHelp(void)
{
	PrintString(3,24,help1);
	PrintString(4,24,help2);
	PrintString(5,24,help3);
	PrintString(6,24,help4);
	PrintString(7,24,help5);
	PrintString(8,24,help6);
	PrintString(9,24,help7);
	PrintString(11,24,help8);
	PrintString(12,24,help9);
	PrintString(13,24,help10);
}

uchar n;
void CheckNextLevelPlayer1(void)
{
	uchar found;
	
	found=0;
	for(n=0;n<80;n++)
	 if(grid_player1[n]) found=1;

	if(!found)	// We should do something else, such as play some level-end music or whatever
	{
	    player1_level++;	
   	    SetOnePlayerGrid(player1_level);	
	}
}

char *gameover_string="Game Over\xff";

void GameOver(void)
{
  PrintString(12,10,gameover_string);
  sp_WaitForKey();
}

uchar x_edit, y_edit;

char *confirm_save="Are you sure you want to save?\xff";
char *save_success="Save successful               \xff";
char *save_error  ="Save error                    \xff";
FILE *p;

void SaveLevels(void)
{
  	memset(16384,0,6912);   		 
   	PrintString(10,1,confirm_save);
   	sp_WaitForKey();
   	if(sp_KeyPressed(sp_LookupKey('y')))
   	{
   		sp_WaitForNoKey();
   		p=fopen("levels.bin","wb");
   		if(!p)
   		{
   		 PrintString(10,1,save_error);
	 	}
	 	else
	 	{
	 		if(fwrite((uchar*)(49152),80,30,p) != 30)   		 	
   	 		{
   	 			PrintString(10,1,save_error);
			}	   		 			
   		 	else
   		 	{
   		 		PrintString(10,1,save_success);
			}
		}	   		 		
		fclose(p);
   		sp_WaitForKey();
   		sp_WaitForNoKey();
   	}   		    	
	sp_Invalidate(sp_ClipStruct, sp_ClipStruct);     		 
	sp_UpdateNow();
	printGameArea();
	DrawHelp(); 	
	DrawSelectedBall();
	SetOnePlayerGrid(player1_level);
}

char *confirm_load="Are you sure you want to load?\xff";
char *load_success="Load successful               \xff";
char *load_error  ="Load error                    \xff";
void LoadLevels(void)
{
  	memset(16384,0,6912);   		 
   	PrintString(10,1,confirm_load);
   	sp_WaitForKey();
   	if(sp_KeyPressed(sp_LookupKey('y')))
   	{
   		sp_WaitForNoKey();
   		p=fopen("levels.bin","rb");
   		if(!p)
   		{
   		 PrintString(10,1,load_error);
	 	}
	 	else
	 	{
	 		if(fread((uchar*)(49152),80,30,p) != 30)   		 	
   	 		{
   	 			PrintString(10,1,load_error);
			}	   		 			
   		 	else
   		 	{
   		 		PrintString(10,1,load_success);
			}
		}	   		 		
		fclose(p);
   		sp_WaitForKey();
   		sp_WaitForNoKey();
   	}   	
	sp_Invalidate(sp_ClipStruct, sp_ClipStruct);     		 
	sp_UpdateNow();
	printGameArea();
	DrawHelp(); 	
	DrawSelectedBall();
	SetOnePlayerGrid(player1_level);   		
}

void DrawSelectedBall(void)
{
 // Draw the ball
 sp_PrintAtInv(15, 27, ball_colors[edit_color], 150);
 sp_PrintAtInv(15, 28, ball_colors[edit_color], 151);
 sp_PrintAtInv(16, 27, ball_colors[edit_color], 152);
 sp_PrintAtInv(16, 28, ball_colors[edit_color], 153);   	
}

uchar i, j;
main() 
{ 
   uint posx, posy; 
   uchar *grid;
   uchar *level_pointer;

// This is all generic initialization, so it must stay as it is now
 
   #asm 
   di 
   #endasm 
   sp_InitIM2(0xb1b1); 
   sp_CreateGenericISR(0xb1b1); 
   sp_RegisterHook(255, timerISR);
   #asm 
   ei 
   #endasm 

   // Initialization
   
   sp_Initialize(INK_WHITE | PAPER_BLACK, ' '); 
   sp_Border (BLACK );
   sp_AddMemory(0, 130, 14, 0xea60); // Adjust this as needed
        
   for(i=0;i<1;i++)
   {
    	// Define ball sprites
    	current_ball[i]=(struct ball *)u_malloc(sizeof(struct ball));
    	current_ball[i]->sprite = sp_CreateSpr(sp_OR_SPRITE, 3, bola_1, 1, TRANSPARENT);  
    	sp_AddColSpr(current_ball[i]->sprite, bola_2, TRANSPARENT); 
    	sp_AddColSpr(current_ball[i]->sprite, bola_2, TRANSPARENT);    
    	current_ball[i]->player=i;

   	
   	// Define arrow sprites
   	Arrows.sprite=sp_CreateSpr(sp_MASK_SPRITE, 3, puntero_1, 1, TRANSPARENT);
   	sp_AddColSpr(Arrows.sprite, puntero_2, TRANSPARENT); 
   	sp_AddColSpr(Arrows.sprite, puntero_2, TRANSPARENT);
   	counter_till_nullspr = 6;   	   	   	
   	new_color = ball_colors[current_ball[i]->ball_type];
   	sp_IterateSprChar(Arrows.sprite, SetNullSpr); 
   	Arrows.frame=96;	
   }   
   
   // Define pirate sprite
   Players.sprite=sp_CreateSpr(sp_MASK_SPRITE, 3, pirate_1_f1, 1, PAPER_YELLOW | INK_BLACK);
   sp_AddColSpr(Players.sprite, pirate_2_f1, PAPER_YELLOW | INK_BLACK);
   sp_AddColSpr(Players.sprite, pirate_3_f1, PAPER_YELLOW | INK_BLACK);
   Players.frame_sprite=0;    
     
   // Define tiles
   sp_TileArray(150,ball_tile_1);
   sp_TileArray(151,ball_tile_2);
   sp_TileArray(152,ball_tile_3);
   sp_TileArray(153,ball_tile_4);
   sp_TileArray(154,miniball);
   for(i=0;i<60;i++) sp_TileArray(155+i,cannon_f1 + (i<<3)); // Cannon, frames
   for(i=0;i<16;i++) sp_TileArray(214+i,ball_destroy_anim + (i<<3)); // Ball being destroyed, frames

   // Joystick
   joyfunc = sp_JoySinclair1; 

   
   // Some more definitions (remember, only 1 player)
   	BALL_OFFSET_X_PLAYER1[0]=BALL_OFFSETX_1_P1_1PLAYER;
	BALL_OFFSET_X_PLAYER1[1]=BALL_OFFSETX_2_P1_1PLAYER;
	INITPOS_PLAYER1[0]=INITPOS_PLAYER1_1_1PLAYER;
	INITPOS_PLAYER1[1]=INITPOS_PLAYER1_2_1PLAYER;
	NEXTBALL_POSX[0]= 10; // FIXME!! NEED TO CHECK THIS!!!
	PLAYER_SPRPOS[0]= 11; 
	
	cliprect.row_coord = 1; 
   	cliprect.col_coord = 9; 
   	cliprect.height = 18; 
   	cliprect.width  = 14;

   	// Draw main screen

   	sp_UpdateNow();    
   	printGameArea();    
   	sp_UpdateNow();

	DrawHelp();
	editing=1;
	player1_level=0;
	edit_color=1;
	
   while(1)
   {
   	SetOnePlayerGrid(player1_level);
   	x_edit=0;
   	y_edit=1;
   	counter_till_nullspr = 6;   	   	   	
   	new_color = ball_colors[0]; // Transparent
   	sp_IterateSprChar(Arrows.sprite, SetNullSpr); 
	DrawSelectedBall();
   	
   	while(editing)
   	{ 	
   		level_pointer=(uchar*)(49152+80*player1_level);
   		
   		// Draw the cursor
   		modifier = y_edit & 1;
  		posx = 9+(x_edit<<1)+modifier; 
		posy = 1+(y_edit<<1); 							
		//sp_MoveSprAbs(Arrows.sprite,&(cliprect),arrow_offsets[Arrows.frame&7], 
		sp_MoveSprAbs(Arrows.sprite,&(cliprect),0, 
			posy ,  
			posx , 
			0, 
			0);   		
#asm
	halt
#endasm   		
		// Check for joystick movement
		posx = (joyfunc)(&keys); 
    		if (!(posx & sp_LEFT))
    		{
    			while(!(posx & sp_LEFT)) posx = (joyfunc)(&keys); // Wait for key release
    			if(x_edit > 0) x_edit--;
    		}		
    		if (!(posx & sp_RIGHT))
    		{
    			 while(!(posx & sp_RIGHT)) posx = (joyfunc)(&keys); // Wait for key release
    			 if(x_edit < 6) x_edit++;
    		}
    		if (!(posx & sp_UP))
    		{
    			 while(!(posx & sp_UP)) posx = (joyfunc)(&keys); // Wait for key release
    			 if(y_edit > 0) y_edit--;
    		}
    		if (!(posx & sp_DOWN))
    		{
    			 while(!(posx & sp_DOWN)) posx = (joyfunc)(&keys); // Wait for key release
    			 if(y_edit < 8) y_edit++;
    		}
    		if(!(posx & sp_FIRE))
    		{
    			 while(!(posx & sp_FIRE)) posx = (joyfunc)(&keys); // Wait for key release
			 
			 if((y_edit & 1) && (x_edit > 5))
			 {
			 	// Do nothing!
			 }
			 else
			 {
			 	level_pointer[(y_edit<<3)|x_edit]=edit_color; // Place it in the grid			 
			 	DrawTileBall(0, (y_edit<<3)|x_edit, 1, ball_colors[edit_color]); // Show it
			 }
    		}
    		
    		
    		
   		// Check for keypresses
   		if(sp_KeyPressed(sp_LookupKey('p'))) // Test the level
   		{
   			sp_WaitForNoKey();
   			editing=0;	
   		}
   		else if(sp_KeyPressed(sp_LookupKey('c'))) // Change the ball color
   		{
   			sp_WaitForNoKey();
   			edit_color++;		
   			if(edit_color > 6) edit_color=0;
			DrawSelectedBall();
   		}
   		else if(sp_KeyPressed(sp_LookupKey('s'))) // Save the levels
   		{
   		 sp_WaitForNoKey();
   		 SaveLevels();
   		}
   		else if(sp_KeyPressed(sp_LookupKey('l'))) // Load the levels
   		{
   		 sp_WaitForNoKey();
   		 LoadLevels();
   		}
   		else if(sp_KeyPressed(sp_LookupKey('b'))) // Go to previous level
   		{
   		  if(player1_level > 0)
   		  {
   		  	player1_level--;	
   	    		SetOnePlayerGrid(player1_level);		
   		  }	
   		}
   		else if(sp_KeyPressed(sp_LookupKey('n'))) // Go to next level
   		{
   		  if(player1_level < 29)
   		  {
   		  	player1_level++;	
   	    		SetOnePlayerGrid(player1_level);		
   		  }	
   		}
   		sp_UpdateNow();   		   		   		 
  		
   	}
   	
   	
	num_players=1;
   	// All of this initialization must be done everytime we start a new game   
   	memset(grid_player1,0,80);
   	SetOnePlayerGrid(player1_level);   	
   	current_ball[0]->posx=INITPOS_PLAYER1[0]; current_ball[0]->posx<<=7;
   	current_ball[0]->posy=INITPOS_PLAYER1[1]; current_ball[0]->posy<<=7;
   	state_player=PL_WAITING;
   	Players.time_to_go = WAIT_TIME;
    	                               

   	Arrows.angle=34;
   	DrawTileCannon(0,2);
   	sp_MoveSprAbs(Players.sprite,sp_ClipStruct,player_offsets[Players.frame_sprite & 7 ],20,PLAYER_SPRPOS[0],0,0);
   	   		   	
   	current_ball[0]->ball_type = NextBall();
   	next_ball[0]=NextBall();
   	sp_PrintAtInv(NEXTBALL_POSY, NEXTBALL_POSX[0], ball_colors[next_ball[0]], 154); 	

   	sp_UpdateNow();


   	playing=1;
   	
   	// This is the game loop itself
   
   	while(playing) {            
	 for(i=0;i<num_players;i++)
	 {
		grid=grid_player1;
		cursor_moved=0;
		// Read joysticks and update arrow angles
    		posx = (joyfunc)(&keys); 
    		if (!(posx & sp_LEFT))
    		{
    			if(Arrows.angle > 8) Arrows.angle--;  // TEST!!! should be > 4
    			cursor_moved=1;
    		}
    		if (!(posx & sp_RIGHT))
    		{
    			if(Arrows.angle < 64) Arrows.angle++;    	// TEST!!! should be < 32
    			cursor_moved=1;    			
    		}
    		
    		// Check if we have press "e" to go back to edit mode
    		if(sp_KeyPressed(sp_LookupKey('e')))
    		{
    			playing=0; 
    			editing=1;	
    		}
    					
		switch(state_player)
		{
			case PL_WAITING:
					if(!(posx & sp_FIRE))
					{
						LaunchBall(current_ball[i]);
						state_player = PL_BALL_MOVING;						
					}
					break;
			case PL_BALL_MOVING:
					CalcNewPosition(current_ball[i]);
    					sp_MoveSprAbs(current_ball[i]->sprite,&(cliprect),0, 
    						      current_ball[i]->posy >> 10,  
    						      current_ball[i]->posx >> 10, 
    						      (current_ball[i]->posx >> 7) & 0x7, 
    						      (current_ball[i]->posy >> 7) & 0x7);                   
					break;
			case PL_LINES:  	
					Players.destroy_anim_pos=0;		
					state_player = PL_DESTROY_ANIM;
					if (num_players == 1) // Calc new player1_valid_balltypes value
					{
						player1_valid_balltypes=0;
						for(j=0;j<80;j++)
						 if ((grid[j]&0x7f) && ((grid[j]&0x80)==0)) player1_valid_balltypes |= 1 << (grid[j]&0x7f);
						if(player1_valid_balltypes==0) player1_valid_balltypes = 126;
					     // Recalc the next ball type
    						next_ball[i] = NextBall();    	
   						sp_PrintAtInv(NEXTBALL_POSY, NEXTBALL_POSX[i], ball_colors[next_ball[i]], 154);
				        }	
					break;		
			case PL_DESTROY_ANIM:
					for(j=0;j<80;j++)
					{
					 if(grid[j] & 0x80)
					 {
					   DrawTileBall(i, j,2+(Players.destroy_anim_pos), ball_colors[grid[j] & 0x7f]);
					 }
					}	
					if((Players.destroy_anim_pos++) == 4)
					{
						CleanupGrid(i,grid);	
						state_player = PL_FIND_HANGING;
					}
					break;								
			case PL_FIND_HANGING: // First, 
					for(j=0;j<7;j++) 
						if(grid[j]) FindHangingBalls(j,0,grid);
					for(j=0;j<80;j++)
					{
						if (grid[j] && (!(grid[j]&0x80)))  // There were some balls left hanging
						{
							state_player = PL_FALLING;					
							grid[j] |= 0x80; // Mark this ball as falling
						}
						else grid[j] &=0x7f; // Cleanup
					}
					if(state_player != PL_FALLING)
					{  // For one player matches, check if we have finished this level
					  if (num_players == 1)
					  {
						CheckNextLevelPlayer1();
				          }									
					  state_player = PL_WAITING;
					}
					break;
			case PL_FALLING:
					for(j=79;j;j--)
					{
						if (grid[j] & 0x80)
						{
							if(j<64)
							{
								DrawTileBall(i,j,0,0);
								DrawTileBall(i,j+8,1,ball_colors[grid[j]&0x7f]);		
								grid[j+8]=grid[j];
								grid[j]=0;
							}
							else
							{
								grid[j]=0;
								DrawTileBall(i,j,0,0);
							}								
						}
					}
					// See if we are still falling
					state_player = PL_WAITING;
					for(j=0;j<80;j++)
					{
						if (grid[j]&0x80)  // There were some balls left hanging
							state_player = PL_FALLING;					
					}		
					if ((num_players == 1) && (state_player == PL_WAITING))
					{
					 CheckNextLevelPlayer1();
				        }													
					break;
		}
	}

    	// Redraw pointer sprites and cannon
	for(i=0;i<num_players;i++)
	{
		posx = INITPOS_PLAYER1[0]; posx <<= 7; 
		posy = INITPOS_PLAYER1[1]; posy <<= 7; 						
		posx += ((int)(costable[Arrows.angle >> 1]) << 5);
		posy -= ((int)(costable[(Arrows.angle >> 1)+18]) << 5);
	
		//sp_MoveSprAbs(Arrows.sprite,&(cliprect),arrow_offsets[Arrows.frame&7], 
		sp_MoveSprAbs(Arrows.sprite,&(cliprect),0, 
			posy >> 10,  
			posx >> 10, 
			(posx >> 7) & 0x7, 
			(posy >> 7) & 0x7);         
	 	Arrows.frame ++;		
	 	if(cursor_moved)
	 	{    	
    			DrawTileCannon(i,Arrows.angle >> 4);  // TEST!!!! should be >> 3
   //			Players.frame_sprite++;
   //			sp_MoveSprAbs(Players.sprite,sp_ClipStruct,player_offsets[Players.frame_sprite & 7 ],20,PLAYER_SPRPOS[i],0,0);   
    	 	}	          	  
    	}
    	sp_UpdateNow();                      
  	// Wait for the next interrupt
	#asm
	halt
	#endasm 
    } 
    	GameOver();
   }
return 0;
}

