
#include "wav.h"
#include "readdir.h"


filelist_struct filelist[MAX_FILES];
WAV_struct WAV_list[MAX_FILES];

int amount_linkfiles;
int sample_bytes_total;

int read_directory()
{
	struct _finddata_t ffblk;
	long handle;
	int done, i,j;
	int max_files = MAX_FILES;
	u8 *q;
	u32 r, offset;

	amount_linkfiles = i = 0;
	sample_bytes_total   = 0;

	printf("input WAV-files:\n");
	printf("----------------\n");

	handle = _findfirst("*.WAV",&ffblk);
	
	if(handle == -1)
	{
		printf("\n*** ERROR READING DIRECTORY ***\n");
		return -1;
	}

	done = 0;
	while (!done)
	{
		filelist[i].length = ffblk.size;
		strcpy(filelist[i].fname,ffblk.name);

		// read first 4 bytes of filename for search id
		q = (u8*)&ffblk.name;
		r = q[0]<<24 | q[1]<<16 | q[2]<<8 | q[3];
		filelist[i].f0 =  r;		

		printf("  %s  -- %i bytes\n", ffblk.name,ffblk.size);

		done = _findnext(handle, &ffblk);

		i++;
		amount_linkfiles++;
		max_files--;
		if(!max_files) break;
	}
	printf("\n\n%i WAV-files found\n",amount_linkfiles);


	sort_filelist();

	//display_filelist();

	// set samples id to "null"
	for(i=0;i<MAX_FILES;i++)
	{
		WAV_list[i].id[0] = 'n';
		WAV_list[i].id[1] = 'u';
		WAV_list[i].id[2] = 'l';
		WAV_list[i].id[3] = 'l';
	}

	for(i=0;i<amount_linkfiles;i++)
	{
		strcpy(WAV_list[i].fname,filelist[i].fname);

		// copy 4 chars sample id
		for(j=0;j<4;j++) WAV_list[i].id[j] = ' ';
		for(j=0;j<4;j++)
		{
			if(filelist[i].fname[j+3] == '-') break;
			WAV_list[i].id[j] = filelist[i].fname[j+3];
		}

		if (load_WAV_header(WAV_list[i].fname)==-1) return -1;

		WAV_list[i].num_samples = num_samples;

		sample_bytes_total+=num_samples;
		sample_bytes_total+=1024;
	}


	// copy sample id to binary
	for(i=0;i<MAX_FILES;i++)
	{
		for(j=0;j<4;j++)
			reboy_template[i*8 + j + samples_text_start] = WAV_list[i].id[j];
	}


	// copy samplestart & samplelength to binary

	offset =samples_raw_start;
	offset+=BIN_START;		// absolute address

	for(i=0;i<amount_linkfiles;i++)
	{
		write32(reboy_template+i*8 + samples_list_start    , offset);
		write32(reboy_template+i*8 + samples_list_start + 4, WAV_list[i].num_samples);

		offset+=WAV_list[i].num_samples;
		offset+=1024;
	}


	printf("\n\n%i bytes for samples total\n\n\n",sample_bytes_total);


	// write main part of binary
	fwrite(reboy_template,samples_raw_start,1,reboy_out_file);

	// process wav-files & write raw data
	for(i=0;i<amount_linkfiles;i++)
	{
		printf("\nadding wav: %s",WAV_list[i].fname);
		load_WAV(WAV_list[i].fname);
	}
	return 0;
}


void sort_filelist()
{
	int i,j;
	char fname[256];
	u32	 f0;
	u32	 length;

	// bubblesort
	for(i=0;i<amount_linkfiles;i++)
	{
		for(j=i;j<amount_linkfiles;j++)
		{
			if(filelist[j].f0 < filelist[i].f0)
			{
				strcpy(fname,filelist[j].fname);
				f0 = 	filelist[j].f0;
				length= filelist[j].length;

				strcpy(filelist[j].fname, filelist[i].fname);
				filelist[j].f0 		= filelist[i].f0;
				filelist[j].length 	= filelist[i].length;

				strcpy(filelist[i].fname, fname);
				filelist[i].f0 		= f0;
				filelist[i].length 	= length;
			}
		}
	}
}


void display_filelist()
{
	int i;
	printf("\n\nSORTED FILES:\n\n");
	for(i=0;i<amount_linkfiles;i++)
	{
		printf("\n%s",filelist[i].fname);
	}
}

