--Demo Script


SCENE = 1
IMAGE = 2

CAM1 = 0
CAM2 = 1
CAM3 = 2
CAM4 = 3

BACKGROUND	= 0
LAYER1		= 1
LAYER2		= 2
LAYER3		= 3
LAYER4		= 4
LAYER5		= 5
CAPTURE1	= 11
CAPTURE2	= 12
CAPTURE3	= 13
CAPTURE4	= 14
CAPTURE5	= 15


-- Direct3D Blend modes
BLEND_ZERO				= 1  -- Blend factor is (0, 0, 0, 0) 
BLEND_ONE				= 2  -- Blend factor is (1, 1, 1, 1)
BLEND_SRCCOLOR			= 3  -- Blend factor is (Rs,Gs,Bs,As)
BLEND_INVSRCCOLOR		= 4  -- Blend factor is (1 - Rs, 1 - Gs, 1 - Bs, 1 - As)
BLEND_SRCALPHA			= 5  -- Blend factor is (As, As, As, As)
BLEND_INVSRCALPHA		= 6  -- Blend factor is ( 1 - As, 1 - As, 1 - As, 1 - As)
BLEND_DESTALPHA			= 7  -- Blend factor is (Ad, Ad, Ad, Ad)
BLEND_INVDESTALPHA		= 8  -- Blend factor is (1 - Ad, 1 - Ad, 1 - Ad, 1 - Ad)
BLEND_DESTCOLOR			= 9  -- Blend factor is (Rd, Gd, Bd, Ad)
BLEND_INVDESTCOLOR		= 10 -- Blend factor is (1 - Rd, 1 - Gd, 1 - Bd, 1 - Ad)
BLEND_SRCALPHASAT		= 11 -- Blend factor is (f, f, f, 1); f = min(A, 1 - Ad)

createtexture(0, 0, "color")
setambientcolor(0,0,0)


------------------------------------



loadimage("data/hyttelan_1.png", "hyttelan")
loadimage("data/scroll.png", "scroll")


createtexture(1024, 1024, "captexture")

starttime(0)
endtime(60)

loadmusic("data/jur.ogg")


function fadefromblack(t1, delay)
    id = layer(IMAGE, "color", LAYER5, BLEND_SRCALPHA, BLEND_INVSRCALPHA)
    
    start(t1, id)
      setimagescale(t1, 1024, 768, id)
      setimagepos(t1, 0, 0, id)
      setimagecolor(t1, 0, 0, 0, 255, id)
      setimagecolor(t1+delay, 0, 0, 0, 0, id)
    stop(t1+delay, id)
end

function fadetoblack(t1, delay)
    id = layer(IMAGE, "color", LAYER5, BLEND_SRCALPHA, BLEND_INVSRCALPHA)
    
    start(t1, id)
      setimagescale(t1, 1024, 768, id)
      setimagepos(t1, 0, 0, id)
      setimagecolor(t1, 0, 0, 0, 0, id)
      setimagecolor(t1+delay, 0, 0, 0, 255, id)
    stop(t1+delay, id)
end



function scene_crossfade(t1, t2)

	capture("captexture", t1, t2)

    id = layer(SCENE, "TEST", CAM1, 0, CAPTURE1, BLEND_ONE, BLEND_ONE)
    start(t1+3, id)
    stop(t2, id)

    id = layer(SCENE, "teapot", CAM1, 0, LAYER1, BLEND_ONE, BLEND_ZERO)
    start(t1, id)
    stop(t1+5, id)
    
    
	id = layer(IMAGE, "captexture", LAYER2, BLEND_SRCALPHA, BLEND_INVSRCALPHA)
	start(t1+3, id)
	setimagescale(t1, 1024, 768, id)
	setimagecolor(t1+3, 255, 255, 255, 0, id)
	setimagecolor(t1+5, 255, 255, 255, 255, id)
	stop(t2, id)
	
 
    fadefromblack(t1, 1)
    fadetoblack(t2-1, 1)
    
	    
 end




function test(t1, t2)

       id = layer(IMAGE, "BKG", BACKGROUND, BLEND_ONE, BLEND_ZERO)
       start(t1, id)
       stop(t2, id)

       id = layer(IMAGE, "DAMN", LAYER2, BLEND_SRCALPHA, BLEND_INVSRCALPHA)
       start(t1, id)
       setimagecolor(t1, 255,255,255, 128, id)
       stop(t2, id)
end


function demo1(t1, t2)
	fadefromblack(t1,3)
	
    id = layer(IMAGE, "color", BACKGROUND, BLEND_ONE, BLEND_ZERO)
    setimagescale( t1, 1024, 768, id )
    setimagecolor( t1, 255, 255, 255, 255, id)
    start(t1, id)
    stop(t2, id)

    id = layer(IMAGE, "scroll", LAYER1, BLEND_ONE, BLEND_ZERO)

        setimagepos(t1, 0, 768, id)
    start(t1, id)
        setimagepos(t1, 0, 768, id)
        setimagepos(t2, 0, -2700, id)
    stop(t2, id)
    
    
    id = layer(IMAGE, "hyttelan", LAYER3, BLEND_SRCALPHA, BLEND_INVSRCALPHA)
    setimagescale( t1, 1024, 768, id )
    start(t1, id)
    stop(t2, id)
    fadetoblack(t2-2, 2)

end
    

demo1(0,60)

