
#ifndef __dummy_h
#define __dummy_h

#include "renderfx.h"
#include "m_main.h"
#include "l_main.h"
#include "g_main.h"
#include "i_main.h"

extern cbitmap *gettext (int i);


typedef struct
{
  float z_start;
  float z_amplitude;
  float z_periods;

  float r_start;
  float r_amplitude;
  float r_periods;
}RotIn;

typedef struct
{
  float z_start;
  float z_amplitude;
  float z_periods;

  float r_start;
  float r_amplitude;
  float r_periods;

  int duration;
}RotOut;


typedef struct
{
  float z_start1;
  float z_end1;

  float z_start2;
  float z_end2;

  float amplitude;

  float i_start1;
  float i_start2;


}BackIn;


typedef struct
{
  float z_start1;
  float z_end1;

  float z_start2;
  float z_end2;

  float i_start1;
  float i_start2;


  float amplitude;

  int duration;
}BackOut;


typedef struct
{
  float z_start1;
  float z_end1;

}ZoomIn;


typedef struct
{
  float z_start1;
  float z_end1;

  int duration;
}ZoomOut;



typedef struct
{
  float winkel1;
  float winkel2;
  float winkel3;
  float winkel4;
}ShadeIn;

typedef struct
{
  float posx;
  float posy;
  float posz;


  float winkelx;
  float winkely;
  float winkelz;

}WaterIn;

typedef struct
{
  float posx;
  float posy;
  float posz;


  float winkelx;
  float winkely;
  float winkelz;

}envieIn;

typedef struct
{
//  int   bmp;
  int startx;
  int starty;

  int endx;
  int endy;
}FlareIn;


void Init_Tabs (void);
void Exit_Tabs (void);



void * init_dummy (void *,cbitmap *s, cbitmap *d, int);
void  doit_dummy (void *, cbitmap *s1, cbitmap *s2, cbitmap *d, int, int );
void  exit_dummy (void *);


void * init_rotz (void *,cbitmap *s, cbitmap *d, int);
void  doit_rotz (void *, cbitmap *s1, cbitmap *s2, cbitmap *d, int, int );
void  exit_rotz (void *);


void * init_back (void *,cbitmap *s, cbitmap *d, int);
void  doit_back (void *, cbitmap *s1, cbitmap *s2, cbitmap *d, int, int );
void  exit_back (void *);


void * init_zoom (void *,cbitmap *s, cbitmap *d, int);
void  doit_zoom (void *, cbitmap *s1, cbitmap *s2, cbitmap *d, int, int );
void  exit_zoom (void *);

void * init_xfade (void *,cbitmap *s, cbitmap *d, int);
void  doit_xfade (void *, cbitmap *s1, cbitmap *s2, cbitmap *d, int, int );
void  exit_xfade (void *);

void * init_copym (void *,cbitmap *s, cbitmap *d, int);
void  doit_copym (void *, cbitmap *s1, cbitmap *s2, cbitmap *d, int, int );
void  exit_copym (void *);

void * init_pixelm (void *,cbitmap *s, cbitmap *d, int);
void  doit_pixelm (void *, cbitmap *s1, cbitmap *s2, cbitmap *d, int, int );
void  exit_pixelm (void *);

void * init_water (void *,cbitmap *s, cbitmap *d, int);
void  doit_water (void *, cbitmap *s1, cbitmap *s2, cbitmap *d, int, int );
void  exit_water (void *);


void * init_shadem (void *,cbitmap *s, cbitmap *d, int);
void  doit_shadem (void *, cbitmap *s1, cbitmap *s2, cbitmap *d, int, int );
void  exit_shadem (void *);


void * init_fadem (void *,cbitmap *s, cbitmap *d, int);
void  doit_fadem (void *, cbitmap *s1, cbitmap *s2, cbitmap *d, int, int );
void  exit_fadem (void *);

void * init_flare (void *,cbitmap *s, cbitmap *d, int);
void  doit_flare (void *, cbitmap *s1, cbitmap *s2, cbitmap *d, int, int );
void  exit_flare (void *);

void * init_rain (void *,cbitmap *s, cbitmap *d, int);
void  doit_rain (void *, cbitmap *s1, cbitmap *s2, cbitmap *d, int, int );
void  exit_rain (void *);


#endif
