include promise.inc
protseg segment use32   public
assume  cs:protseg,ds:protseg

align	4
potobj	label	byte
include	objekt.inc

;-----------------------------------------------;
extrn   gen_arc_cos:near                        ; Fong.
extrn   gen_fong_table:near
extrn   fong_line:near
extrn   xyz2ab:near

extrn   param_cut_triangle:near                 ; Prmcfill.

extrn   set_video_mode:near                     ; Common.
extrn   visible:near                            ; Common.
extrn   raster:near                             ; Common.
extrn   rot_make_matrix:near			; Common.
extrn   rot_turn9:near				; Common.
extrn   sin_gen:near				; Common.


;-----------------------------------------------;
; Runtime allokated addresses

_filltbl        dd      ?                       ; Da triangle sidez table addr
_fongmap        dd      ?			; Fong table addr
_virtscreen     dd      ?                       ; Guess ho??
_objekt         dd      ?
_track          dd      ?                       ; Objekt's trak
_sintab         dd      ?
_sortmem	dd	?			; Memory buf 4 sorting
_anim		dd	?
_envmap		dd	?


;-----------------------------------------------;
__animptr	dd	?
animframes	dd	256
actual_map	dd	?

;-----------------------------------------------;
face_num	dd	?



;-----------------------------------------------;
lamp    dd      0,10000h,10000h                 ; Fong engin lightsource vektor

alfa    dd      0
beta    dd      0
gama    dd      0



public  pot
pot:
		push	prolomemstart prohimemstart

		mov	eax,64*64*256
		call	gethimem
		mov	_anim,eax
		mov	__animptr,eax

                mov     eax,257*4*256*4           ; Reserve mem. for sorting
                call    gethimem
                mov     _sortmem,eax

		mov	eax,10000h
		call	getlomem
		mov	_envmap,eax

                call    prepare_track
                call    fong_init
                call    video_init

		call	calc_anim

		mov	ecx,10h
play:
		call	calc_bigpot
		dec	ch
		jne	play

		mov	ecx,10h
again:
		call	calc_bigpot
		sub	ch,32
		sete	al
		sub	cl,al
		jne	again

suks:
		pop	prohimemstart prolomemstart
		ret



;-----------------------------------------------;
; In:	cl: anim leve 0..16
frame_cnt	dd	0

calc_bigpot:
		pushad
		mov	eax,_envmap
		mov	actual_map,eax

		mov	eax,frame_cnt
		mov	ebx,8
		mov     edi,_envmap
		push	ecx
		call	disp_anim2
		pop	ecx

		mov	eax,frame_cnt
		mov	ebx,8
		dec	cl
		sets	ch
		add	cl,ch
		mov	edi,_virtscreen
		call	disp_anim3

		inc	frame_cnt
		and	frame_cnt,255

                mov     eax,alfa
                mov     ebx,beta
                mov     ecx,gama
                add     alfa,2
                sub     beta,4
                add     gama,2

                mov     esi,_sintab

                call    rot_make_matrix

                mov     esi,_objekt
                mov     edi,_track
                mov     ecx,face_num
                LEA     ECX,[ECX+ECX*2]
                SHL     ECX,1
                mov     eax,0
                mov     ebx,0
                mov     edx,1300*10000h
                call    rot_turn9

                call    lanterna

                mov     esi,_sortmem
                call    disp_objekt

                mov     edi,0a0000h
                sub     edi,absprotseg
                mov     esi,_virtscreen         ; Refresh video memory
		mov	ecx,16000
	rep	movsd
		popad
		ret



;-----------------------------------------------;
; In:	eax:	initial phase
;	ebx:	phase adder
;	cl:	number of x/y frames
;	edi:	dest

align	4
ph_adder2	dd	?
anim_needs	db	?

disp_anim2:
		push	eax ebx ebp
		shl	ebx,12
		mov	ph_adder2,ebx
		mov	esi,_anim
		shl	eax,12
		add	esi,eax
		mov	ebx,_fongmap
		mov	al,4
		mov	ch,16
da_inner2:
		dec	cl
		setns	anim_needs
		cmp	esi,_anim
		jae	da_esiok2
		add	esi,256*64*64
da_esiok2:
		push	ebx ecx edx esi edi
		mov	edx,64
da_12:
		push	eax
		mov	ecx,16
da2_copy:
		mov	eax,[ebx]		; Load fong map data
		add	ebx,4
		cmp	anim_needs,0
		je	da2_noanim
		add	eax,[esi]		; Load anim phase
da2_noanim:
		add	esi,4
		and	eax,0fefefefeh
		shr	eax,1
		or	eax,40404040h
		stosd

		dec	ecx
		jne	da2_copy

		pop	eax
		add	edi,256-64
		add	ebx,256-64
		dec	edx
		jne	da_12
		pop	edi esi edx ecx ebx

		sub	esi,ph_adder2
		add	edi,64
		add	ebx,64
		dec	al
		jne	da2_in
		mov	al,4
		add	edi,63*256
		add	ebx,63*256
da2_in:
		dec	ch
		jne	da_inner2
		pop	ebp ebx eax
		ret



;-----------------------------------------------;
; In:	eax:	initial phase
;	ebx:	phase adder
;	cl:	number of rows+remainder frames
;	edi:	dest

align	4
ph_adder3	dd	?
en3		db	?

disp_anim3:
;		test	cl,cl
;		je	da3_end
		pushad
		shl	ebx,12
		mov	esi,_anim
		shl	eax,12
		add	esi,eax
		mov	al,5
		mov	ch,16
da3l:
		cmp	esi,_anim
		jae	da3_ok
		add	esi,64*64*256
da3_ok:
		dec	cl
		jns	da3_sq
		call	c_square
		jmp	da3_heh
da3_sq:
		call	d_square
da3_heh:
		sub	esi,ebx
		add	edi,64
		dec	al
		jne	da_skip
		mov	al,5
		add	edi,63*320
da_skip:
		dec	ch
		jne	da3l
		popad
da3_end:
		ret



;-----------------------------------------------;
; In: esi,edi

d_square:
		push	eax ecx edx esi edi
		mov	edx,64
da_1:
		mov	ecx,16
	rep	movsd
		add	edi,320-64
		dec	edx
		jne	da_1
		pop	edi esi edx ecx eax
		ret



;-----------------------------------------------;
; In: edi

c_square:
		push	eax ecx edx esi edi
		mov	edx,64
da_c:
		mov	ecx,16
		xor	eax,eax
	rep	stosd
		add	edi,320-64
		dec	edx
		jne	da_c
		pop	edi esi edx ecx eax
		ret



;-----------------------------------------------;
calc_anim:
		mov	eax,_fongmap
		mov	actual_map,eax

                xor     eax,eax                 ; Klear virtual skreen
                mov     ecx,16000
                mov     edi,_virtscreen
        rep     stosd

                mov     eax,alfa
                mov     ebx,beta
                mov     ecx,gama
                sub     beta,2
                add     gama,4

                mov     esi,_sintab

                call    rot_make_matrix

                mov     esi,_objekt
                mov     edi,_track
                mov     ecx,face_num
                LEA     ECX,[ECX+ECX*2]
                SHL     ECX,1
                mov     eax,0
                mov     ebx,0
                mov     edx,2*1500*10000h
                call    rot_turn9

                call    lanterna

                mov     esi,_sortmem
                call    disp_objekt

		mov	eax,320
		mov	ebx,64
		mov	ecx,64
		mov	edx,64
		mov	esi,_virtscreen
		add	esi,320*(100-32)+160-32
		mov	edi,__animptr
		add	__animptr,64*64
		call	copy_skreen

		mov	eax,animframes
		neg	eax
		add	eax,256
		mov	ecx,eax
		shr	ecx,3
		cmp	ecx,15
		jb	afok
		mov	ecx,14
afok:
		inc	ecx
		mov	ebx,8
		mov	edi,0a0000h
		sub	edi,absprotseg
		call	disp_anim3

		dec	animframes
		jne	calc_anim
		ret



;-----------------------------------------------;
; In:	esi -> array #1 & position
;	edi -> array #2 & position
;	eax = array1 length
;	ebx = array2 length
;	ecx =  x copy
;	edx =  y copy
copy_skreen:
		sub	eax,ecx
		sub	ebx,ecx
		shr	ecx,2
ckloop:
		push	ecx
	rep	movsd
		pop	ecx
		add	esi,eax
		add	edi,ebx
		dec	edx
		jne	ckloop
		ret



;-----------------------------------------------;
lanterna:
                mov     ecx,face_num               ; Transform to 2d
                LEA     ECX,[ECX+ECX*2]
                mov     esi,_track
                call    r_transform

                mov     edi,_track              ; Adjust 2 fit da skreen &
                mov     ecx,face_num               ; average trianglez
scrshift:
                add     d [edi],160
                add     d [edi+4],100
                mov     eax,[edi+8]
                add     d [edi+24],160
                add     d [edi+24+4],100
                add     eax,[edi+24+8]
                add     d [edi+48],160
                add     d [edi+48+4],100
                add     eax,[edi+48+8]          ; eax = z average
                neg     eax

                push    eax ecx edi             ; Chek visibility
                mov     ebx,[edi+2]
                mov     bx,[edi]
                mov     ecx,[edi+24+2]
                mov     cx,[edi+24]
                mov     edx,[edi+48+2]
                mov     dx,[edi+48]
                call    visible
                pop     edi ecx ebp
                setge   dl

                lea     esi,[edi+12]            ; Transform normalz
                call    xyz2ab
                shl     eax,24
                mov     [esi-4],eax
                shl     ebx,24
                mov     [esi],ebx
                mov     [esi+4],ebp             ; Set z average
                mov     [esi+8],dl              ; Set visibility
                lea     esi,[edi+24+12]
                call    xyz2ab
                shl     eax,24
                mov     [esi-4],eax
                shl     ebx,24
                mov     [esi],ebx
                lea     esi,[edi+48+12]
                call    xyz2ab
                shl     eax,24
                mov     [esi-4],eax
                shl     ebx,24
                mov     [esi],ebx
                add     edi,72
                dec     ecx
                jne     scrshift

                mov     esi,_track
                mov     eax,_sortmem            ; Sort trianglez
                mov     ebp,face_num
                call    esort
		ret



;-----------------------------------------------;
; Display one frame.
; In: esi = frame descriptor (x',y',z)
;-----------------------------------------------;
disp_objekt:
                cld
                mov     ecx,face_num
dsl:
		push	esi
		mov	esi,[esi]
                cmp     b [esi+20],0
                je      disped

                push    ecx
                mov     eax,esi
                call    disp_one
                pop     ecx

disped:
		pop	esi
                add     esi,4
                dec     ecx
                jne     dsl

                ret



;-----------------------------------------------;
; Draw one triangle
; In: eax -> triangle deskriptor (3* x,y,c0,c1)

disp_one:
                lea     ebx,[eax+24]
                lea     ecx,[eax+48]
                mov     edi,_filltbl
                call    param_cut_triangle

                xchg    ebp,eax
                mov     esi,_filltbl
                mov     edi,_virtscreen
                call    fong_triang2
                ret



;-----------------------------------------------;
; Draw a fonged/textured triangle
; In:   esi -> table (w x0, w y0, d c00, d c01, w x1, w y1, d c10, d c11)
;       edi -> 320*200 array
;       ebp =  table length
;-----------------------------------------------;
align   16
public  fong_triang2
fong_triang2:
                test    ebp,ebp
                jne     fc_yeah
                ret

fc_yeah:
                mov     _cutarray,edi

fc_loop:
                push    esi ebp
                lea     ebx,[esi+4]
                movzx   eax,w [esi+2]
                lea     ecx,[esi+16]
                movzx   ebp,w [esi+12]
                movzx   edi,w [esi]

                sub     ebp,edi
                jnb     fc_nochange

                neg     ebp
                sub     edi,ebp
                xchg    ecx,ebx
fc_nochange:
                inc     ebp
                imul    eax,320
                lea     edi,[edi+eax+100h]
_cutarray       equ     d $-4

                shr     d [ebx],24
                shr     d [ebx+4],24
                shr     d [ecx],24
                shr     d [ecx+4],24

                mov     esi,actual_map
                call    fong_line

                pop     ebp esi
fc_skip:
                add     esi,24
                dec     ebp
                jne     fc_loop
                ret



;-----------------------------------------------;
; In: ecx,esi

r_transform:
                cld
                mov     ax,ds
                mov     es,ax
                mov     ebx,aspect_ratio
                mov     edi,esi
trnsfrm1:
                mov     edx,zoom_factor
                xor     eax,eax
                idiv    dword ptr [esi+8]
                mov     ebp,eax
                mov     eax,[esi]
                imul    ebp
                shrd    eax,edx,10h
                imul    ebx
                shl     eax,1
                adc     edx,0
                mov     eax,[esi+4]
                mov     [edi],edx
                add     esi,24
                imul    ebp
                shl     eax,1
                adc     edx,0
                mov     [edi+4],edx
                add     edi,24
                dec     ecx
                jnz     trnsfrm1
                ret

aspect_ratio = 72090            ; 1.1 * 10000h
zoom_factor  = 300



;-----------------------------------------------;
; Initialize da fong engin

fong_init:
                cld
                mov     eax,256                 ; Gen arkus kosinus table
                mov     ebx,256
                mov     ecx,64
                call    gen_arc_cos

                mov     eax,24*200              ; Gen kolor map
                call    getlomem
                mov     _filltbl,eax

                xchg    edi,eax
		mov	ecx,0ffh
		mov	ebx,0ffh*0ffh/3fh
fi_gcm:
		mov	eax,ecx
		mul	ecx
		div	ebx
		stosb
		dec	ecx
		jns	fi_gcm

                mov     eax,10000h+32              ; Gen fong map
                call    getlomem
                mov     _fongmap,eax
                lea     edx,[edi-256]
                xchg    edi,eax
                mov     esi,o lamp
                call    gen_fong_table

                mov     eax,2560
                call    getlomem
                mov     _sintab,eax
                xchg    edi,eax
                mov     eax,0ff0ch
                mov     ebx,512
                mov     ecx,4
                mov     ebp,512+128
                call    sin_gen
                ret



;-----------------------------------------------;
; Set video mode & palette

video_init:
                mov     eax,64000
                call    getlomem
                mov     _virtscreen,eax

                call    set_video_mode

                mov     al,0
                mov     edx,3c8h
                out     dx,al
                inc     edx
vi_yyy:
		push	eax
		out	dx,al
		shr	al,1
		out	dx,al
		mov	al,0
		out	dx,al
		pop	eax
                inc     eax
                cmp     al,64
                jne     vi_yyy

		mov	al,0
vi_xxx:
		out	dx,al
		out	dx,al
		push	eax
		mov	al,0
		out	dx,al
		pop	eax
                inc     eax
                cmp     al,64
                jne     vi_xxx

                ret



;-----------------------------------------------;
obj_length	dd	?

prepare_track:
		mov	obj_length,240*72
                mov     _objekt,o potobj
		mov	eax,obj_length
                call    getlomem
                mov     _track,eax

		mov	face_num,240
                ret


locals
include fsort.asm

protseg ends
end
