.386p
LOCALS
;------------------------------------------------------------------------------
amp_seg SEGMENT PUBLIC USE16
amp_seg ENDS
EXTRN amp_entry :FAR
;------------------------------------------------------------------------------
protseg SEGMENT PUBLIC USE32
ASSUME cs:protseg,ds:protseg


EXTRN Sin_Gen         :PROC
EXTRN Set_Video_Mode  :PROC
EXTRN Raster          :PROC
EXTRN Rot_Make_Matrix :PROC
EXTRN Rot_Turn9       :PROC
EXTRN Rot_Transform   :PROC
EXTRN Order           :PROC
EXTRN Visible         :PROC

;------------------------------------------------------------------------------
;############################################################################
;#                                                                          #
;#                     S P H E R E   E F F E C T                            #
;#                                                                          #
;############################################################################
;
; Memory requrements: 1400kB HiMem
;
; Szinek: 0:border, 1:a gomb hattere, 16-31-ig a kockak light-sourced-je
;         128-255 ua., mint a 0-127-ig csak ezt hasznalja a vizhez,
;         tehat kicsit sotetebb, es kotrasztosabb, esetleg kekesebb legyen.
;         PhotoStyler,PhotoShop,FractalDezignPainter etc. RULEZ!
;
;

PUBLIC Sphere
EXTRN SpPalette   :DATAPTR
EXTRN SpBackGround:DATAPTR
EXTRN SpLogo      :DATAPTR
;------------------------------------------------------------------------------
                                ; Length

BkgData         EQU 0                   ; 64k
Text_Map        EQU BkgData+65536       ; 64*128=8192
SinTab          EQU Text_Map+8192       ; (256+64)*4=1280
SinTab2         EQU SinTab+1280         ; (512+128)*4=2560
Text1           EQU SinTab2+2560        ; 3.15*100*100=64000
Edge            EQU Text1+64000         ; 100*2*2*2=800
Text_Tmp        EQU Edge+800            ; 259*256*2=132608
SinTmp          EQU Text_Tmp+132608     ; 200*2=800
Scr_Row         EQU SinTmp+800          ; 200*2=400
Wave1           EQU Scr_Row+400         ; 20*((320*40+1)*2)=512040
Wave_Strt       EQU Wave1+512040        ; 81*4=324
SpRotd          EQU Wave_Strt+324       ; 150*3*3*4=5400
SpNVects        EQU SpRotd+5400         ; 20*3*4=240
SpOrdd          EQU SpNVects+240        ; 150*2*4=1200
Temp_Area       EQU SpOrdd+1200         ; 64k
Order_Area      EQU Temp_Area+65536     ; 512k

Use_Himem               dd ?
Rel_Himem               dd ?
Rotate_SinTab   dd ?
;------------------------------------------------------------------------------
INCLUDE global.sym
INCLUDE promise.inc

Sphere          PROC NEAR

                sti
                cld
                mov     ax,zrdss
                mov     es,ax
                mov     eax,prohimemstart
                add     eax,absprotseg
                add     eax,03fffh
                and     eax,NOT 03fffh
                sub     eax,absprotseg
                mov     [Rel_Himem],eax
                add     eax,absprotseg
                mov     [Use_Himem],eax
                mov     edi,Scr_Row
                add     edi,eax
                xor     ax,ax
                mov     cl,200
@@Sp1:
                stosw
                add     ax,320
                dec     cl
                jnz     @@Sp1

                call    Set_Video_Mode

                mov     bl,0
                call    getirq
                mov     [Old_IRQ0],eax
                mov     bp,300
                call    Measure_Raster
                mov     [Raster_Time],ax
                mov     eax,O Raster_IRQ
                mov     bl,0
                call    setirq

                mov     ax,amp_seg
                shl     eax,16
                mov     ax,o amp_entry
                mov     realprocaddr,eax


                mov     ax,9ffh
                call    realproc

                mov     esi,O SpBackGround
                call    Make_Text

                call    Put_Bkg

                mov     edi,SinTab
                add     edi,[Use_Himem]
                mov     eax,0ff0ch
                mov     ebx,256
                mov     ecx,4
                mov     ebp,256+64
                call    Sin_Gen

                mov     edi,SinTab2
                add     edi,[Use_Himem]
                mov     eax,0ff0ch
                mov     ebx,512
                mov     ecx,4
                mov     ebp,512+128
                call    Sin_Gen
                mov     eax,SinTab2
                add     eax,[Rel_Himem]
                mov     [Rotate_Sintab],eax

                mov     esi,Text1
                add     esi,[Use_Himem]
                mov     eax,50
                call    Text_Deform

                mov     edi,SinTmp
                add     edi,[Use_Himem]
                mov     eax,0ff0ch
                mov     ebx,20
                mov     ecx,4
                mov     ebp,200
                call    Sin_Gen

                mov     esi,Wave1
                add     esi,[Use_Himem]
                mov     ecx,20
@@Sp2:
                push    ecx esi
                mov     ebx,3           ; ebx=amp
                neg     ecx
                add     ecx,20         ; ecx=phase (0-20)
                call    Make_Wave       ; es:esi=addr
                pop     esi ecx
                add     esi,25602
                loop    @@Sp2
@@Sp3:
;               mov     ax,amp_seg
;               shl     eax,16
;               mov     ax,o amp_entry
;               mov     realprocaddr,eax
;               mov     ah,7
;               call    realproc
                cmp     [RCall],O Fill_Water
                jne     @@Sp3

                mov     ax,9ffh
                call    realproc

                mov     [RCall],O Blank
                mov     eax,O Control_IRQ
                mov     bl,0
                call    setirq
                mov     al,34h
                out     43h,al
                jmp     $+2
                mov     ax,14915;1193180/80 ;17045 ;5966
                out     40h,al
                jmp     $+2
                mov     al,ah
                out     40h,al

                call    Crash                   ; Itt kezdodik a mozgas.
                mov     [Sphere_Pos],38afh
                mov     ax,80                   ; az ido 1/80-ad sec.-ben
                call    Dont_Move
                mov     [Turn_Sphere],63
                mov     ax,15
                call    Dont_Move
                mov     [Turn_Sphere],61
                mov     ax,15
                call    Dont_Move
                mov     [Turn_Sphere],59
                mov     ax,10
                call    Dont_Move
                mov     [Turn_Sphere],57
                mov     ax,10
                call    Dont_Move
                mov     [Turn_Sphere],55
                mov     ax,80
                call    Dont_Move
                mov     ax,38afh+90             ; ax-nel kisebb marad a gomb pozicioja
                call    Go_Right
                mov     ax,38afh ;-90
                call    Go_Left
                mov     [Turn_Sphere],62
                ;mov    ax,38afh
                ;call   Go_Right
                mov     ax,80
                call    Dont_Move
                mov     [Sphere_Pos],38afh
                call    Spin_Up
                mov     ax,2*80
                call    Dont_Move
                ;mov    ax,320*105
                ;call   Go_Down
                ;mov    ax,320*50
                ;call   Go_Up
                ;mov    [Turn_Sphere],62
                ;mov    ax,50
                ;call   Dont_Move
                mov     ax,320*125
                call    Go_Down
                mov     [Turn_Sphere],62
                mov     ax,5
                call    Dont_Move
                mov     ax,5*80
                call    Stay
                call    Wound
                mov     [Timer_Cnt],2*80
@@Sp4:
                call    WWave
                cmp     [Timer_Cnt],0
                jne     @@Sp4
;----------------------------------------------------------------------------
                mov     eax,[Old_IRQ0]
                mov     bl,0
                call    setirq
                mov     al,34h
                out     43h,al
                jmp     $+2
                mov     al,0
                out     40h,al
                jmp     $+2
                out     40h,al

                ret

Sphere          ENDP
;------------------------------------------------------------------------------
Crash           PROC NEAR
                mov     ebx,O @@DistBkg
@@1:
                mov     edi,38afh               ; 45*320*111
                call    Store_Bkg
                push    ebx
                movzx   ebx,B [ebx]
                cmp     bl,0feh
                jne     @@2
                mov     [OnCube],0ffh
                jmp     @@3
@@2:
                mov     esi,Text1
                add     esi,[Use_Himem]
                mov     edi,38afh               ; 45*320*111
                mov     eax,[Sphere_Text]
                call    Little_Sphere
                call    Raster
                mov     edi,38afh               ; 45*320*111
                call    Put_Window
@@3:
                call    Fill_Water
                pop     ebx
                inc     ebx
                cmp     B [ebx],0ffh
                jne     @@1
                ret

@@DistBkg LABEL Byte
x=0
;REPT 16
;   db x,x
;   x=x+1
;ENDM
;REPT 16
;   db x,x
;   x=x-1
;ENDM
;   db 70 Dup(0)
;REPT 25
;   db x,x
;   x=x+1
;ENDM
;REPT 25
;   db x,x
;   x=x-1
;ENDM
   db 40 Dup(0)
REPT 25
   db x,x
   x=x+1
ENDM
   db x,x,x
   x=x+1
   db x,x,x
   x=x+1
   db x,x,x,x
   x=x+1
   db x,x,x,x,x
   x=x+1
   db x,x,x,x,x,x
   x=x+1
   db 20 Dup(x)
   db 0feh
   x=x+7
REPT 20-7
   db x
   x=x+1
ENDM
   db 0ffh
Crash           ENDP
;------------------------------------------------------------------------------
Go_Right                PROC NEAR
                mov     [Move_Sphere],1
@@1:
                push    ax
                movzx   edi,[Sphere_Pos]
                push    edi
                call    Store_Bkg
                mov     esi,Text1
                add     esi,[Use_Himem]
                mov     edi,[esp]
                mov     eax,[Sphere_Text]
                xor     ebx,ebx
                call    Put_Sphere
                call    Raster
                pop     edi
                call    Put_Window
                call    Fill_Water
                inc     [Turn_Sphere]
                cmp     [Turn_Sphere],63
                jb      @@2
                dec     [Turn_Sphere]
@@2:
                pop     ax
                cmp     [Sphere_Pos],ax
                jb      @@1
                mov     [Move_Sphere],0
                ret
Go_Right                ENDP
;------------------------------------------------------------------------------
Go_Left         PROC NEAR
                mov     [Turn_Sphere],2
                mov     [Move_Sphere],-1
@@1:
                push    ax
                movzx   edi,[Sphere_Pos]
                push    edi
                call    Store_Bkg
                mov     esi,Text1
                add     esi,[Use_Himem]
                mov     edi,[esp]
                mov     eax,[Sphere_Text]
                xor     ebx,ebx
                call    Put_Sphere
                call    Raster
                pop     edi
                call    Put_Window
                call    Fill_Water
                pop     ax
                cmp     [Sphere_Pos],ax
                ja      @@1
                mov     [Move_Sphere],0
                ret
Go_Left         ENDP
;------------------------------------------------------------------------------
Dont_Move               PROC NEAR
                mov     [Timer_Cnt],ax
@@1:
                movzx   edi,[Sphere_Pos]
                push    edi
                call    Store_Bkg
                mov     esi,Text1
                add     esi,[Use_Himem]
                mov     edi,[esp]
                mov     eax,[Sphere_Text]
                xor     ebx,ebx
                call    Put_Sphere
                call    Raster
                pop     edi
                call    Put_Window
                call    Fill_Water
                cmp     [Timer_Cnt],0
                jne     @@1
                ret
Dont_Move               ENDP
;------------------------------------------------------------------------------
Spin_Up         PROC NEAR

                mov     [Turn_Sphere],62
@@1:
                mov     [Timer_Cnt],5
@@2:
                call    Put_It
                cmp     [Timer_Cnt],0
                jne     @@2
                dec     [Turn_Sphere]
                cmp     [Turn_Sphere],63-16
                jne     @@1

;               mov     [Timer_Cnt],80
;@@3:
;               call    Put_It
;               cmp     [Timer_Cnt],0
;               jne     @@3
                mov     [SpAddAlfa],2
                mov     [SpAddBeta],-2
@@4:
                mov     [Timer_Cnt],8
@@5:
                call    Put_It
                cmp     [Timer_Cnt],0
                jne     @@5
                inc     [Turn_Sphere]
                cmp     [Turn_Sphere],62
                jne     @@4

                mov     [Timer_Cnt],40
@@6:
                call    Put_It
                cmp     [Timer_Cnt],0
                jne     @@6
                mov     [Turn_Sphere],62
                ret
Spin_Up         ENDP
;------------------------------------------------------------------------------
Go_Down         PROC NEAR
                mov     [Turn_Sphere],01111100111110b
                mov     [Move_Sphere],320
@@1:
                call    Put_It2
                cmp     [Sphere_Pos],ax
                jb      @@1
                mov     [Move_Sphere],0
                ret
Go_Down         ENDP
;------------------------------------------------------------------------------
Go_Up           PROC NEAR
                mov     [Turn_Sphere],00000100111110b
Go_Up2:
                mov     [Move_Sphere],-320
@@1:
                call    Put_It2
                cmp     [Sphere_Pos],ax
                ja      @@1
                mov     [Move_Sphere],0
                ret
Go_Up           ENDP
;------------------------------------------------------------------------------
Stay            PROC NEAR

                push    ax
                mov     cl,80
@@1:
                mov     eax,7
                push    cx
                call    Shift_Sinus
                pop     cx
                dec     cl
                jnz     @@1
                mov     edx,Wave_Strt
                add     edx,[Use_Himem]
                mov     eax,es:[edx]
                add     eax,8
                shl     eax,1
                add     eax,Scr_Row
                add     eax,[Use_Himem]
                mov     ax,W es:[eax]
                add     ax,320*97
                call    Go_Up2
                pop     ax
                mov     [Timer_Cnt],ax
@@2:
                mov     eax,7
                call    Shift_Sinus
                mov     edx,Wave_Strt
                add     edx,[Use_Himem]
                mov     eax,es:[edx]
                add     eax,8
                shl     eax,1
                add     eax,Scr_Row
                add     eax,[Use_Himem]
                mov     ax,W es:[eax]
                add     ax,320*97+111
                mov     [Sphere_Pos],ax
                call    Put_It2
                cmp     [Timer_Cnt],0
                jne     @@2
                ret
Stay            ENDP
;------------------------------------------------------------------------------
Wound           PROC NEAR
                mov     ebx,50
@@1:
                push    ebx
                mov     eax,7
                call    Shift_Sinus
                mov     edx,Wave_Strt
                add     edx,[Use_Himem]
                mov     eax,es:[edx]
                add     eax,8
                shl     eax,1
                add     eax,Scr_Row
                add     eax,[Use_Himem]
                mov     ax,W es:[eax]
                add     ax,320*97+111
                mov     [Sphere_Pos],ax
                movzx   edi,ax
                call    Store_Bkg
                mov     esi,Text1
                add     esi,[Use_Himem]
                movzx   edi,[Sphere_Pos]
                mov     eax,[Sphere_Text]
                mov     ebx,[esp]
                call    Little_Sphere
                ;call   Put_Sphere
                call    Raster
                movzx   edi,[Sphere_Pos]
                call    Put_Window
                call    WWave
                pop     ebx
                dec     ebx
                jns     @@1
                ret
Wound           ENDP
;------------------------------------------------------------------------------
WWave           PROC NEAR

                mov     ebx,[@@WPos]
                add     ebx,4
                cmp     ebx,O WT+4*20
                jb      @@1
                mov     ebx,O WT
@@1:
                mov     [@@WPos],ebx
                mov     ebx,[ebx]
                add     ebx,[Use_Himem]
                call    Put_Wave
                ret
x=Wave1
WT LABEL DWord
REPT 20
        dd x
        x=x+25602
ENDM

@@WPos  dd O WT
WWave           ENDP
;------------------------------------------------------------------------------
Put_It          PROC NEAR

                mov     edi,38afh
                call    Store_Bkg
                mov     esi,Text1
                add     esi,[Use_Himem]
                mov     edi,38afh
                mov     eax,[Sphere_Text]
                xor     ebx,ebx
                call    Put_Sphere
                call    Raster
                mov     edi,38afh
                call    Put_Window
                call    Fill_Water
                ret
Put_It          ENDP
;------------------------------------------------------------------------------
Put_It2         PROC NEAR

                push    ax
                movzx   edi,[Sphere_Pos]
                push    edi
                call    Store_Bkg
                mov     esi,Text1
                add     esi,[Use_Himem]
                mov     edi,[esp]
                mov     eax,edi
                cdq
                mov     ebx,320
                div     ebx
                mov     ebx,70+100
                sub     ebx,eax
                mov     eax,O Fill_Water
                cmp     ebx,100
                jae     @@1
                mov     eax,O WWave
@@1:
                mov     [@@Do_Water],eax
                mov     eax,[Sphere_Text]
                call    Put_Sphere
                call    Raster
                pop     edi
                call    Put_Window
                call    [@@Do_Water]
                pop     ax
                ret
@@Do_Water dd ?
Put_It2         ENDP
;------------------------------------------------------------------------------
Put_Bkg         PROC NEAR

                mov     edi,BkgData
                add     edi,[Use_Himem]
                mov     B [@@PB3-1],32
                mov     W [@@PB5-4],319*32

                mov     ch,7
@@PB1:
                mov     cl,10
@@PB2:
                mov     esi,O SpBackGround
                mov     bh,32
@@PB3:
                mov     bl,8
@@PB4:
                movsd
                dec     bl
                jnz     @@PB4
                add     edi,320-32
                dec     bh
                jnz     @@PB3
                sub     edi,319*32
@@PB5:
                dec     cl
                jnz     @@PB2
                cmp     ch,2
                jne     @@PB6
                mov     B [@@PB3-1],8
                mov     W [@@PB5-4],320*8-32
@@PB6:
                add     edi,320*31
                dec     ch
                jnz     @@PB1

                mov     esi,BkgData
                add     esi,[Use_Himem]
                mov     edi,0a0000h
                mov     ecx,64000/4
@@PB7:
                mov     eax,es:[esi]
                stosd
                add     esi,4
                loop    @@PB7

                ret
Put_Bkg         ENDP
;------------------------------------------------------------------------------
Put_Sphere      PROC NEAR

                push    eax bx edi esi
                call    Make_Cube
                pop     esi edi bx eax
                mov     [@@Loose],3
                mov     [@@Height],bx
                mov     ebp,edi
@@PS1:
                movzx   edx,W es:[esi]
                cmp     dx,0ffffh
                jne     @@PS2
                ret
@@PS2:
                movzx   ecx,W es:[esi+2]
                add     esi,4
                dec     [@@Loose]
                jnz     @@PS3
                shl     ecx,1
                add     esi,ecx
                mov     [@@Loose],12
                jmp     @@PS5
@@PS3:
                mov     edi,ebp
                add     edi,edx
                add     edi,Temp_Area
                add     edi,[Use_Himem]
@@PS4:
                movzx   ebx,W es:[esi]
                add     ebx,eax
                and     ebx,111111111111111101111110111111b
                inc     esi
                inc     esi
                mov     bl,es:[ebx]
                mov     es:[edi],bl
                inc     edi
                dec     ecx
                jnz     @@PS4
                add     ebp,320
@@PS5:
                dec     [@@Height]
                jnz     @@PS1
                ret
@@Height        dw 0
@@Loose db 0
Put_Sphere      ENDP
;------------------------------------------------------------------------------
Little_Sphere   PROC NEAR

@@Cos_Add = 64*4
                push    eax edi esi

                push    ebx
                call    Make_Cube
                pop     ebx

                mov     edi,Edge
                add     edi,[Use_Himem]
                mov     eax,0ffffffffh
                mov     ecx,100
        rep     stosd
                mov     esi,SinTab
                add     esi,[Use_Himem]
                mov     edi,Edge
                add     edi,[Use_Himem]
                                        ; ecx=0 !!!
@@LS1:
                mov     eax,es:[esi+@@Cos_Add][ecx*4]
                neg     eax
                imul    ebx
                sar     eax,10h
                adc     eax,50
                mov     ebp,eax
                mov     eax,es:[esi][ecx*4]
                neg     eax
                imul    ebx
                sar     eax,10h
                adc     eax,50
                mov     es:[edi][ebp*4],ax
                mov     es:[edi+4][ebp*4],ax
                inc     cl
                cmp     cl,80h
                jbe     @@LS1
                inc     edi
                inc     edi
                mov     cl,0ffh
@@LS2:
                mov     eax,es:[esi+@@Cos_Add][ecx*4]
                neg     eax
                imul    ebx
                sar     eax,10h
                adc     eax,50
                mov     ebp,eax
                mov     eax,es:[esi][ecx*4]
                neg     eax
                imul    ebx
                sar     eax,10h
                adc     eax,50
                sub     ax,es:[edi-2][ebp*4]
                mov     es:[edi][ebp*4],ax
                mov     es:[edi+4][ebp*4],ax
                dec     cl
                cmp     cl,80h
                jae     @@LS2

                pop     esi edi ebx

                mov     [@@Loose],3
                mov     ebp,edi
                add     ebp,Temp_Area
                add     ebp,[Use_Himem]
                mov     ecx,Edge
                add     ecx,[Use_Himem]
                mov     [@@Cnt],100
@@LS3:
                movzx   edx,W es:[esi]
                cmp     dx,0ffffh
                je      @@LS_Exit
                add     esi,4
                movzx   eax,W es:[ecx]
                inc     ecx
                inc     ecx
                dec     [@@Loose]
                jnz     @@LS3a
                mov     [@@Loose],12
                jmp     @@LS6
@@LS3a:
                cmp     ax,0ffffh
                je      @@LS5
                cmp     W es:[ecx],0
                jle     @@LS5
                mov     edi,ebp
                add     edi,eax
                sub     eax,edx
@@LS4:
                movzx   edx,W es:[esi+eax*2]
                add     edx,ebx
                and     edx,111111111111111101111110111111b
                mov     dl,es:[edx]
                mov     es:[edi],dl
                inc     edi
                inc     eax
                dec     W es:[ecx]
                jnz     @@LS4
@@LS5:
                add     ebp,320
@@LS6:
                movzx   edx,W es:[esi-2]
                shl     edx,1
                add     esi,edx
                inc     ecx
                inc     ecx
                dec     [@@Cnt]
                jnz     @@LS3
@@LS_Exit:
                ret
@@Cnt   dw ?
@@Loose db 0
Little_Sphere   ENDP
;------------------------------------------------------------------------------
Put_Wave                PROC NEAR

                mov     edx,0a0000h
                push    ds
                mov     ax,es
                mov     ds,ax
                mov     edi,320*160+0a0000h
                movzx   esi,W es:[ebx]
                mov     cl,80h
@@PW1:
                add     esi,edx
                inc     ebx
                inc     ebx
                mov     al,es:[esi]
                add     al,cl
                stosb
                movzx   esi,W es:[ebx]
                cmp     si,0ffffh
                jne     @@PW1

                pop     ds
                ret
Put_Wave                ENDP
;------------------------------------------------------------------------------
Text_Deform     PROC NEAR

XSize   = 64
@@XLog  = 6
YSize   = 64
@@YLog  = 6
VLine   = 128
@@VLLog = 7

@@Cos_Add = 64*4
@@FP_Num1 = 10000h

                push    esi
                mov     [@@Radius],eax
                mov     edi,SinTab2+128*4
                add     edi,[Use_Himem]
                xor     ebx,ebx
@@TD1:
                mov     eax,ebx
                mov     edx,es:[edi][eax*4]
                mov     eax,@@FP_Num1
                sub     eax,edx
                shr     eax,1
                mov     al,0
                mov     ecx,eax
                xor     ebp,ebp
@@TD2:
                mov     eax,ebp
                mov     edx,es:[edi][eax*4]
                mov     eax,@@FP_Num1
                sub     eax,edx
                shr     eax,8+1
                mov     si,ax
                add     eax,ecx ; eax=row+kx
                shl     eax,1   ; word array
                add     eax,Text_Tmp
                add     eax,[Use_Himem]
                mov     edx,ebx
                and     edx,3fh
                shl     edx,7
                push    ebp
                and     ebp,3fh
                add     edx,ebp
                pop     ebp
                xor     edx,01000000100000b
                cmp     si,255
                ja      @@TD2a
                mov     es:[eax],dx
                mov     es:[eax+256*2],dx
                mov     es:[eax+256*4],dx
                mov     es:[eax+256*6],dx
                cmp     si,255 ;XSize-1
                je      @@TD2a
                mov     es:[eax+2],dx
                mov     es:[eax+256*2+2],dx
                mov     es:[eax+256*4+2],dx
                mov     es:[eax+256*6+2],dx
                cmp     si,254 ;XSize-2
                je      @@TD2a
                mov     es:[eax+4],dx
                mov     es:[eax+256*2+4],dx
                mov     es:[eax+256*4+4],dx
                mov     es:[eax+256*6+4],dx
                cmp     si,253 ;XSize-3
                je      @@TD2a
                mov     es:[eax+6],dx
                mov     es:[eax+256*2+6],dx
                mov     es:[eax+256*4+6],dx
                mov     es:[eax+256*6+6],dx
                cmp     si,252 ;XSize-3
                je      @@TD2a
                mov     es:[eax+8],dx
                mov     es:[eax+256*2+8],dx
                mov     es:[eax+256*4+8],dx
                mov     es:[eax+256*6+8],dx
                cmp     si,251 ;XSize-3
                je      @@TD2a
                mov     es:[eax+10],dx
                mov     es:[eax+256*2+10],dx
                mov     es:[eax+256*4+10],dx
                mov     es:[eax+256*6+10],dx
@@TD2a:
                inc     ebp
                cmp     bp,256 ;XSize
                jb      @@TD2
                inc     ebx
                cmp     bx,256 ;YSize
                jb      @@TD1

                mov     esi,Edge
                add     esi,[Use_Himem]
                mov     edi,esi
                mov     eax,0ffffffffh
                mov     ecx,[@@Radius]
                shl     ecx,1
        rep     stosd
                mov     esi,Edge
                add     esi,[Use_Himem]
                mov     edi,SinTab
                add     edi,[Use_Himem]
                                        ; ecx=0 !!!
@@TD3:
                mov     eax,es:[edi+@@Cos_Add][ecx*4]
                neg     eax
                imul    [@@Radius]
                sar     eax,10h
                adc     eax,[@@Radius]
                mov     ebx,eax
                mov     eax,es:[edi][ecx*4]
                neg     eax
                imul    [@@Radius]
                sar     eax,10h
                adc     eax,[@@Radius]
                mov     es:[esi][ebx*4],ax
                inc     cl
                cmp     cl,80h
                jbe     @@TD3
                mov     cl,0ffh
@@TD4:
                mov     eax,es:[edi+@@Cos_Add][ecx*4]
                neg     eax
                imul    [@@Radius]
                sar     eax,10h
                adc     eax,[@@Radius]
                mov     ebx,eax
                mov     eax,es:[edi][ecx*4]
                neg     eax
                imul    [@@Radius]
                sar     eax,10h
                adc     eax,[@@Radius]
                sub     ax,es:[esi][ebx*4]
                ja      @@xx
                mov     ax,1
@@xx:
                mov     es:[esi+2][ebx*4],ax
                dec     cl
                cmp     cl,80h
                jae     @@TD4

                shl     [@@Radius],1
                mov     esi,Edge
                add     esi,[Use_Himem]
                mov     ecx,[@@Radius]
@@TD5:
                cmp     W es:[esi],0ffffh
                jne     @@TD6
                mov     ax,es:[esi-4]
                mov     es:[esi],ax
@@TD6:
                cmp     W es:[esi+2],0ffffh
                jne     @@TD7
                mov     ax,es:[esi-2]
                mov     es:[esi+2],ax
@@TD7:
                add     esi,4
                loop    @@TD5

                pop     esi
                xor     ebx,ebx
@@TD8:
                mov     edx,Edge
                add     edx,[Use_Himem]
                mov     ebp,es:[edx][ebx*4]
                mov     es:[esi],ebp
                movzx   edi,bp
                shl     edi,2
                add     edi,Edge
                add     edi,[Use_Himem]
                shr     ebp,10h
                mov     [@@Lx],ebp
                add     esi,4
                xor     ecx,ecx
@@TD9:
                push    ebx
                mov     eax,ebx
                movzx   ebx,W es:[edi]
                sub     eax,ebx
                shl     eax,8
                cdq
                movzx   ebx,W es:[edi+2]
                div     ebx
                mov     ebx,eax
                add     edi,4
                shl     ebx,8

                mov     eax,ecx
                shl     eax,8
                cdq
                div     [@@Lx]
                add     eax,ebx

                shl     eax,1
                add     eax,Text_Tmp
                add     eax,[Use_Himem]
                mov     ax,es:[eax]
                mov     es:[esi],ax
                inc     esi
                inc     esi

                inc     ecx
                pop     ebx
                dec     ebp
                jnz     @@TD9
                inc     ebx
                cmp     ebx,[@@Radius]
                jb      @@TD8
                mov     W es:[esi],0ffffh

                ret
@@Radius        dd 0
@@Lx    dd 0
@@Tmp   dd XSize
Text_Deform     ENDP
;------------------------------------------------------------------------------
Make_Text               PROC NEAR

                mov     edi,Text_Map
                add     edi,[Use_Himem]
                mov     ebx,16+8*32
                mov     ch,32
@@MT1:
                mov     cl,32
@@MT2:
                mov     al,[esi+ebx]
                inc     ebx
                and     ebx,1111111111b
                mov     ah,al
                mov     es:[edi+128],ax
                stosw
                dec     cl
                jnz     @@MT2
                add     edi,256-64
                dec     ch
                jnz     @@MT1
                ret
Make_Text               ENDP
;------------------------------------------------------------------------------
Make_Wave       PROC NEAR
; ecx=phase (0-20)
; esi=addr
; ebx=amp
                mov     edi,esi
                add     edi,319*2
                mov     [@@Phase],ecx
                shl     ebx,10h
                mov     [@@Amp],ebx
                mov     [@@b],-2
@@MV1:
                mov     [@@a],-160
@@MV2:
                movsx   eax,W [@@a]
                imul    eax
                mov     ecx,eax
                movsx   eax,B [@@b]
                imul    eax
                add     eax,ecx
                shl     eax,10h
                cmp     eax,10000h
                jae     @@MV3
                mov     ax,es:[edi+2]
                mov     bx,ax
                jmp     @@MV6
@@MV3:
                call    Sqrt
                mov     ecx,eax         ; ecx=c
                shr     eax,10h
                adc     eax,[@@Phase]
                mov     edx,SinTmp
                add     edx,[Use_Himem]
                mov     edx,es:[edx][eax*4]
                mov     eax,[@@Amp]
                imul    edx             ; edx=d
                idiv    ecx             ; eax=d/c (FP)
                mov     ecx,eax
                movsx   eax,W [@@a]
                imul    ecx
                movsx   edx,W [@@a]
                sar     eax,10h
                adc     edx,eax
                add     edx,@@XCenter
                mov     ebp,edx         ; ebp=a+x
                movsx   eax,B [@@b]
                imul    ecx
                movsx   edx,B [@@b]
                sar     eax,10h
                adc     eax,edx         ; edx=b+y
                shl     eax,1
                mov     edx,@@YCenter
                sub     edx,eax
                mov     eax,Scr_Row
                add     eax,[Use_Himem]
                mov     ax,W es:[eax][edx*2]
@@MV4:
                cmp     ax,320*160
                jb      @@MV5
                movsx   eax,B [@@b]
                add     eax,163
                mov     ebp,Scr_Row
                add     ebp,[Use_Himem]
                movzx   eax,W es:[ebp][eax*2]
                movsx   ebp,W [@@a]
                add     ebp,160
@@MV5:
                mov     bx,ax
                add     bx,320
                add     ax,bp
                sub     bx,bp
@@MV6:
                mov     es:[esi],ax
                mov     es:[edi],bx
                add     esi,2
                sub     edi,2
                inc     [@@a]
                cmp     [@@a],0
                jl      @@MV2
                add     esi,160*2
                add     edi,(160+320)*2
                inc     [@@b]
                cmp     [@@b],38
                jl      @@MV1
                mov     W es:[esi],0ffffh

                ret

@@XCenter = 160
@@YCenter = 156

@@a     dw 0
@@b     db 0
@@Phase dd 0
@@Amp   dd 0
                ret
Make_Wave       ENDP

Sqrt    PROC    NEAR
; eax -> sqrt(eax)
; ebp,ecx,edx,eax,ebx
                mov     ebp,eax
                shr     ebp,5
                mov     ebx,eax
                mov     cl,7
@@Sqrt1:
                mov     eax,ebx
                mov     edx,eax
                shr     edx,10h
                shl     eax,10h
                div     ebp
                add     ebp,eax
                shr     ebp,1
                dec     cl
                jnz     @@Sqrt1
                mov     eax,ebp
@@Sqrt2:
                ret
Sqrt    ENDP
;------------------------------------------------------------------------------
Make_Cube               PROC NEAR
                cmp     [OnCube],0
                je      @@XIT
                mov     edi,Text_Map
                add     edi,[Use_Himem]
                mov     eax,1010101h
                mov     dl,64
@@0:
                mov     ecx,64/4
        rep     stosd
                add     edi,128-64
                dec     dl
                jnz     @@0
                xor     eax,eax
                xor     ebx,ebx
                xor     edx,edx
                mov     esi,O SpCube
                call    Put_Obj2
@@XIT:
                ret
OnCube  db 0
SPalfa  dd 40h
SPbeta  dd 0
SPgamma dd 40h
a=50*10000h
SpCube  dd 8
        dd -a,-a,-a, a,-a,-a, a,a,-a, -a,a,-a
        dd -a,-a,a,  a,-a,a,  a,a,a,  -a,a,a
        dd 6
        dd 0,0,-10000h
        dd 0,0,10000h
        dd 10000h,0,0
        dd -10000h,0,0
        dd 0,10000h,0
        dd 0,-10000h,0
        dd 12
        dd 0,0,1,2
        dd 0,2,3,0
        dd 1,5,4,6
        dd 1,7,6,4
        dd 2,1,5,6
        dd 2,6,2,1
        dd 3,0,3,7
        dd 3,7,4,0
        dd 4,3,2,6
        dd 4,6,7,3
        dd 5,5,1,0
        dd 5,0,4,5
Make_Cube               ENDP
;------------------------------------------------------------------------------
Put_Obj2                PROC NEAR
; eax,ebx,ecx=a,b,g
; ds:esi=obj ds=prdss
@@TriNo=4
                push    eax ebx edx esi

                mov     eax,[Spalfa]
                mov     ebx,[Spbeta]
                mov     ecx,[Spgamma]
                mov     esi,[Rotate_Sintab]
                call    Rot_Make_Matrix
                pop     esi edx ebx eax

                add     edx,1000*10000h
                mov     edi,SpRotd
                add     edi,[Rel_Himem]
                mov     ecx,[esi]
                mov     [@@Tmp1],ecx
                add     esi,4
                push    esi
                call    Rot_Turn9
                pop     esi
                mov     eax,[esi-4]
                lea     eax,[eax+eax*2]
                shl     eax,2
                add     esi,eax         ; eax=NumOfPoints*12+4

                xor     eax,eax
                xor     ebx,ebx
                xor     edx,edx
                mov     edi,SpNVects
                add     edi,[Rel_Himem]
                mov     ecx,[esi]
                add     esi,4
                push    esi
                call    Rot_Turn9
                pop     esi
                mov     eax,[esi-4]
                lea     eax,[eax+eax*2]
                shl     eax,2
                add     esi,eax         ; eax=NumOfPoints*12+4

                mov     ecx,[esi]
                add     esi,4
                mov     ebx,SpRotd
                add     ebx,[Rel_Himem]
                mov     edi,SpOrdd
                add     edi,[Rel_Himem]
                push    esi
                mov     eax,Order_Area
                add     eax,[Rel_Himem]
                call    Order

                mov     esi,SpRotd
                add     esi,[Rel_Himem]
                mov     ecx,[@@Tmp1]
                call    Rot_Transform
                pop     esi

                mov     edi,SpOrdd+4
                add     edi,[Rel_Himem]
                mov     ecx,[esi-4]
@@Loop:
                push    ecx edi esi

                mov     eax,[edi]
                shl     eax,4
                add     esi,eax
                mov     eax,[esi+4]
                lea     eax,[eax+eax*2]
                shl     eax,2
                mov     edi,SpRotd
                add     edi,[Rel_Himem]
                mov     bx,W [eax+edi+4]
                add     bx,32
                shl     ebx,10h
                mov     bx,W [eax+edi]
                add     bx,32
                mov     eax,[esi+8]
                lea     eax,[eax+eax*2]
                shl     eax,2
                mov     cx,W [eax+edi+4]
                add     cx,32
                shl     ecx,10h
                mov     cx,W [eax+edi]
                add     cx,32
                mov     eax,[esi+12]
                lea     eax,[eax+eax*2]
                shl     eax,2
                mov     dx,W [eax+edi+4]
                add     dx,32
                shl     edx,10h
                mov     dx,W [eax+edi]
                add     dx,32
                call    Visible
                jge     @@NoV
                movzx   eax,B [esi]
                lea     eax,[eax+eax*2]
                shl     eax,2
                add     eax,SpNVects
                add     eax,[Rel_Himem]
                mov     esi,eax
                call    LightSource2
                mov     edi,Text_Map
                add     edi,[Use_Himem]
                call    Put_Triangle2
@@NoV:
                pop     esi edi ecx
                add     edi,8
                dec     ecx
                jnz     @@Loop
                ret
@@Tmp1  dd ?

Put_Obj2                ENDP
;------------------------------------------------------------------------------
LightSource2    PROC NEAR
@@LSX EQU -37837
@@LSY EQU 37837
@@LSZ EQU -37837
                push    ecx edx
                mov     eax,[esi]
                mov     ecx,@@LSX
                imul    ecx
                mov     ebp,eax
                mov     edi,edx
                mov     eax,[esi+4]
                mov     ecx,@@LSY
                imul    ecx
                add     ebp,eax
                adc     edi,edx
                mov     eax,[esi+8]
                mov     ecx,@@LSZ
                imul    ecx
                add     ebp,eax
                adc     edi,edx
                shld    edi,ebp,5
                mov     eax,edi
                add     eax,20h+O @@ArcCos
                mov     al,[eax]
                shr     al,2
                add     al,10h
                pop     edx ecx
                ret
x=0                             ; Starting color's number.
@@ArcCos        db 63+x,62+x,62+x,61+x,60+x,60+x
        db 59+x,58+x,58+x,57+x,57+x,56+x
        db 55+x,55+x,54+x,54+x,53+x,52+x
        db 52+x,51+x,50+x,50+x,49+x,48+x
        db 48+x,47+x,46+x,45+x,45+x,44+x
        db 43+x,43+x,42+x,41+x,41+x,40+x
        db 39+x,38+x,38+x,37+x,36+x,35+x
        db 34+x,33+x,33+x,32+x,31+x,30+x
        db 29+x,28+x,27+x,26+x,25+x,24+x
        db 23+x,22+x,20+x,19+x,18+x,16+x
        db 14+x,12+x,10+x,7+x,0+x
LightSource2    ENDP
;------------------------------------------------------------------------------
Put_Triangle2   PROC NEAR
HLine   MACRO
local   zz,zzz,zzzz,H1,H2,H3,H4
                push    ebx ecx edi esi

                cmp     edi,62*10000h
                jle     H1
                cmp     esi,62*10000h
                jg      zzzz
                mov     edi,62*10000h
                jmp     H2
H1:
                test    edi,edi
                jns     H2
                test    esi,esi
                js      zzzz
                xor     edi,edi
H2:
                cmp     esi,62*10000h
                jle     H3
                cmp     edi,62*10000h
                jg      zzzz
                mov     esi,62*10000h
                jmp     H4
H3:
                test    esi,esi
                jns     H4
                test    edi,edi
                js      zzzz
                xor     esi,esi
H4:
                shl     ebx,7
                add     ebx,[@@Addr]
                sar     esi,10h
                adc     esi,ebx
                sar     edi,10h
                adc     edi,ebx

                mov     ecx,esi
                sub     ecx,edi
                jnb     zzz

                neg     ecx
                mov     edi,esi
zzz:
                inc     ecx

                mov     ebx,ecx
                mov     ecx,3
                and     ecx,edi
                sub     ebx,ecx
                jns     zz
                add     ecx,ebx
        rep     stosb
                jmp     zzzz
zz:
        rep     stosb

                mov     ecx,ebx
                shr     ecx,2
        rep     stosd

                and     ebx,3
                mov     ecx,ebx
        rep     stosb
zzzz:
                pop     esi edi ecx ebx
ENDM
;------------------------------------------------------------------------------
                rol     ebx,10h
                rol     ecx,10h
                rol     edx,10h
                mov     [@@Addr],edi

                cmp     bx,cx
                jle     @@T1
                xchg    ebx,ecx
@@T1:
                cmp     bx,dx
                jle     @@T2
                xchg    ebx,edx
@@T2:
                cmp     cx,dx
                jle     @@T3
                xchg    ecx,edx
@@T3:
                cmp     bx,200
                jge     @@XIT
                test    dx,dx
                js      @@XIT
                mov     esi,edx

                mov     ah,al
                push    ax ax

                xor     edi,edi
                mov     [@@CloserAdd],edi
                mov     [@@CloserLen],edi
                sub     dx,bx
                jz      @@T4
                mov     eax,edx
                xor     ax,ax
                mov     ebp,ebx
                xor     bp,bp
                sub     eax,ebp
                movsx   ebp,dx
                cdq
                idiv    ebp
                shl     edx,1
                adc     eax,0
                mov     edi,eax
@@T4:
                sub     si,cx
                jz      @@T5
                mov     Word Ptr [@@CloserLen],si
                mov     eax,esi
                xor     ax,ax
                mov     ebp,ecx
                xor     bp,bp
                sub     eax,ebp
                movsx   ebp,si
                cdq
                idiv    ebp
                shl     edx,1
                adc     eax,0
                mov     [@@CloserAdd],eax
@@T5:
                mov     eax,ecx
                xor     ax,ax
                mov     ebp,ebx
                xor     bp,bp
                sub     eax,ebp
                xor     ebp,ebp
                sub     cx,bx
                jz      @@T6
                movzx   esi,cx
                movsx   ebp,cx
                cdq
                idiv    ebp
                shl     edx,1
                adc     eax,0
                mov     ebp,esi
                mov     ecx,eax
                xor     eax,eax
@@T6:
                mov     edx,edi

                mov     esi,ebx
                xor     si,si
                mov     edi,esi
                add     edi,eax
                movsx   ebx,bx
                pop     eax
                test    ebp,ebp
                jz      @@HTop
                test    ebx,ebx
                js      @@OutSide1
@@Loop1:
                HLine
                add     edi,ecx
                add     esi,edx
                inc     ebx
                cmp     bx,64
                jge     @@XIT
                dec     ebp
                jnz     @@Loop1
@@HTop:
                mov     ecx,[@@CloserAdd]
                mov     ebp,[@@CloserLen]
                test    ebp,ebp
                jz      @@HCloser
                test    ebx,ebx
                js      @@OutSide2
@@Loop2:
                HLine
                add     edi,ecx
                add     esi,edx
                inc     ebx
                cmp     bx,64
                jge     @@XIT
                dec     ebp
                jnz     @@Loop2
@@HCloser:
@@XIT:
                ret
@@OutSide1:
                add     edi,ecx
                add     esi,edx
                dec     ebp
                jz      @@HTop
                inc     ebx
                js      @@OutSide1
                jmp     @@Loop1
@@OutSide2:
                add     edi,ecx
                add     esi,edx
                dec     ebp
                jz      @@HCloser
                inc     ebx
                js      @@OutSide2
                jmp     @@Loop2

@@Addr          dd 0
@@CloserAdd     dd 0
@@CloserLen     dd 0
Put_Triangle2   ENDP

Measure_Raster  PROC NEAR

                cli

                mov     dx,3dah
                xor     si,si
                mov     ah,0
@@Ras1:
                in      al,dx   ; waiting a raster retrace
                test    al,8
                jnz     @@Ras1
@@Ras2:
                in      al,dx
                test    al,8
                jz      @@Ras2
                mov     al,30h  ; reset TIMER
                out     43h,al
                jmp     $+2
                mov     al,ah
                out     40h,al
                jmp     $+2
                out     40h,al
@@Ras3:
                in      al,dx   ; waiting the other 300
                test    al,1    ; horizontal raster retrace
                jnz     @@Ras3
@@Ras4:
                in      al,dx
                test    al,1
                jz      @@Ras4
                inc     si
                cmp     si,bp
                jc      @@Ras3
                mov     al,ah
                out     43h,al
                jmp     $+2
                in      al,40h
                mov     ah,al
                in      al,40h
                xchg    al,ah
                neg     ax      ; get the TIMER's register
                sti
                ret

Measure_Raster  ENDP
;------------------------------------------------------------------------------
Raster_IRQ      PROC FAR

                pushad
;               in      al,21h
;               or      al,1
;               out     21h,al
                push    ds
                push    es
                mov     ax,prdss
                mov     ds,ax
                mov     ax,zrdss
                mov     es,ax
;               sti

                call    [RCall]
                mov     dx,3dah ; waiting for vertical retrace
@@Vert_Retr:
                in      al,dx
                test    al,8
                jz      @@Vert_Retr

                mov     ax,amp_seg
                shl     eax,16
                mov     ax,o amp_entry
                mov     realprocaddr,eax
                mov     ah,7
                call    realproc

                mov     al,30h
                out     43h,al  ; the set the TIMER
                jmp     $+2
                mov     ax,[Raster_Time]
                out     40h,al
                jmp     $+2
                mov     al,ah
                out     40h,al

                pop     es
                pop     ds
;               cli
;               in      al,21h
;               and     al,NOT 1
;               out     21h,al
                mov     al,20h
                out     20h,al
                popad
                iretd

RCall   dd O Warm_Up
Raster_Time     dw ?
Old_IRQ0                dd ?

Raster_IRQ      ENDP
;------------------------------------------------------------------------------
Warm_Up         PROC NEAR
                mov     edi,Temp_Area
                add     edi,[Use_Himem]
                mov     eax,0ffffffffh
                mov     ecx,192
        rep     stosd
                mov     edi,Wave_Strt
                add     edi,[Use_Himem]
                mov     ecx,40
                xor     eax,eax
        rep     stosd
                mov     eax,80808080h
                stosd
                mov     [RCall],O Fade_In
                ret
Warm_Up         ENDP
;------------------------------------------------------------------------------
Fade_In         PROC NEAR

                xor     [@@Waitt],1
                jz      @@F3

                mov     dx,3c8h ; Set palette
                mov     al,0
                out     dx,al
                mov     esi,Temp_Area
                add     esi,[Use_Himem]
                mov     edi,O SpPalette
                mov     ah,0
                mov     cl,40h
@@F0:
                mov     dx,3dah ; waiting the raster
@@HRetr1:
                in      al,dx   ; to reach the right
                test    al,1    ; side of the screen
                jnz     @@HRetr1
@@HRetr2:
                in      al,dx
                test    al,1
                jz      @@HRetr2
                mov     dx,3c9h
                mov     ch,3
@@F1:
                mov     al,es:[esi]
                cmp     al,[edi]
                je      @@F2
                inc     al
                mov     es:[esi],al
                mov     ah,0ffh
@@F2:
                out     dx,al
                inc     esi
                inc     edi
                dec     ch
                jnz     @@F1
                dec     cl
                jnz     @@F0
                test    ah,ah
                jnz     @@F3
                mov     [RCall],O Fill_Water	;Logo_In
                mov     esi,edi
                mov     ecx,300h-40h*3
        rep     outsb
@@F3:
                ret
@@Waitt db 0
Fade_In         ENDP
;------------------------------------------------------------------------------
comment~
Logo_In         PROC NEAR

                mov     edi,0a0000h
                movzx   esi,[@@Pos]
                mov     ecx,320*32
                sub     ecx,esi
                shr     ecx,2
                add     esi,O SpLogo
                mov     edx,BkgData
                add     edx,[Use_Himem]
                mov     ebp,4
@@L0:
                lodsd
                test    al,NOT 3fh
                jnz     @@L1
                mov     al,es:[edx]
@@L1:
                ror     eax,8
                test    al,NOT 3fh
                jnz     @@L2
                mov     al,es:[edx+1]
@@L2:
                ror     eax,8
                test    al,NOT 3fh
                jnz     @@L3
                mov     al,es:[edx+2]
@@L3:
                ror     eax,8
                test    al,NOT 3fh
                jnz     @@L4
                mov     al,es:[edx+3]
@@L4:
                ror     eax,8

;                stosd				;!!!!!!!!!!!!!!!!!!!!!!!!!!
		add	edi,4

                add     edx,ebp
                dec     ecx
                jnz     @@L0
                sub     [@@Pos],320
                jns     @@LI1
                mov     [RCall],O Store_Logo
@@LI1:
                ret
@@Pos   dw 320*31
Logo_In         ENDP
;------------------------------------------------------------------------------
Store_Logo      PROC NEAR

                mov     edi,BkgData
                add     edi,[Use_Himem]
                mov     esi,O SpLogo
                mov     ecx,320*32/4
        rep     movsd
                mov     edi,0a0000h
                mov     esi,O SpLogo
                mov     ecx,320*32/4
        rep     movsd
                mov     [RCall],O Fill_Water
                ret
Store_Logo      ENDP
~
;------------------------------------------------------------------------------
Fill_Water      PROC NEAR
                mov     al,[@@Depth]
                inc     al
                cmp     al,39
                jbe     @@FW0
                dec     al
@@FW0:
                mov     [@@Depth],al
                movzx   ecx,B [@@Depth]
                mov     eax,200
                sub     eax,ecx
                mov     ebp,Scr_Row
                add     ebp,[Use_Himem]
                movzx   edi,W es:[ebp][eax*2]
                add     edi,0a0000h
                mov     esi,158*320+0a0000h
                mov     edx,Wave_Strt
                add     edx,[Use_Himem]
                mov     ebp,esi
@@FW1:
                mov     ebx,4
                mov     esi,ebp
                add     esi,es:[edx]
                add     edx,4
                mov     ch,80
@@FW2:
                mov     eax,es:[esi]
                add     eax,80808080h
                stosd
                add     esi,ebx
                dec     ch
                jnz     @@FW2
                sub     ebp,320*2
                dec     cl
                jnz     @@FW1
                mov     eax,3
                call    Shift_Sinus
                ret
@@Depth db 1
Fill_Water      ENDP
;------------------------------------------------------------------------------
Shift_Sinus     PROC NEAR

                mov     [@@Amp],eax
                mov     edi,Wave_Strt
                add     edi,[Use_Himem]
                lea     esi,[edi+4]
                push    ds
                mov     ax,zrdss
                mov     ds,ax
                mov     ecx,80
        rep     movsd
                pop     ds
                mov     edi,Wave_Strt+39*4
                add     edi,[Use_Himem]
                cmp     D es:[edi],80808080h
                jne     @@S2
                call    Rnd
                and     eax,3
                add     al,7
                mov     ebp,eax
                call    Rnd
                and     eax,[@@Amp]
                mov     ebx,eax
                mov     esi,SinTab
                add     esi,[Use_Himem]
                mov     ecx,ebp
                shr     ecx,1
@@S1:
                mov     eax,es:[esi][ecx*4]
                imul    ebx
                sar     eax,10h
                stosd
                add     ecx,ebp
                cmp     ecx,100h
                jb      @@S1
                mov     eax,80808080h
                stosd
@@S2:
                ret
@@Amp   dd 0
Shift_Sinus     ENDP
;------------------------------------------------------------------------------
Blank           PROC NEAR
                ret
Blank           ENDP
;------------------------------------------------------------------------------
Rnd             PROC NEAR

                dec     [@@Rnd_Cnt]
                jnz     @@Rnd_Random
                mov     [@@Rnd_Cnt],1000
                mov     al,0
                out     43h,al
                jmp     $+2
                in      al,40h
                mov     ah,al
                in      al,40h
                mov     [@@Seed],ax
                ret
@@Rnd_Random:
                mov     ax,[@@Seed]
                inc     ax
                mov     dx,997
                mul     dx
                mov     [@@Seed],ax
                ret

@@Rnd_Cnt       dw 1
@@Seed  dw ?
Rnd             ENDP
;------------------------------------------------------------------------------
Store_Bkg               PROC NEAR
                sub     edi,320*6+12
                mov     esi,edi
                add     esi,BkgData
                add     esi,[Use_Himem]
                add     edi,Temp_Area
                add     edi,[Use_Himem]
                mov     ebp,320-124
                push    ds
                mov     ax,zrdss
                mov     ds,ax
                mov     al,112
@@SB1:
                mov     ecx,31
        rep     movsd
                add     esi,ebp
                add     edi,ebp
                dec     al
                jnz     @@SB1
                pop     ds
                ret
Store_Bkg               ENDP
;------------------------------------------------------------------------------
Put_Window      PROC NEAR
                sub     edi,320*6+12
                mov     esi,edi
                add     esi,Temp_Area
                add     esi,[Use_Himem]
                add     edi,0a0000h
                mov     ebp,320-124
                push    ds
                mov     ax,zrdss
                mov     ds,ax
                mov     al,112
@@PW1:
                mov     ecx,31
        rep     movsd
                add     esi,ebp
                add     edi,ebp
                cmp     edi,320*161+0a0000h
                ja      @@PW2
                dec     al
                jnz     @@PW1
@@PW2:
                pop     ds
                ret
Put_Window      ENDP
;------------------------------------------------------------------------------
Control_IRQ     PROC FAR
                push    eax ebx ds
                mov     ax,prdss
                mov     ds,ax

                sub     [Timer_Cnt],1
                adc     [Timer_Cnt],0

                mov     ax,[@@Sph_Add]
                add     ax,[Turn_Sphere]
                and     ax,01111110111111b
                mov     [@@Sph_Add],ax
                movzx   eax,ax
                add     eax,Text_Map
                add     eax,[Use_Himem]
                mov     [Sphere_Text],eax

                mov     ax,[Move_Sphere]
                add     ax,[Sphere_Pos]
                mov     [Sphere_Pos],ax

                movzx   eax,B [SpAddAlfa]
                add     [Spalfa],eax
                movzx   eax,B [SpAddBeta]
                add     [Spbeta],eax
                movzx   eax,B [SpAddGamma]
                add     [Spgamma],eax

                pop     ds ebx
                mov     al,20h
                out     20h,al
                pop     eax
                iretd

Timer_Cnt               dw 0
Turn_Sphere     dw 0
@@Sph_Add               dw 0
Sphere_Text     dd 0
Move_Sphere     dw 0
Sphere_Pos      dw 38afh
SpAddAlfa               db 0
SpAddBeta               db 0
SpAddGamma      db 0
Control_IRQ     ENDP

;############################################################################
;#                                                                          #
;#                     C R E D I T S   P A R T                              #
;#                                                                          #
;############################################################################
;
; Memory requrements: 950kB HiMem
;
;
; Itt a szinek: 0:border, 1:space (a vonalak kozt), 2:stars, 3:lines,
;               4:a kulso resz; 5,6,7,8,9:a folso ill. az also sprite-ok
;               szinei.
;               128-191:az eppen bejovo alkoto nevenek szine. Ezt
;                       atallitom miden uj bejovetelnel, a 'GenLSPal'-lal.
;                       Ennek R kompnens megy eax-tol ebx-ig, G(ecx-edx),
;                       B(edi-esi)
;               192-255:szines haromszogek szinei, rnd-vel
;
PUBLIC Credits
EXTRN Packed3DChr :DATAPTR
EXTRN CrdSprt     :DATAPTR
;------------------------------------------------------------------------------
                                ; Length

CrdBkg          EQU 0                   ; 64k
CrdRotd         EQU CrdBkg+65536        ; 2000*3*3*4=72000
CrdNVects       EQU CrdRotd+72000       ; 200*3*4=240
CrdOrdd         EQU CrdNVects+2400      ; 2000*2*4=16000
CrdChAddr       EQU CrdOrdd+16000       ; 27*4=108
CrSinTab        EQU CrdChAddr+108       ; (512+128)*4=2560
CrdSprUP        EQU CrSinTab+2560       ; 5*96*10=4800
Chr3D           EQU CrdSprUP+4800       ; 64k enough surely
TmpObj          EQU Chr3D+65536         ; 64k enough surely
TmpVects        EQU TmpObj+65536        ; 1000*12=12000
TmpAngles       EQU TmpVects+12000      ; 1000*12=12000
TmpColors       EQU TmpAngles+12000     ; 200
CrdStars        EQU TmpColors+200       ; 100*4=400
BigObj1         EQU CrdStars+400        ; 64k enough surely
BigObj2         EQU BigObj1+65536       ; 1M enough surely

Chr3DA  EQU 0
Chr3DB  EQU 1
Chr3DC  EQU 2
Chr3DD  EQU 3
Chr3DE  EQU 4
Chr3DF  EQU 5
Chr3DG  EQU 6
Chr3DI  EQU 7
Chr3DL  EQU 8
Chr3DM  EQU 9
Chr3DN  EQU 10
Chr3DO  EQU 11
Chr3DP  EQU 12
Chr3DR  EQU 13
Chr3DT  EQU 14
Chr3DV  EQU 15
Chr3DFS EQU 16
;------------------------------------------------------------------------------
Credits         PROC NEAR
                sti
                cld
                mov     eax,prohimemstart
                add     eax,absprotseg
                add     eax,0fh
                and     eax,NOT 0fh
                sub     eax,absprotseg
                mov     [Rel_Himem],eax
                add     eax,absprotseg
                mov     [Use_Himem],eax
                mov     ax,zrdss
                mov     es,ax

                mov     edi,CrSinTab
                add     edi,[Use_Himem]
                mov     eax,0ff0ch
                mov     ebx,512
                mov     ecx,4
                mov     ebp,512+128
                call    Sin_Gen
                mov     eax,CrSinTab
                add     eax,[Rel_Himem]
                mov     [Rotate_Sintab],eax

                call    Set_Video_Mode
                ;call   Make_VasBkg		; modified!!!!!!!!!!!!!!

                mov     dx,3c8h
                mov     al,0
                out     dx,al
                inc     dx
                mov     esi,O PalBegin
                mov     ecx,10*3
@@Pal1:
                lodsb
                out     dx,al
                loop    @@Pal1

                mov     dx,3c8h
                mov     al,0c0h
                out     dx,al
                inc     dx
                mov     ecx,40h*3
@@Pal2:
                push    dx
                call    Rnd
                pop     dx
                out     dx,al
                loop    @@Pal2

                call    Unpack_3DChars
                call    Unpack_Sprites

                call    Make_CrdBkg
                call    Crd_First
                call    Crd_Second
                call    Crd_Third
                call    Crd_Fourth
                call    Crd_Fifth
                call    Crd_Sixth

                ret

PalBegin        db 0,0,0, 0,0,5, 19,19,30, 0,32,28, 6,0,13
                ; Border  Space  Stars     Lines    Outfield
                db 44,53,53, 0,0,63, 47,38,45, 63,0,0, 50,44,53
                ; 1st sprt   2nd     etc.
Crdalfa dd 0
Crdbeta dd 0
Crdgamma        dd 0
@@ZAdd=150*10000h
DescrGOD        dd Chr3DG,440*10000h,@@ZAdd,0
                dd Chr3DFS,520*10000h,@@ZAdd,0
                dd Chr3DO,600*10000h,@@ZAdd,0
                dd Chr3DFS,665*10000h,@@ZAdd,0
                dd Chr3DD,780*10000h,@@ZAdd,0
                dd Chr3DFS,840*10000h,@@ZAdd,0,-1
@@ZAdd=-350*10000h
DescrPERLA      dd Chr3DP,-190*10000h,@@ZAdd,0
                dd Chr3DE,-90*10000h,@@ZAdd,0
                dd Chr3DR,0,@@ZAdd,0
                dd Chr3DL,110*10000h,@@ZAdd,0
                dd Chr3DA,220*10000h,@@ZAdd,0,-1
@@ZAdd=350*10000h
DescrTOMCAT     dd Chr3DT,-350*10000h,@@ZAdd,0
                dd Chr3DO,-220*10000h,@@ZAdd,0
                dd Chr3DM,-50*10000h,@@ZAdd,0
                dd Chr3DC,110*10000h,@@ZAdd,0
                dd Chr3DA,250*10000h,@@ZAdd,0
                dd Chr3DT,350*10000h,@@ZAdd,0,-1
@@ZAdd=-150*10000h
DescrERVIN      dd Chr3DE,-500*10000h,@@ZAdd,0
                dd Chr3DR,-400*10000h,@@ZAdd,0
                dd Chr3DV,-280*10000h,@@ZAdd,0
                dd Chr3DI,-190*10000h,@@ZAdd,0
                dd Chr3DN,-100*10000h,@@ZAdd,0,-1

DescrDIAMOND    dd Chr3DD,-340*10000h,@@ZAdd,0
                dd Chr3DI,-250*10000h,@@ZAdd,0
                dd Chr3DA,-160*10000h,@@ZAdd,0
                dd Chr3DM,0,@@ZAdd,0
                dd Chr3DO,170*10000h,@@ZAdd,0
                dd Chr3DN,310*10000h,@@ZAdd,0
                dd Chr3DD,450*10000h,@@ZAdd,0,-1
Credits         ENDP

GenLSPal        PROC NEAR
; R: eax -> ebx
; G: ecx -> edx
; B: edi -> esi

                shl     eax,10h-6
                shl     ebx,10h-6
                sub     ebx,eax
                mov     [@@RAdd],ebx
                mov     ebx,eax
                shl     ecx,10h-6
                shl     edx,10h-6
                sub     edx,ecx
                mov     [@@GAdd],edx
                shl     edi,10h-6
                shl     esi,10h-6
                sub     esi,edi
                mov     [@@BAdd],esi
                mov     esi,edi
                mov     edi,edx

                mov     dx,3c8h
                mov     al,80h
                out     dx,al
                inc     dx

                mov     ecx,40h
@@1:
                mov     eax,ebx
                shr     eax,10h
                out     dx,al
                mov     eax,edi
                shr     eax,10h
                out     dx,al
                mov     eax,esi
                shr     eax,10h
                out     dx,al
                add     ebx,[@@RAdd]
                add     edi,[@@GAdd]
                add     esi,[@@BAdd]
                loop    @@1
                ret
@@RAdd  dd ?
@@BAdd  dd ?
@@GAdd  dd ?
GenLSPal        ENDP

Crd_First       PROC NEAR
                mov     eax,54
                mov     ebx,0
                mov     ecx,63
                mov     edx,0;16
                mov     edi,63
                mov     esi,0;16
                call    GenLSPal

                mov     esi,O DescrERVIN
                call    Append_Obj
                mov     [Crdbeta],-128-64

@@Again:
                mov     edi,[Use_Himem]
                add     edi,CrdBkg+320*31
                mov     eax,1010101h
                mov     ecx,320*138/4
        rep     stosd
                call    Raster
                call    Put_Stars

                mov     edi,CrdSprUP
                add     edi,[Rel_Himem]
                call    Rolling_Ups

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                mov     eax,280*10000h
                xor     ebx,ebx
                mov     edx,600*10000h
                call    Put_Obj

                mov     edi,0a0000h+320*31
                mov     esi,CrdBkg+320*31
                add     esi,[Rel_Himem]
                mov     ecx,320*138/4
                call    Raster
        rep     movsd

                mov     edi,CrdSprUP
                add     edi,[Rel_Himem]
                call    Rolling_Ups

                add     [Crdbeta],2
                jnz     @@Again

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                mov     ecx,[esi]
                add     esi,4
@@1:
                add     D [esi],280*10000h
                add     D [esi+4],250*10000h
                add     esi,12
                loop    @@1

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                call    Make_TmpObj
                mov     [BooomCnt],0

                mov     esi,320*10

                ret
Crd_First       ENDP

Crd_Second      PROC NEAR
                mov     eax,0
                mov     ebx,0
                mov     ecx,0
                mov     edx,0
                mov     edi,63
                mov     esi,9
                call    GenLSPal

                add     [RUpSin],4
                mov     esi,O DescrGOD
                call    Append_Obj
                mov     [Crdbeta],128+54
@@Again:
                mov     edi,CrdSprUP
                add     edi,[Rel_Himem]
                call    Rolling_Ups
                mov     edi,CrdSprUP+96*10
                add     edi,[Rel_Himem]
                call    Rolling_Dws

                mov     edi,[Use_Himem]
                add     edi,CrdBkg+320*31
                mov     eax,1010101h
                mov     ecx,320*138/4
        rep     stosd
                call    Raster
                call    Put_Stars

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                mov     eax,-600*10000h
                xor     ebx,ebx
                mov     edx,600*10000h
                call    Put_Obj

                mov     edi,CrdSprUP
                add     edi,[Rel_Himem]
                call    Rolling_Ups
                mov     edi,CrdSprUP+96*10
                add     edi,[Rel_Himem]
                call    Rolling_Dws

                mov     esi,TmpObj
                add     esi,[Rel_Himem]
                xor     eax,eax
                mov     ebx,-250*10000h
                mov     edx,600*10000h
                call    Put_ObjNoCol

                mov     edi,0a0000h+320*31
                mov     esi,CrdBkg+320*31
                add     esi,[Rel_Himem]
                mov     ecx,320*138/4
                call    Raster
        rep     movsd

                sub     [Crdbeta],2
                jnz     @@Again

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                mov     ecx,[esi]
                add     esi,4
@@1:
                sub     D [esi],600*10000h
                sub     D [esi+4],270*10000h
                add     esi,12
                loop    @@1

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                call    Make_TmpObj
                mov     [BooomCnt],0
                ret

Crd_Second      ENDP

Crd_Third       PROC NEAR
                mov     eax,53
                mov     ebx,11
                mov     ecx,48
                mov     edx,0
                mov     edi,45
                mov     esi,4
                call    GenLSPal

                add     [RDwSin],4
                mov     [RUpSin],0
                mov     esi,O DescrPerla
                call    Append_Obj
                mov     [Crdgamma],128+92

@@Again:
                mov     edi,CrdSprUP+96*10
                add     edi,[Rel_Himem]
                call    Rolling_Dws
                mov     edi,CrdSprUP+96*10*2
                add     edi,[Rel_Himem]
                call    Rolling_Ups

                mov     edi,[Use_Himem]
                add     edi,CrdBkg+320*31
                mov     eax,1010101h
                mov     ecx,320*138/4
        rep     stosd
                call    Raster
                call    Put_Stars

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                xor     eax,eax
                mov     ebx,250*10000h
                mov     edx,600*10000h
                call    Put_Obj

                mov     edi,CrdSprUP+96*10
                add     edi,[Rel_Himem]
                call    Rolling_Dws
                mov     edi,CrdSprUP+96*10*2
                add     edi,[Rel_Himem]
                call    Rolling_Ups

                mov     esi,TmpObj
                add     esi,[Rel_Himem]
                xor     eax,eax
                mov     ebx,270*10000h
                mov     edx,600*10000h
                call    Put_ObjNoCol

                mov     edi,0a0000h+320*31
                mov     esi,CrdBkg+320*31
                add     esi,[Rel_Himem]
                mov     ecx,320*138/4
                call    Raster
        rep     movsd

                sub     [Crdgamma],2
                jnc     @@Again

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                mov     ecx,[esi]
                add     esi,8
@@1:
                add     D [esi],480*10000h
                add     esi,12
                loop    @@1

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                call    Make_TmpObj
                mov     [BooomCnt],0

                ret

Crd_Third       ENDP

Crd_Fourth      PROC NEAR
                mov     eax,63
                mov     ebx,16
                mov     ecx,0
                mov     edx,0
                mov     edi,0
                mov     esi,0
                call    GenLSPal

                add     [RUpSin],4
                mov     [RDwSin],0
                mov     esi,O DescrTOMCAT
                call    Append_Obj
                mov     [Crdgamma],128+80

@@Again:
                mov     edi,CrdSprUP+96*10*2
                add     edi,[Rel_Himem]
                call    Rolling_Ups
                mov     edi,CrdSprUP+96*10*3
                add     edi,[Rel_Himem]
                call    Rolling_Dws

                mov     edi,[Use_Himem]
                add     edi,CrdBkg+320*31
                mov     eax,1010101h
                mov     ecx,320*138/4
        rep     stosd
                call    Raster
                call    Put_Stars

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                xor     eax,eax
                mov     ebx,-200*10000h
                mov     edx,600*10000h
                call    Put_Obj

                mov     esi,TmpObj
                add     esi,[Rel_Himem]
                xor     eax,eax
                mov     ebx,-220*10000h
                mov     edx,600*10000h
                call    Put_ObjNoCol

                mov     edi,CrdSprUP+96*10*2
                add     edi,[Rel_Himem]
                call    Rolling_Ups
                mov     edi,CrdSprUP+96*10*3
                add     edi,[Rel_Himem]
                call    Rolling_Dws

                mov     edi,0a0000h+320*31
                mov     esi,CrdBkg+320*31
                add     esi,[Rel_Himem]
                mov     ecx,320*138/4
                call    Raster
        rep     movsd

                sub     [Crdgamma],2
                cmp     [Crdgamma],-2
                jne     @@Again

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                mov     ecx,[esi]
                add     esi,8
@@1:
                sub     D [esi],450*10000h
                add     esi,12
                loop    @@1

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                call    Make_TmpObj
                mov     [BooomCnt],0

                ret

Crd_Fourth      ENDP

Crd_Fifth       PROC NEAR
                mov     eax,60
                mov     ebx,11
                mov     ecx,54
                mov     edx,0
                mov     edi,63
                mov     esi,16
                call    GenLSPal

                add     [RDwSin],4
                mov     [RUpSin],0
                mov     esi,O DescrDIAMOND
                call    Append_Obj
                mov     [Crdgamma],0

@@Again:
                mov     edi,[Use_Himem]
                add     edi,CrdBkg+320*31
                mov     eax,1010101h
                mov     ecx,320*138/4
        rep     stosd
                call    Raster
                call    Put_Stars

                mov     edi,CrdSprUP+96*10*3
                add     edi,[Rel_Himem]
                call    Rolling_Dws
                mov     edi,CrdSprUP+96*10*4
                add     edi,[Rel_Himem]
                call    Rolling_Ups

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                xor     eax,eax
                xor     ebx,ebx
                mov     edx,[@@ZC]
                call    Put_Obj

                mov     esi,TmpObj
                add     esi,[Rel_Himem]
                xor     eax,eax
                mov     ebx,250*10000h
                mov     edx,600*10000h
                call    Put_ObjNoCol

                mov     edi,CrdSprUP+96*10*3
                add     edi,[Rel_Himem]
                call    Rolling_Dws
                mov     edi,CrdSprUP+96*10*4
                add     edi,[Rel_Himem]
                call    Rolling_Ups

                mov     edi,0a0000h+320*31
                mov     esi,CrdBkg+320*31
                add     esi,[Rel_Himem]
                mov     ecx,320*138/4
                call    Raster
        rep     movsd

                add     [@@ZC],10*10000h
                cmp     [@@ZC],600*10000h
                jne     @@Again

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                mov     ecx,[esi]
                add     esi,8
@@1:
                add     D [esi],200*10000h
                add     esi,12
                loop    @@1

                mov     esi,BigObj1
                add     esi,[Rel_Himem]
                call    Make_TmpObj
                mov     [BooomCnt],0

                ret
@@ZC    dd -500*10000h
Crd_Fifth       ENDP

Crd_Sixth       PROC NEAR

                add     [RUpSin],4
                mov     [@@Cnt],80
@@Again:
                mov     edi,[Use_Himem]
                add     edi,CrdBkg+320*31
                mov     eax,1010101h
                mov     ecx,320*138/4
        rep     stosd
                call    Raster
                call    Put_Stars

                mov     edi,CrdSprUP+96*10*4
                add     edi,[Rel_Himem]
                call    Rolling_Ups

                mov     esi,TmpObj
                add     esi,[Rel_Himem]
                xor     eax,eax
                mov     ebx,-200*10000h
                mov     edx,600*10000h
                call    Put_ObjNoCol

                mov     edi,CrdSprUP+96*10*4
                add     edi,[Rel_Himem]
                call    Rolling_Ups

                mov     edi,0a0000h+320*31
                mov     esi,CrdBkg+320*31
                add     esi,[Rel_Himem]
                mov     ecx,320*138/4
                call    Raster
        rep     movsd

                dec     [@@Cnt]
                jnz     @@Again

                ret
@@Cnt   db ?
Crd_Sixth       ENDP

Rolling_Ups     PROC NEAR

                mov     esi,0a0000h+320*10

                mov     cl,10
@@2:
                movzx   eax,cl
                dec     eax
                mov     eax,[RUpSin][eax*4]
                add     eax,[Rel_Himem]
                mov     eax,[eax+CrSinTab]

                mov     ebp,300*10000h
                mul     ebp
                mov     eax,edx
                cmp     [RUpSin],512/4*4
                jae     @@0
                neg     eax
                add     eax,160+300
                jmp     @@1
@@0:
                sub     eax,300-160
@@1:
                add     eax,300-160-96
                mov     ebx,96
@@3:
                cmp     eax,320
                jae     @@4
                mov     dl,[edi]
                mov     es:[esi+eax],dl
@@4:
                inc     edi
                inc     eax
                dec     ebx
                jnz     @@3
                sub     eax,96
                add     esi,320
                dec     cl
                jnz     @@2

                mov     ebx,O RUpSin+4*9
                mov     cl,9
@@00:
                mov     eax,[ebx-4]
                mov     [ebx],eax
                sub     ebx,4
                dec     cl
                jnz     @@00

                add     [RUpSin],4
                cmp     [RUpSin],512/4*4
                jne     @@5
                sub     [RUpSin],4
@@5:
                cmp     [RUpSin],512/2*4
                jne     @@XIT
                sub     [RUpSin],4
@@XIT:
                ret

RUpSin  dd 10 Dup(0)
Rolling_Ups     ENDP

Rolling_Dws     PROC NEAR

                mov     esi,0a0000h+320*180

                mov     cl,10
@@2:
                movzx   eax,cl
                neg     eax
                add     eax,10
                mov     eax,[RDwSin][eax*4]
                add     eax,[Rel_Himem]
                mov     eax,[eax+CrSinTab]

                mov     ebp,300*10000h
                mul     ebp
                mov     eax,edx
                cmp     [RDwSin],512/4*4
                jb      @@0
                neg     eax
                add     eax,160+300
                jmp     @@1
@@0:
                sub     eax,300-160
@@1:
                sub     eax,300-160
                mov     ebx,96
@@3:
                cmp     eax,320
                jae     @@4
                mov     dl,[edi]
                mov     es:[esi+eax],dl
@@4:
                inc     edi
                inc     eax
                dec     ebx
                jnz     @@3
                sub     eax,96
                add     esi,320
                dec     cl
                jnz     @@2

                mov     ebx,O RDwSin+4*9
                mov     cl,9
@@00:
                mov     eax,[ebx-4]
                mov     [ebx],eax
                sub     ebx,4
                dec     cl
                jnz     @@00

                add     [RDwSin],4
                cmp     [RDwSin],512/4*4
                jne     @@5
                sub     [RDwSin],4
@@5:
                cmp     [RDwSin],512/2*4
                jne     @@XIT
                sub     [RDwSin],4
@@XIT:
                ret
RDwSin  dd 10 Dup(0)
Rolling_Dws     ENDP

Make_CrdBkg     PROC NEAR

                mov     edi,0a0000h             ; Put outfield
                mov     eax,4040404h
                mov     ecx,320*29/4
        rep     stosd
                mov     eax,3030303h
                mov     ecx,320/4
        rep     stosd
                mov     eax,1010101h
                mov     ecx,320*140/4
        rep     stosd
                mov     eax,3030303h
                mov     ecx,320/4
        rep     stosd
                mov     eax,4040404h
                mov     ecx,320*29/4
        rep     stosd

                mov     edi,CrdStars
                add     edi,[Rel_Himem]
                mov     ecx,100
@@1:
                call    Rnd
                movzx   eax,ax
                cdq
                mov     ebx,138
                div     ebx
                lea     edx,[edx+edx*4]
                shl     edx,6
                mov     ebp,edx
                call    Rnd
                movzx   eax,ax
                cdq
                mov     ebx,320
                div     ebx
                add     ebp,edx
                add     ebp,CrdBkg+320*31
                add     ebp,[Rel_Himem]
                mov     [edi],ebp
                sub     ebp,[Rel_Himem]
                add     ebp,0a0000h-CrdBkg
                mov     B es:[ebp],2
                add     edi,4
                loop    @@1

                ret
Make_CrdBkg     ENDP

Put_Stars       PROC NEAR
                mov     esi,CrdStars
                add     esi,[Rel_Himem]
                mov     ecx,100
@@1:
                lodsd
                mov     B [eax],2
                dec     ecx
                jnz     @@1

                ret
Put_Stars       ENDP

Make_VasBkg     PROC NEAR
a=20*10000h
@@max=1000
                mov     edi,[Use_Himem]
                add     edi,CrdBkg
                xor     eax,eax
                mov     ecx,320*200/4
        rep     stosd

                mov     dx,3c8h
                mov     ax,18h
                out     dx,al
                inc     dx
@@Pal:
                mov     al,0
                out     dx,al
                out     dx,al
                mov     al,ah
                shr     al,2
                out     dx,al
                add     ah,1
                mov     al,0
                out     dx,al
                out     dx,al
                mov     al,ah
                shr     al,2
                out     dx,al
                add     ah,2
                cmp     ah,40h
                jb      @@Pal

                mov     edx,-@@max*10000h
@@1:
                mov     ebx,edx
                neg     ebx
                lea     ebx,[ebx+ebx*2]
                shr     ebx,2
                add     ebx,2*a
@@2:
                mov     eax,edx
                neg     eax
                sub     eax,2*a
@@3:
                mov     esi,O CrdCube
                push    eax ebx edx
                mov     ebp,@@max*10000h-4*a/2
                test    eax,eax
                jns     @@4
                neg     ebp
@@4:
                sub     eax,ebp
                mov     ebp,@@max*10000h*3/4-4*a/2
                test    ebx,ebx
                jns     @@5
                mov     ebp,@@max*10000h-4*a/2
                neg     ebp
@@5:
                sub     ebx,ebp
                neg     edx
                call    Put_Obj
                pop     edx ebx eax
                sub     eax,4*a
                cmp     eax,edx
                jg      @@3
                sub     ebx,4*a
                cmp     ebx,edx
                jg      @@2
                add     edx,4*a
                test    edx,edx
                js     @@1			; modified!!!!!!!!!!!!!!!!!

                mov     edi,0a0000h
                mov     esi,CrdBkg
                add     esi,[Rel_Himem]
                mov     ecx,320*200/4
        rep     movsd

                jmp     $
                ret

a=5*a/4

CrdCube dd 8
        dd -a,-a,-a, a,-a,-a, a,a,-a, -a,a,-a
        dd -a,-a,a,  a,-a,a,  a,a,a,  -a,a,a
        dd 6
        dd 0,0,-10000h
        dd 0,0,10000h
        dd 10000h,0,0
        dd -10000h,0,0
        dd 0,10000h,0
        dd 0,-10000h,0
        dd 12
        dd 0,0,1,2
        dd 0,2,3,0
        dd 1,5,4,6
        dd 1,7,6,4
        dd 2,1,5,6
        dd 2,6,2,1
        dd 3,0,3,7
        dd 3,7,4,0
        dd 4,3,2,6
        dd 4,6,7,3
        dd 5,5,1,0
        dd 5,0,4,5
Make_VasBkg     ENDP

Append_Obj      PROC NEAR
                mov     edi,BigObj1
                add     edi,[Rel_Himem]
                mov     [@@Addr1],edi
                mov     ebx,[esi]
                shl     ebx,2
                add     ebx,CrdChAddr
                add     ebx,[Rel_Himem]
                mov     ebx,[ebx]
                mov     eax,[esi+4]
                mov     [@@XAdd],eax
                mov     eax,[esi+8]
                mov     [@@YAdd],eax
                mov     eax,[esi+12]
                mov     [@@ZAdd],eax
                add     esi,16
                mov     ecx,[ebx]
                add     ebx,4
                mov     [edi],ecx
                add     edi,4
@@I1:
                mov     eax,[ebx]
                add     eax,[@@XAdd]
                mov     [edi],eax
                mov     eax,[ebx+4]
                add     eax,[@@YAdd]
                mov     [edi+4],eax
                mov     eax,[ebx+8]
                add     eax,[@@ZAdd]
                mov     [edi+8],eax
                add     ebx,12
                add     edi,12
                loop    @@I1

                mov     ecx,[ebx]
                add     ebx,4
                mov     [edi],ecx
                add     edi,4
                lea     ecx,[ecx+ecx*2]
@@I2:
                mov     eax,[ebx]
                mov     [edi],eax
                add     ebx,4
                add     edi,4
                loop    @@I2
                mov     ecx,[ebx]
                add     ebx,4
                mov     [edi],ecx
                add     edi,4
                shl     ecx,2
@@I3:
                mov     eax,[ebx]
                mov     [edi],eax
                add     ebx,4
                add     edi,4
                loop    @@I3
                mov     eax,BigObj2
                add     eax,[Rel_Himem]
                mov     [@@Addr2],eax
                mov     [@@Ind],0
@@0:
                mov     eax,[esi]
                cmp     eax,-1
                jne     @@2
                cmp     [@@Ind],0
                je      @@1
                mov     edi,BigObj1
                add     edi,[Use_Himem]
                mov     esi,BigObj2
                add     esi,[Rel_Himem]
                mov     ecx,(BigObj2-BigObj1)/4
        rep     movsd
@@1:
                ;mov    ax,zrdss
                ;mov    es,ax
                ;mov    edi,90000h
                ;mov    esi,BigObj1
                ;add    esi,[Rel_Himem]
                ;mov    ecx,60000/4
                ;cld
        ;rep    movsd
                ;mov    ah,0
                ;int    16h
                ret
@@2:
                mov     ebx,[esi+4]
                mov     [@@XAdd],ebx
                mov     ebx,[esi+8]
                mov     [@@YAdd],ebx
                mov     ebx,[esi+12]
                mov     [@@ZAdd],ebx
                add     esi,16
                push    esi
                shl     eax,2
                add     eax,CrdChAddr
                add     eax,[Rel_Himem]
                mov     esi,[eax]
                mov     edi,[@@Addr1]           ; esi,addr1 => addr2
                mov     ebx,[@@Addr2]           ;     edi      ebx
                mov     eax,[esi]
                add     esi,4
                mov     [@@SPnt2],eax
                mov     ecx,eax
                add     eax,[edi]
                mov     [ebx],eax
                add     ebx,4
@@3:
                mov     eax,[esi]
                add     eax,[@@XAdd]
                mov     [ebx],eax
                mov     eax,[esi+4]
                add     eax,[@@YAdd]
                mov     [ebx+4],eax
                mov     eax,[esi+8]
                add     eax,[@@ZAdd]
                mov     [ebx+8],eax
                add     esi,12
                add     ebx,12
                loop    @@3
                mov     ecx,[edi]
                add     edi,4
                lea     ecx,[ecx+ecx*2]
@@4:
                mov     eax,[edi]
                mov     [ebx],eax
                add     edi,4
                add     ebx,4
                loop    @@4
                mov     eax,[esi]
                add     esi,4
                mov     [@@SNVec2],eax
                mov     ecx,eax
                add     eax,[edi]
                mov     [ebx],eax
                add     ebx,4
                lea     ecx,[ecx+ecx*2]
@@5:
                mov     eax,[esi]
                mov     [ebx],eax
                add     esi,4
                add     ebx,4
                loop    @@5
                mov     ecx,[edi]
                add     edi,4
                lea     ecx,[ecx+ecx*2]
@@6:
                mov     eax,[edi]
                mov     [ebx],eax
                add     edi,4
                add     ebx,4
                loop    @@6

                mov     eax,[esi]
                add     esi,4
                mov     ecx,eax
                add     eax,[edi]
                mov     [ebx],eax
                add     ebx,4
                shl     ecx,2
@@7:
                mov     eax,[esi]
                mov     [ebx],eax
                add     esi,4
                add     ebx,4
                loop    @@7
                mov     ecx,[edi]
                add     edi,4
@@8:
                mov     eax,[edi]
                add     eax,[@@SNVec2]
                mov     [ebx],eax
                mov     eax,[edi+4]
                add     eax,[@@SPnt2]
                mov     [ebx+4],eax
                mov     eax,[edi+8]
                add     eax,[@@SPnt2]
                mov     [ebx+8],eax
                mov     eax,[edi+12]
                add     eax,[@@SPnt2]
                mov     [ebx+12],eax
                add     edi,16
                add     ebx,16
                loop    @@8
                mov     eax,[@@Addr1]
                xchg    eax,[@@Addr2]
                mov     [@@Addr1],eax
                xor     [@@Ind],0ffh
                pop     esi
                jmp     @@0
@@Addr1 dd ?
@@Addr2 dd ?
@@SPnt2 dd ?
@@SNVec2        dd ?
@@XAdd  dd ?
@@YAdd  dd ?
@@ZAdd  dd ?
@@Ind   db ?
Append_Obj      ENDP

Make_TmpObj     PROC NEAR

                mov     edi,[esi]
                lea     edi,[edi+edi*2]
                shl     edi,2
                add     esi,4
                add     edi,esi
                mov     eax,[edi]
                lea     eax,[eax+eax*2]
                inc     eax
                shl     eax,2
                add     edi,eax
                mov     ecx,[edi]
                add     edi,4
                mov     ebx,TmpObj
                add     ebx,[Rel_Himem]
                mov     edx,ecx
                lea     edx,[edx+edx*2]
                mov     [ebx],edx
                add     ebx,4
                lea     edx,[edx+edx*2]
                shl     edx,2
                add     edx,ebx
                mov     [edx],ecx
                add     edx,4
                xor     ebp,ebp
@@1:
                                        ; esi=ori.points
                                        ; edi=ori.faces
                                        ; ebx=new points
                                        ; edx=new faces
                add     edi,4
                push    edx
                call    Rnd
                pop     edx
                and     eax,3fh
                add     eax,0c0h
                mov     [edx],eax
                add     edx,4
                push    ecx
                mov     cl,3
@@2:
                mov     eax,[edi]
                add     edi,4
                lea     eax,[eax+eax*2]
                shl     eax,2
                push    eax
                mov     eax,[esi+eax]
                mov     [ebx],eax
                mov     eax,[esp]
                mov     eax,[esi+eax+4]
                mov     [ebx+4],eax
                pop     eax
                mov     eax,[esi+eax+8]
                mov     [ebx+8],eax
                add     ebx,12
                mov     [edx],ebp
                inc     ebp
                add     edx,4
                dec     cl
                jnz     @@2
                pop     ecx
                loop    @@1

                mov     edi,TmpVects
                add     edi,[Rel_Himem]
                mov     ebx,TmpAngles
                add     ebx,[Rel_Himem]
                mov     esi,TmpObj
                add     esi,[Rel_Himem]
                mov     ecx,[esi]
                add     esi,4
@@3:
                push    ecx
                mov     ebp,3
@@4:
                mov     eax,[esi]
                add     eax,[esi+12]
                add     eax,[esi+24]
                cdq
                mov     ecx,5
                idiv    ecx
                mov     ecx,eax
                call    Rnd
                movsx   eax,ax
                shl     eax,4
                add     ecx,eax
                mov     [edi],ecx
                add     edi,4
                add     esi,4
                call    Rnd
                movzx   eax,ax
                mov     [ebx],eax
                add     ebx,4
                dec     ebp
                jnz     @@4
                add     esi,24
                pop     ecx
                sub     ecx,3
                ja      @@3

                ret
Make_TmpObj     ENDP

Put_Obj         PROC NEAR
; eax,ebx,ecx=a,b,g
; ds:esi=obj ds=prdss
@@TriNo=4
                push    eax ebx edx esi

                mov     eax,[Crdalfa]
                mov     ebx,[Crdbeta]
                mov     ecx,[Crdgamma]
                mov     esi,[Rotate_Sintab]
                call    Rot_Make_Matrix
                pop     esi edx ebx eax

                add     edx,600*10000h
                mov     edi,CrdRotd
                add     edi,[Rel_Himem]
                mov     ecx,[esi]
                mov     [@@Tmp1],ecx
                add     esi,4
                push    esi
                call    Rot_Turn9
                pop     esi
                mov     eax,[esi-4]
                lea     eax,[eax+eax*2]
                shl     eax,2
                add     esi,eax         ; eax=NumOfPoints*12+4

                xor     eax,eax
                xor     ebx,ebx
                xor     edx,edx
                mov     edi,CrdNVects
                add     edi,[Rel_Himem]
                mov     ecx,[esi]
                add     esi,4
                push    esi ecx
                call    Rot_Turn9
                pop     ecx
                mov     esi,CrdNVects
                add     esi,[Rel_Himem]
                mov     edx,TmpColors
                add     edx,[Rel_Himem]
@@LS_Loop:
                call    LightSource
                mov     [edx],al
                inc     edx
                add     esi,12
                dec     ecx
                jnz     @@LS_Loop

                pop     esi
                mov     eax,[esi-4]
                lea     eax,[eax+eax*2]
                shl     eax,2
                add     esi,eax         ; eax=NumOfPoints*12+4

                mov     ecx,[esi]
                add     esi,4
                mov     ebx,CrdRotd
                add     ebx,[Rel_Himem]
                mov     edi,CrdOrdd
                add     edi,[Rel_Himem]
                push    esi
                mov     eax,BigObj2
                add     eax,[Rel_Himem]
                call    Order

                mov     esi,CrdRotd
                add     esi,[Rel_Himem]
                mov     ecx,[@@Tmp1]
                call    Rot_Transform
                pop     esi

                mov     edi,BigObj2
                add     edi,[Rel_Himem]
                mov     ecx,[esi-4]
@@Loop:
                push    ecx edi esi

                mov     eax,[edi]
                mov     eax,[eax+4]
                shl     eax,4
                add     esi,eax
                mov     eax,[esi+4]
                lea     eax,[eax+eax*2]
                shl     eax,2
                mov     edi,CrdRotd
                add     edi,[Rel_Himem]
                mov     bx,W [eax+edi+4]
                add     bx,100
                shl     ebx,10h
                mov     bx,W [eax+edi]
                add     bx,160
                mov     eax,[esi+8]
                lea     eax,[eax+eax*2]
                shl     eax,2
                mov     cx,W [eax+edi+4]
                add     cx,100
                shl     ecx,10h
                mov     cx,W [eax+edi]
                add     cx,160
                mov     eax,[esi+12]
                lea     eax,[eax+eax*2]
                shl     eax,2
                mov     dx,W [eax+edi+4]
                add     dx,100
                shl     edx,10h
                mov     dx,W [eax+edi]
                add     dx,160
                call    Visible
                jge     @@NoV
                movzx   eax,B [esi]
                add     eax,[Rel_Himem]
                mov     al,[eax+TmpColors]
                mov     edi,CrdBkg
                add     edi,[Use_Himem]
                call    Put_Triangle
@@NoV:
                pop     esi edi ecx
                add     edi,4
                dec     ecx
                jnz     @@Loop
                ret
@@Tmp1  dd ?

Put_Obj         ENDP

Put_ObjNoCol    PROC NEAR
; eax,ebx,ecx=a,b,g
; ds:esi=obj ds=prdss
@@TriNo=4
                mov     [@@Pnt],0
                inc     [BooomCnt]
                add     edx,600*10000h
                mov     [@@XAdd],eax
                mov     [@@YAdd],ebx
                mov     [@@ZAdd],edx
                mov     edi,CrdRotd
                add     edi,[Rel_Himem]
                mov     ecx,[esi]
                mov     [@@Tmp1],ecx
                add     esi,4
@@Rott:
                push    ecx edi esi
                mov     edi,[@@Pnt]
                lea     edi,[edi+edi*2]
                shl     edi,2
                add     edi,TmpAngles
                add     edi,[Rel_Himem]
                mov     eax,[edi]
                mul     [BooomCnt]
                shr     eax,12
                mov     ebp,eax
                mov     eax,[edi+4]
                mul     [BooomCnt]
                shr     eax,12
                mov     ebx,eax
                ;mov    eax,[edi+8]
                ;mul    [BooomCnt]
                ;shr    eax,13
                ;mov    ecx,eax
                xor     ecx,ecx
                mov     eax,ebp
                mov     esi,[Rotate_Sintab]
                call    Rot_Make_Matrix
                pop     esi edi
                push    edi esi
                mov     ecx,[@@Pnt]
                inc     [@@Pnt]
                lea     ecx,[ecx+ecx*2]
                shl     ecx,2
                add     ecx,TmpVects
                add     ecx,[Rel_Himem]
                mov     eax,[ecx]
                mov     [@@XATmp],eax
                sub     [esi],eax
                sub     [esi+12],eax
                sub     [esi+24],eax
                imul    [BooomCnt]
                shld    edx,eax,20h-2
                add     edx,[@@Xadd]
                mov     ebp,edx
                mov     eax,[ecx+4]
                mov     [@@YATmp],eax
                sub     [esi+4],eax
                sub     [esi+16],eax
                sub     [esi+28],eax
                imul    [BooomCnt]
                shld    edx,eax,20h-2
                add     edx,[@@Yadd]
                mov     ebx,edx
                mov     eax,[ecx+8]
                mov     [@@ZATmp],eax
                sub     [esi+8],eax
                sub     [esi+20],eax
                sub     [esi+32],eax
                imul    [BooomCnt]
                shld    edx,eax,20h-2
                add     edx,[@@Zadd]
                mov     eax,ebp
                mov     ecx,3
                call    Rot_Turn9
                pop     esi edi ecx
                mov     eax,[@@XATmp]
                add     [esi],eax
                add     [esi+12],eax
                add     [esi+24],eax
                add     [edi],eax
                add     [edi+12],eax
                add     [edi+24],eax
                mov     eax,[@@YATmp]
                add     [esi+4],eax
                add     [esi+16],eax
                add     [esi+28],eax
                add     [edi+4],eax
                add     [edi+16],eax
                add     [edi+28],eax
                mov     eax,[@@ZATmp]
                add     [esi+8],eax
                add     [esi+20],eax
                add     [esi+32],eax
                add     [edi+8],eax
                add     [edi+20],eax
                add     [edi+32],eax
                add     edi,3*12
                add     esi,3*12
                sub     ecx,3
                ja      @@Rott

                mov     ecx,[esi]
                add     esi,4
                mov     ebx,CrdRotd
                add     ebx,[Rel_Himem]
                mov     edi,CrdOrdd
                add     edi,[Rel_Himem]
                push    esi
                mov     eax,BigObj2
                add     eax,[Rel_Himem]
                call    Order

                mov     esi,CrdRotd
                add     esi,[Rel_Himem]
                mov     ecx,[@@Tmp1]
                call    Rot_Transform
                pop     esi

                mov     edi,BigObj2
                add     edi,[Rel_Himem]
                mov     ecx,[esi-4]
@@Loop:
                push    ecx edi esi

                mov     eax,[edi]
                mov     eax,[eax+4]
                shl     eax,4
                add     esi,eax
                mov     eax,[esi+4]
                lea     eax,[eax+eax*2]
                shl     eax,2
                mov     edi,CrdRotd
                add     edi,[Rel_Himem]
                mov     bx,W [eax+edi+4]
                add     bx,100
                shl     ebx,10h
                mov     bx,W [eax+edi]
                add     bx,160
                ;mov    eax,[esi+8]
                ;lea    eax,[eax+eax*2]
                ;shl    eax,2
                add     eax,12
                mov     cx,W [eax+edi+4]
                add     cx,100
                shl     ecx,10h
                mov     cx,W [eax+edi]
                add     cx,160
                ;mov    eax,[esi+12]
                ;lea    eax,[eax+eax*2]
                ;shl    eax,2
                add     eax,12
                mov     dx,W [eax+edi+4]
                add     dx,100
                shl     edx,10h
                mov     dx,W [eax+edi]
                add     dx,160
                mov     al,B [esi]
                mov     edi,CrdBkg
                add     edi,[Use_Himem]
                call    Put_Triangle
@@NoV:
                pop     esi edi ecx
                add     edi,4
                dec     ecx
                jnz     @@Loop
                ret
@@Tmp1  dd ?
@@Pnt   dd ?
BooomCnt        dd 0
@@XAdd  dd ?
@@YAdd  dd ?
@@ZAdd  dd ?
@@XATmp dd ?
@@YATmp dd ?
@@ZATmp dd ?

Put_ObjNoCol    ENDP

LightSource     PROC NEAR
;@@LSX EQU 37837
;@@LSY EQU 37837
;@@LSZ EQU -37837
@@LSX EQU 32768
@@LSY EQU 0
@@LSZ EQU 56756
                push    ecx edx
                mov     eax,[esi]
                mov     ecx,@@LSX
                imul    ecx
                mov     ebp,eax
                mov     edi,edx
                mov     eax,[esi+4]
                mov     ecx,@@LSY
                imul    ecx
                add     ebp,eax
                adc     edi,edx
                mov     eax,[esi+8]
                mov     ecx,@@LSZ
                imul    ecx
                add     ebp,eax
                adc     edi,edx
                shld    edi,ebp,5
                mov     al,[edi+20h+O @@ArcCos]
                add     al,80h
                pop     edx ecx
                ret
x=0                             ; Starting color's number.
@@ArcCos        db 63+x,62+x,62+x,61+x,60+x,60+x
        db 59+x,58+x,58+x,57+x,57+x,56+x
        db 55+x,55+x,54+x,54+x,53+x,52+x
        db 52+x,51+x,50+x,50+x,49+x,48+x
        db 48+x,47+x,46+x,45+x,45+x,44+x
        db 43+x,43+x,42+x,41+x,41+x,40+x
        db 39+x,38+x,38+x,37+x,36+x,35+x
        db 34+x,33+x,33+x,32+x,31+x,30+x
        db 29+x,28+x,27+x,26+x,25+x,24+x
        db 23+x,22+x,20+x,19+x,18+x,16+x
        db 14+x,12+x,10+x,7+x,0+x
LightSource     ENDP
;------------------------------------------------------------------------------
Put_Triangle    PROC NEAR
HLine   MACRO
local   zz,zzz,zzzz,H1,H2,H3,H4
                push    ebx ecx edi esi

                cmp     edi,318*10000h
                jle     H1
                cmp     esi,318*10000h
                jg      zzzz
                mov     edi,318*10000h
                jmp     H2
H1:
                test    edi,edi
                jns     H2
                test    esi,esi
                js      zzzz
                xor     edi,edi
H2:
                cmp     esi,318*10000h
                jle     H3
                cmp     edi,318*10000h
                jg      zzzz
                mov     esi,318*10000h
                jmp     H4
H3:
                test    esi,esi
                jns     H4
                test    edi,edi
                js      zzzz
                xor     esi,esi
H4:
                lea     ebx,[ebx+ebx*4]
                shl     ebx,6
                add     ebx,[@@Addr]
                sar     esi,10h
                adc     esi,ebx
                sar     edi,10h
                adc     edi,ebx

                mov     ecx,esi
                sub     ecx,edi
                jnb     zzz

                neg     ecx
                mov     edi,esi
zzz:
                inc     ecx

                mov     ebx,ecx
                mov     ecx,3
                and     ecx,edi
                sub     ebx,ecx
                jns     zz
                add     ecx,ebx
        rep     stosb
                jmp     zzzz
zz:
        rep     stosb

                mov     ecx,ebx
                shr     ecx,2
        rep     stosd

                and     ebx,3
                mov     ecx,ebx
        rep     stosb
zzzz:
                pop     esi edi ecx ebx
ENDM
;------------------------------------------------------------------------------
                rol     ebx,10h
                rol     ecx,10h
                rol     edx,10h
                mov     [@@Addr],edi

                cmp     bx,cx
                jle     @@T1
                xchg    ebx,ecx
@@T1:
                cmp     bx,dx
                jle     @@T2
                xchg    ebx,edx
@@T2:
                cmp     cx,dx
                jle     @@T3
                xchg    ecx,edx
@@T3:
                cmp     bx,200
                jge     @@XIT
                test    dx,dx
                js      @@XIT
                mov     esi,edx

                mov     ah,al
                push    ax ax

                xor     edi,edi
                mov     [@@CloserAdd],edi
                mov     [@@CloserLen],edi
                sub     dx,bx
                jz      @@T4
                mov     eax,edx
                xor     ax,ax
                mov     ebp,ebx
                xor     bp,bp
                sub     eax,ebp
                movsx   ebp,dx
                cdq
                idiv    ebp
                shl     edx,1
                adc     eax,0
                mov     edi,eax
@@T4:
                sub     si,cx
                jz      @@T5
                mov     Word Ptr [@@CloserLen],si
                mov     eax,esi
                xor     ax,ax
                mov     ebp,ecx
                xor     bp,bp
                sub     eax,ebp
                movsx   ebp,si
                cdq
                idiv    ebp
                shl     edx,1
                adc     eax,0
                mov     [@@CloserAdd],eax
@@T5:
                mov     eax,ecx
                xor     ax,ax
                mov     ebp,ebx
                xor     bp,bp
                sub     eax,ebp
                xor     ebp,ebp
                sub     cx,bx
                jz      @@T6
                movzx   esi,cx
                movsx   ebp,cx
                cdq
                idiv    ebp
                shl     edx,1
                adc     eax,0
                mov     ebp,esi
                mov     ecx,eax
                xor     eax,eax
@@T6:
                mov     edx,edi

                mov     esi,ebx
                xor     si,si
                mov     edi,esi
                add     edi,eax
                movsx   ebx,bx
                pop     eax
                test    ebp,ebp
                jz      @@HTop
                test    ebx,ebx
                js      @@OutSide1
@@Loop1:
                HLine
                add     edi,ecx
                add     esi,edx
                inc     ebx
                cmp     bx,200
                jge     @@XIT
                dec     ebp
                jnz     @@Loop1
@@HTop:
                mov     ecx,[@@CloserAdd]
                mov     ebp,[@@CloserLen]
                test    ebp,ebp
                jz      @@HCloser
                test    ebx,ebx
                js      @@OutSide2
@@Loop2:
                HLine
                add     edi,ecx
                add     esi,edx
                inc     ebx
                cmp     bx,200
                jge     @@XIT
                dec     ebp
                jnz     @@Loop2
@@HCloser:
@@XIT:
                ret
@@OutSide1:
                add     edi,ecx
                add     esi,edx
                dec     ebp
                jz      @@HTop
                inc     ebx
                js      @@OutSide1
                jmp     @@Loop1
@@OutSide2:
                add     edi,ecx
                add     esi,edx
                dec     ebp
                jz      @@HCloser
                inc     ebx
                js      @@OutSide2
                jmp     @@Loop2

@@Addr          dd 0
@@CloserAdd     dd 0
@@CloserLen     dd 0
Put_Triangle    ENDP
;------------------------------------------------------------------------------
UnPack_3DChars  PROC NEAR
                mov     edi,Chr3D
                add     edi,[Rel_Himem]
                mov     esi,CrdChAddr
                add     esi,[Rel_Himem]
                mov     ebx,O Packed3DChr
                mov     cl,17
@@1:
                mov     [esi],edi
                add     esi,4
                movzx   edx,B [ebx]
                inc     ebx
                mov     [edi],edx
                add     edi,4
                lea     edx,[edx+edx*2]
@@2:
                movsx   eax,B [ebx]
                inc     ebx
                shl     eax,10h
                mov     [edi],eax
                add     edi,4
                dec     edx
                jnz     @@2
                movzx   edx,B [ebx]
                inc     ebx
                mov     [edi],edx
                add     edi,4
                lea     edx,[edx+edx*2]
@@3:
                mov     eax,[ebx]
                add     ebx,4
                mov     [edi],eax
                add     edi,4
                dec     edx
                jnz     @@3
                movzx   edx,B [ebx]
                inc     ebx
                mov     [edi],edx
                add     edi,4
                shl     edx,2
@@4:
                movzx   eax,B [ebx]
                inc     ebx
                mov     [edi],eax
                add     edi,4
                dec     edx
                jnz     @@4
                dec     cl
                jnz     @@1
                ret
UnPack_3DChars  ENDP

UnPack_Sprites  PROC NEAR
                mov     edi,CrdSprUP
                add     edi,[Rel_Himem]
                mov     esi,O CrdSprt
                mov     cl,5
@@1:
                mov     dl,10
@@2:
                mov     ch,1
                mov     dh,96
@@3:
                dec     ch
                jnz     @@4
                lodsb
                mov     ch,8
@@4:
                shl     al,1
                mov     ah,4
                jnc     @@5
                mov     ah,[@@Color]
@@5:
                mov     [edi],ah
                inc     edi
                dec     dh
                jnz     @@3
                dec     dl
                jnz     @@2
                inc     [@@Color]
                dec     cl
                jnz     @@1
                ret
@@Color db 5
UnPack_Sprites  ENDP

protseg ENDS
;------------------------------------------------------------------------------
ES_Seg  SEGMENT PUBLIC USE16
ASSUME cs:ES_Seg, ds:ES_Seg
;############################################################################
;#                                                                          #
;#                         E N D S C R O L L                                #
;#                                                                          #
;############################################################################
;
; Memory requrements: 50kB LoMem+the Tracer's
;
; Notes:
;   Inkabb magyarul. A 'Use_Himem' valtozoban van az elso hasznalhato
;   szegmens cime. Innentol hasznalok kb 50kB-ot, a tobbi szabad.
;   A tracert a 'jmp @@aaaa' helyett kell bepakolni.
;   Hasznalom a 0,1,2,3-as szineket. (border&bkg, chr,chr,frame).
;   A 'Start_EndScroll'-ban van a szinbealitas.
;   A rutin ESC-re kilep.
;   Ha szet akarod huzni a kepernyot fuggolegesen, a 'Start_EndScroll'-ban
;   vedd ki a megjegyzesbol.
;   Tel.:(79)322-788
;
;
PUBLIC EndScroll
;------------------------------------------------------------------------------
EXTRN ESCharSet :DATAPTR
;------------------------------------------------------------------------------
                                ; Length

BigChars        EQU 0                   ; 76*8*16=9728
ScrollBuf       EQU BigChars+9728       ; 100*200*2=40000
;------------------------------------------------------------------------------
Use_Lomem               dw ?
ESText          db 10 Dup(CR)
                db '       - PIED -',CR
                db CR,CR
                db 'This was a',CR
                db 'contribution for',CR
                db 'Assembly''95',CR
                db '64k intro compo',CR
                db 'from AbaddoN.',CR
                db CR
                db 'Credits        ',CR
                db '  Code:',CR
                db '        Ervin   ',CR
                db '        G.O.D.  ',CR
                db '        Perla   ',CR
                db '        TomCat  ',CR
                db '  Gfx:',CR
                db '        Tuske',CR
                db '        Ninja',CR
                db '  Additional gfx:',CR
                db '       G.O.D.',CR
                db '  Muzic:',CR
                db '       Diamond ',CR
                db CR
                db ' (C)opyright   ',CR
                db '  AbaddoN 1995.',CR
                db CR,CR
                db 0feh
                db 'Best regards to:',CR
                db CR
                db ' @',CR
                db ' Acme',CR
                db ' Analogue',CR
                db ' Cascada',CR
                db '  VR Section',CR
                db ' Complex',CR
                db '  Media Labs.',CR
                db ' Dust',CR
                db ' EMF',CR
                db ' Flatline Prod.',CR
                db ' Future Crew 252.',CR
                db ' Gollum',CR
                db ' Iguana',CR
                db ' Impact Studios',CR
                db ' Imphobia',CR
                db ' Inertia',CR
                db ' Jeskola!Prod.',CR
                db ' Legend Design',CR
                db ' Logic Design',CR
                db ' Nooon',CR
                db ' Orange',CR
                db ' Prime',CR
		db ' Technomancer',CR
                db ' Tran',CR
                db ' Triton',CR
                db ' Sahara Surfers',CR
                db ' Sonic PC',CR
                db ' Surprise!Prod.',CR
                db ' Twilight Zone',CR
                db ' Valhalla',CR
                db ' VLA',CR
                db ' Xograpy',CR
                db ' Absolute!',CR
                db ' Astroidea',CR
                db ' Biohazard',CR
                db ' Byteam',CR
                db ' Daemons',CR
                db ' Impulse',CR
                db ' gRiF',CR
                db ' Majic 12',CR
                db ' Murmidones',CR
                db ' Remal',CR
                db ' Shock!',CR
                db ' Therapy',CR
                db ' N.O.A',CR
                db CR
                db 'And greetings to',CR
                db 'everybody at',CR
                db 'Assembly''95.',CR
                db CR
                db 'Personal greets:',CR
                db 'From G.O.D.:   ',CR
                db ' Andrew',CR
                db ' Cyberdancer',CR
                db ' Deity',CR
                db ' ERN0',CR
                db ' Greg',CR
                db ' Maxwood',CR
                db ' Nicke',CR
                db ' Stinyo',CR
                db ' Tixi',CR
                db ' TGFX',CR
                db ' TRS',CR
                db ' Valentine',CR
                db ' All We''Kings',CR
                db ' over the world',CR
                db ' And all',CR
                db '  my friends.',CR
                db '               ',CR,CR,CR
		db ' Sorry for the',CR
		db ' greeting list',CR
		db ' Final version',CR
		db ' coming soon!',CR
		db '',CR
                db 0feh
                db 15 Dup(CR)
                db 0ffh
ESChrConv               db  0,38, 0, 0, 0, 0,42,47,43,44, 0, 0,40,45,39,46
                ;      !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /
                db 27,28,29,30,31,32,33,34,35,36,37,48, 0, 0, 0,41,75
                ;   0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @
                db  1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17
                ;   A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q
                db 18,19,20,21,22,23,24,25,26, 0, 0, 0, 0, 0, 0
                ;   R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `
                db 49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65
                ;   a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q
                db 66,67,68,69,70,71,72,73,74, 0, 0, 0, 0
                ;   r  s  t  u  v  w  x  y  z  {  |  }

ESChrWdt                db  5, 7, 7, 7, 7, 7, 8, 4, 4, 4, 7, 7, 3, 6, 3, 6
                ;      !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /
                db  7, 5, 6, 6, 6, 6, 6, 6, 7, 6, 3, 3, 7, 7, 7, 6, 8
                ;   0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @
                db  7, 7, 6, 7, 6, 6, 7, 7, 3, 6, 7, 6, 7, 6, 7, 6, 7
                ;   A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q
                db  6, 6, 7, 7, 7, 8, 7, 7, 6, 7, 7, 7, 7, 7, 7
                ;   R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `
                db  6, 5, 5, 6, 5, 5, 6, 6, 3, 5, 6, 5, 7, 6, 6, 5, 6
                ;   a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q
                db  5, 5, 7, 6, 6, 8, 6, 7, 6, 7, 7, 7, 7
                ;   r  s  t  u  v  w  x  y  z  {  |  }

;------------------------------------------------------------------------------
EndScroll               PROC FAR

                sti
                cld
                mov     bx,cs
                mov     ds,bx
                mov     [Use_Lomem],ax

                xor     ax,ax
                mov     es,ax
                mov     [StackPointer],sp
                mov     [StackSegment],ss
                mov     eax,es:[24h]
                mov     [Old_KIRQ],eax
                mov     ax,cs
                shl     eax,10h
                mov     ax,O RealKeyIRQ
                mov     es:[24h],eax
                call    Start_EndScroll
                mov     ax,0a000h
                mov     es,ax
                mov     di,320*24+20
                mov     eax,02020202h
                mov     dl,144
@@Make_Frame1:
                mov     cx,152/4
        rep     stosd
                add     di,320-152
                dec     dl
                jnz     @@Make_Frame1
                mov     di,320*(24+8)+172
                mov     eax,03030303h
                mov     dl,144-8
@@Make_Frame2:
                stosd
                stosd
                stosd
                add     di,320-12
                dec     dl
                jnz     @@Make_Frame2
                mov     di,320*(24+144)+32
                mov     dl,8
@@Make_Frame3:
                mov     cx,152/4
        rep     stosd
                add     di,320-152
                dec     dl
                jnz     @@Make_Frame3

;               mov     di,320*24+20+320*6+8
;               xor     eax,eax
;               mov     dl,144-2*6
;@@Make_Frame4:
;               mov     cx,(152-2*8)/4
;       rep     stosd
;               add     di,320-152+2*8
;               dec     dl
;               jnz     @@Make_Frame4

		push	cs
		pop	ds

		cld
		mov	dx,03c8h
		mov	al,4
		out	dx,al
		inc	dx
		mov	si,o spidpal+4*3
		mov	cx,768-3*4
	rep	outsb

		mov	si,o spidmap
		mov	cl,132
		mov	di,9628
@@kcl:
		mov	ch,136/8
@@aaaa:
		mov	dx,03dah
@@rv1:
		in	al,dx
		test	al,8
		jne	@@rv1
@@rv2:
		in	al,dx
		test	al,8
		je	@@rv2

		movsd
		movsd
		dec	ch
		jne	@@aaaa
		add	di,320-136
		loop	@@kcl

		jmp	$

spidpal:
include		spidpal.inc
spidmap:
include		spidmap.inc

EndEndScroll:
                call    Stop_EndScroll
                cli
                xor     ax,ax
                mov     es,ax
                mov     eax,[Old_KIRQ]
                mov     es:[24h],eax
                sti
                mov     bx,0ffffh
                ret

ES_RasterCnt    dw ?
Old_TIRQ                dd ?
Old_KIRQ                dd ?
StackPointer    dw ?
StackSegment    dw ?
EndScroll               ENDP
;------------------------------------------------------------------------------
Start_EndScroll PROC NEAR

; Unpack charset & clear scroll-buffer

                cld
                mov     es,[Use_Lomem]
                mov     di,BigChars
                xor     eax,eax
                mov     cx,32
        rep     stosd
                mov     si,O ESCharSet
                mov     dl,75
@@0:
                mov     ch,3
@@1:
                mov     cl,6
@@2:
                mov     ah,7
@@3:
                mov     bl,[si]
                shr     bl,cl
                mov     al,bl
                and     al,3
                stosb
                add     si,3
                dec     ah
                jnz     @@3
                mov     al,0
                stosb
                sub     si,21
                dec     cl
                dec     cl
                jns     @@2
                inc     si
                dec     ch
                jnz     @@1
                xor     eax,eax
                mov     cx,8
        rep     stosd
                add     si,18
                dec     dl
                jnz     @@0

                mov     di,ScrollBuf
                mov     [Scroll_Pos],di
                mov     cx,40000/4
        rep     stosd

; Setting video mode 13h.
                call    RRaster
                mov     dx,3c8h ; Make black screen
                mov     al,0
                out     dx,al
                inc     dx
                mov     cx,300h
@@SVM1:
                out     dx,al
                loop    @@SVM1

                call    RRaster
                mov     ax,0a000h
                mov     es,ax
                xor     di,di
                xor     eax,eax
                mov     cx,65536/4
        rep     stosd

                call    RRaster
                mov     ax,13h  ; Set video mode
                int     10h             ;;;

                ;mov    dx,3c2h         ; A kepernyo szethuzasa.
                ;mov    al,0a3h
                ;out    dx,al

                call    RRaster
                mov     dx,3c8h ; Make black screen
                mov     al,0
                out     dx,al
                inc     dx
                mov     cx,300h
@@SVM2:
                out     dx,al
                loop    @@SVM2

; Measure raster-time.
                mov     bp,150
                ;mov    bp,250
                cli
                mov     dx,3dah
                xor     si,si
                mov     ah,0
@@Ras1:
                in      al,dx   ; waiting a raster retrace
                test    al,8
                jnz     @@Ras1
@@Ras2:
                in      al,dx
                test    al,8
                jz      @@Ras2
                mov     al,30h  ; reset TIMER
                out     43h,al
                jmp     $+2
                mov     al,ah
                out     40h,al
                jmp     $+2
                out     40h,al
@@Ras3:
                in      al,dx   ; waiting the other 'bp'
                test    al,1    ; horizontal raster retrace
                jnz     @@Ras3
@@Ras4:
                in      al,dx
                test    al,1
                jz      @@Ras4
                inc     si
                cmp     si,bp
                jc      @@Ras3
                mov     al,ah
                out     43h,al
                jmp     $+2
                in      al,40h
                mov     ah,al
                in      al,40h
                xchg    al,ah
                neg     ax      ; get the TIMER's register
                mov     [ES_RasterCnt],ax
                xor     ax,ax   ; Set RasterIRQ
                mov     es,ax
                mov     eax,es:[20h]
                mov     [Old_TIRQ],eax
                mov     ax,cs
                shl     eax,10h
                mov     ax,O EndScroll_IRQ
                mov     es:[20h],eax
                sti
                mov     ax,9ffh ; Set handy DMA-buffer filling.
                call    amp_entry

                mov     dx,3c8h
                mov     al,0
                out     dx,al
                inc     dx
                mov     al,11
                out     dx,al
                mov     al,0
                out     dx,al
                mov     al,5
                out     dx,al
                mov     al,63
                out     dx,al
                out     dx,al
                out     dx,al
                mov     al,47
                out     dx,al
                out     dx,al
                out     dx,al
                mov     al,5
                out     dx,al
                mov     al,0
                out     dx,al
                mov     al,2
                out     dx,al

                ret
Start_EndScroll ENDP
;------------------------------------------------------------------------------
Stop_EndScroll  PROC NEAR

                cli
                xor     ax,ax
                mov     es,ax
                mov     eax,[Old_TIRQ]
                mov     es:[20h],eax
                mov     al,34h
                out     43h,al
                jmp     $+2
                mov     al,0
                out     40h,al
                jmp     $+2
                out     40h,al
                in      al,21h
                and     al,NOT 1
                out     21h,al
                sti
                mov     ax,9ffh
                call    amp_entry
                ret
Stop_EndScroll  ENDP
;------------------------------------------------------------------------------
RRaster         PROC NEAR
; Waiting for raster retrace.
; User reg.: ax, dx

                mov     dx,3dah
@@Raster1:
                in      al,dx
                and     al,8
                jnz     @@Raster1
@@Raster2:
                in      al,dx
                and     al,8
                jz      @@Raster2
                ret

RRaster         ENDP
;------------------------------------------------------------------------------
EndScroll_IRQ   PROC FAR

                pushad
                in      al,21h
                or      al,1
                out     21h,al
                push    ds es
                mov     ax,cs
                mov     ds,ax
                mov     ax,0a000h
                mov     es,ax
                mov     al,20h
                out     20h,al
                sti

                ;mov    dx,3c8h
                ;mov    al,0
                ;out    dx,al
                ;inc    dl
                ;mov    al,3fh
                ;out    dx,al
                ;mov    al,0
                ;out    dx,al
                ;out    dx,al

                mov     al,[ESScrSpeed]
                xor     [Odd],al
                jnz     @@Even
                call    NewScrollLine
@@Even:
                mov     dx,3dah
                mov     si,[Scroll_Pos]
                mov     di,[@@Scr_Addr]
                mov     bp,320-100
                mov     bx,[@@Scroll_Hgt]
                mov     ds,[Use_Lomem]
                cld
@@Put_Scroll:
                mov     cx,100/4
        rep     movsd
                add     di,bp
                mov     cx,100/4
        rep     movsd
                add     di,bp
                mov     cx,100/4
        rep     movsd
                add     di,bp
                mov     cx,100/4
        rep     movsd
                add     di,bp
                in      al,dx
                test    al,8
                jnz     @@End_Of_Scroll
                dec     bx
                jnz     @@Put_Scroll
                xor     bp,bp
@@Vert_Retr:
                in      al,dx
                test    al,8
                jz      @@Vert_Retr

@@End_Of_Scroll:
                mov     ax,cs
                mov     ds,ax

                mov     ah,7
                call    amp_entry
                pushf
                adc     [@@CantFill],0
                popf
                mov     ax,0
                mov     cl,[@@CantFill]
                rcl     ax,cl
                add     bx,ax

                ;test   bx,bx
                jz      @@AllRight
                dec     [@@Less_Cnt]
                jnz     @@NoLessLine
                mov     bp,[@@Scroll_Hgt]
                mov     [@@Less_Ind],0ffh
                cmp     bx,5
                ja      @@Many
                dec     [@@Scroll_Hgt]
                jmp     @@AllRight
@@Many:
                sub     bx,5
                sub     [@@Scroll_Hgt],bx
@@AllRight:
                mov     [@@Less_Cnt],2
@@NoLessLine:
                cmp     [@@Less_Ind],0
                je      @@FinishIt
                mov     [@@Less_Ind],0
                cmp     [@@Scroll_Hgt],0
                jg      @@ThereisScroll
                mov     ah,4
                call    amp_entry
                mov     [@@Scroll_Hgt],200/4
                mov     [@@Scr_Addr],208
                mov     dx,3dah
@@Vert_Retr2:
                in      al,dx
                test    al,8
                jz      @@Vert_Retr2
                jmp     @@FinishIt
@@ThereisScroll:
                mov     ax,[@@Scroll_Hgt]
                shl     ax,2
                neg     ax
                add     ax,200
                shr     ax,1
                movzx   eax,ax
                lea     bx,[eax+eax*4]
                shl     bx,6
                add     bx,208
                xor     eax,eax
                mov     di,[@@Scr_Addr]
@@KillTop:
                cmp     di,bx
                jae     @@KillTopOK
                mov     cx,100/4
        rep     stosd
                add     di,320-100
                jmp     @@KillTop
@@KillTopOK:
                mov     [@@Scr_Addr],bx
                movzx   eax,W [@@Scroll_Hgt]
                sub     bp,ax
                lea     di,[eax+eax*4]
                shl     di,8
                add     di,[@@Scr_Addr]
                xor     eax,eax
                test    bp,bp
                jz      @@KillBottomOK
@@KillBottom:
                mov     cx,100/4
        rep     stosd
                add     di,320-100
                mov     cx,100/4
        rep     stosd
                add     di,320-100
                dec     bp
                jnz     @@KillBottom
@@KillBottomOK:

@@FinishIt:
                ;mov    dx,3c8h
                ;mov    al,0
                ;out    dx,al
                ;inc    dl
                ;mov    al,0
                ;out    dx,al
                ;out    dx,al
                ;out    dx,al

                mov     al,30h
                out     43h,al  ; the set the TIMER
                jmp     $+2
                mov     ax,[ES_RasterCnt]
                out     40h,al
                jmp     $+2
                mov     al,ah
                out     40h,al

                pop     es
                pop     ds
                cli
                in      al,21h
                and     al,NOT 1
                out     21h,al
                popad
                iret

@@Scr_Addr      dw 208
Scroll_Pos      dw 0
@@Scroll_Hgt    dw 200/4
@@Less_Ind      db 0
@@Less_Cnt      db 3
@@CantFill      db 0
ESScrSpeed      db 0ffh
Odd             db 0

EndScroll_IRQ   ENDP
;------------------------------------------------------------------------------
NewScrollLine   PROC NEAR

                push    fs
                mov     fs,[Use_Lomem]
                dec     [@@Scroll_Cnt]
                jnz     @@NoNewText
                mov     [@@Scroll_Cnt],15
                mov     bx,O @@CurrLine
                mov     bp,BigChars
                mov     si,[@@ESTextPos]
@@NewChar:
                mov     al,[si]
                cmp     al,0ffh
                jne     @@NoEnd
                mov     si,O ESText
                mov     al,[si]
@@NoEnd:
                inc     si
                cmp     al,CR
                je      @@EOL
                cmp     al,0feh
                jne     @@NoToggle
                xor     [ESScrSpeed],0ffh
                mov     [Odd],0
                jmp     @@NewChar
@@NoToggle:
                mov     ah,0
                sub     al,20h
                mov     di,O ESChrConv
                add     di,ax
                mov     ah,[di]
                mov     al,0
                shr     ax,1
                mov     [bx],ax
                mov     al,[di+O ESChrWdt-O ESChrConv]
                mov     [bx+2],al
                add     bx,4
                jmp     @@NewChar
@@EOL:
                mov     [@@ESTextPos],si
                mov     W [bx],0ffffh
@@NoNewText:
                xor     dx,dx
                mov     bx,O @@CurrLine
                mov     di,[Scroll_Pos]
                mov     bp,4
@@PutLine:
                mov     si,[bx]
                cmp     si,0ffffh
                je      @@Fillin
                add     W [bx],8
                mov     cl,[bx+2]
                add     bx,bp
@@1:
                mov     eax,fs:[si]
                test    cl,11111100b
                jz      @@Remain
                mov     fs:[di],eax
                mov     fs:[di+200*100],eax
                add     di,bp
                add     si,bp
                add     dx,bp
                sub     cl,4
                jmp     @@1
@@Remain:
                test    cl,cl
                jz      @@PutLine
@@Remain2:
                mov     fs:[di],al
                mov     fs:[di+200*100],al
                inc     dx
                inc     di
                shr     eax,8
                dec     cl
                jnz     @@Remain2
                jmp     @@PutLine
@@Fillin:
                cmp     dx,100
                jae     @@Filled
                mov     B fs:[di],0
                mov     B fs:[di+200*100],0
                inc     dx
                inc     di
                jmp     @@Fillin
@@Filled:
                add     [Scroll_Pos],100
                cmp     [Scroll_Pos],200*100+ScrollBuf
                jb      @@Huh
                mov     [Scroll_Pos],ScrollBuf
@@Huh:
                pop     fs
                ret
@@Scroll_Cnt    db 1
@@ESTextPos     dw O ESText
@@CurrLine      dd 25 Dup(0)
NewScrollLine   ENDP

RealKeyIRQ      PROC FAR
                push    ax
                in      al,60h
                cmp     al,1
                jne     @@1
                mov     ax,cs
                mov     ds,ax
                mov     sp,[StackPointer]
                mov     ss,[StackSegment]
                mov     al,20h
                out     20h,al
                jmp     EndEndScroll
@@1:
                mov     al,20h
                out     20h,al
                pop     ax
                iret
RealKeyIRQ      ENDP
;------------------------------------------------------------------------------
ES_Seg  ENDS
END
