; ADATOK:
; -------
; A sugr (flegyenes)
;                          _
;       - kiindul pontja: P = (Px,Py,Pz)
;                 _
;       - irnya: D = (Dx,Dy,Dz)  <--  egysgnyi vektor
; 
; A gmb
;                      _
;       - kzppontja: C = (Cx,Cy,Cz)
; 
;       - sugara: r
;
; SZMOLS:
; ---------
; A tvolsg (t)
; 
;       r2 = r * r      <-- init0
;       _   _   _
;       V = C - P
;           _   _           _     _
;       b = V . D      <--  V dot D
; 
; s
;                   _   _
;       d = b * b - V . V + r2
; 
;       t = b +/- sqrt(d), ha d >= 0
;
; vagy
;              _   _
;       V2 = - V . V + r2      <-- init
; 
;       d = b * b + V2
; 
;       t = b +/- sqrt(d), ha d >= 0
;                _
; A metszspont (M)
;       _   _       _
;       M = P + t * D, ha t > 0
; 
;       azaz
;       _
;       M = (Px + t * Dx, Py + t * Dy, Pz + t * Dz), ha t > 0
; ___________________________________________________________________________

SphereType      STRUC
                Object<>
Center          Vector<>
Radius          DQ      ?
Radius2         DQ      ?
CsubP           Vector<>
CsubP2          DQ      ?
ENDS

Sphere          MACRO   _Cx,_Cy,_Cz,_R,_Texture:REQ,_Next

                ObjectInit Sphere,_Texture,_Next

                Vector<_Cx,_Cy,_Cz>
                DQ      _R
                DQ      ?
                Vector<>
                DQ      ?
ENDM

SphereInitO:
                FLD     Plus1            ;; 1
                FLD     [SI.Radius]      ;; R  1
                FDIV    ST(1),ST         ;; R  1/R
                FMUL    ST,ST            ;; R*R  1/R
                FXCH                     ;; 1/R  R*R
                FSTP    [SI.Radius]      ;; R*R
                FSTP    [SI.Radius2]
                NextInitO

SphereInitF:
                VNSUB   SI.Center,BX.EyePos
                VST     SI.CsubP
                VLD
                VDOT
                FCHS
                FADD    [SI.Radius2]
                FSTP    [SI.CsubP2]
                NextInitF

SphereFirst:
                VDOT    SI.CsubP,Direction      ; b
                FLD     ST                      ; b  b
                FMUL    ST,ST(1)                ; b*b  b
                FADD    [SI.CsubP2]             ; d  b
                FTST
                FNSTSW  AX
                SAHF
                JBE     @@2
                FSQRT                           ; d  b
                FLD     ST(1)                   ; b  d  b
                FXCH                            ; d  b  b
                FADD    ST(2),ST                ; d  b  b+d
                FSUBP   ST(1),ST                ; b-d  b+d
                FCOM    Distance
                FNSTSW  AX
                SAHF
                JAE     @@2
                FCOM    Epsilon
                FXCH                            ; b+d  b-d
                FNSTSW  AX
                SAHF
                JA      @@1
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@2
                FCOM    Distance
                FXCH                            ; b-d  b+d
                FNSTSW  AX
                SAHF
                JAE     @@2
@@1:
                MOV     BX,SI
                MOV     SI,[SI.NextO]
                FSTP    Trash                   ; t
                FSTP    Distance
                CMP     SI,FirstO
                JE      LastFirst
                JMP     O [SI.First]
@@2:
                NextFirst 2

SphereShade:
                FLD     [SI.Center.X]   ; CX
                FSUB    [Position.X]    ; CX-PX
                FLD     [SI.Center.Y]   ; CY  CX-PX
                FSUB    [Position.Y]    ; CY-PY  CX-PX
                FLD     [SI.Center.Z]   ; CZ  CY-PY  CX-PX
                FSUB    [Position.Z]    ; CZ-PZ  CY-PY  CX-PX
                FLD     [Shadow.X]      ; DX  VZ  VY  VX
                FMUL    ST,ST(3)        ; DX*VX  VZ  VY  VX
                FLD     [Shadow.Y]      ; DY  DX*VX  VZ  VY  VX
                FMUL    ST,ST(3)        ; DY*VY  DX*VX  VZ  VY  VX
                FLD     [Shadow.Z]      ; DZ  DY*VY  DX*VX  VZ  VY  VX
                FMUL    ST,ST(3)        ; DZ*VZ  DY*VY  DX*VX  VZ  VY  VX
                FXCH    ST(2)           ; DX*VX  DY*VY  DZ*VZ  VZ  VY  VX
                FADDP                   ; DX*VX+DY*VY  DZ*VZ  VZ  VY  VX
                FLD     ST(2)           ; VZ  DX*VX+DY*VY  DZ*VZ  VZ  VY  VX
                FMULP   ST(3)           ; DX*VX+DY*VY  DZ*VZ  VZ*VZ  VY  VX
                FADDP                   ; DX*VX+DY*VY+DZ*VZ  VZ*VZ  VY  VX
                FLD     ST(2)           ; VY  DX*VX+DY*VY+DZ*VZ  VZ*VZ  VY  VX
                FMULP   ST(3)           ; DX*VX+DY*VY+DZ*VZ  VZ*VZ  VY*VY  VX
                FLD     ST              ; b  b  VZ*VZ  VY*VY  VX
                FXCH    ST(4)           ; VX  b  VZ*VZ  VY*VY  b
                FMUL    ST,ST           ; VX*VX  b  VZ*VZ  VY*VY  b
                FADDP   ST(2),ST        ; b  VX*VX+VZ*VZ  VY*VY  b
                FMUL    ST,ST           ; b*b  VX*VX+VZ*VZ  VY*VY  b
                FSUBRP  ST(1),ST        ; b*b-VX*VX-VZ*VZ  VY*VY  b
                FSUBRP  ST(1),ST        ; b*b-VX*VX-VY*VY-VZ*VZ  b
                FADD    [SI.Radius2]    ; b*b-VX*VX-VY*VY-VZ*VZ+r*r  b
                FTST
                FNSTSW  AX
                SAHF
                JBE     @@2
                FSQRT                   ; d  b
                FLD     ST(1)           ; b  d  b
                FADD    ST,ST(1)        ; b+d  d  b
                FXCH                    ; d  b+d  b
                FSUBP   ST(2),ST        ; b+d  b-d
                FCOM    Epsilon
                FXCH                    ; b-d  b+d
                FNSTSW  AX
                SAHF
                JBE     @@2
                FCOM    Distance
                FXCH                    ; b+d  b-d
                FNSTSW  AX
                SAHF
                JAE     @@2
                CALL    O [SI.Texture]
                FLD     [DI.Transmit]   ; T  b+d  b-d
                FTST
                FXCH    ST(2)           ; b-d  b+d  T
                FNSTSW  AX
                SAHF
                JNZ     @@0
                MOV     [BX.Cache],SI
                FSTP    Trash           ; b+d  0
                FSTP    Trash           ; 0
                RETN
@@0:
                FCOM    Epsilon
                FXCH                    ; b+d  b-d  T
                FNSTSW  AX
                SAHF
                JBE     @@1
                FCOM    Distance
                FXCH    ST(2)           ; T  b-d  b+d
                FNSTSW  AX
                SAHF
                JAE     @@1
                FMUL    ST,ST           ; T*T  b-d  b+d
@@1:
                FMUL    Trans           ; P*TT  b-d  b+d
                FSTP    Trans           ; b-d  b+d
@@2:
                NextShade 2

SphereIsect:
                FLD     [SI.Center.X]   ; CX
                FSUB    [Position.X]    ; CX-PX
                FLD     [SI.Center.Y]   ; CY  CX-PX
                FSUB    [Position.Y]    ; CY-PY  CX-PX
                FLD     [SI.Center.Z]   ; CZ  CY-PY  CX-PX
                FSUB    [Position.Z]    ; CZ-PZ  CY-PY  CX-PX
                FLD     [Direction.X]   ; DX  VZ  VY  VX
                FMUL    ST,ST(3)        ; DX*VX  VZ  VY  VX
                FLD     [Direction.Y]   ; DY  DX*VX  VZ  VY  VX
                FMUL    ST,ST(3)        ; DY*VY  DX*VX  VZ  VY  VX
                FLD     [Direction.Z]   ; DZ  DY*VY  DX*VX  VZ  VY  VX
                FMUL    ST,ST(3)        ; DZ*VZ  DY*VY  DX*VX  VZ  VY  VX
                FXCH    ST(2)           ; DX*VX  DY*VY  DZ*VZ  VZ  VY  VX
                FADDP                   ; DX*VX+DY*VY  DZ*VZ  VZ  VY  VX
                FLD     ST(2)           ; VZ  DX*VX+DY*VY  DZ*VZ  VZ  VY  VX
                FMULP   ST(3)           ; DX*VX+DY*VY  DZ*VZ  VZ*VZ  VY  VX
                FADDP                   ; DX*VX+DY*VY+DZ*VZ  VZ*VZ  VY  VX
                FLD     ST(2)           ; VY  DX*VX+DY*VY+DZ*VZ  VZ*VZ  VY  VX
                FMULP   ST(3)           ; DX*VX+DY*VY+DZ*VZ  VZ*VZ  VY*VY  VX
                FLD     ST              ; b  b  VZ*VZ  VY*VY  VX
                FXCH    ST(4)           ; VX  b  VZ*VZ  VY*VY  b
                FMUL    ST,ST           ; VX*VX  b  VZ*VZ  VY*VY  b
                FADDP   ST(2),ST        ; b  VX*VX+VZ*VZ  VY*VY  b
                FMUL    ST,ST           ; b*b  VX*VX+VZ*VZ  VY*VY  b
                FSUBRP  ST(1),ST        ; b*b-VX*VX-VZ*VZ  VY*VY  b
                FSUBRP  ST(1),ST        ; b*b-VX*VX-VY*VY-VZ*VZ  b
                FADD    [SI.Radius2]    ; b*b-VX*VX-VY*VY-VZ*VZ+r*r  b
                FTST
                FNSTSW  AX
                SAHF
                JBE     @@2
                FSQRT                           ; d  b
                FLD     ST(1)                   ; b  d  b
                FXCH                            ; d  b  b
                FADD    ST(2),ST                ; d  b  b+d
                FSUBP   ST(1),ST                ; b-d  b+d
                FCOM    Distance
                FNSTSW  AX
                SAHF
                JAE     @@2
                FCOM    Epsilon
                FXCH                            ; b+d  b-d
                FNSTSW  AX
                SAHF
                JA      @@1
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@2
                FCOM    Distance
                FXCH                            ; b-d  b+d
                FNSTSW  AX
                SAHF
                JAE     @@2
@@1:
                MOV     BX,SI
                MOV     SI,[SI.NextO]
                FSTP    Trash                   ; t
                FSTP    Distance
                CMP     SI,FirstO
                JE      LastIsect
                JMP     O [SI.Isect]
@@2:
                NextIsect 2

SphereNorml:
                VNSUB   Position,BX.Center
                VMULFR  BX.Radius
                RETN
