.386P
        JUMPS
        LOCALS

Code16  SEGMENT PAGE USE16
        ASSUME CS:Code16,DS:Code16

PlusMem = 0

B       EQU     BYTE PTR
W       EQU     WORD PTR
D       EQU     DWORD PTR
Q       EQU     QWORD PTR
F       EQU     FWORD PTR
O       EQU     OFFSET

INCLUDE MACRODEF.LIB

        ORG     100H

Start:          JMP     Init
;                INC     AX
;                INT     10H
                MOV     AX,202H
                MOV     BH,0
                MOV     DX,25*256
                INT     10H
                CLI
                XOR     AX,AX
                MOV     DS,AX
                MOV     DI,O Interupts
                MOV     SI,8*4
                MOVSW
                MOVSW
                MOVSW
                MOVSW
                MOV     W [SI-8],O INT8
                MOV     [SI-6],CS
                MOV     W [SI-4],O INT9
                MOV     [SI-2],CS
                PUSH    CS
                POP     DS
                FNINIT
                LEA     SP,$
                STI
                JMP     Proggi
SZ=288
MA=102
DARAB=7

;PlusMem=640*240*3+SZ*MA*3

INCLUDE VECTMATH.LIB                    ; Lineris algebra makri
INCLUDE VGA.INC

OneL:
Ang3:
Cam2:
;..............................................................................
INCLUDE TEXTURES.LIB

CameraType      STRUC
From            Vector<>
At              Vector<>
Up              Vector<>
Angle           DQ      ?
ENDS

Camera          MACRO   _Fx,_Fy,_Fz,_Ax,_Ay,_Az,_Ux,_Uy,_Uz,_A
        IFB <_Fx>
                Vector<0.0,0.0,-1.0>
                Vector<0.0,0.0,0.0>
                Vector<0.0,1.0,0.0>
                DQ      45.0
        ELSE
                Vector<_Fx,_Fy,_Fz>
         IFB <_Ax>
                Vector<0.0,0.0,0.0>
         ELSE
                Vector<_Ax,_Ay,_Az>
         ENDIF
         IFB <_Ux>
                Vector<0.0,1.0,0.0>
         ELSE
                Vector<_Ux,_Uy,_Uz>
         ENDIF
         IFB <_A>
                DQ      45.0
         ELSE
                DQ      _A
         ENDIF
        ENDIF
ENDM

ShootType       STRUC
ResX            DW      320
ResY            DW      160
MinX            DW      0
MaxX            DW      320
MinY            DW      0
MaxY            DW      160
EyePos          Vector<>
EyeRay          Vector<>
XAdder          Vector<>
YAdder          Vector<>
ENDS

Shoot MACRO _RX,_RY:REQ,_IX,_AX,_IY,_AY,_PX,_PY,_PZ,_DX,_DY,_DZ,_XX,_XY,_XZ,_YX,_YY,_YZ

                DW      _RX
                DW      _RY
        IFB <_IX>
                DW      0
                DW      _RX
        ELSE
                DW      _IX
                DW      _AX
        ENDIF
        IFB <_IY>
                DW      0
                DW      _RY
        ELSE
                DW      _IY
                DW      _AY
        ENDIF
        IFB <_PX>
                Vector<>
        ELSE
                Vector<_PX,_PY,_PZ>
        ENDIF
        IFB <_DX>
                Vector<>
                Vector<>
                Vector<>
        ELSE
                Vector<_DX,_DY,_DZ>
                Vector<_XX,_XY,_XZ>
                Vector<_YX,_YY,_YZ>
        ENDIF
ENDM

LightType       STRUC
Pos             Vector<>
Col             Vector<>
ENDS

Light           MACRO   _Px,_Py,_Pz,_Cr,_Cg,_Cb

        IFB <_Px>
                Vector<0.0,10.0,-10.0>
                Vector<1.0,1.0,1.0>
        ELSE
                Vector<_Px,_Py,_Pz>
         IFB <_Cr>
                Vector<1.0,1.0,1.0>
         ELSE
                Vector<_Cr,_Cg,_Cb>
         ENDIF
        ENDIF
ENDM

RTConstants     MACRO
                VCONST
Epsilon         DD      0.0005
Minus1          DD      -1.0
Minus2          DD      -2.0
MaxColor        DD      255.0
ENDM

RTVariables     MACRO
Position        Vector<>
Direction       Vector<>
Normal          Vector<>
Shadow          Vector<>
Collect         Vector<>
Distance        DQ      ?
Dot             DQ      ?
Trash           DQ      ?
Trans           DQ      ?
        IFNDEF OneL
FirstL          DW      ?
LastL           DW      ?
        ENDIF
FirstO          DW      ?
Integer1        DW      ?
Integer2        DW      ?
Integer3        DW      ?
ENDM

Object          STRUC
NextO           DW      ?
InitO           DW      ?
InitF           DW      ?
First           DW      ?
Shade           DW      ?
Isect           DW      ?
Norml           DW      ?
Texture         DW      ?
Cache           DW      ?
Refle           DW      ?
ENDS

ObjectInit      MACRO   _Obj,_Texture:REQ,_Next

        IFB <_Next>
                DW      O $ + SIZE _Obj&Type
        ELSE
                DW      O _Next
        ENDIF
                DW      O _Obj&InitO
                DW      O _Obj&InitF
                DW      O _Obj&First
                DW      O _Obj&Shade
                DW      O _Obj&Isect
                DW      O _Obj&Norml
                DW      O _Texture
                DW      ?
                DW      ?
ENDM


LastShade:
                FLD     Trans
LastInitO:
LastInitF:
LastFirst:
LastIsect:
                RETN

NextInitO       MACRO

                MOV     [SI.Cache],BX
                MOV     [SI.Refle],BX
                MOV     SI,[SI.NextO]
                CMP     SI,BX
                JE      LastInitO
                JMP     O [SI.InitO]
ENDM

NextInitF       MACRO

                MOV     SI,[SI.NextO]
                CMP     SI,FirstO
                JE      LastInitF
                JMP     O [SI.InitF]
ENDM

NextFirst       MACRO   _Rep

                MOV     SI,[SI.NextO]
        IFNB <_Rep>
         REPT _Rep
                FSTP    Trash
         ENDM
        ENDIF
                CMP     SI,FirstO
                JE      LastFirst
                JMP     O [SI.First]
ENDM

NextShade       MACRO   _Rep

                MOV     SI,[SI.NextO]
        IFNB <_Rep>
         REPT _Rep
                FSTP    Trash
         ENDM
        ENDIF
                CMP     SI,FirstO
                JE      LastShade
                JMP     O [SI.Shade]
ENDM

NextIsect       MACRO   _Rep

                MOV     SI,[SI.NextO]
        IFNB <_Rep>
         REPT _Rep
                FSTP    Trash
         ENDM
        ENDIF
                CMP     SI,FirstO
                JE      LastIsect
                JMP     O [SI.Isect]
ENDM

RayTracePic     MACRO   _Pic,_Shoot,_Objects,_Lights

        IFDIFI <_Objects>,<SI>
                MOV     SI,O _Objects
        ENDIF
        IFDIFI <_Lights>,<AX>
         IFNDEF OneL
                MOV     AX,O _Lights
         ENDIF
        ENDIF
        IFDIFI <_Shoot>,<BX>
                MOV     BX,O _Shoot
        ENDIF
        IFDIFI <_Pic>,<DI>
                MOV     DI,O _Pic
                PUSH    CS
                POP     ES
        ENDIF
                CALL    TracingPic
ENDM

TracingPic:
        IFNDEF OneL
                MOV     FirstL,AX
                MOV     LastL,SI
        ENDIF
                MOV     FirstO,SI
                CALL    O [SI.InitF]
                VNLD    BX.EyeRay

                XOR     BP,BP
_TP1:
                XOR     CX,CX
_TP2:
                VSTP    BX.EyeRay
                CMP     CX,[BX.MinX]
                JB      _TP7
                CMP     CX,[BX.MaxX]
                JNB     _TP7
                CMP     BP,[BX.MinY]
                JB      _TP7
                CMP     BP,[BX.MaxY]
                JNB     _TP7
                PUSH    BX
                MOV     SI,FirstO
                VNORM   BX.EyeRay
                FLD     Infinite
                VLD     BX.EyePos
                VSTP    Position
                FSTP    Distance
                VSTP    Direction
                XOR     BX,BX
                CALL    O [SI.First]
                TEST    BX,BX
                JNZ     _TP0
                XCHG    BX,AX
                STOSW
                STOSB
                JMP     _TP6
_TP0:
                PUSH    DI BP
                CALL    Shading
                POP     BP DI

                MOV     FirstO,BX

                VMULF   Collect,MaxColor
                FISTP   Integer1
                FISTP   Integer2
                FISTP   Integer3

                MOV     BX,255
                MOV     AX,Integer3
                CMP     AX,BX
                JBE     _TP3
                MOV     AX,BX
_TP3:
                STOSB
                MOV     AX,Integer2
                CMP     AX,BX
                JBE     _TP4
                MOV     AX,BX
_TP4:
                STOSB
                MOV     AX,Integer1
                CMP     AX,BX
                JBE     _TP5
                MOV     AX,BX
_TP5:
                STOSB
_TP6:
                POP     BX
_TP7:
                INC     CX
                VNADD   BX.EyeRay,BX.XAdder
                CMP     CX,[BX.ResX]
                JB      _TP2
                VNADD   BX.YAdder
                INC     BP
                MOV     DX,DI
                MOV     CX,ES
                SHR     DX,4
                ADD     CX,DX
                AND     DI,15
                MOV     ES,CX
                CMP     BP,[BX.ResY]
                JB      _TP1
                VSTP    BX.EyeRay
                RETN

RayTraceFrame   MACRO   _Pic,_Table,_Count,_Shoot,_Objects,_Lights

        IFDIFI <_Table>,<DX>
                MOV     DX,O _Table
                MOV     BP,CS
        ENDIF
        IFDIFI <_Count>,<CX>
                MOV     CX,_Count
        ENDIF
        IFDIFI <_Objects>,<SI>
                MOV     SI,O _Objects
        ENDIF
        IFDIFI <_Lights>,<AX>
         IFNDEF OneL
                MOV     AX,O _Lights
         ENDIF
        ENDIF
        IFDIFI <_Shoot>,<BX>
                MOV     BX,O _Shoot
        ENDIF
        IFDIFI <_Pic>,<DI>
                MOV     DI,O _Pic
                PUSH    CS
                POP     ES
        ENDIF
                CALL    TracingFrame
ENDM

TracingFrame:
        IFNDEF OneL
                MOV     FirstL,AX
                MOV     LastL,SI
        ENDIF
                MOV     FirstO,SI
                PUSH    DX
                CALL    O [SI.InitF]
                POP     SI
_TF1:
                MOV     DS,BP
                FLD     D [SI+8]
                FLD     D [SI+4]
                FLD     D [SI]
                PUSH    CS
                POP     DS
                PUSH    BX SI
                MOV     SI,FirstO
                FLD     Infinite
                VLD     BX.EyePos
                VSTP    Position
                FSTP    Distance
                VSTP    Direction
                XOR     BX,BX
                CALL    O [SI.First]
                TEST    BX,BX
                JNZ     _TF0
                XCHG    BX,AX
                MOV     Integer1,AX
                MOV     Integer2,AX
                MOV     Integer3,AX
                JMP     _TF6
_TF0:
                PUSH    DI BP
;                CALL    O [BX.Texture]
;                VLD     DI.Color
;                VSTP    Collect
                CALL    Shading
                POP     BP DI

                MOV     FirstO,BX

                VMULF   Collect,MaxColor
                FISTP   Integer1
                FISTP   Integer2
                FISTP   Integer3
_TF6:
                MOV     BX,255
                MOV     AX,Integer3
                CMP     AX,BX
                JBE     _TF3
                MOV     AX,BX
_TF3:
                MOV     ES:[DI+3],AL
                ADD     AL,ES:[DI-3]
                RCR     AL,1
                STOSB
                MOV     AX,Integer2
                CMP     AX,BX
                JBE     _TF4
                MOV     AX,BX
_TF4:
                MOV     ES:[DI+3],AL
                ADD     AL,ES:[DI-3]
                RCR     AL,1
                STOSB
                MOV     AX,Integer1
                CMP     AX,BX
                JBE     _TF5
                MOV     AX,BX
_TF5:
                MOV     ES:[DI+3],AL
                ADD     AL,ES:[DI-3]
                RCR     AL,1
                STOSB
                POP     SI BX
                ADD     SI,3*4
                INC     DI
                INC     DI
                INC     DI
                MOV     AX,SI
                SHR     AX,4
                AND     SI,15
                ADD     BP,AX
                TEST    DI,DI
                JNS     _TF7
                MOV     AX,ES
                SUB     DI,32768-16
                ADD     AX,0800H-1
                MOV     ES,AX
_TF7:
                LOOP    _TF1
                RETN

Shading:
                VNMULF  Direction,Distance
                VADD    Position
                VSTP    Position
                CALL    O [BX.Norml]
                VSTP    Normal
                CALL    O [BX.Texture]
        IFNDEF OneL
                MOV     BP,FirstL
        ELSE
                MOV     BP,O TheLight
        ENDIF
                VSTFP   Collect,DI.Ambient
_SH1:
                VNSUB   BP.Pos,Position
                VST     Shadow
                VDOT    Normal
                FTST                     ;; Dot*|S|
                FNSTSW  AX
                SAHF
                JBE     _SH4
                FLD     Plus1            ;; 1  Dot*|S|
                VABS    Shadow           ;; |S|  1  Dot*|S|
                FST     Distance
                FDIVR   ST,ST(1)         ;; 1/|S|  1  Dot*|S|
                FXCH                     ;; 1  1/|S|  Dot*|S|
                FSTP    Trans            ;; 1/|S|  Dot*|S|
                FMUL    ST(1),ST         ;; 1/|S|  Dot
                VMULF   Shadow           ;; SX  SY  SZ  Dot
                VSTP    Shadow           ;; Dot
                FSTP    Dot
        IFNDEF Shad
                MOV     SI,[BX.Cache]
                MOV     FirstO,SI
                PUSH    DI
                CALL    O [SI.Shade]
                POP     DI
                FCOMP   Zero
                FNSTSW  AX
                SAHF
                JBE     _SH5
        ENDIF
                FLD     [DI.Diffuse]
                FMUL    Dot              ;; Kd*Dot
                FLD     Dot              ;; Dot  Kd*Dot
                FLD     [DI.Shine]
                FCOMP   Zero
                FNSTSW  AX
                SAHF
                JBE     _SH3
                FADD    ST,ST            ;; 2*Dot   Kd*Dot
                VMULF   Normal
                VSUBR   Shadow
                VDOT    Direction
                FCHS
                FTST
                FNSTSW  AX
                SAHF
                JBE     _SH3
                FLD     [DI.Shine]
                FXCH
                FYL2X
                FCOM    Minus2
                FNSTSW  AX
                SAHF
                JB      _SH3
                FADD    Plus1
                F2XM1
                FADD    Plus1
                FMUL    Half
                FMUL    [DI.Specular]
                FADD    ST(1),ST
_SH3:
                FXCH
                FMUL    Trans
                VNMULF  BP.Col
                VADD    Collect
                VSTP    Collect
_SH4:
                FSTP    Trash
_SH5:
        IFNDEF OneL
                ADD     BP,SIZE LightType
                CMP     BP,LastL
                JC      _SH1
        ENDIF
                VMUL    Collect,DI.Color
                VSTP    Collect
        IFNDEF Refl
                CMP     SP,130H-8-30*3
                JBE     _SH7
                FLD     [DI.Reflect]
                FCOMP   Epsilon
                FNSTSW  AX
                SAHF
                JBE     _SH7
                FLD     Infinite
                VDOT    Direction,Normal
                FADD    ST,ST           ;; 2*Dot
                VNMULF  Normal          ;; 2*Dot*NX  2*Dot*NY  2*Dot*NZ
                VSUB    Direction       ;; VX-2*Dot*NX  VY-2*Dot*NY  VZ-2*Dot*NZ
                VSTP    Direction
                FSTP    Distance
                PUSH    BX
                MOV     SI,[BX.Refle]
                MOV     BP,BX
                XOR     BX,BX
                MOV     FirstO,SI
                CALL    O [SI.Isect]
                TEST    BX,BX
                JZ      _SH6
                MOV     [BP.Refle],BX
                VPUSH   Collect
                PUSH    DI
                CALL    Shading
                POP     DI
                VNLD    Collect
                VPOP    Collect
                VNMULFR DI.Reflect
                VADD    Collect
                VSTP    Collect
_SH6:
                POP     BX
_SH7:
        ENDIF
                RETN

InitObjects     MACRO   _Objects

        IFDIFI <_Objects>,<SI>
                MOV     SI,O _Objects
        ENDIF
                MOV     BX,SI
                CALL    O [SI.InitO]
ENDM

ConvCam2Shoot   MACRO   _Shoot,_Camera

        IFDIFI <_Shoot>,<BX>
                MOV     BX,O _Shoot
        ENDIF
        IFDIFI <_Camera>,<SI>
                MOV     SI,O _Camera
        ENDIF
                CALL    Converting
ENDM

Cam2Shoot       MACRO   _Shoot,_Camera

                VNLD    _Camera.From    ;;FX  FY  FZ
                VST     _Shoot.EyePos   ;;FX  FY  FZ
                VNSUB   _Camera.At      ;;GX  GY  GZ
                VST     _Shoot.EyeRay   ;;GX  GY  GZ
                VCROSSR _Camera.Up      ;;XX  XY  XZ
                VST     _Shoot.XAdder   ;;XX  XY  XZ
                VCROSS  _Shoot.EyeRay   ;;YX  YY  YZ
                VSTP    _Shoot.YAdder   ;;
                VABS    _Shoot.EyeRay   ;;|G|
                FLDPI                   ;;PI  |G|
                FMUL    [_Camera.Angle] ;;PI*Ang  |G|
                FMUL    Div360          ;;PI*Ang/360  |G|
                FPTAN                   ;;1  TAN(PI*Ang/360)  |G|
                FSTP    Trash           ;;TAN(PI*Ang/360)  |G|
                FMULP                   ;;|G|*TAN(PI*Ang/360)
                FLD     Aspect          ;;Asp  |G|*TAN(PI*Ang/360)
                FMUL    ST,ST(1)        ;;Asp*|G|*TAN(PI*Ang/360)  |G|*TAN(PI*Ang/360)
                VABS    _Shoot.YAdder   ;;|Y|  Asp*|G|*TAN(PI*Ang/360)  |G|*TAN(PI*Ang/360)
                FDIVP   ST(1),ST        ;;Asp*|G|*TAN(PI*Ang/360)/|Y|  |G|*TAN(PI*Ang/360)
                VNMULF  _Shoot.YAdder   ;;VX  VY  VZ  |G|*TAN(PI*Ang/360)
                VST     _Shoot.YAdder   ;;VX  VY  VZ  |G|*TAN(PI*Ang/360)
                VSUB    _Shoot.EyeRay   ;;VX  VY  VZ  |G|*TAN(PI*Ang/360)
                VSTP    _Shoot.EyeRay   ;;|G|*TAN(PI*Ang/360)
                VABS    _Shoot.XAdder   ;;|X|  |G|*TAN(PI*Ang/360)
                FDIVP   ST(1),ST        ;;|G|*TAN(PI*Ang/360)/|X|
                VNMULF  _Shoot.XAdder   ;;UX  UY  UZ
                VST     _Shoot.XAdder   ;;UX  UY  UZ
                VSUB    _Shoot.EyeRay   ;;UX  UY  UZ
                VSTP    _Shoot.EyeRay   ;;
                FILD    [_Shoot.ResY]   ;;Y
                FMUL    Half            ;;Y/2
                VNDIVF  _Shoot.YAdder   ;;2*VX/Y  2*VY/Y  2*VZ/Y
                VNSUBR  _Shoot.XAdder   ;;2*VX/Y-UX  2*VY/Y-UY  2*VZ/Y-UZ
                VSUBR   _Shoot.XAdder   ;;2*VX/Y-2*UX  2*VY/Y-2*UY  2*VZ/Y-2*UZ
                VSTP    _Shoot.YAdder   ;;
                FILD    [_Shoot.ResX]   ;;X
                FMUL    Half            ;;X/2
                VDIVF   _Shoot.XAdder   ;;2*UX/X  2*UY/X  2*UZ/X
                VSTP    _Shoot.XAdder   ;;
ENDM

InitCam2Shoot   MACRO
        LOCAL   _1

                JMP     _1
Converting:
                Cam2Shoot BX,SI
                RETN
Aspect          DD      0.695
Div360          DD      993397601
_1:
ENDM

ShootInit       MACRO   _Dest,_Shoot

        IFDIFI <_Shoot>,<BX>
                MOV     BX,O _Shoot
        ENDIF
        IFDIFI <_Dest>,<DI>
                MOV     DI,O _Dest
                MOV     BP,CS
        ENDIF
                CALL    Shooting
ENDM

Shooting:
                VNLD    BX.EyeRay
                XOR     CX,CX
@@1:
                XOR     AX,AX
@@2:
                CMP     AX,[BX.MinX]
                JB      @@3
                CMP     AX,[BX.MaxX]
                JNB     @@3
                CMP     CX,[BX.MinY]
                JB      @@3
                CMP     CX,[BX.MaxY]
                JNB     @@3
                VST     [BX.EyeRay]
                VNORM
                PUSH    DS
                MOV     DS,BP
                FSTP    D [DI]
                SCASD
;                SCASW
                FSTP    D [DI]
                SCASD
;                SCASW
                FSTP    D [DI]
                SCASD
;                SCASW
                POP     DS
;                ADD     DI,3*4
                VNLD    BX.EyeRay
@@3:
                INC     AX
                VNADD   BX.XAdder
                CMP     AX,[BX.ResX]
                JB      @@2
                VNADD   BX.YAdder
                INC     CX
                MOV     AX,DI
                SHR     AX,4
                AND     DI,15
                ADD     BP,AX
                CMP     CX,[BX.ResY]
                JB      @@1
                VSTP    BX.EyeRay
                RETN

RotateYX        MACRO   _A,_B,_G

                FLD     _A      ;; _A  Y0  X0
                FSINCOS         ;; COS(_A)  SIN(_A)  Y0  X0
                FMUL    ST,ST(2);; Y0*COS(_A)  SIN(_A)  Y0  X0
                FXCH    ST(2)   ;; Y0  SIN(_A)  Y0*COS(_A)  X0
                FMULP           ;; Y0*SIN(_A)  Y0*COS(_A)  X0
                FLD     _B      ;; _B  Z1  Y1  X1
                FSINCOS         ;; COS(_B)  SIN(_B)  Z1  Y1  X1
                FMUL    ST,ST(4);; X1*COS(_B)  SIN(_B)  Z1  Y1  X1
                FXCH            ;; SIN(_B)  X1*COS(_B)  Z1  Y1  X1
                FMUL    ST,ST(2);; Z1*SIN(_B)  X1*COS(_B)  Z1  Y1  X1
                FADD            ;; X2  Z1  Y2  X1
                FLD     _B      ;; _B  X2  Z1  Y2  X1
                FSINCOS         ;; COS(_B)  SIN(_B)  X2  Z1  Y2  X1
                FMULP   ST(3),ST;; SIN(_B)  X2  Z1*COS(_B)  Y2  X1
                FMULP   ST(4),ST;; X2  Z1*COS(_B)  Y2  X1*SIN(_B)
                FXCH            ;; Z1*COS(_B)  X2  Y2  X1*SIN(_B)
                FSUBRP  ST(3),ST;; X2  Y2  Z2
        IFNDEF Ang3
                FLD     _G      ;; _G  X2  Y2  Z2
                FSINCOS         ;; COS(_G)  SIN(_G)  X2  Y2  Z2
                FMUL    ST,ST(2);; X2*COS(_G)  SIN(_G)  X2  Y2  Z2
                FXCH            ;; SIN(_G)  X2*COS(_G)  X2  Y2  Z2
                FMUL    ST,ST(3);; Y2*SIN(_G)  X2*COS(_G)  X2  Y2  Z2
                FSUBP   ST(1),ST;; X3  X2  Y2  Z2
                FLD     _G      ;; _G  X3  X2  Y2  Z2
                FSINCOS         ;; COS(_G)  SIN(_G)  X3  X2  Y2  Z2
                FMULP   ST(4),ST;; SIN(_G)  X3  X2  Y2*COS(_G)  Z2
                FMULP   ST(2),ST;; X3  X2*SIN(_G)  Y2*COS(_G)  Z2
                FXCH            ;; X2*SIN(_G)  X3  Y2*COS(_G)  Z2
                FADDP   ST(2),ST;; X3  Y3  Z3
        ENDIF
ENDM

INCLUDE SPHERE.INC
INCLUDE GROUND_Y.INC
INCLUDE CONE_Z.INC
;..............................................................................
Proggi:
                MOV     DI,O Charset
                MOV     SI,O CharsetBin
                PUSH    DI CS
                POP     ES
                MOV     DX,14
@@0:
                MOV     CL,16
@@1:
                LODSW
                XCHG    BX,AX
                MOV     CH,16
@@2:
                XOR     AX,AX
                SHL     BX,1
                JNC     @@3
                MOV     AX,101H*192;224;255
@@3:
                ADD     AL,[DI-1]
                RCR     AL,1
                STOSW
                DEC     CH
                JNZ     @@2
                ADD     DI,32
                LOOP    @@1
                DEC     DX
                JNZ     @@0
                POP     SI
                MOV     DI,O Charset+32
                MOV     CL,16*14-1
@@4:
                MOV     B [SI],DH
                MOV     B [SI+64],DH
                MOV     DL,32
@@5:
                LODSB
                ADD     AL,[DI+32]
                RCR     AL,1
                STOSB
                DEC     DX
                JNZ     @@5
                ADD     SI,32
                ADD     DI,32
                LOOP    @@4

                MOV     DI,O Charset+31*32
                XCHG    BX,AX
                MOV     DL,14
@@6:
                MOV     CL,32/2
                REP     STOSW
                ADD     DI,31*32
                DEC     DX
                JNZ     @@6
;..............................................................................
        IFNDEF Cam2
                InitCam2Shoot
                ConvCam2Shoot Shoot01,Camera01
        ENDIF
;..............................................................................
                InitObjects Objects01
                RayTracePic Pic01,Shoot01,Objects01,Lights01
                PUSH    DI ES
;..............................................................................
                MOV     SI,O Text1
                MOV     DI,O Pic01+640*3*11+366*3+1
                MOV     DX,CS
                CALL    TextKi
                PUSH    CS
                POP     ES
;..............................................................................
                MOV     DI,O Objects02 + 2*SIZE SphereType
                MOV     SI,O Objects02 + SIZE SphereType
                MOV     AX,11
@@ANYAD:
                MOV     CL,SIZE SphereType/2
                REP     MOVSW
                MOV     [SI.NextO - SIZE SphereType],SI
                DEC     AX
                JNZ     @@ANYAD
                InitObjects Objects02
;..............................................................................
        IFNDEF Cam2
                ConvCam2Shoot Shoot02,Camera02
        ENDIF
;..............................................................................
                POP     ES DI
                CALL    NextFrame
                PUSH    DI ES
;..............................................................................
                PUSH    CS
                POP     ES
@@VAR:
                CMP     Timer,350
                JB      @@VAR
                GraphInit Puffer
                Set640x240
                GotoXY 0,0
                MOV     SI,O Pic01
                MOV     AX,CS
                SHR     SI,4
                ADD     AX,SI
                XOR     SI,SI
                MOV     DS,AX
                PutWindowS 640,240,SI
                PUSH    CS
                POP     DS
;..............................................................................
                POP     ES DI
                MOV     CL,4
@@1:
                PUSH    CX
                CALL    NextFrame
                POP     CX
                LOOP    @@1
                PUSH    DI ES
;..............................................................................
                CALL    CLS
;..............................................................................
                POP     ES DI
                CALL    NextFrame
                MOV     BP,ES
                MOV     SI,DI
;..............................................................................
                PUSH    0A000H
                POP     ES
PR2:
                MOV     CX,6
                PUSH    BP SI
PR3:
                PUSH    CX
                ADD     BP,SZ*MA*3/16
                GotoXY (640-SZ)/2,(160-MA)/8
                MOV     DS,BP
                PUSH    BP SI
                MOV     CX,3
VAROK:
                WaitRetrace
                LOOP    VAROK
                PutWindowS SZ,MA,SI
                POP     SI BP
                POP     CX
                LOOP    PR3
                POP     SI BP
                PUSH    CS
                POP     DS
                CMP     Timer,1000
                JB      PR2
;..............................................................................
                MOV     Szoveg,O Text3
                MOV     Helyez,192*3+1
                CALL    CLS

        IF 12-DARAB
                MOV     W [O Objects02+DARAB*SIZE SphereType].NextO,O Objects02
                InitObjects Objects02
                CALL    O [SI.InitO]
        ENDIF

                MOV     BX,O Shoot02
                SHR     W [BX],1
                SHR     D [BX+4],1
;               SHR     W [BX+6],1
                MOV     B [BX+6].XAdder,101

                MOV     BP,CS
                MOV     DI,O Puffer
                ADD     BP,SZ*MA*3/16
                ShootInit DI,BX

                SUB     SP,30
                MOV     Helyez,SP
                SUB     SP,30*2
;..............................................................................
MAIN:
                MOV     SI,O Objects02 + SIZE SphereType
                MOV     CX,DARAB
                FLD     Frame
@@1:
                FLD     ST
                FSINCOS
                FMUL    Sugar
                FXCH
                FMUL    Sugar
                RotateYX Alpha,Beta,Gamma
                VSTP    [SI.Center]
                FADD    Rad30
                ADD     SI,SIZE SphereType
                LOOP    @@1
                FLD     Alpha
                FADD    AlphaD
                FSTP    Alpha
                FLD     Beta
                FADD    BetaD
                FSTP    Beta
        IFNDEF Ang3
                FLD     Gamma
                FADD    GammaD
                FSTP    Gamma
        ENDIF
                FSTP    Trash
;..............................................................................
                MOV     BP,CS
                MOV     DX,O Puffer
                ADD     BP,SZ*MA*3/16
                RayTraceFrame DX,DX,SZ*MA/2,Shoot02,Objects02,Lights01
;                MOV     DI,O Puffer
;                PUSH    CS
;                POP     ES
;                CALL    NextFrame
                PUSH    0A000H
                POP     ES
                GotoXY (640-SZ)/2,(160-MA)/8
                MOV     SI,O Puffer
                MOV     AX,CS
                SHR     SI,4
                ADD     AX,SI
                XOR     SI,SI
                MOV     DS,AX
                PutWindowS SZ,MA,SI
                PUSH    CS
                POP     DS
;..............................................................................
                CMP     Timer,1400
                JB      MAIN
                MOV     SP,Helyez
                JMP     MAIN
;..............................................................................
INT9:
                PUSH    AX
                MOV     AL,20H
                OUT     20H,AL
                IN      AL,60H
                CMP     AL,1
                JE      VEGE
                POP     AX
                IRET
;..............................................................................
VEGE:
                PUSH    CS
                POP     DS
                XOR     AX,AX
                MOV     ES,AX
                MOV     SI,O Interupts
                MOV     DI,8*4
                MOVSW
                MOVSW
                MOVSW
                MOVSW
                MOV     AL,3
                INT     10H

;                LEA     SI,[Shoot02.XAdder]
;                MOV     CX,12
;KIIR:
;                LODSB
;                MOV     AH,0
;                PUSH    CX SI
;                PrintNum AX
;                Print EOL
;                POP     SI CX
;                LOOP    KIIR

                INT     20H
;                EXITCODE 0
;..............................................................................
INT8:
                PUSH    AX SI
                MOV     AL,20H
                OUT     20H,AL
@@SI:           MOV     SI,O DUMA
                INC     CS:Timer
                CMP     SI,O DUMA2
                JE      @@2
                PUSH    ES DS
                PUSH    DI CS
@@DI:           MOV     DI,80*2-1+14*2
                PUSH    0B800H
                POP     ES DS
@@0:
                MOV     AX,0E0FH
                STOSB
                LODSB
                STOSW
                DEC     DI
;                CMP     AL,' '
;                JE      @@0
                TEST    AL,AL
                JNZ     @@1
                ADD     DI,39*2
@@1:
                MOV     W @@SI[1],SI
                MOV     W @@DI[1],DI
                POP     DI
                POP     DS ES
@@2:
                POP     SI AX
                IRET
Timer           DW      0
;..............................................................................
DUMA:
                DB                    '__                  _     '
                DB      '   /==\      |  \ /==\      ==== / \    '
                DB      '   |    |  | |__/ |  | \  / |__    |    '
                DB      '   |    |__| | \  |  | |\/| |     /     '
                DB      '   \==/ |  | |  \ \==/ |  | |=== /      '
                DB      '        |  |           |  |     |__|    '
                DB                                               0
                DB                                               0
                DB                                               0
                DB                                               0
                DB      '            GET READY FOR               '
                DB                                               0
                DB                                               0
                DB                                               0
                DB      '         REALTIME RAYTRACING!'         ,0
DUMA2:
;..............................................................................
NextFrame:
                PUSH    DI ES

                MOV     SI,O Objects02 + SIZE SphereType
                MOV     CX,12
                FLD     Frame
@@1:
                FLD     ST
                FSINCOS
                FMUL    Sugar
                FSTP    [SI.Center.X]
                FMUL    Sugar
                FSTP    [SI.Center.Y]
                FADD    Rad30
                ADD     SI,SIZE SphereType
                LOOP    @@1
                FADD    Rad5
                FSTP    Frame

                VPUSH   Shoot02.EyeRay
                RayTracePic DI,Shoot02,Objects02,Lights01
                VPOP    Shoot02.EyeRay

                POP     AX DI
                SUB     AX,SZ*MA*3/16
                MOV     ES,AX
                RETN
;..............................................................................
CLS:
                MOV     AX,O Puffer
                MOV     DI,CS
                SHR     AX,4
                ADD     AX,DI
                XOR     DI,DI
                MOV     ES,AX
                XCHG    CX,AX
                MOV     CX,640*32*3/2
                REP     STOSW
                GotoXY 0,0
@@VAR:
                CMP     Timer,690
                JB      @@VAR
                Set640x160
                PUSH    ES 0A000H
                POP     ES DS
                MOV     CX,4
CLS1:
                PUSH    DS CX
                PutWindowS 640,32,0
                POP     CX DS
                LOOP    CLS1
;..............................................................................
                MOV     DX,DS
                PUSH    CS
                POP     DS
                PUSH    DI DX

                MOV     ES,DX
                XOR     DI,DI
                XOR     AX,AX
@@1:
                MOV     CX,640
@@2:
                STOSW
                XCHG    AH,AL
                STOSB
                XCHG    AH,AL
                LOOP    @@2
                ADD     AL,8
                JNZ     @@1

                MOV     SI,Szoveg
                MOV     DI,Helyez
                CALL    TextKi
                POP     DS DI
                PUSH    0A000H
                POP     ES
;                GotoXY 0,122
                PutWindowS 640,32,0
                PUSH    CS
                POP     DS
                RETN
;..............................................................................
TextKi:
                LODSB
                SHL     AX,10
                JC      @@5
                MOV     BX,O Charset
                ADD     BX,AX
                MOV     CL,32
@@1:
                PUSH    DI
                MOV     ES,DX
                MOV     CH,32
@@2:
                MOV     AH,[BX]
                INC     BX
                TEST    AH,AH
                JNZ     @@3
                INC     DI
                INC     DI
                INC     DI
                JMP     @@4
@@3:
                MOV     AL,ES:[DI]
                SHR     AL,2
                ADD     AL,AH;128;+64+32
                STOSB
                MOV     AL,ES:[DI]
                SHR     AL,2
                ADD     AL,AH;128+64+32
                SHR     AH,1
                STOSB
                MOV     AL,ES:[DI]
                SHR     AL,2
                ADD     AL,AH;128+64+32
                STOSB
@@4:
                DEC     CH
                JNZ     @@2
                ADD     DX,640*3/16
                POP     DI
                LOOP    @@1
                SUB     DX,32*640*3/16 - 32*3/16
;                ADD     DI,32*3
                JMP     TextKi
@@5:
                RETN

;                        2  A  C  D  E  H  I  L  M  O  P  R  T  U
;                       00,01,02,03,04,05,06,07,08,09,10,11,12,13

;                        C  H  R  O  M  E  2
Text1           DB      02,05,11,09,08,04,00,255
;                        P  R  E  C  A  L  C  U  L  A  T  E  D
Text2           DB      10,11,04,02,01,07,02,13,07,01,12,04,03,255
;                        R  E  A  L  T  I  M  E
Text3           DB      11,04,01,07,12,06,08,04,255
;..............................................................................
Camera02        LABEL
        IFNDEF Cam2
                Camera
        ENDIF
Shoot02        LABEL
        DW     640,160,(640-SZ)/2,(640+SZ)/2,(160-MA)/2,(160+MA)/2
        Vector<0.0,0.0,-1.0>
        DD     2784178832,1071284857,2805051245,1070754969,0,1072693248
        DD     509356147,3210032430,0,0,0,0
        DD     2784178832,1072333433,1911101614,3211623055,0,0
Objects02       LABEL
                Sphere  0.0,0.0,0.0, 0.106, Texture01
                Sphere  0.0,0.0,0.0, 0.035, Texture00, Objects02
;..............................................................................
CharsetBin:     INCLUDE GODO.INC
;..............................................................................
Camera01        LABEL
        IFNDEF Cam2
                Camera 8.0,13.0,-10.0
        ENDIF
Shoot01        LABEL
        DW     640,240,0,640,0,240
        Vector<8.0,13.0,-10.0>
        DD     3354748600,3222388218,1573231333,3223494768,883430291,1076995307
        DD     1104369304,3214074675,0,0,49003968,3213768786
        DD     2791582120,1076340217,159493984,3214898584,1219516884,1076025019
Objects01       LABEL
                Ground_Y -3.0, Texture06
                Sphere  1.0,1.0,1.0, 2.0, Texture00
                Cone_Z -2.0,-0.5, 1.0, Texture03, Objects01

Texture06:      CheckerZ Texture04,Texture05, 0.8
Texture05:      Solid RichBlue,Metal
Texture04:      Solid White,Metal
Texture03:      Checker Texture01,Texture02
Texture02:      Solid Goldenrod, Reflective
Texture01:      Solid 0.5,0.6,0.6, Reflective
Texture00:      Solid Plum, Reflective

Rad30           DD      1057360530
Rad5            DD      3182606530
Frame           DD      0.0
Sugar           DD      0.15

Alpha           DD      0.0
Beta            DD      0.0
        IFNDEF Ang3
Gamma           DD      0.0
        ENDIF
AlphaD          DD      1032780341
BetaD           DD      1029076816
        IFNDEF Ang3
GammaD          DD      1035122882
        ENDIF

TheLight:       Light

Szoveg          DW      O Text2
Helyez          DW      112*3;+1

                RTConstants
ZeroData:
                RTVariables

Interupts       DD      ?
                DD      ?

        ALIGN   16

Charset         DB      32*32*14 DUP(?)
Puffer          DB      256 DUP(?)
Pic01           LABEL
;..............................................................................

Init: ;........................................................................
                LEA     AX,ZeroData-256+64
                MOV     DX,AX
                SHR     DH,1
                INC     DH
                AND     AX,511
                JNZ     @@1
                DEC     DH
@@1:
                MOV     B PartCnt,DH
                MOV     PartPag,AX

                MOV     AX,Init - ZeroData + 15
                SHR     AX,4
                ADD     MinMem,AX
;..............................................................................
                LEA     DX,FileName
                MOV     AH,41H
                INT     21H
;                MOV     D [EXEHeader-4],'EXE'
                MOV     AH,3CH
                XOR     CX,CX
                INT     21H
                MOV     BX,AX
                MOV     AH,40H
                LEA     DX,EXEHeader
                MOV     CX,64+3
;                INT     21H
                MOV     B DS:[100H],40H
                MOV     W DS:[101H],10CDH
                MOV     AH,40H
                MOV     DX,100H;3H
                LEA     CX,ZeroData-256;-3
                INT     21H
                MOV     AH,3EH
                INT     21H

                INT     20H

FileName        DB      ??filename,'.COM',0

EXEHeader: ;...................................................................
EXESign         DB      'MZ'
PartPag         DW      ?
PartCnt         DW      0
ReloCnt         DW      0
HdrSize         DW      64/16
MinMem          DW      (PlusMem + 15) SHR 4
MaxMem          DW      0FFFFH
ReloSS          DW      0FFF0H
ExeSP           DW      100H
ChkSum          DW      0
ExeIP           DW      100H
ReloCS          DW      0FFF0H
TablOff         DW      1CH
Overlay         DW      0

                DB      13
                DB      'Coded by TomCat/Abaddon - ',??date
                DB      1AH

                DB      0E9H
                DW      O Proggi - 103H
Code16 ENDS
END Start