uses crt;

(* include the file generated by 2asm
   dont forget to run 2asm before trying to compile!

    2ASM PICTURE.RAW /P
                                                                      *)
{$i picture.pas}

(*////////////////////////////////////////////////////////////////////*)

procedure setmode(mode : word); assembler;
asm
   mov    ax, mode
   int    10h
end; {setmode}

(*////////////////////////////////////////////////////////////////////*)

procedure pal(col,r,g,b : byte); assembler;
asm
   mov    al, [col]
   mov    dx, 3c8h
   mov    ah, [r]
   out    dx, ax
   mov    al, [g]
   inc    dx
   out    dx, al
   mov    al, [b]
   out    dx, al
end; {pal}

(*////////////////////////////////////////////////////////////////////*)

var i:word;

begin

   (* set video mode 13h (vga 320x200x256) *)
   setmode($13);

   (* set up a greyscale palette *)
   for i:=0 to 255 do
      pal(i,i div 4,i div 4,i div 4);

   (* move the image to the vga memory (a000h) *)
   for i:=0 to 63999 do
      mem[$a000:i]:=picture_raw[i];

   (* wait for key *)
   readkey;

   (* set textmode *)
   setmode($03);

end.
