;
; First PSX intro by Xerox/LEGEND - Source released on : Dec. 5th 1998.
;
; I've always been a "fan" of people releasing their sourcecode, so other people
; could benefit from it - and I'll probably do the same on the PlayStation.
;
; (read the scrolltext in the very bottom of this file)
;
; Should you wish to contact me about anything, you can reach me :
;
; xerox@www.mother.dk or 
; #psxdev on EFnet
;
; 
; Xerox signing off....
;

				include	equates.inc
				include macros.inc
				
DIST			equ		80

;--------------------------------------------------
; other macros used in the intro
;--------------------------------------------------
push			macro	reg
				sub		sp,sp,4
				sw		reg,0(sp)
				endm

pop				macro	reg
				lw		reg,0(sp)
				add		sp,sp,4
				endm
				
SList			macro next,size
				dw		(next&$00ffffff)!(size<<24)
				endm
				
sprite			macro	next,r,g,b,x,y,u,v,w,h
				dw		(next&$00ffffff)!(5<<24)
				db		r,g,b,$64
				dh		x,y
				db		u,v
				dh		0		; zero
				dh		w
				dh		h
				endm
				
;   Some equates to make bits easier to change & read...

LEGEND			equ		$80100000
MODULE			equ		$80120000

Start           equ     user_ram
Stack           equ     ram+ram_length-$10
Length          equ     Ending-Start

;  This is a psx header, the program may need "exefixup" for cd running!

				header	Start,Length,Stack

;  And now the program itself !!!

				org		Start
				
				sw		ra,Return
				
				
				li		sp,Stack
				li		k1,hardware				; set to hardware base
				
				li		a0, $08000009			; initialise the GPU
				jal		InitGPU                 
				nop
				
				jal		WaitGPU					; clear screen
				nop
				li		a0,$040000000
				sw		a0,GP1(k1)
				li		a0,$28000000
				sw		a0,GP0(k1)
				li		a0,$00000000
				sw		a0,GP0(k1)
				li		a0,$00000140
				sw		a0,GP0(k1)
				li		a0,$01000000
				sw		a0,GP0(k1)
				li		a0,$01000140
				sw		a0,GP0(k1)
				
				la		a0,consoleTxt			; print to pc console	
				jal		print_text
				nop
				

				la		a0,LegendPACK			; Unpack graphics used in intro
				li		a1,LEGEND				;
				jal		BK_Decrunch				;
				nop								;
				
				la		a0,modulePACK			; Unpack music used in intro
				li		a1,MODULE				;
				jal		BK_Decrunch				;
				nop								;

				
				li		a0, $80100014			; put picture in VRAM at pos 512 x 256
				li 		a1, $01000200			
				li 		a2, $00ff00ec
				li 		a3, 236*255/2
				jal 	MEM2VRAM_IO
				nop
				
				la 		a0, Xerox+$14			; put picture in VRAM at pos 0 x 256
				li 		a1, $01000000			
				li 		a2, $000f0058
				li 		a3, 88*15/2
				jal 	MEM2VRAM_IO
				nop
				
				
				jal		InitPads                ; init pads, also the wait vsync routine
				nop
				
            	la 		a0, module				; init the mod player
				jal		HM_Init                 
				nop	

loop
				jal		WaitIdle				; wait the the GPU to finish rendering
				nop
				jal		WaitVSync				; wait for vertical retrace
				nop
				
				jal		Set_Screen				; swap active display buffer
				nop	

				la		a0,blankList			; send the first primitive list
				jal		SendList
				nop
				
				jal		stars					; stars !!!
				nop
				
				jal		scroller				; take a guess
				nop
				
				jal		greeting				; take a guess
				nop
				
				jal		moveLogo				; take a guess
				nop
				
				jal		moveXerox				; take a guess
				nop

				la		a0,RealList				; send the primitives just setup by the 5 last routines
				jal		SendList
       	    	nop
								
				jal 	HM_Poll                 ; call mod player
				nop

				lw		a0,pad_data				; loop the intro untill someone press X on the Keypad
				nop
				andi	a1,a0,$8000
				beqz	a1,pad_01
				nop
				li		a2,4
pad_01:	     	andi	a1,a0,$2000
				beqz	a1,pad_02
				nop
				li		a2,-4
pad_02:			li		a2,-4
		     	lw		a0,pad_data
				nop
				and		a0,$00400040
				beqz	a0,loop
				nop

				j		Do_Return				; return to the CAETLA menu or whichever program called "us"
				nop

;------------------------------------------------------------------------------------------------------
; Stars routine
;------------------------------------------------------------------------------------------------------
MAX_STARS		equ		1024

X				equ		0
Y				equ		1024*4
Z				equ		1024*8

dotFunction		db		$80,0,0,$68
ny_x			dw		10
ny_y			dw		100

stars:			push	ra
				li		a3,0			; s1 = index into cords
				li		a0,MAX_STARS
stars_loop:		push	a0
				lw		a0,xcords(a3)	; hent x	
				li		a1,DIST
				mult	a0,a1
				mflo	a0
				lw		a1,zcords(a3)
				nop
				div		a0,a1
				mflo	a0
				add		a0,a0,320/2
				slti	a1,a0,1
				bnez	a1,next_Star
				nop
				li		a1,320
				sub		a1,a1,a0
				sltiu	a1,a1,1
				bnez	a1,next_Star
				nop
				sw		a0,ny_x
				nop
				lw		a0,ycords(a3)	; hent x	
				li		a1,DIST
				mult	a0,a1
				mflo	a0
				lw		a1,zcords(a3)
				nop
				div		a0,a1
				mflo	a0
				add		a0,a0,256/2
				slt		a1,a0,1
				bnez	a1,next_Star
				nop
				li		a1,256
				sub		a1,a1,a0
				sltiu	a1,a1,1
				bnez	a1,next_Star
				nop
				sw		a0,ny_y
				nop
				li		a0,127
				lw		a1,zcords(a3)
				nop
				sub		a0,a0,a1
				sb		a0,dotFunction		;r
				sb		a0,dotFunction+1	;g	
				sb		a0,dotFunction+2	;b
				nop
				jal		WaitGPU				; draw the DOT
				nop
				li		a0,$040000000
				sw		a0,GP1(k1)
				lw		a0,dotFunction
				nop
				sw		a0,GP0(k1)
				lw		a0,ny_y
				lw		a1,ny_x
				nop
				sll		a0,16
				or		a0,a0,a1
				sw		a0,GP0(k1)
next_star		pop		a0
				subi	a0,a0,1
				add		a3,a3,4
				bnez	a0,stars_loop
				nop
				
;--------- MOVE Z CORDS TO MAKE IT APPEAR THE STARS ARE MOVING -------------

				li		a3,0		
				li		a0,MAX_STARS
move_loop		push	a0
				lw		a0,zcords(a3)
				nop
				subi	a0,a0,1
				bnez	a0,notzero
				nop
				li		a0,127
notzero			sw		a0,zcords(a3)
				pop		a0
				subi	a0,a0,1
				addi	a3,a3,4	
				bnez	a0,move_loop
				nop
				
				pop		ra
				jr		ra
				nop

;-------------------------------------------------------
; Return to calling program
;-------------------------------------------------------
Do_Return		lw		ra,Return
				nop
				jr		ra
				nop

Return			dw	0


;-------------------------------------------------------
; Dubble buffer screen
;-------------------------------------------------------
Set_Screen 		push	ra
				lw		a0,page
				li		t2, $05000000            		; display offset
				jal		WaitGPU
				or		t2,t2,a0
				sw		t2,GP1(k1)
				xori	a0,a0,$140
				jal		WaitGPU
				nop
				li		t2, $e3000000|000<<10|000	  ; clip start
				or		t2,t2,a0
				sw		t2, GP0(k1)
				nop
				li		t2, $e4000000|255<<10|000	  ; clip end
				or		t2,t2,a0
				addi	t2,$13f
				jal		WaitGPU
				nop
				sw		t2, GP0(k1)
				sw		a0,page
				sh		a0,Dr_Offset
				addi	a0,a0,$100
				pop		ra
				j		ra
				nop



;-------------------------------------------------------
; D.Y.C.P. scroll routine
;-------------------------------------------------------
MAX_CHARS		equ		33		; 33

scroller		push	ra
				li		a0,7					; start the scroller when the GREETING is complete
				lw		a1,gvar					;	
				nop								;
				bne		a0,a1,dontScroll		;
				nop								;

				li		a3,0
				li		a1,0
				li		a0,MAX_CHARS
addSinus	
				lw		a2,dycpTab(a1)
				nop
				add		a2,a2,4
				and		a2,a2,$ff
				sw		a2,dycpTab(a1)
				nop

				push	a1
				lw		a1,sinus(a2)
				nop
				srl		a1,a1,2
				add		a1,a1,165
				sh		a1,letter+10(a3)
				nop
				pop		a1

				add		a3,a3,20
				add		a1,a1,4
				sub		a0,a0,1
				bnez	a0,addSinus
				nop

				lw		a2,scrPos
				nop
				sub		a2,a2,1
				bnez	a2,scrOk
				nop
			
nextChar	
				li		a1,0
				li		a0,MAX_CHARS-1
moveTab			lw		a2,dycpTab+4(a1)
				nop
				sw		a2,dycpTab+0(a1)
				nop
				add		a1,a1,4
				sub		a0,a0,1
				bnez	a0,MoveTab
				nop

				lw		a2,dycpVar
				nop

				sw		a2,dycpTab(a1)
				nop
				add		a2,a2,32
				sw		a2,dycpVar
				nop


				li		a1,0
				li		a0,MAX_CHARS-1
moveScr			lh		a2,letter+20+12(a1)		; move x positions
				nop								;
				sh		a2,letter+12(a1)		;
				nop								;

				lh		a2,letter+20+10(a1)		; move y positions
				nop								;
				sh		a2,letter+10(a1)		;
				nop								;
				add		a1,a1,20
				sub		a0,a0,1
				bnez	a0,moveScr
				nop


readAgain		
				lw		a0,scrollPtr
				nop
				lb		a0,scrollText(a0)
				nop
				bnez	a0,charOK
				nop
				li		a0,0
				sw		a0,scrollPtr
				nop
				j		readAgain
				nop
			
charOK			sub		a2,a0,' '
				bnez	a2,notSpace
				nop
				li		a0,39
				j		foundChar
				nop
			
notSpace		sub		a2,a0,'.'
				bnez	a2,notSpecial1
				nop
				li		a0,36
				j		foundChar
				nop
			
notSpecial1		sub		a2,a0,'@'
				bnez	a2,notSpecial2
				nop
				li		a0,37
				j		foundChar
				nop
			
notSpecial2		sub		a2,a0,':'
				bnez	a2,notSpecial3
				nop
				li		a0,38
				j		foundChar
				nop
notSpecial3	
				sub		a2,a0,'0'
				bnez	a2,not0
				nop
				li		a0,26
				j		foundChar
				nop
not0
				sub		a2,a0,'1'
				bnez	a2,not1
				nop
				li		a0,27
				j		foundChar
				nop
not1
				sub		a2,a0,'2'
				bnez	a2,not2
				nop
				li		a0,28
				j		foundChar
				nop
not2
				sub		a2,a0,'3'
				bnez	a2,not3
				nop
				li		a0,29
				j		foundChar
				nop
not3
				sub		a2,a0,'4'
				bnez	a2,not4
				nop
				li		a0,30
				j		foundChar
				nop
not4
				sub		a2,a0,'5'
				bnez	a2,not5
				nop
				li		a0,31
				j		foundChar
				nop
not5
				sub		a2,a0,'6'
				bnez	a2,not6
				nop
				li		a0,32
				j		foundChar
				nop
not6
				sub		a2,a0,'7'
				bnez	a2,not7
				nop
				li		a0,33
				j		foundChar
				nop
not7
				sub		a2,a0,'8'
				bnez	a2,not8
				nop
				li		a0,34
				j		foundChar
				nop
not8
				sub		a2,a0,'9'
				bnez	a2,not9
				nop
				li		a0,35
				j		foundChar
				nop
not9
				sub		a0,a0,$61
foundChar		sll		a0,a0,1
				lh		a2,scrollTab(a0)
				sh		a2,letter+12(a1)
				nop

				lw		a0,scrollPtr
				nop
				add		a0,a0,1
				sw		a0,scrollPtr
				nop

				li		a2,10				; MOVE SPRITES BACK TO POS 10
scrOK			sw		a2,scrPos
				nop


; setup scroll positions
				li		a1,0		; offset
				lw		a2,scrPos	; start pos
				nop
				sub		a2,a2,10	; scrPos should go from 0 to -10 but it doesn't work for me !??!
									; so instead it goes from 10 to 0 and i then subtract 10 :o)
									; lame I know ... but heck, its my first psx release.	

				li		a0,MAX_CHARS
scrLoop			push	a0
				sh		a2,letter+8(a1)
				nop
				pop		a0
				add		a1,a1,20
				add		a2,a2,10
				subi	a0,a0,1
				bnez	a0,scrLoop
				nop

dontScroll		pop		ra
				jr		ra
				nop

;--------------------------------------
;--------------------------------------
greeting		push	ra
				
				li		a1,7
				lw		a0,gvar
				nop
				beq		a0,a1,dontGreet
				nop

				lw		a0,goffset
				nop
				lb		a1,glist+0(a0)
				lb		a2,glist+1(a0)
				sb		a1,u0+0
				sb		a2,u0+1
				
				lb		a1,glist+2(a0)
				lb		a2,glist+3(a0)
				sb		a1,u1+0
				sb		a2,u1+1
				
				lb		a1,glist+4(a0)
				lb		a2,glist+5(a0)
				sb		a1,u2+0
				sb		a2,u2+1
				
				lb		a1,glist+6(a0)
				lb		a2,glist+7(a0)
				sb		a1,u3+0
				sb		a2,u3+1


				li		a3,0		; offset
				
				li		a0,4		; 4 cords for the greeting
greet_loop:		push	a0
				lw		a0,gxcords(a3)	; hent x	
				li		a1,DIST
				mult	a0,a1
				mflo	a0
				lw		a1,gzcord	
				nop
				div		a0,a1
				mflo	a0
				add		a0,a0,320/2
				sw		a0,gnyx(a3)
				nop
				
				lw		a0,gycords(a3)	; hent x	
				li		a1,DIST
				mult	a0,a1
				mflo	a0
				lw		a1,gzcord
				nop
				div		a0,a1
				mflo	a0
				add		a0,a0,256/2
				sw		a0,gnyy(a3)
				nop
				pop		a0
				subi	a0,a0,1
				
				add		a3,a3,4
				bnez	a0,greet_loop
				nop
				
				lw		a0,gzcord
				nop
				li		a1,3
				div		a0,a1
				mflo	a0
				
				li		a1,80
				sub		a1,a1,a0
				
				sb		a1,gcol1
				sb		a1,gcol2
				sb		a1,gcol3
				nop
				
				
				lw		a0,gnyx+0
				lw		a1,gnyx+4
				lw		a2,gnyx+8
				lw		a3,gnyx+12
				nop
				sh		a0,gx0
				sh		a1,gx1
				sh		a2,gx2
				sh		a3,gx3
				nop
				
				lw		a0,gnyy+0
				lw		a1,gnyy+4
				lw		a2,gnyy+8
				lw		a3,gnyy+12
				nop
				sh		a0,gy0
				sh		a1,gy1
				sh		a2,gy2
				sh		a3,gy3
				nop
				
				
				lw		a0,gzcord
				nop
				sub		a0,a0,4
				bnez	a0,zeroG
				nop
				
				lw		a0,gvar
				nop
				add		a0,a0,1
				sw		a0,gvar
				
				lw		a0,goffset
				nop
				add		a0,a0,8
				
				sw		a0,goffset
				nop
				
				
				li		a0,2*80
zeroG			sw		a0,gzcord
				nop
				j		quit
				nop
				
dontGreet		
				
				li		a0,1		
				sh		a0,gx0
				sh		a0,gx1
				sh		a0,gx2
				sh		a0,gx3
				sh		a0,gy0
				sh		a0,gy1
				sh		a0,gy2
				sh		a0,gy3
				nop
quit			pop		ra
				jr		ra
				nop


;--------------------------------------
;--------------------------------------
moveXerox		push	ra

				lw		a0,xeroxDelay
				nop
				bnez	a0,noXerox
				nop

				lw		a0,xeroxVar
				nop
				and		a0,a0,$ff

				li		a2,4*17
				sub		a3,a2,a0
				bnez	a3,lame
				nop
				j		xeroxON
				nop
lame			
				lw		a1,sinus(a0)
				nop
				li		a2,350
				sub		a2,a2,a1


				add		a0,a0,4
				sw		a0,xeroxVar
				nop

				sh		a2,xeroxXPos
				nop

				j		xeroxON
				nop

			
noXerox			sub		a0,a0,1
				sw		a0,xeroxDelay
				nop	

xeroxON
				pop		ra
				jr		ra
				nop
			
;--------------------------------------
;--------------------------------------
moveLogo		push	ra

				lw		a3,LegendYPos		; global Y position for ALL letters
				nop

				lw		a0,var1
				nop
				add		a0,a0,4
				and		a0,a0,$ff
				sw		a0,var1

				lw		a1,sinus(a0)
				nop
				srl		a1,2
				nop
				add		a1,a1,a3
				sh		a1,pos1
				nop


				lw		a0,var2
				nop
				add		a0,a0,4
				and		a0,a0,$ff
				sw		a0,var2
				lw		a1,sinus(a0)
				nop
				srl		a1,2
				nop
				add		a1,a1,a3
				sh		a1,pos2


				lw		a0,var3
				nop
				add		a0,a0,4
				and		a0,a0,$ff
				sw		a0,var3
				lw		a1,sinus(a0)
				nop
				srl		a1,2
				nop
				add		a1,a1,a3
				sh		a1,pos3


				lw		a0,var4
				nop
				add		a0,a0,4
				and		a0,a0,$ff
				sw		a0,var4
				lw		a1,sinus(a0)
				nop
				srl		a1,2
				nop
				add		a1,a1,a3
				sh		a1,pos4


				lw		a0,var5
				nop
				add		a0,a0,4
				and		a0,a0,$ff
				sw		a0,var5
				lw		a1,sinus(a0)
				nop
				srl		a1,2
				nop
				add		a1,a1,a3
				sh		a1,pos5


				lw		a0,var6
				nop
				add		a0,a0,4
				and		a0,a0,$ff
				sw		a0,var6
				lw		a1,sinus(a0)
				nop
				srl		a1,2
				nop
				add		a1,a1,a3
				sh		a1,pos6

				li		a0,7					; Dont show the logo before the GREETING is complete
				lw		a1,gvar					;	
				nop								;
				bne		a0,a1,dontShowLogo		;
				nop								;

				li		a1,40
				lw		a0,LegendYPos
				nop
				beq		a0,a1,dontShowLogo
				nop

				add		a0,a0,1
				sw		a0,LegendYPOs
				nop
dontShowLogo			
				pop		ra
				jr		ra
				nop

;--------------------------------------
;--------------------------------------
blankList		SList	clsScreen,1
Dr_offset		dw		$e5000000

clsScreen		SList	-1,5	
				dw		$28000000		; flat shared quadrangle
				dh		0,0
				dh		320,0
				dh		0,256
				dh		320,256

print_text		push	ra
				li 		t1,$3f
				li 		t2, $b0
				jalr	t2
				nop
				pop		ra
				jr		ra
				nop	
			
modulePACK		incbin	 	readmym.pak

;--------------------------------------
;--------------------------------------
RealList    	SList   xeroxgfx1,1
            	dw		$e1000000|$0400|$0000|$0100
			
xeroxgfx1		dr_tpage	xeroxgfx2,direct16,trans0,$0000,$0100

xeroxgfx2		SList 	legendgfx,4
				db		$40
				db		$40
				db		$40
				db		$64
			
xeroxXpos		dh		320		;310-88
				dh		256-20	;256-20
				db		0,0
				dh		0
				dh		88,15
			
;-------------			
			
legendgfx		Slist	lamt,1
				dw	$e1000000|$0400|$0200|$0100			
				
lamt			dr_tpage	legend_l,direct16,trans0,$200,$100

STARTPOS		equ		28

legend_l		SList 	legend_e,4
    			db		$60
				db		$60
				db		$60
				db		$64
			
				dh		STARTPOS
pos1			dh		100
				db		0,0
				dh		0
				dh		30,40
			
legend_e		SList 	legend_g,4
    			db		$60
				db		$60
				db		$60
				db		$64

				dh		STARTPOS+40
pos2			dh		100			
				db		116,0
				dh		0
				dh		34,40
			
legend_g		SList 	legend_e2,4
    			db		$60
				db		$60
				db		$60
				db		$64

				dh		STARTPOS+40+44
pos3			dh		100			
				db		71,0
				dh		0
				dh		40,40
			
legend_e2		SList 	legend_n,4
    			db		$60
				db		$60
				db		$60
				db		$64

				dh		STARTPOS+40+44+50
pos4			dh		100			
				db		116,0
				dh		0
				dh		34,40
			
legend_n		SList 	legend_d,4
    			db		$60
				db		$60
				db		$60
				db		$64

				dh		STARTPOS+40+44+50+44
pos5			dh		100
				db		154,0
				dh		0
				dh		38,40
			
legend_d		SList 	letter,4
    			db		$60
				db		$60
				db		$60
				db		$64

				dh		STARTPOS+40+44+50+44+48
pos6			dh		100			
				db		199,0
				dh		0
				dh		37,40
			
			
letter
letter1			sprite	letter2,$70,$70,$70,0,50,9,44,8,12
letter2			sprite	letter3,$70,$70,$70,10,55,9,44,8,12
letter3			sprite	letter4,$70,$70,$70,20,60,9,44,8,12
letter4			sprite	letter5,$70,$70,$70,30,65,9,44,8,12
letter5			sprite	letter6,$70,$70,$70,40,70,9,44,8,12
letter6			sprite	letter7,$70,$70,$70,50,75,9,44,8,12
letter7			sprite	letter8,$70,$70,$70,60,80,9,44,8,12
letter8			sprite	letter9,$70,$70,$70,70,85,9,44,8,12
letter9			sprite	letter10,$70,$70,$70,80,90,9,44,8,12
letter10		sprite	letter11,$70,$70,$70,90,95,9,44,8,12
letter11		sprite	letter12,$70,$70,$70,100,100,9,44,8,12
letter12		sprite	letter13,$70,$70,$70,110,105,9,44,8,12
letter13		sprite	letter14,$70,$70,$70,120,110,9,44,8,12
letter14		sprite	letter15,$70,$70,$70,130,115,9,44,8,12
letter15		sprite	letter16,$70,$70,$70,140,120,9,44,8,12
letter16		sprite	letter17,$70,$70,$70,150,125,9,44,8,12
letter17		sprite	letter18,$70,$70,$70,160,130,9,44,8,12
letter18		sprite	letter19,$70,$70,$70,170,135,9,44,8,12
letter19		sprite	letter20,$70,$70,$70,180,140,9,44,8,12
letter20		sprite	letter21,$70,$70,$70,190,145,9,44,8,12
letter21		sprite	letter22,$70,$70,$70,200,150,9,44,8,12
letter22		sprite	letter23,$70,$70,$70,210,155,9,44,8,12
letter23		sprite	letter24,$70,$70,$70,220,160,9,44,8,12
letter24		sprite	letter25,$70,$70,$70,230,165,9,44,8,12
letter25		sprite	letter26,$70,$70,$70,240,170,9,44,8,12
letter26		sprite	letter27,$70,$70,$70,250,175,9,44,8,12
letter27		sprite	letter28,$70,$70,$70,260,180,9,44,8,12
letter28		sprite	letter29,$70,$70,$70,270,185,9,44,8,12
letter29		sprite	letter30,$70,$70,$70,280,190,9,44,8,12
letter30		sprite	letter31,$70,$70,$70,290,195,9,44,8,12
letter31		sprite	letter32,$70,$70,$70,300,200,9,44,8,12
letter32		sprite	letter33,$70,$70,$70,310,205,9,44,8,12
letter33		sprite	letter34,$70,$70,$70,320,210,9,44,8,12
letter34		sprite	texture,$70,$70,$70,330,215,9,44,8,12

xx				equ		$0200
yy				equ		$0100

texture			SList	-1,9		; this "function" is the one that shows the initial "greeting" 
gcol1			db		0
gcol2			db		0
gcol3			db		0
				db		$2c
				
gx0				dh		50
gy0				dh		110			; x0, y0
u0				db		0,88		; u0, v0
				dh		0
			
gx1				dh		320-50
gy1				dh		110			; x1, y1
u1				db		166,88		; u1, v1
				dh		((direct16&3)<<7)!((trans3&3)<<5)!((xx>>6)&$f)!(((yy>>8)&1)<<4)!(((yy>>9)&1)<<$b)
			
gx2				dh		50
gy2				dh		140			; x1, y1
u2				db		0,103		; u1, v1
				dh		0			; clut

gx3				dh		320-50
gy3				dh		140		; x1, y1
u3				db		166,103	; u1, v1
				dh		0			; clut
			
goffset			dw		0
gvar			dw		0

; The next section contain X,Y offsets in the graphicsblock, where the different texts are stored

glist			db		0,88		; WELCOME
				db		165,88
				db		0,103
				db		165,103
								
				db		0,117		; TO
				db		165,117
				db		0,132
				db		165,132
									
				db		0,147		; MY
				db		165,147
				db		0,161
				db		165,161
								
				db		0,176		; FIRST
				db		165,176
				db		0,191
				db		165,191
								
				db		0,205		; PLAYSTATION
				db		165,205	
				db		0,221
				db		165,221
								
				db		0,235		; RELEASE
				db		165,235
				db		0,250
				db		165,250
			
				db		0,0			; empty
				db		0,0
				db		0,0
				db		0,0
			
			

;------------------------------------------------------------------------------------------------

legendYPos		dw			-100

xeroxVar		dw			0
xeroxDelay		dw			150		;main delay before showing the logo

Xerox			incbin		xerox.tim

LegendPACK		incbin		legend.pak		; packed graphics
				include		silph.inc
			
sinus			include		sinus.inc

xcords			incbin		cords_x.dat		; precalculated X,Y,Z positions for the stars
ycords			incbin		cords_y.dat		;
zcords			incbin		cords_z.dat		;


gxcords			dw			-25,25,-25,25	; cordinates the the initial greeting
gycords			dw			-10,-10,10,10	;
gzcord			dw			2*80			; Z values here are being modified by the program

gnyx			dw			0,0,0,0			; After a little "math" of the above values, the 
gnyy			dw			0,0,0,0			; result are stored in the X, Y tables

page			dw			0				; Control var for the doublebuffer routine

var1			dw			0				; 6 offsets into the sinus which controls the position of the LEGEND logo
var2			dw			20				;
var3			dw			40				;
var4			dw			60				;
var5			dw			80				;
var6			dw			100				;

scrPos			dw			5

scrollTab		db			0,44	; a
				db			18,44	; b
				db			36,44	; c
				db			54,44	; d
				db			72,44	; e
				db			90,44	; f
				db			108,44	; g
				db			126,44	; h
				db			144,44	; i
				db			162,44	; j
				db			180,44	; k
				db			198,44	; l
				db			216,44	; m
				
				db			0,58	; n
				db			18,58	; o
				db			36,58	; p
				db			54,58	; q
				db			72,58	; r
				db			90,58	; s
				db			108,58	; t
				db			126,58	; u
				db			144,58	; v
				db			162,58	; w
				db			180,58	; x
				db			198,58	; y
				db			216,58	; z

				db			0,72	; 0
				db			18,72	; 1
				db			36,72	; 2
				db			54,72	; 3
				db			72,72	; 4
				db			90,72	; 5
				db			108,72	; 6
				db			126,72	; 7
				db			144,72	; 8
				db			162,72	; 9
				db			180,72	; .
				db			198,72	; @
				db			216,72	; :
				db			220,72	; space
			

dycpVar			dw			0
dycpTab			dw			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


scrollPtr		dw		0
scrollText		db		"this is my very first attempt to do something on the psx so dont bitch about the quality.         "
				db		"greeting to  .. doc .. cat .. hitmen .. and the guys in psxdev who have been helping me getting "
				db		"started on the playstation. you probably know who i am talking about.     "
				db		"credits for this little into go to ...  xerox for code and graphics ... silpheed of hitmen for the module player.  "
				db		"great player but i wish i has the asm source for version 1.5.  hint hint..  heh     "
				db		"if you could use my talents in your group then please contact me on irc.    "	
				db		"anyway. i have not "
				db		"written a scroller for ages and i honestly dont have a clue what i should write so this is the end "
				db		"of the scroller.    xerox signing off..."

				db		"                                        "
				db		0
			
consoleTxt		db		10,13,10,13
				db		"A huge ""THANK YOU"" to Silpheed of Hitmen for releasing the source to greentro. ",10,13
				db		"It gave a quick and precise introduction to programming on the PSX, and without",10,13
				db		"the source, this intro had probably never existed.  Cheers pal!!",10,13,10,13
				db		0
			
;------------------
				include		decrunch.asm	
				include 	hitmod.inc

Ending






