//Common routines library
//for the gameboy advanced
//by Richard van der Brugge aka Ries
//
//Most stuff is borrowed from other authors

#include "gbasys.h"




//-------------------------------------------------------------------------------------------------
//	VSYNC function by Eloist
//description:		Wait until scanline hits 160 (bottom of screen) to sync
//input: 			none
//output:			 none
//-------------------------------------------------------------------------------------------------
void VSync()
{
  __asm
   {
    mov 	r0, #0x4000006
scanline_wait:
     ldrh	r1, [r0]
     cmp	r1, #160
    bne 	scanline_wait
   }
}






//-------------------------------------------------------------------------------------------------
//DMAclearscreen  by Jum Hig
//description:		Clear the screen using fast DMA method
//input: 			none
//output:			 none
//-------------------------------------------------------------------------------------------------
void DMAClearScreen(void) {
	REG_DM3SAD = 0x08010000;		// src addr (gulp!)
	REG_DM3DAD = 0x06000000;		// dest addr
	REG_DM3CNT = 0x84002580;		// 9600 bytes?
}





//-------------------------------------------------------------------------------------------------
//ClearScreen  by Jeff
//description:		Clear the screen using normal slower method
//input: 			none
//output:			 none
//-------------------------------------------------------------------------------------------------
void ClearScreen(void){
u32 i=0;
// Clear VRAM
   for (i=0; i<240*160*2; i=i+2)
      *(u16 *)(SCREEN+ i) = 1;
}




//-------------------------------------------------------------------------------------------------
//CreatePalette  by Jum Hig
//description:		Set palette to 32xgray 32xred 32x green
//input: 			none
//output:			 none
//-------------------------------------------------------------------------------------------------
void CreatePalette(void){
unsigned short *ppal;
int i;

	ppal = PALETTE;
	// first, 32 shades of grey
	for(i=0; i<32; i++) {
		*ppal++ = (i & 0x1F) | ((i & 0x1F) << 5) | ((i & 0x1F) << 10);
	}
	// then, 32 shades of red
	for(i=0; i<32; i++) {
		*ppal++ = (i & 0x1F);
	}
	// then, 32 shades of green
	for(i=0; i<32; i++) {
		*ppal++ = (i & 0x1F) << 5;
	}
}



//-------------------------------------------------------------------------------------------------
//SetDisplayModeX
//description:		Set specific display mode
//input: 			none
//output:			 none
//-------------------------------------------------------------------------------------------------
//mode 4 = 240x160 with 8bits color per pixel (256 colors)
void SetDisplayMode4On(void){
REG_DISPCNT = 0x0004;
}
//mode 3 =240x160 with 15bits color per pixel (32768 colors)
void SetDisplayMode3(void){
REG_DISPCNT	= 0x0003;
}


//-------------------------------------------------------------------------------------------------
//Drawpixel by Richard vd Brugge/Ries
//description:		Draw a pixel at x,y with palette color color
//input: 			u16 x,y,color
//output:			 none
//-------------------------------------------------------------------------------------------------
void DrawPixel (u16 x, u16 y , u16 color)
{
unsigned char *p;
p = SCREEN;							// p points to start of screen
*(p+((y*240)+x))=color;
}



