//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_PARALLEL_FOR_H_
#define _NULSTEIN_PARALLEL_FOR_H_

class CWorkerThread;

//________________________________________________________________________________
class CRange
{
public:
	CRange(){}
	
	CRange(const CRange &R)
	{
		begin		= R.begin;
		end			= R.end;
		granularity	= R.granularity;
	}

	CRange(int _begin, int _end)
	{
		begin		= _begin;
		end			= _end;
		granularity	= 1;
	}

	CRange(int _begin, int _end, int _granularity)
	{
		begin		= _begin;
		end			= _end;
		granularity	= _granularity;
	}

public:
	int begin;	
	int end;
	int granularity;
};

//________________________________________________________________________________
class IForTask
{
public:
	virtual bool DoRange(CWorkerThread* pThread, const CRange &Range) const =0;
};

//________________________________________________________________________________
bool ParallelFor(const IForTask *pTask, const CRange &Range);
bool ParallelFor(CWorkerThread* pThread, const IForTask *pTask, const CRange &Range);

#endif // _NULSTEIN_PARALLEL_FOR_H_
