//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "StdAfx.h"
#include "EntityCamera.h"

CEntityCamera::CEntityCamera(CEntitySlot* pSlot) : CEntity(pSlot)
{
	m_Camera.m_Position.Set(	0.0f, -1.0f, 0.0f);
	m_Camera.m_Target.Set(		0.0f,  0.0f, 0.0f);
	m_Camera.m_Up.Set(			0.0f,  0.0f, 1.0f);
	
	m_Camera.m_FieldOfView	=   1.0808f; /* yFOV of 20mm on 24x36 */ 
	m_Camera.m_Near			=   0.001f;
	m_Camera.m_Far			= 100.0f;

	pSlot->SetFlag( ENTITY_NODRAW );
}

bool CEntityCamera::PreUpdate(CFrame* pFrame, float dt)
{
	return true;
}

bool CEntityCamera::Update(CFrame* pFrame, float dt)
{
	m_Camera.UpdateMatrix();
	return true;
}

bool CEntityCamera::Draw(CDisplayListAdder* pDL, uint32_t EntityKey, int iView)
{
	ASSERT(false);
	return false;
}

bool CEntityCamera::Render(CGfx* pGfx, const CDisplayItemKey &Key, uint32_t EntityKey, ULONG Param)
{
	ASSERT(false);
	return false;
}
	
