//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "StdAfx.h"
#include "Gfx/Gfx.h"
#include "Entity.h"
#include "TaskScheduler.h"

//________________________________________________________________________________
CEntity::CEntity(CEntitySlot* pSlot)
{
	m_pSlot	= pSlot;
	m_pSlot->Init(this);
}

CEntity::~CEntity()
{
	m_pSlot->m_pEntity	= NULL;
	m_pSlot->m_Flags	= 0;
}

//________________________________________________________________________________
void CEntitySlot::Init(CEntity* pEntity)
{
	m_pEntity			= pEntity;
	m_Flags				= 0;	
	m_DependentCount	= 0;
	m_PredecessorCount	= 0;
}

//________________________________________________________________________________
bool CEntity::UpdateDependsOn(CEntity* pOther)
{	/* this can only be called during PreUpdate phase */ 
	CEntitySlot&	Slot = *pOther->m_pSlot;
	LONG			iDependent;
	
	/* register with other entity */ 
	iDependent = InterlockedIncrement( &Slot.m_DependentCount ) - 1;
	if (iDependent >= MAX_DEPENDENTCOUNT) return false;
	
	Slot.m_Dependent[iDependent] = m_pSlot;
	
	/* set ourselves up */ 
	m_pSlot->m_Flags |= ENTITY_DEPENDENT;
	m_pSlot->m_PredecessorCount++;
	
	return true;
}

//________________________________________________________________________________
class CDependentUpdater : public CInternalTask
{
public:
	CDependentUpdater(CTaskCompletion* pCompletion, CFrame* pFrame, CEntitySlot* pSlot, float dt)
	:	CInternalTask(pCompletion)
	{
		m_pSlot  = pSlot;
		m_pFrame = pFrame;
		m_dt	 = dt;
	}
	
	bool Run(CWorkerThread* pThread)
	{
		bool bOk;
		
		bOk = m_pSlot->_Update(m_pFrame, m_dt); /* doesn't check the ENTITY_DEPENDENT flag */ 
		ASSERT(bOk);
		
		delete this;
		return true;
	}
	
public:
	CEntitySlot*	m_pSlot;
	CFrame*			m_pFrame;
	float			m_dt;
};

void CEntitySlot::UpdateDependents(CFrame* pFrame, float dt)
{	/* NOTE: this can only be called during Update phase */ 
	CWorkerThread* pThread = CWorkerThread::GetCurrent();
	
	if (m_DependentCount > MAX_DEPENDENTCOUNT)
		m_DependentCount = MAX_DEPENDENTCOUNT;

	for(int iDependent=0; iDependent<m_DependentCount; iDependent++)
	{
		CEntitySlot&		Slot = *m_Dependent[iDependent];
		LONG				count;
		
		/* check if entity is still depending on other objects */ 
		count = InterlockedDecrement( &Slot.m_PredecessorCount );
		if (count) continue;
		
		/* queue update as a task (so other workers can steal it...) */ 
		pThread->PushTask( new CDependentUpdater(pThread->m_pCurrentCompletion, pFrame, &Slot, dt) );
	}
	
	m_DependentCount = 0;
}

