//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_MESH_H
#define _NULSTEIN_MESH_H

#include "Gfx.h"

//________________________________________________________________________________
class CVertexPN
{
public:
	float x, y, z;
	float nx,ny,nz;
};

class CVertexPNT : public CVertexPN
{
public:
	float	u,v;
};

class CVertexPNTC : public CVertexPNT
{
public:
	DWORD	rgba;
};

//________________________________________________________________________________
class CMesh
{
public:
	CMesh();

	bool Allocate(CGfx *pGfx, int VertexCount, int FaceCount, int VertexSize);
	void Free();

	bool LockVertices(void** ppVtx, DWORD D3DFlags);
	bool UnlockVertices();
	
	bool LockIndices(WORD** ppIdx, DWORD D3DFlags);
	bool UnlockIndices();

	bool Draw(CGfx* pGfx, const CMatrix &MtxModelToWorld, const CVector4 &Tint) const;

public:
	CComPtr<IDirect3DVertexBuffer9>	m_spVB;
	CComPtr<IDirect3DIndexBuffer9>	m_spIB;
	size_t							m_VertexSize;
	int								m_VertexCount;
	int								m_FaceCount;
};

#endif // _NULSTEIN_MESH_H