//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "stdafx.h"
#include "View.h"
#include "Gfx/DisplayList.h"

bool CView::SetDisplayItemKey(CDisplayItemKey* pKey, int iView)
{	/* TODO: do */ 

	pKey->m_iRenderTarget	= 0;
	pKey->m_iLayer			= 0;
	pKey->m_iViewport		= 0;
	pKey->m_iViewportLayer	= 0;
	return true;
}

bool CView::Setup(CGfx* pGfx)
{ /* TODO: this is at placeholder stage */ 
	bool	bOk;
	float	AspectRatio;
	RECT	R;
	
	pGfx->GetRect(&R);
	
	AspectRatio = float(R.right  - R.left)
				/ float(R.bottom - R.top );

	/* World to Camera */ 
	pGfx->m_MtxWorldToCamera = m_pCamera->m_WorldToView;
	
	/* Camera to Screen */ 
	MtxPerspective(	&pGfx->m_MtxCameraToScreen, 
					m_pCamera->m_FieldOfView, 
					AspectRatio, 
					m_pCamera->m_Near, m_pCamera->m_Far);
	
	/* World to Screen */ 
	MtxMul(	&pGfx->m_MtxWorldToScreen, 
			 pGfx->m_MtxWorldToCamera, 
			 pGfx->m_MtxCameraToScreen);
	
	/* Viewport */  
	// if (iViewport)
	// 	 bOk = m_pGfx->SelectViewport(&m_Viewport[iViewport]);
	// else bOk = m_pGfx->SelectViewport(NULL);
	bOk = pGfx->SelectViewport(NULL);
	IF_FAILED_RETURN(bOk);

	return true;
}
