//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_CAMERA_H_
#define _NULSTEIN_CAMERA_H_

#include "GfxMath.h"

class CCamera
{
public:
	void UpdateMatrix()
	{
		MtxLookat( &m_WorldToView, m_Position, m_Target, m_Up);
	}
	
	float ComputeZ(const CVector3 &M) const;
	
public:
	CVector3	m_Position;
	CVector3	m_Target;
	CVector3	m_Up;
	float		m_FieldOfView;
	float		m_Near, m_Far;
	
	CMatrix		m_WorldToView;
};

#endif // _NULSTEIN_CAMERA_H_