//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "StdAfx.h"
#include "Gfx/View.h"
#include "Misc/Defines.h"
#include "DisplayList.h"
#include "nulstein/ParallelSort.h"

#define DISPLAYLISTADDER_GRANULARITY 256

#pragma pack(push, 1)
struct sKey_Opaque
{
	BYTE	LowZ;
	USHORT	HighZ;
	BYTE	MtlPass;

	USHORT	Mtl;
	USHORT	BaseKey;
};

struct sKey_Alpha
{
	BYTE	MtlPass;
	USHORT	Mtl;
	BYTE	LowZ;

	USHORT	HighZ;
	USHORT	BaseKey;
};

struct sKey_Command
{
	ULONG	Param;

	USHORT	Priority;
	USHORT	BaseKey;
};

union uKey
{
	ULONGLONG		Value;
	sKey_Opaque		Opaque;
	sKey_Alpha		Alpha;
	sKey_Command	Command;
};

#pragma pack(pop)



//________________________________________________________________________________
CDisplayList::CDisplayList()
{
	m_View = NULL;
	m_ItemCount = 0;
}

CDisplayList::~CDisplayList()
{
}

CDisplayListAdder::CDisplayListAdder()
{
	m_pDisplayList	= NULL;
	Reset();
}

void CDisplayListAdder::Reset()
{
	m_pNextItem		= NULL;
	m_ItemsReserved	= 0;
	m_AddCount		= 0;
}


void	CDisplayList::Begin()
{
	InterlockedExchange(&m_ItemCount, 0);
}

bool CDisplayListAdder::Add(ULONGLONG Key, uint32_t EntityKey, uint32_t Param)
{
	sDisplayItem*	pItem;
	
	/* if we ran out, reserve a block */ 
	if (!m_ItemsReserved)
	{
		LONG iFirstItem;
		
		iFirstItem = InterlockedExchangeAdd(&m_pDisplayList->m_ItemCount, DISPLAYLISTADDER_GRANULARITY);
		if (iFirstItem+DISPLAYLISTADDER_GRANULARITY > MAX_DISPLAYLISTSIZE) return false;
		
		m_pNextItem = m_pDisplayList->m_Item + iFirstItem;
		m_ItemsReserved = DISPLAYLISTADDER_GRANULARITY;
		
		/* init to "not an item", so the slots we don't use go at the end of the list and get ignored */ 
		memset(m_pNextItem, 0xFF, sizeof(sDisplayItem)*DISPLAYLISTADDER_GRANULARITY);
	}

	/* allocate an item locally */ 
	pItem = m_pNextItem++;
	m_ItemsReserved--;
	m_AddCount++;
	
	/* fill it in */ 
	pItem->m_Key		= Key;
	pItem->m_EntityKey	= EntityKey;
	pItem->m_Param		= Param;
	
	return true;
}

//________________________________________________________________________________
class DisplayItemComparator
{
public:
	static bool isCorrectOrder(const sDisplayItem &A, const sDisplayItem &B) 
	{ 
		return A.m_Key <= B.m_Key; 
	}
};

typedef CSorter<sDisplayItem, DisplayItemComparator, 2048> CDisplayItemSorter;

void CDisplayList::EndAndSort()
{
	sDisplayItem*		pTemp = (sDisplayItem*) malloc( m_ItemCount * sizeof(sDisplayItem) );
	CDisplayItemSorter Sorter(m_Item, m_ItemCount, pTemp);

#ifdef USE_PARALLELSORT
	Sorter.Sort();
#else
	Sorter.Sort_Serial();
#endif
	free(pTemp);
}

