# -*- coding: utf-8 -*-

import numpy, os

inputFile = open('meta3w.bmp', 'rb')
inputFileSize = os.path.getsize('meta3w.bmp')
inputArray = numpy.ndarray(inputFileSize, numpy.uint8)
inputArray = inputFile.read(inputFileSize)
inputFile.close()

imageSizeY = inputArray[0x16] + (inputArray[0x17] << 8) + (inputArray[0x18] << 16) + (inputArray[0x19] << 24)
imageHeaderSize = inputArray[0x0a] + (inputArray[0x0b] << 8) + (inputArray[0x0c] << 16) + (inputArray[0x0d] << 24)
imageSizeX = (inputFileSize - imageHeaderSize) // imageSizeY
print('inputFileSize: ' + str(inputFileSize))
print('imageHeaderSize: ' + str(imageHeaderSize))
print('imageSize: ' + str(imageSizeX) + 'x' + str(imageSizeY))

outputArray = numpy.ndarray(inputFileSize - imageHeaderSize, numpy.uint8)
i = 0
for x in range(imageSizeX):
    for y in range(imageSizeY):
        outputArray[i] = ~inputArray[imageHeaderSize + x + (y * imageSizeX)]
        i += 1
    
outputFile = open('metawide.bin', 'ab')
outputFile.write(outputArray)
outputFile.close()