/***************************************************************************************

	YM - Music Driver.

	Drives standard YM tunes, Digi-Mix and Universal tracker.

	Written by Arnaud Carr (Leonard/OXYGENE) since 1996.
	Totally C++ recoded in May 1999.
	
	arnaud.carre@freesurf.fr
	http://leonard.oxg.free.fr

***************************************************************************************/


#ifndef __YMENGINEPUBLIC__
#define __YMENGINEPUBLIC__

#define	YM_FALSE		(0)
#define	YM_TRUE			(!YM_FALSE)
typedef int				YM_BOOL;
typedef signed short	YM_SAMPLE;

typedef struct
{
	char	*	pSongName;
	char	*	pSongAuthor;
	char	*	pSongComment;
	char	*	pSongType;
	char	*	pSongPlayer;
	long		musicTimeInSec;
} ymMusicInfo_t;

extern	YM_BOOL		ymMusicLoad(char *fName);
extern	YM_BOOL		ymMusicLoadMemory(void *pBlock,unsigned long size);
extern	void		ymMusicUnload(void);
extern	YM_BOOL		ymMusicCompute(YM_SAMPLE *pBuffer,int nbSample);
extern	void		ymMusicSetLoopMode(YM_BOOL bLoop);
extern	char	*	ymMusicGetLastError(void);
extern	int			ymMusicGetRegister(int reg);

extern	void		ymMusicGetInfo(ymMusicInfo_t *pInfo);


#endif
