; Detect if we are running on a CD32 system
; d0=null then it is not a cd32
CD32Detect:
	move.l	a6,-(a7)
	move.l	ExecBase,a6
	lea	FreeAnimName(pc),a1
	jsr	_LVOFindResident(a6)
	move.l	(a7)+,a6
	rts
	
CD32OpenNVRAMLib:
	move.l	a6,-(a7)
	move.l	ExecBase,a6
	moveq	#0,d0
	lea	NovolatileName(pc),a1
	jsr	_LVOOpenLibrary(a6)
	lea	NonvolatileBase(pc),a0
	move.l	d0,(a0)
	tst.l	d0
	bne.s	.ok

	move.l	a0,-(a7)
	lea	txtSaveOpenNVRAMFail,a0
	bsr	agdPrintLine
	move.l	(a7)+,a0	
	
.ok:	move.l	(a7)+,a6
.quit:	rts

CD32CloseNVRAMLib:
	move.l	a6,-(a7)
	move.l	ExecBase,a6
	move.l	NonvolatileBase(pc),d0
	beq.b	.quit
	move.l	d0,a1
	jsr	_LVOCloseLibrary(a6)
	clr.l	NonvolatileBase
	move.l	(a7)+,a6
.quit:	rts

; d0.l: length
; a0.l: file name
; a1.l: destination
CD32LoadHighscores:
	movem.l	d2-d4/a2-a6,-(a7)
	move.l	d0,d7			; save length
	move.l	a1,a5			; a5: destination
	lea	AppName(pc),a0
	lea	ItemName(pc),a1
	moveq	#1,d1			; killRequesters = true
	move.l	NonvolatileBase(pc),d2
	beq.b	.exit
	move.l	d2,a6
	jsr	_LVOGetCopyNV(a6)
	tst.l	d0
	bne.b	.ok			; Nothing to fetch back.
	
	move.l	a0,-(a7)
	lea	txtLoadHiscoresGetCopyNVFail,a0
	bsr	agdPrintLine
	move.l	(a7)+,a0	
	
	bra	.exit
	
.ok:	move.l	d0,a0
.copy	move.b	(a0)+,(a5)+		; copy highscores to destination area
	subq.l	#1,d7
	bne.b	.copy
.exit	movem.l	(a7)+,d2-d4/a2-a6
	rts



lib_error:
	moveq	#0,d0
	rts

; d0.l: length
; a0.l: file name
; a1.l: data
CD32SaveHighscores
	movem.l	d2-d4/a2-a6,-(a7)
	lea	AppName(pc),a0
	lea	ItemName(pc),a1
	move.l	#CD32SaveUnits,d0			;300 bytes
	lea	HISCORE_IO_START,a2
	
; length must be a multiple of 10, original length: 55 bytes hence
; we use 60/10.
	moveq	#1,d1			; killRequesters = true
	move.l	NonvolatileBase(pc),d2
	beq.b	.exit
	move.l	d2,a6

	jsr	_LVOStoreNV(a6)
.exit	movem.l	(a7)+,d2-d4/a2-a6
	rts


NonvolatileBase:	dc.l	0
HunkStart		dc.l	0
CurrentChar		dc.b	"a"
			dc.b	5		; delay
DOSBase			dc.b	"dos.library",0
			even
NovolatileName		dc.b	"nonvolatile.library",0
			even
ItemName		dc.b	"hiscore",0
			even
AppName			dc.b	"TurboSprint",0
			even
FreeAnimName:		dc.b	"freeanim.library",0
			even


