/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Decoder;
import classes.Encoder;
import java.nio.ByteBuffer;

public class Format80
implements Encoder,
Decoder {
    private static final byte CMD_TRANSFER = -128;
    private static final int CMD_TRANSFER_MAX = 63;
    private static final byte CMD_OFFSET = 0;
    private static final int CMD_OFFSET_MAX = 10;
    private static final int CMD_OFFSET_THRESHOLD = 2;
    private static final int CMD_OFFSET_RANGE = 4095;
    private static final byte CMD_COPY_S = -64;
    private static final int CMD_COPY_S_MAX = 64;
    private static final int CMD_COPY_S_THRESHOLD = 2;
    private static final byte CMD_COPY_L = -1;
    private static final int CMD_COPY_L_MAX = 65535;
    private static final byte CMD_FILL = -2;
    private static final int CMD_FILL_MAX = 65535;
    private static final int CMD_FILL_THRESHOLD = 3;

    /*
     * Unable to fully structure code
     */
    @Override
    public void decode(ByteBuffer source, ByteBuffer dest, ByteBuffer ... extra) {
        block8: {
            try {
                block2: while (true) lbl-1000:
                // 6 sources

                {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    if (((command = (byte)(source.get() & 255)) & 128) != 0) break block9;
                                    count = (command >>> 4) + 3 & 255;
                                    copypos = ((command & 15) << 8) + (source.get() & 255) & 65535;
                                    copypos = dest.position() - copypos;
                                    while (true) {
                                        if (count-- <= 0) ** GOTO lbl-1000
                                        dest.put(dest.get(copypos++));
                                    }
                                }
                                count = command & 63;
                                if ((command & 64) != 0) break block10;
                                if (count == 0) break block8;
                                while (true) {
                                    if (count-- <= 0) ** GOTO lbl-1000
                                    dest.put(source.get());
                                }
                            }
                            if (count >= 62) break block11;
                            count += 3;
                            byte1 = source.get() & 255;
                            byte2 = source.get() & 255;
                            copypos = (byte2 << 8 | byte1) & 65535;
                            while (true) {
                                if (count-- <= 0) ** GOTO lbl-1000
                                dest.put(dest.get(copypos++));
                            }
                        }
                        if (count != 62) break block12;
                        byte1 = source.get() & 255;
                        byte2 = source.get() & 255;
                        count = (byte2 << 8 | byte1) & 65535;
                        fill = source.get();
                        while (true) {
                            if (count-- <= 0) ** GOTO lbl-1000
                            dest.put(fill);
                        }
                    }
                    byte1 = source.get() & 255;
                    byte2 = source.get() & 255;
                    count = (byte2 << 8 | byte1) & 65535;
                    byte1 = source.get() & 255;
                    byte2 = source.get() & 255;
                    copypos = (byte2 << 8 | byte1) & 65535;
                    while (true) {
                        if (count-- <= 0) continue block2;
                        dest.put(dest.get(copypos++));
                    }
                    break;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        source.rewind();
        dest.flip();
    }

    @Override
    public void encode(ByteBuffer source, ByteBuffer dest, ByteBuffer ... extra) {
        dest.put((byte)-127);
        dest.put(source.get());
        while (source.hasRemaining()) {
            int xferlength;
            int filllength;
            int[] copypart;
            int[] offsetpart = Format80.isCandidateForOffsetCopyCommand(source);
            int bestmethod = Math.max(offsetpart[0], Math.max((copypart = Format80.isCandidateForCopyCommand(source))[0], Math.max(filllength = Format80.isCandidateForFillCommand(source), xferlength = Format80.isCandidateForTransferCommand(source))));
            if (bestmethod == filllength) {
                byte colourval = source.get();
                dest.put((byte)-2);
                dest.putShort((short)filllength);
                dest.put(colourval);
                source.position(source.position() - 1 + filllength);
                continue;
            }
            if (bestmethod == offsetpart[0]) {
                dest.put((byte)(0 | offsetpart[0] - 3 << 4 | offsetpart[1] >>> 8));
                dest.put((byte)offsetpart[1]);
                source.position(source.position() + offsetpart[0]);
                continue;
            }
            if (bestmethod == copypart[0]) {
                if (copypart[0] <= 64) {
                    dest.put((byte)(0xFFFFFFC0 | copypart[0] - 3));
                    dest.putShort((short)copypart[1]);
                } else {
                    dest.put((byte)-1);
                    dest.putShort((short)copypart[0]);
                    dest.putShort((short)copypart[1]);
                }
                source.position(source.position() + copypart[0]);
                continue;
            }
            byte[] xferbytes = new byte[xferlength];
            source.get(xferbytes);
            dest.put((byte)(0xFFFFFF80 | xferlength));
            dest.put(xferbytes);
        }
        dest.put((byte)-128);
        source.rewind();
        dest.flip();
    }

    private static int[] isCandidateForOffsetCopyCommand(ByteBuffer source) {
        source.mark();
        ByteBuffer sourcecopy = source.duplicate();
        sourcecopy.limit(source.position());
        sourcecopy.position(Math.max(0, source.position() - 4095));
        int candidatelength = 0;
        int candidateposition = -1;
        int copypos = sourcecopy.position();
        while (source.hasRemaining() && sourcecopy.hasRemaining()) {
            int runlength;
            sourcecopy.mark();
            for (runlength = 0; source.hasRemaining() && sourcecopy.hasRemaining() && runlength < 10 && source.get() == sourcecopy.get(); ++runlength) {
            }
            source.reset();
            sourcecopy.reset();
            if (runlength > candidatelength) {
                candidatelength = runlength;
                candidateposition = source.position() - copypos;
            }
            sourcecopy.position(++copypos);
        }
        source.reset();
        return new int[]{candidatelength > 2 ? candidatelength : 0, candidateposition};
    }

    private static int[] isCandidateForCopyCommand(ByteBuffer source) {
        source.mark();
        ByteBuffer sourcecopy = source.duplicate();
        sourcecopy.limit(Math.min(source.position(), 131070));
        sourcecopy.position(0);
        int candidatelength = 0;
        int candidateposition = -1;
        int copypos = 0;
        while (source.hasRemaining() && sourcecopy.hasRemaining() && copypos < 65535) {
            int runlength;
            sourcecopy.mark();
            for (runlength = 0; source.hasRemaining() && sourcecopy.hasRemaining() && runlength < 65535 && source.get() == sourcecopy.get(); ++runlength) {
            }
            source.reset();
            sourcecopy.reset();
            if (runlength > candidatelength) {
                candidatelength = runlength;
                candidateposition = copypos;
            }
            sourcecopy.position(++copypos);
        }
        source.reset();
        return new int[]{candidatelength > 2 ? candidatelength : 0, candidateposition};
    }

    private static int isCandidateForFillCommand(ByteBuffer source) {
        int candidatelength;
        source.mark();
        byte fillbyte = source.get();
        for (candidatelength = 1; source.hasRemaining() && candidatelength < 65535 && fillbyte == source.get(); ++candidatelength) {
        }
        source.reset();
        return candidatelength > 3 ? candidatelength : 0;
    }

    private static int isCandidateForTransferCommand(ByteBuffer source) {
        int candidatelength;
        source.mark();
        int runlength = 1;
        byte lastbyte = source.get();
        for (candidatelength = 1; source.hasRemaining() && candidatelength < 63; ++candidatelength) {
            byte nextbyte = source.get();
            if (nextbyte == lastbyte) {
                if (++runlength > 3) {
                    candidatelength -= runlength - 2;
                    break;
                }
            } else {
                runlength = 1;
            }
            lastbyte = nextbyte;
        }
        source.reset();
        return candidatelength;
    }
}

