/*
 * Decompiled with CFR 0.152.
 */
package CPCFileSystem;

import CPCFileSystem.DskManagerEditor;
import CPCFileSystem.DskMaster;
import CPCFileSystem.Settings;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class TransferHelper
extends TransferHandler {
    private DskManagerEditor dskManagerEditor;

    public TransferHelper(DskManagerEditor dskManagerEditor) {
        this.dskManagerEditor = dskManagerEditor;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        if (!info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            this.dskManagerEditor.table.setCursor(DragSource.DefaultMoveNoDrop);
            return false;
        }
        this.dskManagerEditor.table.setCursor(DragSource.DefaultMoveDrop);
        return true;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        if (!info.isDrop()) {
            return false;
        }
        this.dskManagerEditor.table.setCursor(Cursor.getPredefinedCursor(0));
        if (!info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return false;
        }
        Transferable t = info.getTransferable();
        return this.importDataTransferable(t);
    }

    public boolean importDataTransferable(Transferable t) {
        try {
            boolean generateAMSDOSHeader = false;
            boolean generateAMSDOSHeaderDone = false;
            for (File file : (List)t.getTransferData(DataFlavor.javaFileListFlavor)) {
                String realrealname;
                String string = realrealname = this.dskManagerEditor.dskFile == null ? null : this.dskManagerEditor.dskFile.master.realname2realname(file.getName());
                if (file.getName().toUpperCase().endsWith(".DSK")) {
                    this.dskManagerEditor.dskFile = this.dskManagerEditor.dm.loadDsk(file.getParentFile(), file.getName());
                    if (this.dskManagerEditor.dskFile.master.type == null) {
                        this.dskManagerEditor.ejectTable();
                        JOptionPane.showMessageDialog(this.dskManagerEditor, "Disk unknown");
                        continue;
                    }
                    Settings.set("last_path", file.getParent() + "/");
                    Settings.set("last_opened", file.getAbsolutePath());
                    continue;
                }
                if (this.dskManagerEditor.dskFile == null || this.dskManagerEditor.dskFile.master.type == null) {
                    this.dskManagerEditor.ejectTable();
                    JOptionPane.showMessageDialog(this.dskManagerEditor, "Disk unknown");
                    continue;
                }
                if (!this.dskManagerEditor.dm.listFiles(this.dskManagerEditor.dskFile).containsKey(realrealname)) {
                    if ((long)(this.dskManagerEditor.freeSize * 1024) >= file.length()) {
                        try {
                            byte[] b = new byte[128];
                            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));
                            bin.read(b);
                            bin.close();
                            if (!DskMaster.CheckAMSDOS(b) && !generateAMSDOSHeaderDone) {
                                generateAMSDOSHeader = JOptionPane.showConfirmDialog(this.dskManagerEditor, "Add AMSDOS Header", "WARNING", 0) == 0;
                                generateAMSDOSHeaderDone = true;
                            }
                            generateAMSDOSHeaderDone = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.dskManagerEditor.dm.addFile(this.dskManagerEditor.dskFile, file.getParentFile(), file.getName(), generateAMSDOSHeader ? Boolean.valueOf(true) : null);
                        continue;
                    }
                    JOptionPane.showMessageDialog(this.dskManagerEditor, "Full disk.", "Warning", 0);
                    break;
                }
                JOptionPane.showMessageDialog(this.dskManagerEditor, "File already present.", "Warning", 0);
            }
            if (this.dskManagerEditor.dskFile != null && this.dskManagerEditor.dskFile.master.type != null) {
                this.dskManagerEditor.updateTable();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        JTable list = (JTable)c;
        int[] values = list.getSelectedRows();
        ArrayList<File> files = new ArrayList<File>();
        for (int v : values) {
            File dossierTmp = new File(System.getProperty("user.home"), ".DskManager");
            dossierTmp.deleteOnExit();
            dossierTmp.mkdirs();
            String filename = (String)this.dskManagerEditor.model.getValueAt(v, 0);
            String filenameDrop = filename.substring(0, 8).replaceAll("\\s+$", "") + filename.substring(8, 12).replaceAll("\\s+$", "");
            String filenameNoAttributes = "";
            for (int i = 0; i < filenameDrop.length(); ++i) {
                int a = filenameDrop.charAt(i) & 0x7F;
                filenameNoAttributes = filenameNoAttributes + (char)a;
            }
            File tmpFile = new File(dossierTmp, filenameNoAttributes);
            tmpFile.deleteOnExit();
            try {
                FileOutputStream fos = new FileOutputStream(tmpFile);
                byte[] data = this.dskManagerEditor.list.get(filename).toByteArray();
                if (DskMaster.CheckAMSDOS(data)) {
                    int size = DskMaster.getWord(data, 24) + 128;
                    byte[] d = new byte[size];
                    System.arraycopy(data, 0, d, 0, d.length);
                    fos.write(d);
                } else {
                    fos.write(data);
                }
                fos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            files.add(tmpFile);
        }
        return new FileTransferable(files);
    }

    @Override
    protected void exportDone(JComponent c, Transferable t, int act) {
        if (act == 2 || act == 0) {
            this.dskManagerEditor.table.setCursor(Cursor.getPredefinedCursor(0));
        }
        super.exportDone(c, t, act);
    }

    private class FileTransferable
    implements Transferable {
        private List<File> files;

        public FileTransferable(List<File> files) {
            this.files = files;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DataFlavor.javaFileListFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.files;
        }
    }
}

