#!/usr/bin/env python

from shortcrust import BaseGLApp
from shortcrust.shader import ShaderProgram
from shortcrust.gl2 import *


class ChocoluxShader(ShaderProgram):
	vertex_shader = """
		attribute vec4 vPosition;
		void main()
		{
			gl_Position = vPosition;
		}
	"""

	fragment_shader = """
#ifdef GL_ES
precision highp float;
#endif

uniform vec2 resolution;
uniform float time;

void main(void)
{
	vec3 s[4];
	s[0]=vec3(0);
	s[3]=vec3(sin(time),cos(time),0);
	s[1]=s[3].zxy;
	s[2]=s[3].zzx;

	float t,b,c,h=0.0;
	vec3 m,n;
	vec3 p=vec3(.2);
	vec3 d=normalize(.001*gl_FragCoord.rgb-p);
	for(int i=0;i<4;i++)
	{
		t=2.0;
		for(int i=0;i<4;i++)
		{
			b=dot(d,n=s[i]-p);
			c=b*b+.2-dot(n,n);
			if(b-c<t)
			if(c>0.0)
			{
				m=s[i];t=b-c;
			}
		}
	p+=t*d;
	d=reflect(d,n=normalize(p-m));
	h+=pow(n.x*n.x,44.)+n.x*n.x*.2;
	}
	gl_FragColor=vec4(h,h*h,h*h*h*h,1);
}
	"""

	def __init__(self):
		super(ChocoluxShader, self).__init__()
		self.vertex_position_attr = glGetAttribLocation(self.program_object, 'vPosition')
		self.time_unif = glGetUniformLocation(self.program_object, 'time')
		self.resolution_unif = glGetUniformLocation(self.program_object, 'resolution')


class Chocolux(BaseGLApp):
	title = "Chocolux by Auld"

	def setup(self):
		self.shader = ChocoluxShader()
		glClearColor(0.0, 0.0, 0.0, 1.0)  # This Will Clear The Background Color To Black

	def draw(self, time):
		bg_vertices = GLfloats((
			-1.0, -1.0, 0.0,
			-1.0, 1.0, 0.0,
			1.0, -1.0, 0.0,
			1.0, 1.0, 0.0,
		))
		glViewport(0, 0, self.width, self.height)

		# Clear The Colour Buffer
		glClear(GL_COLOR_BUFFER_BIT)
		self.shader.use()

		glVertexAttribPointer(self.shader.vertex_position_attr, 3, GL_FLOAT, GL_FALSE, 0, bg_vertices)

		glUniform1f(self.shader.time_unif, time)
		glUniform2f(self.shader.resolution_unif, self.width, self.height)

		glEnableVertexAttribArray(self.shader.vertex_position_attr)
		glDrawArrays(GL_TRIANGLE_STRIP, 0, 4)


Chocolux().run()
